/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.support.java.JavaClass;
import org.netbeans.modules.debugger.support.java.LoadedClassesProducer;
import org.netbeans.modules.debugger.support.java.nodes.PackageContent;
import org.netbeans.modules.debugger.support.java.nodes.PackageNode;
import org.netbeans.modules.debugger.support.util.RequestProcessor;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class ClassesRootNode
extends PackageNode
implements Validator.Object {
    static final long serialVersionUID = -5432332119936122231L;
    private static String ICON_BASE = "/org/netbeans/modules/debugger/resources/loadedClasses";
    private static ResourceBundle bundle;
    private Debugger debugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode;

    static String getLocalizedString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode == null ? (class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode = ClassesRootNode.class$("org.netbeans.modules.debugger.support.java.nodes.ClassesRootNode")) : class$org$netbeans$modules$debugger$support$java$nodes$ClassesRootNode));
        }
        return bundle.getString(string);
    }

    public ClassesRootNode() {
        super(new PackageContent(""));
    }

    protected void init() {
        try {
            this.debugger = TopManager.getDefault().getDebugger();
            this.debugger.addPropertyChangeListener((PropertyChangeListener)new StateListener(this, this.debugger));
        }
        catch (DebuggerException debuggerException) {
            // empty catch block
        }
        String string = ClassesRootNode.getLocalizedString("CTL_Classes_root");
        this.setDisplayName(string);
        this.setName(string);
        this.setIconBase(ICON_BASE);
        this.changeChildren();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerClassesRootNode");
    }

    public Node.Handle getHandle() {
        return new ClassesHandle();
    }

    void changeChildren() {
        List list = null;
        try {
            AbstractDebugger abstractDebugger = ((CoreDebugger)TopManager.getDefault().getDebugger()).getCurrentDebugger();
            list = abstractDebugger == null ? new ArrayList() : (abstractDebugger instanceof LoadedClassesProducer ? ((LoadedClassesProducer)((Object)abstractDebugger)).getLoadedClasses() : new ArrayList());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.content.add((JavaClass)iterator.next());
            }
            this.content.reorganize();
            ((PackageNode.PackageChildren)this.getChildren()).setContent(this.content);
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
    }

    public void validate() {
        int n = this.debugger.getState();
        if (n == 4 || n == 1) {
            try {
                this.changeChildren();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean canRemove() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ClassesHandle
    implements Node.Handle {
        static final long serialVersionUID = -3418262400286559650L;

        private ClassesHandle() {
        }

        public Node getNode() {
            return new ClassesRootNode();
        }
    }

    private static class RefreshThread
    extends Thread {
        private boolean finished = false;
        private WeakReference node;
        private Debugger debugger;

        public RefreshThread(String string, WeakReference weakReference, Debugger debugger) {
            super(string);
            this.node = weakReference;
            this.debugger = debugger;
        }

        public void finish() {
            this.finished = true;
        }

        public void run() {
            while (!this.finished) {
                try {
                    Thread.sleep(6000L);
                }
                catch (InterruptedException interruptedException) {
                    this.finished = true;
                }
                final Object t = this.node.get();
                if (t == null) {
                    this.finish();
                    break;
                }
                RequestProcessor.postRequest(new Runnable(){

                    public void run() {
                        if (debugger.getState() != 1) {
                            try {
                                ((ClassesRootNode)t).changeChildren();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }

    private static class StateListener
    implements PropertyChangeListener {
        private RefreshThread thread = null;
        private WeakReference node;
        private Debugger debugger;

        public StateListener(ClassesRootNode classesRootNode, Debugger debugger) {
            this.node = new WeakReference<ClassesRootNode>(classesRootNode);
            this.debugger = debugger;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object t = this.node.get();
            if (t == null) {
                this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
                if (this.thread != null) {
                    this.thread.finish();
                }
                return;
            }
            if (!propertyChangeEvent.getPropertyName().equals("state")) {
                return;
            }
            switch (this.debugger.getState()) {
                case 1: {
                    StateListener stateListener = this;
                    synchronized (stateListener) {
                        if (this.thread != null) {
                            this.thread.finish();
                            this.thread = null;
                        }
                        ((ClassesRootNode)t).changeChildren();
                        break;
                    }
                }
                case 3: {
                    StateListener stateListener = this;
                    synchronized (stateListener) {
                        if (this.thread != null) {
                            this.thread.finish();
                        }
                        this.thread = new RefreshThread("Debugger Classes Refresher", this.node, this.debugger);
                        this.thread.start();
                        break;
                    }
                }
            }
        }
    }
}

