/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.debugger.support.java.ClassLookup;
import org.netbeans.modules.debugger.support.java.PackageClassHistory;
import org.netbeans.modules.debugger.support.util.AbstractHistory;
import org.netbeans.modules.debugger.support.util.HistoryEvent;
import org.netbeans.modules.debugger.support.util.HistoryListener;
import org.netbeans.modules.debugger.support.util.PackageListLoader;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.src.ClassElement;
import org.openide.src.InitializerElement;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class JavaElementSelector
implements Observer,
ActionListener {
    public static final int PACKAGE_ELEMENT = 1;
    public static final int CLASS_ELEMENT = 2;
    public static final int INIT_ELEMENT = 4;
    public static final int CLINIT_ELEMENT = 8;
    public static final int METHOD_ELEMENT = 16;
    public static final int FIELD_ELEMENT = 32;
    protected static final int MEMBER_ELEMENTS = 60;
    protected static final String LOADING_PACKAGE_NAMES = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaElementSelector == null ? (class$org$netbeans$modules$debugger$support$java$JavaElementSelector = JavaElementSelector.class$("org.netbeans.modules.debugger.support.java.JavaElementSelector")) : class$org$netbeans$modules$debugger$support$java$JavaElementSelector)).getString("CTL_Loading_package_names");
    protected static final String SEARCHING = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaElementSelector == null ? (class$org$netbeans$modules$debugger$support$java$JavaElementSelector = JavaElementSelector.class$("org.netbeans.modules.debugger.support.java.JavaElementSelector")) : class$org$netbeans$modules$debugger$support$java$JavaElementSelector)).getString("CTL_searching");
    protected static final String CLINIT_DESCRIPTION = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaElementSelector == null ? (class$org$netbeans$modules$debugger$support$java$JavaElementSelector = JavaElementSelector.class$("org.netbeans.modules.debugger.support.java.JavaElementSelector")) : class$org$netbeans$modules$debugger$support$java$JavaElementSelector)).getString("CTL_clinit_description");
    protected static final String INIT_DESCRIPTION = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$java$JavaElementSelector == null ? (class$org$netbeans$modules$debugger$support$java$JavaElementSelector = JavaElementSelector.class$("org.netbeans.modules.debugger.support.java.JavaElementSelector")) : class$org$netbeans$modules$debugger$support$java$JavaElementSelector)).getString("CTL_init_description");
    protected static final JComponent SEPARATOR = new JSeparator();
    protected static final ListCellRenderer LIST_CELL_RENDERER = new ComboBoxItemRenderer();
    protected static final Collection STANDARD_JAVA_EXCEPTIONS;
    protected static final Object DUMMY_OBJECT;
    private List changeListeners;
    private boolean packageEdited;
    private boolean classEdited;
    private final boolean initElem;
    private final boolean clinitElem;
    private final boolean fieldElem;
    private final boolean methodElem;
    private final boolean lookForMembers;
    private String lastPackage;
    private Object lastClass;
    private AbstractHistory packageHistory;
    private PackageClassHistory classHistory;
    protected final Map classElementMap;
    protected final int elementsMask;
    protected JComboBox cboxPackage;
    protected JComboBox cboxClass;
    protected JComboBox cboxMember;
    protected MyMutableComboBoxModel cboxPackageModel;
    protected MyMutableComboBoxModel cboxClassModel;
    protected MyMutableComboBoxModel cboxMemberModel;
    protected ClassLookup classLookup;
    protected Thread classLookupThread;
    protected String needMembersForClassName;
    protected boolean exceptionFilter;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$java$JavaElementSelector;

    public JavaElementSelector(int n) {
        this.elementsMask = n;
        this.lookForMembers = (n & 0x3C) != 0;
        this.cboxPackageModel = new MyMutableComboBoxModel();
        this.cboxPackage = new JComboBox(this.cboxPackageModel);
        this.loadPackageNames();
        this.cboxClassModel = new MyMutableComboBoxModel();
        this.cboxClass = new JComboBox(this.cboxClassModel);
        this.cboxPackage.setEditable(true);
        this.cboxClass.setEditable(true);
        this.cboxPackage.setRenderer(LIST_CELL_RENDERER);
        this.cboxClass.setRenderer(LIST_CELL_RENDERER);
        this.classElementMap = new HashMap(26, 0.75f);
        if (this.lookForMembers) {
            this.cboxMemberModel = new MyMutableComboBoxModel();
            this.cboxMember = new JComboBox(this.cboxMemberModel);
            this.cboxMember.setEditable(true);
            this.initElem = (n & 4) != 0;
            this.clinitElem = (n & 8) != 0;
            this.methodElem = (n & 0x10) != 0;
            this.fieldElem = (n & 0x20) != 0;
        } else {
            this.initElem = false;
            this.clinitElem = false;
            this.methodElem = false;
            this.fieldElem = false;
        }
        this.cboxPackage.addActionListener(this);
        this.cboxClass.addActionListener(this);
        this.cboxPackage.getEditor().getEditorComponent().addFocusListener(new ComboBoxFocusListener(this.cboxPackage));
        this.cboxClass.getEditor().getEditorComponent().addFocusListener(new ComboBoxFocusListener(this.cboxClass));
        if (this.cboxMember != null) {
            this.cboxMember.getEditor().getEditorComponent().addFocusListener(new ComboBoxFocusListener(this.cboxMember));
        }
    }

    private void loadPackageNames() {
        List list = PackageListLoader.getPackageNames();
        if (list != null) {
            this.cboxPackageModel.setElements(list);
        } else {
            this.cboxPackageModel.setSingleElement(LOADING_PACKAGE_NAMES);
            PackageListLoader.loadPackageNames(new TaskListener(){

                public void taskFinished(Task task) {
                    List list = PackageListLoader.getPackageNames();
                    if (list == null) {
                        throw new IllegalStateException("Could not load list of package names.");
                    }
                    JavaElementSelector.this.cboxPackageModel.setElements(list);
                }
            });
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        if (jComboBox == this.cboxPackage) {
            this.packageEdited = true;
        } else if (jComboBox == this.cboxClass) {
            this.classEdited = true;
        }
    }

    public void setInitialSelection(String string, String string2) {
        this.setInitialSelection(string, string2, null);
    }

    public void setExceptionFilter(boolean bl) {
        this.exceptionFilter = bl;
    }

    public void setInitialSelection(String string, String string2, String string3) {
        if (this.lookForMembers && string3 != null) {
            this.cboxMember.setSelectedItem(string3);
        }
        if (string2 != null) {
            this.cboxClass.setSelectedItem(string2);
            this.lastClass = string2;
            this.needMembersForClassName = string2;
        }
        if (string != null) {
            this.cboxPackage.setSelectedItem(string);
            this.loadClassList(string);
            this.lastPackage = string;
        }
        if (this.classHistory != null) {
            this.classHistory.setPackage(string != null ? string : "");
        }
    }

    public void setPackageHistory(AbstractHistory abstractHistory) {
        if (abstractHistory != this.packageHistory) {
            if (this.packageHistory != null) {
                this.packageHistory.removeHistoryListener(this.cboxPackageModel);
                this.cboxPackageModel.setHistory(null);
            }
            this.packageHistory = abstractHistory;
            if (this.packageHistory != null) {
                this.cboxPackageModel.setHistory(this.packageHistory);
                this.packageHistory.addHistoryListener(this.cboxPackageModel);
            }
        }
    }

    public void setClassHistory(PackageClassHistory packageClassHistory) {
        if (packageClassHistory != this.classHistory) {
            if (this.classHistory != null) {
                this.classHistory.removeHistoryListener(this.cboxClassModel);
                this.cboxClassModel.setHistory(null);
            }
            this.classHistory = packageClassHistory;
            if (this.classHistory != null) {
                this.classHistory.setPackage((String)this.cboxClass.getEditor().getItem());
                this.cboxClassModel.setHistory(this.classHistory);
                this.classHistory.addHistoryListener(this.cboxClassModel);
            }
        }
    }

    public static final String getShortClassName(ClassElement classElement) {
        if (classElement.isInner()) {
            String string = classElement.getVMName();
            return string.substring(string.lastIndexOf(46) + 1).replace('$', '.');
        }
        return classElement.getName().getName();
    }

    public JComboBox getPackageSelector() {
        return this.cboxPackage;
    }

    public JComboBox getClassSelector() {
        return this.cboxClass;
    }

    public JComboBox getMemberSelector() {
        return this.cboxMember;
    }

    public String getSelectedPackage() {
        return ((String)this.cboxPackage.getEditor().getItem()).trim();
    }

    public String getSelectedClass() {
        return ((String)this.cboxClass.getEditor().getItem()).trim();
    }

    public String getSelectedMember() {
        return ((String)this.cboxMember.getEditor().getItem()).trim();
    }

    private void cboxPackageFocusLost() {
        String string = ((String)this.cboxPackage.getEditor().getItem()).trim();
        if (this.packageEdited && !string.equals(this.lastPackage)) {
            this.loadClassList(string);
        }
        this.lastPackage = string;
        this.packageEdited = false;
    }

    private void cboxClassFocusLost() {
        if (this.classEdited && this.lookForMembers) {
            String string = ((String)this.cboxClass.getEditor().getItem()).trim();
            if (!string.equals(this.lastClass)) {
                ClassElement classElement = null;
                JavaElementSelector javaElementSelector = this;
                synchronized (javaElementSelector) {
                    if (string.length() != 0 && (classElement = (ClassElement)this.classElementMap.get(string)) == null) {
                        this.needMembersForClassName = string;
                    }
                    if (classElement == null) {
                        this.cboxMemberModel.removeAllElements();
                    } else {
                        this.loadMemberList(classElement);
                    }
                }
            }
            this.lastClass = string;
            this.classEdited = false;
        }
    }

    private void loadClassList(String string) {
        if (this.exceptionFilter && string.equals("java.lang")) {
            this.waitForClassLookupThread();
            this.cboxClassModel.setElements(STANDARD_JAVA_EXCEPTIONS);
        } else {
            if (this.classLookup == null) {
                this.classLookup = new ClassLookup(this);
            }
            this.waitForClassLookupThread();
            this.classElementMap.clear();
            if (this.lookForMembers) {
                this.cboxMemberModel.removeAllElements();
                this.needMembersForClassName = ((String)this.cboxClass.getEditor().getItem()).trim();
            }
            this.cboxClassModel.setSingleElement(SEARCHING);
            this.classLookup.setPackage(string);
            this.classLookupThread = new Thread((Runnable)this.classLookup, "Debugger Class Lookup");
            this.classLookupThread.start();
        }
    }

    private void loadMemberList(ClassElement classElement) {
        int n;
        int n2;
        InitializerElement[] initializerElementArray;
        ArrayList<String> arrayList = new ArrayList<String>(15);
        if (this.clinitElem) {
            initializerElementArray = classElement.getInitializers();
            n2 = initializerElementArray.length;
            n = 0;
            while (n < n2) {
                if (initializerElementArray[n].isStatic()) {
                    arrayList.add(CLINIT_DESCRIPTION);
                    break;
                }
                ++n;
            }
        }
        if (this.initElem) {
            arrayList.add(INIT_DESCRIPTION);
        }
        if (this.methodElem) {
            initializerElementArray = classElement.getMethods();
            n2 = initializerElementArray.length;
            n = 0;
            while (n < n2) {
                arrayList.add(initializerElementArray[n].getName().getName());
                ++n;
            }
        }
        if (this.fieldElem) {
            initializerElementArray = classElement.getFields();
            n2 = initializerElementArray.length;
            n = 0;
            while (n < n2) {
                arrayList.add(initializerElementArray[n].getName().getName());
                ++n;
            }
        }
        this.cboxMemberModel.setElements(arrayList);
    }

    private void waitForClassLookupThread() {
        if (this.classLookupThread != null && this.classLookupThread.isAlive()) {
            this.classLookup.interrupt();
            try {
                this.classLookupThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void update(Observable observable, Object object) {
        int n = this.cboxClassModel.getSize();
        if (object == null) {
            this.cboxClassModel.removeLastElement();
        } else {
            String string;
            boolean bl;
            ClassElement classElement = (ClassElement)object;
            if (this.exceptionFilter) {
                int n2;
                bl = false;
                string = null;
                if (!classElement.isInner() && (n2 = (string = classElement.getName().getName()).length()) >= 5 && string.charAt(n2 - 2) == 'o' && (string.endsWith("Exception") || string.endsWith("Error"))) {
                    bl = this.classElementMap.put(string, DUMMY_OBJECT) == null;
                }
            } else {
                string = JavaElementSelector.getShortClassName(classElement);
                if (this.lookForMembers) {
                    JavaElementSelector javaElementSelector = this;
                    synchronized (javaElementSelector) {
                        boolean bl2 = bl = this.classElementMap.put(string, classElement) == null;
                        if (this.needMembersForClassName != null && string.equals(this.needMembersForClassName)) {
                            this.loadMemberList(classElement);
                            this.needMembersForClassName = null;
                        }
                    }
                } else {
                    boolean bl3 = bl = this.classElementMap.put(string, DUMMY_OBJECT) == null;
                }
            }
            if (bl) {
                this.cboxClassModel.insertElementBeforeLast(string);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList(3);
        }
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
            if (this.changeListeners.size() == 0) {
                this.changeListeners = null;
            }
        }
    }

    protected void fireStateChanged(JComboBox jComboBox) {
        if (this.changeListeners != null) {
            ChangeEvent changeEvent = new ChangeEvent(jComboBox);
            Iterator iterator = this.changeListeners.iterator();
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged(changeEvent);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DUMMY_OBJECT = new Object();
        boolean bl = Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
        STANDARD_JAVA_EXCEPTIONS = new ArrayList(bl ? 47 : 46);
        STANDARD_JAVA_EXCEPTIONS.add("ArithmeticException");
        STANDARD_JAVA_EXCEPTIONS.add("ArrayIndexOutOfBoundsException");
        STANDARD_JAVA_EXCEPTIONS.add("ArrayStoreException");
        STANDARD_JAVA_EXCEPTIONS.add("ClassCastException");
        STANDARD_JAVA_EXCEPTIONS.add("ClassNotFoundException");
        STANDARD_JAVA_EXCEPTIONS.add("CloneNotSupportedException");
        STANDARD_JAVA_EXCEPTIONS.add("Exception");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalAccessException");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalArgumentException");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalMonitorStateException");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalStateException");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalThreadStateException");
        STANDARD_JAVA_EXCEPTIONS.add("IndexOutOfBoundsException");
        STANDARD_JAVA_EXCEPTIONS.add("InstantiationException");
        STANDARD_JAVA_EXCEPTIONS.add("InterruptedException");
        STANDARD_JAVA_EXCEPTIONS.add("NegativeArraySizeException");
        STANDARD_JAVA_EXCEPTIONS.add("NoSuchFieldException");
        STANDARD_JAVA_EXCEPTIONS.add("NoSuchMethodException");
        STANDARD_JAVA_EXCEPTIONS.add("NullPointerException");
        STANDARD_JAVA_EXCEPTIONS.add("NumberFormatException");
        STANDARD_JAVA_EXCEPTIONS.add("RuntimeException");
        STANDARD_JAVA_EXCEPTIONS.add("SecurityException");
        STANDARD_JAVA_EXCEPTIONS.add("StringIndexOutOfBoundsException");
        STANDARD_JAVA_EXCEPTIONS.add("UnsupportedOperationException");
        STANDARD_JAVA_EXCEPTIONS.add("AbstractMethodError");
        if (bl) {
            STANDARD_JAVA_EXCEPTIONS.add("AssertionError");
        }
        STANDARD_JAVA_EXCEPTIONS.add("ClassCircularityError");
        STANDARD_JAVA_EXCEPTIONS.add("ClassFormatError");
        STANDARD_JAVA_EXCEPTIONS.add("Error");
        STANDARD_JAVA_EXCEPTIONS.add("ExceptionInInitializerError");
        STANDARD_JAVA_EXCEPTIONS.add("IllegalAccessError");
        STANDARD_JAVA_EXCEPTIONS.add("IncompatibleClassChangeError");
        STANDARD_JAVA_EXCEPTIONS.add("InstantiationError");
        STANDARD_JAVA_EXCEPTIONS.add("InternalError");
        STANDARD_JAVA_EXCEPTIONS.add("LinkageError");
        STANDARD_JAVA_EXCEPTIONS.add("NoClassDefFoundError");
        STANDARD_JAVA_EXCEPTIONS.add("NoSuchFieldError");
        STANDARD_JAVA_EXCEPTIONS.add("NoSuchMethodError");
        STANDARD_JAVA_EXCEPTIONS.add("OutOfMemoryError");
        STANDARD_JAVA_EXCEPTIONS.add("StackOverflowError");
        STANDARD_JAVA_EXCEPTIONS.add("ThreadDeath");
        STANDARD_JAVA_EXCEPTIONS.add("UnknownError");
        STANDARD_JAVA_EXCEPTIONS.add("UnsatisfiedLinkError");
        STANDARD_JAVA_EXCEPTIONS.add("UnsupportedClassVersionError");
        STANDARD_JAVA_EXCEPTIONS.add("VerifyError");
        STANDARD_JAVA_EXCEPTIONS.add("VirtualMachineError");
        STANDARD_JAVA_EXCEPTIONS.add("Throwable");
    }

    private static final class ComboBoxItemRenderer
    implements ListCellRenderer {
        private static final ListCellRenderer DEFAULT = new JComboBox().getRenderer();

        private ComboBoxItemRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == SEPARATOR) {
                return SEPARATOR;
            }
            return DEFAULT.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }

    private final class ComboBoxFocusListener
    implements FocusListener {
        private JComboBox cbox;

        public ComboBoxFocusListener(JComboBox jComboBox) {
            this.cbox = jComboBox;
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                if (this.cbox == JavaElementSelector.this.cboxPackage) {
                    JavaElementSelector.this.cboxPackageFocusLost();
                } else if (this.cbox == JavaElementSelector.this.cboxClass) {
                    JavaElementSelector.this.cboxClassFocusLost();
                }
                JavaElementSelector.this.fireStateChanged(this.cbox);
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                this.cbox.getEditor().selectAll();
            }
        }
    }

    public static final class MyMutableComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    HistoryListener {
        protected static final int MIN_SIZE = 5;
        protected static final Object DUMMY = " ";
        protected Vector data = new Vector(20, 15);
        protected ArrayList historyData;
        protected boolean hasSeparator;
        protected Object selectedItem;
        protected AbstractHistory history;
        protected int dataSize;
        protected int historySize;
        protected int totalSize;
        protected int maxHistoryRows;

        public int getSize() {
            if (this.totalSize > 5) {
                return this.totalSize;
            }
            return 5;
        }

        public Object getElementAt(int n) {
            if (n < 0) {
                return null;
            }
            if (n < this.historySize) {
                return this.historyData.get(this.historySize - n - 1);
            }
            if (n < this.totalSize) {
                if (this.hasSeparator) {
                    if (n == this.historySize) {
                        return SEPARATOR;
                    }
                    return this.data.elementAt(n - this.historySize - 1);
                }
                return this.data.elementAt(n);
            }
            if (n < 5) {
                return DUMMY;
            }
            return null;
        }

        public void setSelectedItem(Object object) {
            if (object == DUMMY || object == SEARCHING || object == SEPARATOR) {
                return;
            }
            if (this.selectedItem == null && object != null || this.selectedItem != null && !this.selectedItem.equals(object)) {
                if (object != CLINIT_DESCRIPTION && object != INIT_DESCRIPTION) {
                    this.selectedItem = object;
                } else if (object == CLINIT_DESCRIPTION) {
                    this.selectedItem = "<clinit>";
                } else if (object == INIT_DESCRIPTION) {
                    this.selectedItem = "<init>";
                }
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void insertElementBeforeLast(Object object) {
            int n = this.dataSize - 1;
            int n2 = this.totalSize - 1;
            int n3 = this.dataSize + 1;
            int n4 = this.totalSize + 1;
            if (this.totalSize > 5) {
                this.data.insertElementAt(object, n);
                this.dataSize = n3;
                this.totalSize = n4;
                this.fireIntervalAdded(this, n2, n2);
            } else {
                int n5 = n2 + 1;
                this.data.insertElementAt(object, n);
                this.dataSize = n3;
                this.totalSize = n4;
                this.fireContentsChanged(this, n2, n5);
            }
        }

        public void removeLastElement() {
            if (this.dataSize == 1) {
                this.removeAllElements();
            } else {
                int n = this.dataSize - 1;
                int n2 = this.totalSize - 1;
                boolean bl = this.dataSize > 5;
                this.data.removeElementAt(n);
                this.dataSize = n;
                this.totalSize = n2;
                if (bl) {
                    this.fireIntervalRemoved(this, n2, n2);
                } else {
                    this.fireContentsChanged(this, n2, n2);
                }
            }
        }

        public void setSingleElement(Object object) {
            if (this.dataSize == 0) {
                boolean bl;
                boolean bl2;
                int n;
                int n2;
                int n3;
                if (this.historySize == 0) {
                    n3 = 1;
                    n2 = 0;
                    n = 0;
                    bl2 = false;
                    bl = false;
                } else {
                    n3 = this.historySize + 2;
                    n2 = this.historySize;
                    n = n2 + 1;
                    bl2 = true;
                    bl = this.historySize >= 5;
                }
                this.data.add(object);
                this.dataSize = 1;
                this.totalSize = n3;
                this.hasSeparator = bl2;
                if (bl) {
                    this.fireIntervalAdded(this, n2, n);
                } else {
                    this.fireContentsChanged(this, n2, n);
                }
            } else {
                int n = this.hasSeparator ? this.historySize + 1 : 0;
                int n4 = n + this.dataSize - 1;
                int n5 = n + 1;
                this.data.clear();
                this.data.add(object);
                this.dataSize = 1;
                this.totalSize = n5;
                this.fireContentsChanged(this, n, n4);
                this.data.trimToSize();
            }
        }

        public void removeAllElements() {
            if (this.dataSize != 0) {
                int n;
                int n2;
                if (this.historySize == 0) {
                    n2 = 0;
                    n = this.dataSize - 1;
                } else {
                    n2 = this.historySize;
                    n = n2 + this.dataSize;
                }
                if (n2 < 5) {
                    this.data.removeAllElements();
                    this.dataSize = 0;
                    this.totalSize = this.historySize;
                    this.hasSeparator = false;
                    this.fireContentsChanged(this, n2, n);
                } else {
                    this.data.removeAllElements();
                    this.dataSize = 0;
                    this.totalSize = this.historySize;
                    this.hasSeparator = false;
                    this.fireIntervalRemoved(this, n2, n);
                }
            }
        }

        public void setElements(Collection collection) {
            int n = collection.size();
            if (n == 0) {
                this.removeAllElements();
                return;
            }
            if (this.dataSize == 0) {
                boolean bl;
                boolean bl2;
                int n2;
                int n3;
                int n4;
                if (this.historySize == 0) {
                    n4 = n;
                    n3 = 0;
                    n2 = n - 1;
                    bl2 = false;
                    bl = false;
                } else {
                    n4 = this.historySize + n + 1;
                    n3 = this.historySize;
                    n2 = n3 + n;
                    bl2 = true;
                    bl = n3 >= 5;
                }
                this.data.clear();
                this.data.addAll(collection);
                this.data.trimToSize();
                this.dataSize = n;
                this.totalSize = n4;
                this.hasSeparator = bl2;
                if (bl) {
                    this.fireIntervalAdded(this, n3, n2);
                } else {
                    this.fireContentsChanged(this, n3, n2);
                }
            } else {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9 = n8 = n > this.dataSize ? n : this.dataSize;
                if (this.hasSeparator) {
                    n7 = this.historySize + 1;
                    n6 = n7 + n8;
                    n5 = this.historySize + 1 + n;
                } else {
                    n7 = 0;
                    n6 = n8 - 1;
                    n5 = n;
                }
                this.data.clear();
                this.data.addAll(collection);
                this.data.trimToSize();
                this.dataSize = n;
                this.totalSize = n5;
                this.fireContentsChanged(this, n7, n6);
            }
        }

        public void setHistory(AbstractHistory abstractHistory) {
            this.historyData = abstractHistory == null ? null : new ArrayList(abstractHistory.getMaxSize());
            this.replaceHistoryData(0, abstractHistory.getItems());
            this.history = abstractHistory;
        }

        private void replaceHistoryData(int n, List list) {
            int n2 = list.size();
            if (n2 == n) {
                if (n2 != 0) {
                    int n3 = this.historySize - 1;
                    this.historyData.clear();
                    this.historyData.addAll(list);
                    this.fireContentsChanged(this, 0, n3);
                }
            } else if (n == 0) {
                boolean bl;
                boolean bl2;
                int n4;
                int n5;
                if (this.dataSize == 0) {
                    n5 = n2 - 1;
                    n4 = n2;
                    bl2 = false;
                    bl = false;
                } else if (this.dataSize < 5) {
                    n5 = n2 + this.dataSize;
                    n4 = n5 + 1;
                    bl2 = true;
                    bl = false;
                } else {
                    n5 = n2;
                    n4 = n2 + 1 + this.dataSize;
                    bl2 = true;
                    bl = true;
                }
                this.historyData.addAll(list);
                this.historySize = n2;
                this.hasSeparator = bl2;
                this.totalSize = n4;
                if (bl) {
                    this.fireIntervalAdded(this, 0, n5);
                } else {
                    this.fireContentsChanged(this, 0, n5);
                }
            } else if (n2 == 0) {
                boolean bl;
                int n6;
                if (this.dataSize == 0) {
                    n6 = this.historySize - 1;
                    bl = false;
                } else if (this.dataSize < 5) {
                    n6 = this.historySize + this.dataSize;
                    bl = false;
                } else {
                    n6 = this.historySize;
                    bl = true;
                }
                this.hasSeparator = false;
                this.historyData.clear();
                this.historySize = 0;
                this.totalSize = this.dataSize;
                if (bl) {
                    this.fireIntervalRemoved(this, 0, n6);
                } else {
                    this.fireContentsChanged(this, 0, n6);
                }
            } else {
                int n7 = this.totalSize + n2 - n;
                int n8 = n7 - 1;
                this.historyData.clear();
                this.historyData.addAll(list);
                this.historySize = n2;
                this.totalSize = n7;
                this.fireContentsChanged(this, 0, n8);
            }
        }

        public void historyListChanged(HistoryEvent historyEvent) {
            AbstractHistory abstractHistory = (AbstractHistory)historyEvent.getSource();
            int n = historyEvent.getEventType();
            switch (n) {
                case 2: {
                    this.replaceHistoryData(this.historySize, abstractHistory.getItems());
                    break;
                }
                case 0: {
                    int n2;
                    boolean bl;
                    Object object = historyEvent.getAddedItem();
                    int n3 = this.historySize + 1;
                    if (this.dataSize == 0) {
                        bl = false;
                        n2 = n3;
                    } else {
                        bl = true;
                        n2 = this.historySize + 2 + this.dataSize;
                    }
                    int n4 = this.historySize;
                    if (this.totalSize < 5) {
                        int n5 = n2 - 1;
                        this.historyData.add(object);
                        this.historySize = n3;
                        this.totalSize = n2;
                        this.hasSeparator = bl;
                        this.fireContentsChanged(this, 0, n5);
                        break;
                    }
                    int n6 = bl == this.hasSeparator ? 0 : 1;
                    this.historyData.add(object);
                    this.historySize = n3;
                    this.totalSize = n2;
                    this.hasSeparator = bl;
                    this.fireIntervalAdded(this, 0, n6);
                    break;
                }
                case 1: {
                    Object object = historyEvent.getAddedItem();
                    int n7 = this.historySize - 1;
                    this.historyData.remove(0);
                    this.historyData.add(object);
                    this.fireContentsChanged(this, 0, n7);
                }
            }
        }
    }
}

