/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.VariablesProducer;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.debugger.DebuggerException;
import org.openide.text.Line;

public abstract class CallStackFrame
implements Location,
VariablesProducer {
    public static final String PROP_IS_CURRENT = "isCurrentFrame";
    private transient boolean isCurrent;
    private transient PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public abstract int getLineNumber();

    public abstract String getMethodName();

    public abstract String getClassName();

    public abstract String getSourceName() throws DebuggerException;

    public boolean isLeaf() {
        return false;
    }

    public Line getLine() {
        try {
            return Utils.getLineForSource(this.getClassName(), this.getSourceName(), this.getLineNumber());
        }
        catch (DebuggerException debuggerException) {
            return Utils.getLine(this.getClassName(), this.getLineNumber());
        }
    }

    public String getLocationName() {
        return this.getClassName() + '.' + this.getMethodName() + " : " + this.getLineNumber();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setCurrent(boolean bl) {
        if (bl != this.isCurrent) {
            this.isCurrent = bl;
            this.pcs.firePropertyChange(PROP_IS_CURRENT, !this.isCurrent, this.isCurrent);
        }
    }

    public boolean isCurrent() {
        return this.isCurrent;
    }

    public abstract AbstractVariable[] getVariables();

    public abstract String getInfo();

    public abstract void setVariablesFilter(VariablesFilter var1);

    public abstract VariablesFilter getVariablesFilter();
}

