/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support.java;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;
import org.openide.filesystems.RepositoryReorderedEvent;
import org.openide.src.ClassElement;
import org.openide.util.WeakListener;

public class BreakpointUpdater
extends FileChangeAdapter
implements PropertyChangeListener,
RepositoryListener {
    protected CoreBreakpoint.Event breakpoint;
    protected String className;
    private Method classNameChangeMethod;
    private String classNameChangeMethodName;
    private WeakReference clsElemRef;
    protected transient FileObject fileObject;
    private PropertyChangeListener clsElementChangeListenerWeak;
    protected boolean onNestedClass;
    protected boolean listenOnClass;
    private Repository repository = TopManager.getDefault().getRepository();
    static /* synthetic */ Class class$java$lang$String;

    protected ClassElement getClsElement() {
        if (this.clsElemRef == null) {
            return null;
        }
        ClassElement classElement = (ClassElement)this.clsElemRef.get();
        if (classElement == null) {
            this.clsElementChangeListenerWeak = null;
        }
        return classElement;
    }

    protected ClassElement setClsElement(ClassElement classElement) {
        this.clsElemRef = classElement == null ? null : new WeakReference<ClassElement>(classElement);
        return classElement;
    }

    public BreakpointUpdater(CoreBreakpoint.Event event, String string, String string2) {
        this.repository.addRepositoryListener((RepositoryListener)this);
        this.classNameChangeMethodName = string;
        this.breakpoint = event;
        this.setClassName(string2);
    }

    public void dispose() {
        ClassElement classElement = this.getClsElement();
        if (classElement != null) {
            this.refreshClsElementListener(classElement, null);
        }
        if (this.fileObject != null) {
            this.refreshFileObjectListener(this.fileObject, null);
        }
        if (this.repository != null) {
            this.repository.removeRepositoryListener((RepositoryListener)this);
            this.repository = null;
        }
    }

    protected synchronized void refreshClsElementListener() {
        ClassElement classElement;
        ClassElement classElement2 = this.getClsElement();
        ClassElement classElement3 = classElement = this.className == null ? null : ClassElement.forName((String)this.className);
        if (classElement == classElement2) {
            return;
        }
        this.setClsElement(classElement);
        this.refreshClsElementListener(classElement2, classElement);
    }

    protected synchronized void refreshClsElementListener(ClassElement classElement, ClassElement classElement2) {
        if (classElement2 != classElement) {
            if (classElement != null) {
                classElement.removePropertyChangeListener(this.clsElementChangeListenerWeak);
                this.clsElementChangeListenerWeak = null;
            }
            if (classElement2 != null) {
                this.clsElementChangeListenerWeak = WeakListener.propertyChange((PropertyChangeListener)this, (Object)classElement2);
                classElement2.addPropertyChangeListener(this.clsElementChangeListenerWeak);
            }
        }
    }

    protected synchronized void refreshFileObjectListener() {
        FileObject fileObject = this.fileObject;
        this.fileObject = this.className == null ? null : TopManager.getDefault().getRepository().find(Utils.getPackageName(this.className), Utils.getTopClassName(Utils.getClassName(this.className)), "java");
        this.refreshFileObjectListener(fileObject, this.fileObject);
    }

    protected synchronized void refreshFileObjectListener(FileObject fileObject, FileObject fileObject2) {
        if (fileObject2 != fileObject) {
            if (fileObject != null) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
            }
            if (fileObject2 != null) {
                fileObject2.addFileChangeListener((FileChangeListener)this);
            }
        }
    }

    public void setClassName(String string) {
        this.className = string;
        boolean bl = this.listenOnClass;
        this.refreshFileObjectListener();
        this.onNestedClass = string != null && string.indexOf(36) != -1;
        boolean bl2 = this.listenOnClass = this.onNestedClass && this.fileObject != null;
        if (bl && !this.listenOnClass) {
            ClassElement classElement = this.getClsElement();
            this.setClsElement(null);
            this.refreshClsElementListener(classElement, null);
        } else if (this.listenOnClass) {
            this.refreshClsElementListener();
        }
    }

    protected void updateBreakpoint() {
        if (this.classNameChangeMethodName != null) {
            try {
                this.classNameChangeMethod = this.breakpoint.getClass().getMethod(this.classNameChangeMethodName, class$java$lang$String == null ? (class$java$lang$String = BreakpointUpdater.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (Exception exception) {
                TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
            }
            this.classNameChangeMethodName = null;
        }
        if (this.classNameChangeMethod != null) {
            try {
                this.classNameChangeMethod.invoke((Object)this.breakpoint, this.className);
            }
            catch (Exception exception) {
                this.classNameChangeMethod = null;
                TopManager.getDefault().getErrorManager().notify(4096, (Throwable)exception);
            }
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        if (this.onNestedClass) {
            this.refreshClsElementListener();
        }
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.fileObject = null;
        this.refreshFileObjectListener(this.fileObject, null);
        if (this.listenOnClass) {
            this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        if (!this.onNestedClass) {
            this.className = this.fileObject.getPackageName('.');
            this.updateBreakpoint();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("name")) {
            this.className = ((ClassElement)propertyChangeEvent.getSource()).getVMName();
            this.updateBreakpoint();
        }
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        if (this.fileObject == null) {
            this.refreshFileObjectListener();
            boolean bl = this.listenOnClass = this.onNestedClass && this.fileObject != null;
            if (this.listenOnClass) {
                this.refreshClsElementListener();
            }
        }
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        if (this.fileObject != null) {
            boolean bl;
            try {
                bl = repositoryEvent.getFileSystem() == this.fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                bl = true;
            }
            if (bl) {
                this.fileObject = null;
                this.refreshFileObjectListener(this.fileObject, null);
                if (this.listenOnClass) {
                    this.refreshClsElementListener(this.getClsElement(), this.setClsElement(null));
                    this.listenOnClass = false;
                }
            }
        }
    }

    public void fileSystemPoolReordered(RepositoryReorderedEvent repositoryReorderedEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

