/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import org.netbeans.modules.debugger.AbstractDebuggerType;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.support.ProcessDebuggerInfo;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.execution.ExecInfo;
import org.openide.execution.NbClassPath;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileSystemCapability;
import org.openide.loaders.DataObject;
import org.openide.loaders.ExecSupport;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.text.Line;
import org.openide.util.HelpCtx;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ProcessDebuggerType
extends AbstractDebuggerType {
    static final long serialVersionUID = 833275268075073629L;
    public static final String PROP_DEBUGGER_PROCESS = "debuggerProcess";
    public static final String PROP_CLASSIC = "classic";
    public static final String PROP_CLASSPATH = "classPath";
    public static final String PROP_BOOT_CLASSPATH = "bootClassPath";
    public static final String PROP_REPOSITORY = "repositoryPath";
    public static final String PROP_LIBRARY = "libraryPath";
    public static final String PROP_NAME = "name";
    public static final String PROP_WORKING_DIRECTORY = "workingDirectory";
    public static final String CLASSIC_SWITCH = "classic";
    public static final String DEBUGGER_OPTIONS = "debuggerOptions";
    public static final String BOOT_CLASS_PATH_SWITCH_SWITCH = "bootclasspathSwitch";
    public static final String BOOT_CLASS_PATH_SWITCH = "bootclasspath";
    public static final String REPOSITORY_SWITCH = "filesystems";
    public static final String LIBRARY_SWITCH = "library";
    public static final String CLASS_PATH_SWITCH = "classpath";
    public static final String MAIN_SWITCH = "main";
    public static final String JAVA_HOME_SWITCH = "java.home";
    public static final String JDK_HOME_SWITCH = "jdk.home";
    public static final String FILE_SEPARATOR_SWITCH = "/";
    public static final String PATH_SEPARATOR_SWITCH = ":";
    public static final String QUOTE_SWITCH = "q";
    public static NbProcessDescriptor DEFAULT_DEBUGGER_PROCESS;
    private static String bootClassPath;
    private NbProcessDescriptor debuggerProcess;
    protected boolean classic;
    protected boolean classicInited = false;
    protected boolean setted = false;
    private File workingDirectory = null;
    private int serialVer = 1;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$ProcessDebuggerType;

    public static NbProcessDescriptor getDefaultDebuggerProcess() {
        if (DEFAULT_DEBUGGER_PROCESS != null) {
            return DEFAULT_DEBUGGER_PROCESS;
        }
        DEFAULT_DEBUGGER_PROCESS = new NbProcessDescriptor(ProcessDebuggerType.getDefaultProcessName(), "{classic}{debuggerOptions} -Djava.compiler=NONE {q}{bootclasspathSwitch}{bootclasspath}{q} -classpath {q}{filesystems}{q} {main}", NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$ProcessDebuggerType == null ? (class$org$netbeans$modules$debugger$support$ProcessDebuggerType = ProcessDebuggerType.class$("org.netbeans.modules.debugger.support.ProcessDebuggerType")) : class$org$netbeans$modules$debugger$support$ProcessDebuggerType)).getString("MSG_DebuggerHint"));
        return DEFAULT_DEBUGGER_PROCESS;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.serialVer == 0) {
            this.setDebuggerProcess(ProcessDebuggerType.getDefaultDebuggerProcess());
        }
    }

    public String displayName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$support$ProcessDebuggerType == null ? (class$org$netbeans$modules$debugger$support$ProcessDebuggerType = ProcessDebuggerType.class$("org.netbeans.modules.debugger.support.ProcessDebuggerType")) : class$org$netbeans$modules$debugger$support$ProcessDebuggerType)).getString("CTL_Process_debugger_type");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$modules$debugger$support$ProcessDebuggerType == null ? (class$org$netbeans$modules$debugger$support$ProcessDebuggerType = ProcessDebuggerType.class$("org.netbeans.modules.debugger.support.ProcessDebuggerType")) : class$org$netbeans$modules$debugger$support$ProcessDebuggerType);
    }

    public void startDebugger(DataObject dataObject, Line line) throws DebuggerException {
        String[] stringArray;
        try {
            stringArray = TopManager.getDefault().getDebugger();
            CoreBreakpoint coreBreakpoint = (CoreBreakpoint)stringArray.createBreakpoint(line, true);
            CoreBreakpoint.Action[] actionArray = coreBreakpoint.getActions();
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (actionArray[n2] instanceof PrintAction) {
                    ((PrintAction)actionArray[n2]).setPrintText(PrintAction.RUN_TO_CURSOR_TEXT);
                }
                ++n2;
            }
            stringArray.addPropertyChangeListener((PropertyChangeListener)new Listener((Debugger)stringArray, coreBreakpoint));
        }
        catch (DebuggerNotFoundException debuggerNotFoundException) {
            // empty catch block
        }
        stringArray = ExecSupport.getArguments((MultiDataObject.Entry)new FileEntry(null, dataObject.getPrimaryFile()));
        this.startDebugger(new ExecInfo(dataObject.getPrimaryFile().getPackageName('.'), stringArray), false);
    }

    public void startDebugger(ExecInfo execInfo, boolean bl) throws DebuggerException {
        if (!this.prepareArguments()) {
            return;
        }
        this.startDebugger(execInfo.getClassName(), execInfo.getArguments(), bl ? execInfo.getClassName() : null, this.getDebuggerProcess(), this.getClassPath(), this.getBootClassPath(), this.getRepositoryPath(), this.getLibraryPath(), this.isClassic(), execInfo, bl);
    }

    public boolean supportsDebuggingOf(DataObject dataObject) {
        return dataObject.getPrimaryFile().getMIMEType().equals("text/x-java");
    }

    protected void startDebugger(String string, String[] stringArray, String string2, NbProcessDescriptor nbProcessDescriptor, String string3, String string4, String string5, String string6, boolean bl, ExecInfo execInfo, boolean bl2) throws DebuggerException {
        TopManager.getDefault().getDebugger().startDebugger((DebuggerInfo)new ProcessDebuggerInfo(string, stringArray, string2, nbProcessDescriptor, string3, string4, string5, string6, this.getWorkingDirectory(), bl, string));
    }

    protected boolean getClassicDefault() {
        boolean bl = Utils.hasHotSpot(new MapFormat((Map)Utils.processDebuggerInfo(null, "", "")).format(this.getDebuggerProcess().getProcessName()));
        return bl;
    }

    protected boolean prepareArguments() {
        if (!this.setted) {
            boolean bl = this.classic;
            this.classic = this.getClassicDefault();
            this.firePropertyChange("classic", new Boolean(bl), new Boolean(this.classic));
        }
        return true;
    }

    public static String getDefaultProcessName() {
        if (Utilities.getOperatingSystem() == 1024) {
            return "{jdk.home}{/}jre{/}bin{/}java";
        }
        return "{jdk.home}{/}bin{/}java";
    }

    public NbProcessDescriptor getDebuggerProcess() {
        if (this.debuggerProcess != null) {
            return this.debuggerProcess;
        }
        return ProcessDebuggerType.getDefaultDebuggerProcess();
    }

    public void setDebuggerProcess(NbProcessDescriptor nbProcessDescriptor) {
        NbProcessDescriptor nbProcessDescriptor2 = this.getDebuggerProcess();
        this.debuggerProcess = nbProcessDescriptor;
        this.firePropertyChange(PROP_DEBUGGER_PROCESS, nbProcessDescriptor2, this.debuggerProcess);
    }

    public boolean isClassic() {
        if (this.setted || this.classicInited) {
            return this.classic;
        }
        this.classicInited = true;
        this.classic = this.getClassicDefault();
        return this.classic;
    }

    public void setClassic(boolean bl) {
        if (bl == this.classic) {
            return;
        }
        this.classic = bl;
        this.setted = true;
        this.firePropertyChange("classic", new Boolean(!bl), new Boolean(bl));
    }

    public String getRepositoryPath() {
        return NbClassPath.createRepositoryPath((FileSystemCapability)FileSystemCapability.DEBUG).getClassPath();
    }

    public void setRepositoryPath(String string) {
    }

    public String getLibraryPath() {
        return NbClassPath.createLibraryPath().getClassPath();
    }

    public void setLibraryPath(String string) {
    }

    public String getClassPath() {
        return NbClassPath.createClassPath().getClassPath();
    }

    public void setClassPath(String string) {
    }

    public String getBootClassPath() {
        if (bootClassPath != null) {
            return bootClassPath;
        }
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty(JAVA_HOME_SWITCH) + string;
        String string4 = System.getProperty("netbeans.home");
        String string5 = System.getProperty(JDK_HOME_SWITCH) + string;
        bootClassPath = NbClassPath.createBootClassPath().getClassPath();
        if (bootClassPath.startsWith("\"")) {
            bootClassPath = bootClassPath.substring(1, bootClassPath.length());
        }
        if (bootClassPath.endsWith("\"")) {
            bootClassPath = bootClassPath.substring(0, bootClassPath.length() - 1);
        }
        bootClassPath = string5 + "lib" + string + "tools.jar" + string2 + bootClassPath;
        return bootClassPath;
    }

    public void setBootClassPath(String string) {
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File file) {
        this.workingDirectory = file;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements PropertyChangeListener {
        Breakpoint b;
        Debugger d;

        Listener(Debugger debugger, Breakpoint breakpoint) {
            this.d = debugger;
            this.b = breakpoint;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block2: {
                block3: {
                    if (!propertyChangeEvent.getPropertyName().equals("state")) break block2;
                    if ((Integer)propertyChangeEvent.getNewValue() == 4) break block3;
                    if ((Integer)propertyChangeEvent.getNewValue() != 1) break block2;
                }
                this.b.remove();
                this.d.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

