/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.multisession;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.State;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.delegator.DelegatingBreakpoint;
import org.netbeans.modules.debugger.delegator.DelegatingDebugger;
import org.netbeans.modules.debugger.delegator.DelegatingThreadProducer;
import org.netbeans.modules.debugger.multisession.FinishActionPanel;
import org.netbeans.modules.debugger.multisession.Session;
import org.netbeans.modules.debugger.multisession.SessionBreakpoint;
import org.netbeans.modules.debugger.multisession.SessionsListener;
import org.netbeans.modules.debugger.support.DebuggerContextSettings;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.actions.ContinueAction;
import org.netbeans.modules.debugger.support.actions.FinishAction;
import org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction;
import org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction;
import org.netbeans.modules.debugger.support.actions.PauseAction;
import org.netbeans.modules.debugger.support.actions.RunToCursorAction;
import org.netbeans.modules.debugger.support.actions.StepIntoAction;
import org.netbeans.modules.debugger.support.actions.StepOutAction;
import org.netbeans.modules.debugger.support.actions.StepOverAction;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.StartDebuggerAction;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public class EnterpriseDebugger
extends DelegatingDebugger {
    static final long serialVersionUID = 1969501498004072694L;
    public static final String PROP_CURRENT_SESSION = "currentSession";
    public static final int RUN_SINGLE = 0;
    public static final int RUN_MULTI = 1;
    public static final int RUN_CANCEL = 2;
    private static ResourceBundle bundle;
    private transient Session currentSession;
    private transient ArrayList debuggers = new ArrayList();
    private transient HashMap runningDebuggers = new HashMap();
    private transient Vector sessionsListener = new Vector(10, 20);
    private transient SessionListener sessionListener = new SessionListener();
    private static ArrayList ioToClose;
    private transient DelegatingThreadProducer threadProducer = new DelegatingThreadProducer();
    private AbstractDebugger currentDebugger;
    private StepIntoAction stepIntoAction;
    private StepOverAction stepOverAction;
    private StepOutAction stepOutAction;
    private GoToCalledMethodAction goToCalledMethodAction;
    private GoToCallingMethodAction goToCallingMethodAction;
    private RunToCursorAction runToCursorAction;
    private PauseAction pauseAction;
    private ContinueAction continueAction;
    private FinishAction finishAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$DebuggerContextSettings;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$delegator$DelegatingDebugger;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepIntoAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepOverAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$StepOutAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$RunToCursorAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$PauseAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$ContinueAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$FinishAction;

    static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger == null ? (class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger = EnterpriseDebugger.class$("org.netbeans.modules.debugger.multisession.EnterpriseDebugger")) : class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger));
        }
        return bundle.getString(string);
    }

    protected void setDebugger(AbstractDebugger abstractDebugger) {
        super.setDebugger(abstractDebugger);
        Breakpoint[] breakpointArray = this.getBreakpoints();
        int n = 0;
        while (n < breakpointArray.length) {
            if (breakpointArray[n] instanceof DelegatingBreakpoint) {
                breakpointArray[n].remove();
                this.createBreakpoint(false).setEvent(((DelegatingBreakpoint)breakpointArray[n]).getEvent(this));
            }
            ++n;
        }
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        Session session;
        int n;
        String string;
        this.lastDebugInfo = debuggerInfo;
        WindowManager windowManager = TopManager.getDefault().getWindowManager();
        Workspace workspace = windowManager.findWorkspace(string = ((DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true)).getDesktop());
        if (workspace != null) {
            workspace.activate();
        }
        int n2 = 1;
        if (debuggerInfo != null && this.debuggers.size() > 0) {
            n2 = this.showStartSessionDialog();
        }
        if (n2 == 2) {
            AbstractDebugger[] abstractDebuggerArray;
            AbstractDebugger abstractDebugger = this.getCurrentDebugger();
            if (abstractDebugger == null && (abstractDebuggerArray = this.getDebuggers()).length > 0) {
                abstractDebugger = this.getDebuggers()[0];
            }
            this.setState(2);
            if (abstractDebugger != null) {
                this.setState(abstractDebugger.getState());
            } else {
                this.setState(1);
            }
            return;
        }
        if (n2 == 0) {
            n = this.debuggers.size() - 1;
            while (n >= 0) {
                session = (Session)this.debuggers.get(n);
                session.finishIn();
                --n;
            }
        } else {
            n = this.debuggers.size() - 1;
            while (n >= 0) {
                session = (Session)this.debuggers.get(n);
                session.start();
                --n;
            }
        }
        int n3 = ioToClose.size();
        n = 0;
        while (n < n3) {
            ((InputOutput)ioToClose.get(n)).closeInputOutput();
            ++n;
        }
        ioToClose = new ArrayList();
        if (debuggerInfo != null) {
            this.startSession(debuggerInfo);
        }
    }

    public void finishDebugger() throws DebuggerException {
        this.finishDebuggerIn();
    }

    public CoreBreakpoint createBreakpoint(boolean bl) {
        SessionBreakpoint sessionBreakpoint = new SessionBreakpoint(bl);
        this.getRootBreakpointGroup().addBreakpoint(sessionBreakpoint);
        this.addBreakpoint(sessionBreakpoint);
        return sessionBreakpoint;
    }

    protected AbstractDebugger createDebugger(DebuggerInfo debuggerInfo) {
        AbstractDebugger abstractDebugger = super.createDebugger(debuggerInfo);
        return abstractDebugger;
    }

    public void setSuspended(boolean bl) {
    }

    public String getVersion() {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger == null ? (class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger = EnterpriseDebugger.class$("org.netbeans.modules.debugger.multisession.EnterpriseDebugger")) : class$org$netbeans$modules$debugger$multisession$EnterpriseDebugger)).getString("CTL_Debugger_version");
    }

    public int getVersionPriority() {
        return 0;
    }

    public String getProcessName(DebuggerInfo debuggerInfo) {
        return "???";
    }

    public String getLocationName(DebuggerInfo debuggerInfo) {
        return "???";
    }

    public AbstractDebugger getInnerDebugger() {
        return this.getCurrentDebugger();
    }

    protected void setDebuggerState(State state) {
        super.setDebuggerState(state);
        this.refreshActions();
    }

    protected void setState(int n) {
        super.setState(n);
        if (n == 1) {
            this.setDebuggerState(DebuggerSupport.STATE_NOT_RUNNING);
        }
    }

    public AbstractDebugger getCurrentDebugger() {
        if (this.currentSession == null) {
            return this.currentDebugger;
        }
        return this.currentSession.getDebugger();
    }

    public Session getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(Session session) {
        if (session == this.currentSession) {
            return;
        }
        if (session == null) {
            Session session2 = this.currentSession;
            AbstractDebugger abstractDebugger = this.getCurrentDebugger();
            this.currentSession = null;
            this.firePropertyChange(PROP_CURRENT_SESSION, session2, this.currentSession);
            this.firePropertyChange("currentDebugger", abstractDebugger, this.getCurrentDebugger());
            return;
        }
        if (session.getCurrentThread() != null) {
            AbstractDebugger abstractDebugger = this.getCurrentDebugger();
            session.getCurrentThread().setCurrent(true);
            this.firePropertyChange("currentDebugger", abstractDebugger, this.getCurrentDebugger());
        } else {
            this.setCurrentDebugger(session.getDebugger());
        }
    }

    public Session[] getSessions() {
        Session[] sessionArray = new Session[this.debuggers.size()];
        return this.debuggers.toArray(sessionArray);
    }

    public AbstractDebugger[] getDebuggers() {
        ArrayList arrayList = (ArrayList)this.debuggers.clone();
        int n = arrayList.size();
        AbstractDebugger[] abstractDebuggerArray = new AbstractDebugger[n];
        int n2 = 0;
        while (n2 < n) {
            abstractDebuggerArray[n2] = ((Session)arrayList.get(n2)).getDebugger();
            ++n2;
        }
        return abstractDebuggerArray;
    }

    public Session findSession(AbstractDebugger abstractDebugger) {
        int n = this.debuggers.size();
        int n2 = 0;
        while (n2 < n) {
            if (((Session)this.debuggers.get(n2)).getDebugger().equals(abstractDebugger)) {
                return (Session)this.debuggers.get(n2);
            }
            ++n2;
        }
        return null;
    }

    public void startSession(DebuggerInfo debuggerInfo) throws DebuggerException {
        if (this.getState() == 1) {
            this.setState(2);
        }
        AbstractDebugger abstractDebugger = this.createDebugger(debuggerInfo);
        abstractDebugger.addPropertyChangeListener(this.sessionListener);
        this.currentDebugger = abstractDebugger;
        abstractDebugger.startDebugger(debuggerInfo);
        this.currentDebugger = null;
        if (abstractDebugger.getState() == 1) {
            abstractDebugger.removePropertyChangeListener(this.sessionListener);
            return;
        }
        if (abstractDebugger instanceof ThreadsRoot) {
            this.threadProducer.setRemoteThreadGroup(((ThreadsRoot)((Object)abstractDebugger)).getThreadsRoot());
        }
        if (debuggerInfo instanceof AbstractDebuggerInfo) {
            this.addSession(new Session(((AbstractDebuggerInfo)debuggerInfo).getProcessName(), ((AbstractDebuggerInfo)debuggerInfo).getLocationName(), abstractDebugger, debuggerInfo));
        } else {
            this.addSession(new Session("process", "localhost", abstractDebugger, debuggerInfo));
        }
    }

    private int showStartSessionDialog() {
        Object object;
        DebuggerContextSettings debuggerContextSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        if (!debuggerContextSettings.getShowRunMultisessionDialog()) {
            return debuggerContextSettings.getRunMultisession() ? 1 : 0;
        }
        String string = null;
        String string2 = EnterpriseDebugger.getString("TITLE_Start_session_dialog");
        int n = this.debuggers.size();
        if (n > 1) {
            string = new MessageFormat(EnterpriseDebugger.getString("MSG_Start_session_dialog")).format(new Object[]{new Integer(n)});
        } else {
            object = this.getSessions()[0].getSessionName();
            string = new MessageFormat(EnterpriseDebugger.getString("MSG_Start_second_session_dialog")).format(new Object[]{object});
        }
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout(0, 8));
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setEnabled(false);
        jTextArea.setOpaque(false);
        jTextArea.setFont(UIManager.getFont("Label.font"));
        jTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        ((JPanel)object).getAccessibleContext().setAccessibleName(bundle.getString("ACS_MSG_Start_session_dialog"));
        ((JPanel)object).getAccessibleContext().setAccessibleDescription(jTextArea.getText());
        ((Container)object).add((Component)jTextArea, "North");
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setText(EnterpriseDebugger.getString("CTL_DNSTDNT"));
        jCheckBox.setMnemonic(EnterpriseDebugger.getString("CTL_DNSTDNT_Mnemonic").charAt(0));
        jCheckBox.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_DNSTDNT"));
        ((Container)object).add((Component)jCheckBox, "South");
        ((JComponent)object).setPreferredSize(new Dimension(100, 110));
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(object, string2);
        JButton jButton = new JButton(EnterpriseDebugger.getString("CTL_FinishAndStart"));
        jButton.setMnemonic(EnterpriseDebugger.getString("CTL_FinishAndStart_Mnemonic").charAt(0));
        jButton.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_FinishAndStart"));
        JButton jButton2 = new JButton(EnterpriseDebugger.getString("CTL_StartNewSession"));
        jButton2.setMnemonic(EnterpriseDebugger.getString("CTL_StartNewSession_Mnemonic").charAt(0));
        jButton2.getAccessibleContext().setAccessibleDescription(EnterpriseDebugger.getString("ACSD_CTL_StartNewSession"));
        confirmation.setOptions(new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION});
        Object object2 = TopManager.getDefault().notify((NotifyDescriptor)confirmation);
        if (object2 == jButton) {
            debuggerContextSettings.setRunMultisession(false);
            debuggerContextSettings.setShowRunMultisessionDialog(!jCheckBox.isSelected());
            return 0;
        }
        if (object2 == jButton2) {
            debuggerContextSettings.setRunMultisession(true);
            debuggerContextSettings.setShowRunMultisessionDialog(!jCheckBox.isSelected());
            return 1;
        }
        return 2;
    }

    boolean finishDebuggerIn() throws DebuggerException {
        if (this.debuggers.size() > 0) {
            DebuggerContextSettings debuggerContextSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
            if (debuggerContextSettings.getShowFinishDialog() && !this.showFinishDialog()) {
                return false;
            }
            int n = this.debuggers.size() - 1;
            while (n >= 0) {
                Session session = (Session)this.debuggers.get(n);
                session.finish();
                --n;
            }
            this.debuggerNotRunning();
        }
        return true;
    }

    private boolean showFinishDialog() {
        final Session[] sessionArray = this.debuggers.toArray(new Session[this.debuggers.size()]);
        final Dialog[] dialogArray = new Dialog[1];
        final FinishActionPanel finishActionPanel = new FinishActionPanel();
        finishActionPanel.setSessions(sessionArray);
        final DebuggerContextSettings debuggerContextSettings = (DebuggerContextSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$debugger$support$DebuggerContextSettings == null ? (class$org$netbeans$modules$debugger$support$DebuggerContextSettings = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.DebuggerContextSettings")) : class$org$netbeans$modules$debugger$support$DebuggerContextSettings), (boolean)true);
        finishActionPanel.setShowFinishDialog(debuggerContextSettings.getShowFinishDialog());
        final boolean[] blArray = new boolean[]{false};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)finishActionPanel, EnterpriseDebugger.getString("CTL_Finish_debugging_dialog"), true, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    boolean[] blArray2 = finishActionPanel.getState();
                    int n = blArray2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        sessionArray[n2].setPersistent(blArray2[n2]);
                        ++n2;
                    }
                    blArray[0] = true;
                    debuggerContextSettings.setShowFinishDialog(finishActionPanel.getShowFinishDialog());
                }
                dialogArray[0].dispose();
            }
        });
        dialogDescriptor.setHelpCtx(new HelpCtx((class$org$netbeans$modules$debugger$delegator$DelegatingDebugger == null ? (class$org$netbeans$modules$debugger$delegator$DelegatingDebugger = EnterpriseDebugger.class$("org.netbeans.modules.debugger.delegator.DelegatingDebugger")) : class$org$netbeans$modules$debugger$delegator$DelegatingDebugger).getName() + ".dialog"));
        dialogArray[0] = TopManager.getDefault().createDialog(dialogDescriptor);
        dialogArray[0].show();
        return blArray[0];
    }

    void setCurrentDebugger(AbstractDebugger abstractDebugger) {
        Object object;
        AbstractDebugger abstractDebugger2 = this.getCurrentDebugger();
        if (abstractDebugger != this.getCurrentDebugger() && this.getCurrentDebugger() != null) {
            object = this.getCurrentDebugger();
            AbstractThread abstractThread = null;
            if (object instanceof ThreadsRoot) {
                abstractThread = ((ThreadsRoot)object).getCurrentThread();
            }
            if (abstractThread != null) {
                abstractThread.setCurrent(false);
            }
        }
        object = this.currentSession;
        this.currentSession = this.findSession(abstractDebugger);
        this.firePropertyChange(PROP_CURRENT_SESSION, object, this.currentSession);
        this.firePropertyChange("currentDebugger", abstractDebugger2, abstractDebugger);
        this.setState(abstractDebugger.getState());
        if (abstractDebugger instanceof AbstractDebugger) {
            this.setDebuggerState(abstractDebugger.getDebuggerState());
        }
    }

    boolean wakeUpDebugger(AbstractDebugger abstractDebugger) {
        Session session = this.findSession(abstractDebugger);
        if (TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)new MessageFormat(EnterpriseDebugger.getString("CTL_Hidden_debugger_on_breakpoint")).format(new Object[]{session.getSessionName()}), 0)) == NotifyDescriptor.YES_OPTION) {
            WindowManager windowManager = TopManager.getDefault().getWindowManager();
            Workspace workspace = windowManager.findWorkspace(StartDebuggerAction.getWorkspace());
            if (workspace != null) {
                workspace.activate();
            }
            this.setState(2);
            this.setState(3);
            this.refreshActions();
            try {
                this.startDebugger(null);
            }
            catch (DebuggerException debuggerException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private void addSession(Session session) {
        AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
        this.debuggers.add(session);
        AbstractDebugger[] abstractDebuggerArray2 = this.getDebuggers();
        this.firePropertyChange("debuggers", abstractDebuggerArray, abstractDebuggerArray2);
        this.fireSessionCreated(session);
        this.setCurrentSession(session);
    }

    void removeSession(Session session) {
        Session[] sessionArray;
        if (session.getDebugger() != null) {
            session.getDebugger().removePropertyChangeListener(this.sessionListener);
        }
        AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
        ((AbstractCollection)this.debuggers).remove(session);
        AbstractDebugger[] abstractDebuggerArray2 = this.getDebuggers();
        this.firePropertyChange("debuggers", abstractDebuggerArray, abstractDebuggerArray2);
        this.fireSessionDeath(session);
        if (this.currentSession == session && (sessionArray = this.getSessions()).length > 0) {
            this.setCurrentSession(sessionArray[0]);
        }
    }

    protected void firstDebuggerRunning(AbstractDebugger abstractDebugger) {
    }

    protected void debugerRunning(AbstractDebugger abstractDebugger) {
        this.addEvents(abstractDebugger);
    }

    protected void debuggerNotRunning() {
        try {
            super.finishDebugger();
        }
        catch (DebuggerException debuggerException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(((InvocationTargetException)((Object)debuggerException)).getTargetException() == null ? debuggerException : ((InvocationTargetException)((Object)debuggerException)).getTargetException(), (Object)(EnterpriseDebugger.getString("EXC_Debugger") + ": " + debuggerException.getMessage())));
        }
        this.runningDebuggers = new HashMap();
        TopManager.getDefault().setStatusText(EnterpriseDebugger.getString("CTL_Debugger_end"));
    }

    private void addEvents(AbstractDebugger abstractDebugger) {
        Breakpoint[] breakpointArray = this.getBreakpoints();
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ((SessionBreakpoint)breakpointArray[n2]).addDebugger(abstractDebugger);
            ++n2;
        }
    }

    private void removeEvents(AbstractDebugger abstractDebugger) {
        Breakpoint[] breakpointArray = this.getBreakpoints();
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ((SessionBreakpoint)breakpointArray[n2]).removeDebugger(abstractDebugger);
            ++n2;
        }
    }

    private void refreshActions() {
        if (this.stepIntoAction == null) {
            this.stepIntoAction = (StepIntoAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepIntoAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepIntoAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepIntoAction")) : class$org$netbeans$modules$debugger$support$actions$StepIntoAction));
            this.stepOverAction = (StepOverAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepOverAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepOverAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepOverAction")) : class$org$netbeans$modules$debugger$support$actions$StepOverAction));
            this.stepOutAction = (StepOutAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$StepOutAction == null ? (class$org$netbeans$modules$debugger$support$actions$StepOutAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.StepOutAction")) : class$org$netbeans$modules$debugger$support$actions$StepOutAction));
            this.goToCalledMethodAction = (GoToCalledMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.GoToCalledMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCalledMethodAction));
            this.goToCallingMethodAction = (GoToCallingMethodAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction == null ? (class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.GoToCallingMethodAction")) : class$org$netbeans$modules$debugger$support$actions$GoToCallingMethodAction));
            this.runToCursorAction = (RunToCursorAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$RunToCursorAction == null ? (class$org$netbeans$modules$debugger$support$actions$RunToCursorAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.RunToCursorAction")) : class$org$netbeans$modules$debugger$support$actions$RunToCursorAction));
            this.pauseAction = (PauseAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$PauseAction == null ? (class$org$netbeans$modules$debugger$support$actions$PauseAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.PauseAction")) : class$org$netbeans$modules$debugger$support$actions$PauseAction));
            this.continueAction = (ContinueAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$ContinueAction == null ? (class$org$netbeans$modules$debugger$support$actions$ContinueAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.ContinueAction")) : class$org$netbeans$modules$debugger$support$actions$ContinueAction));
            this.finishAction = (FinishAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$FinishAction == null ? (class$org$netbeans$modules$debugger$support$actions$FinishAction = EnterpriseDebugger.class$("org.netbeans.modules.debugger.support.actions.FinishAction")) : class$org$netbeans$modules$debugger$support$actions$FinishAction));
        }
        this.stepIntoAction.checkEnabled();
        this.stepOverAction.setEnabled(this.getDebuggerState().isStepOverEnabled());
        this.stepOutAction.setEnabled(this.getDebuggerState().isStepOutEnabled());
        this.goToCalledMethodAction.setEnabled(this.getDebuggerState().isGoToCalledMethodEnabled());
        this.goToCallingMethodAction.setEnabled(this.getDebuggerState().isGoToCallingMethodEnabled());
        this.runToCursorAction.checkEnabled();
        this.pauseAction.setEnabled(this.getDebuggerState().isPauseEnabled());
        this.continueAction.setEnabled(this.getDebuggerState().isContinueEnabled());
        this.finishAction.setEnabled(this.getState() != 1);
    }

    public void addSessionsListener(SessionsListener sessionsListener) {
        this.sessionsListener.addElement(sessionsListener);
    }

    public void removeSessionsListener(SessionsListener sessionsListener) {
        this.sessionsListener.removeElement(sessionsListener);
    }

    protected void fireSessionCreated(final Session session) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = EnterpriseDebugger.this.sessionsListener.size();
                int n2 = 0;
                while (n2 < n) {
                    ((SessionsListener)EnterpriseDebugger.this.sessionsListener.elementAt(n2)).sessionCreated(session);
                    ++n2;
                }
            }
        });
    }

    protected void fireSessionDeath(final Session session) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int n = EnterpriseDebugger.this.sessionsListener.size();
                int n2 = 0;
                while (n2 < n) {
                    ((SessionsListener)EnterpriseDebugger.this.sessionsListener.elementAt(n2)).sessionDeath(session);
                    ++n2;
                }
            }
        });
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ioToClose = new ArrayList();
    }

    private class SessionListener
    implements PropertyChangeListener {
        private SessionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractDebugger abstractDebugger = (AbstractDebugger)propertyChangeEvent.getSource();
            int n = EnterpriseDebugger.this.getState();
            int n2 = abstractDebugger.getState();
            if (propertyChangeEvent.getPropertyName().equals("state")) {
                Session session;
                if (n2 == 1) {
                    EnterpriseDebugger.this.runningDebuggers.remove(abstractDebugger);
                    session = EnterpriseDebugger.this.findSession(abstractDebugger);
                    EnterpriseDebugger.this.removeEvents(abstractDebugger);
                    if (session != null && !session.isPersistent()) {
                        EnterpriseDebugger.this.removeSession(session);
                    }
                    if (abstractDebugger == EnterpriseDebugger.this.getCurrentDebugger()) {
                        EnterpriseDebugger.this.setCurrentSession(null);
                    }
                    boolean bl = false;
                    int n3 = 0;
                    while (n3 < EnterpriseDebugger.this.debuggers.size()) {
                        Session session2 = (Session)EnterpriseDebugger.this.debuggers.get(n3);
                        if (session2.getDebugger().getState() != 1 && !session2.isHidden()) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        EnterpriseDebugger.this.debuggerNotRunning();
                    }
                }
                if (n2 == 4 && (session = EnterpriseDebugger.this.findSession(abstractDebugger)) != null && session.isHidden()) {
                    EnterpriseDebugger.this.wakeUpDebugger(abstractDebugger);
                }
                if (n == 1) {
                    return;
                }
                if (n2 != 1 && (abstractDebugger == EnterpriseDebugger.this.getCurrentDebugger() || EnterpriseDebugger.this.debuggers.size() < 2) && n != n2) {
                    EnterpriseDebugger.this.setState(n2);
                    if (n == 2 && n2 == 3) {
                        EnterpriseDebugger.this.firstDebuggerRunning(abstractDebugger);
                    }
                }
                if (n2 == 3 && !EnterpriseDebugger.this.runningDebuggers.containsKey(abstractDebugger)) {
                    EnterpriseDebugger.this.debugerRunning(abstractDebugger);
                    EnterpriseDebugger.this.runningDebuggers.put(abstractDebugger, abstractDebugger);
                }
            } else if (propertyChangeEvent.getPropertyName().equals("debuggerState")) {
                if (abstractDebugger == EnterpriseDebugger.this.getCurrentDebugger()) {
                    EnterpriseDebugger.this.setDebuggerState((State)propertyChangeEvent.getNewValue());
                }
            } else if (propertyChangeEvent.getPropertyName().equals("currentThread")) {
                if (abstractDebugger != EnterpriseDebugger.this.getCurrentDebugger() && ((ThreadsRoot)((Object)abstractDebugger)).getCurrentThread() == null) {
                    return;
                }
                if (abstractDebugger != EnterpriseDebugger.this.getCurrentDebugger()) {
                    EnterpriseDebugger.this.setCurrentDebugger(abstractDebugger);
                }
                EnterpriseDebugger.this.firePropertyChange("currentThread", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("currentLine")) {
                if (abstractDebugger != EnterpriseDebugger.this.getCurrentDebugger()) {
                    return;
                }
                EnterpriseDebugger.this.firePropertyChange("currentLine", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("lastAction")) {
                if (abstractDebugger != EnterpriseDebugger.this.getCurrentDebugger()) {
                    return;
                }
                EnterpriseDebugger.this.firePropertyChange("lastAction", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }
}

