/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.delegator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.AbstractDebuggerInfo;
import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.AbstractWatch;
import org.netbeans.modules.debugger.BreakpointProducer;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.CoreDebugger;
import org.netbeans.modules.debugger.Register;
import org.netbeans.modules.debugger.ThreadsProducer;
import org.netbeans.modules.debugger.ThreadsRoot;
import org.netbeans.modules.debugger.Validator;
import org.netbeans.modules.debugger.ValidatorHolder;
import org.netbeans.modules.debugger.delegator.DelegatingBreakpoint;
import org.netbeans.modules.debugger.delegator.DelegatingDebuggerImpl;
import org.netbeans.modules.debugger.delegator.DelegatingThreadProducer;
import org.netbeans.modules.debugger.delegator.DelegatingWatch;
import org.netbeans.modules.debugger.support.DebuggerSupport;
import org.netbeans.modules.debugger.support.util.ValidatorImpl;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.actions.StartDebuggerAction;
import org.openide.debugger.Breakpoint;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.debugger.DebuggerInfo;
import org.openide.debugger.Watch;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.windows.InputOutput;

public class DelegatingDebugger
extends DebuggerSupport
implements ValidatorHolder,
ThreadsRoot,
BreakpointProducer,
CoreDebugger {
    static final long serialVersionUID = 7558733005739651906L;
    private static InputOutput ioToClose;
    private static transient ResourceBundle bundle;
    private transient Validator validator;
    private transient AbstractDebugger debugger;
    private transient SessionListener sessionListener = new SessionListener();
    protected transient DelegatingThreadProducer threadProducer = new DelegatingThreadProducer();
    protected transient DebuggerInfo lastDebugInfo = null;
    HashMap gDebuggerToBreakpoints = new HashMap();
    HashMap gDebuggerToWatches = new HashMap();
    static /* synthetic */ Class class$org$netbeans$modules$debugger$delegator$DelegatingDebugger;
    static /* synthetic */ Class class$org$openide$actions$StartDebuggerAction;
    static /* synthetic */ Class class$org$netbeans$modules$debugger$support$actions$ConnectAction;

    static String getLocString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$debugger$delegator$DelegatingDebugger == null ? (class$org$netbeans$modules$debugger$delegator$DelegatingDebugger = DelegatingDebugger.class$("org.netbeans.modules.debugger.delegator.DelegatingDebugger")) : class$org$netbeans$modules$debugger$delegator$DelegatingDebugger));
        }
        return bundle.getString(string);
    }

    public DelegatingDebugger() {
        if (Register.getDebuggerCoreImpl() == null) {
            Register.setDebuggerCoreImpl(new DelegatingDebuggerImpl());
        }
        this.setValidator(new ValidatorImpl());
    }

    public void startDebugger(DebuggerInfo debuggerInfo) throws DebuggerException {
        this.lastDebugInfo = debuggerInfo;
        ((StartDebuggerAction)SystemAction.get((Class)(class$org$openide$actions$StartDebuggerAction == null ? (class$org$openide$actions$StartDebuggerAction = DelegatingDebugger.class$("org.openide.actions.StartDebuggerAction")) : class$org$openide$actions$StartDebuggerAction))).changeEnabled(true);
        if (ioToClose != null) {
            ioToClose.closeInputOutput();
        }
        if (debuggerInfo != null) {
            this.startSession(debuggerInfo);
        }
        ((StartDebuggerAction)SystemAction.get((Class)(class$org$openide$actions$StartDebuggerAction == null ? (class$org$openide$actions$StartDebuggerAction = DelegatingDebugger.class$("org.openide.actions.StartDebuggerAction")) : class$org$openide$actions$StartDebuggerAction))).changeEnabled(true);
    }

    public void finishDebugger() throws DebuggerException {
        try {
            if (this.debugger != null) {
                this.debugger.finishDebugger();
            }
            super.finishDebugger();
        }
        catch (DebuggerException debuggerException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(((InvocationTargetException)((Object)debuggerException)).getTargetException() == null ? debuggerException : ((InvocationTargetException)((Object)debuggerException)).getTargetException(), (Object)(DelegatingDebugger.getLocString("EXC_Debugger") + ": " + debuggerException.getMessage())));
        }
    }

    public DebuggerInfo getDebuggerInfo() {
        return this.lastDebugInfo;
    }

    public void traceInto() throws DebuggerException {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(3);
        abstractDebugger.traceInto();
    }

    public void traceOver() throws DebuggerException {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(2);
        abstractDebugger.traceOver();
    }

    public void go() throws DebuggerException {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(5);
        abstractDebugger.go();
    }

    public void stepOut() throws DebuggerException {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(4);
        abstractDebugger.stepOut();
    }

    public void pause() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(9);
        abstractDebugger.pause();
    }

    public void runToCursor(Line line) {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(10);
        abstractDebugger.runToCursor(line);
    }

    public void goToCalledMethod() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(7);
        abstractDebugger.goToCalledMethod();
    }

    public void goToCallingMethod() {
        AbstractDebugger abstractDebugger = this.getCurrentDebugger();
        if (abstractDebugger == null) {
            return;
        }
        this.setLastAction(8);
        abstractDebugger.goToCallingMethod();
    }

    public CoreBreakpoint createBreakpoint(boolean bl) {
        DelegatingBreakpoint delegatingBreakpoint = new DelegatingBreakpoint(bl);
        this.getRootBreakpointGroup().addBreakpoint(delegatingBreakpoint);
        this.addBreakpoint(delegatingBreakpoint);
        return delegatingBreakpoint;
    }

    public Watch createWatch() {
        DelegatingWatch delegatingWatch = new DelegatingWatch(false);
        this.addWatch(delegatingWatch);
        return delegatingWatch;
    }

    public Watch createWatch(String string, boolean bl) {
        DelegatingWatch delegatingWatch = new DelegatingWatch(bl);
        delegatingWatch.setVariableName(string);
        this.addWatch(delegatingWatch);
        return delegatingWatch;
    }

    public int getLastAction() {
        if (this.getCurrentDebugger() == null) {
            return 6;
        }
        if (!(this.getCurrentDebugger() instanceof AbstractDebugger)) {
            return 6;
        }
        return this.getCurrentDebugger().getLastAction();
    }

    public Line getCurrentLine() {
        if (this.getCurrentDebugger() == null) {
            return null;
        }
        return this.getCurrentDebugger().getCurrentLine();
    }

    public String getProcessName(DebuggerInfo debuggerInfo) {
        return "???";
    }

    public String getLocationName(DebuggerInfo debuggerInfo) {
        return "???";
    }

    public ThreadsProducer getThreadsRoot() {
        return this.threadProducer;
    }

    public AbstractThread getCurrentThread() {
        if (this.getCurrentDebugger() == null) {
            return null;
        }
        if (!(this.getCurrentDebugger() instanceof ThreadsRoot)) {
            return null;
        }
        return ((ThreadsRoot)((Object)this.getCurrentDebugger())).getCurrentThread();
    }

    public void setCurrentThread(AbstractThread abstractThread) {
        abstractThread.setCurrent(true);
    }

    public InputOutput getIO() {
        return null;
    }

    public void println(String string) {
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public AbstractDebugger getCurrentDebugger() {
        return this.debugger;
    }

    public AbstractDebugger[] getDebuggers() {
        if (this.getCurrentDebugger() != null) {
            return new AbstractDebugger[]{this.getCurrentDebugger()};
        }
        return new AbstractDebugger[0];
    }

    public void startSession(DebuggerInfo debuggerInfo) throws DebuggerException {
        if (this.getState() == 1) {
            this.setState(2);
        }
        this.debugger = this.createDebugger(debuggerInfo);
        this.firePropertyChange("debuggers", new Debugger[0], this.getDebuggers());
        this.firePropertyChange("currentDebugger", null, this.debugger);
        this.debugger.addPropertyChangeListener(this.sessionListener);
        this.debugger.startDebugger(debuggerInfo);
        if (this.debugger.getState() == 1) {
            this.debugger.removePropertyChangeListener(this.sessionListener);
            AbstractDebugger abstractDebugger = this.debugger;
            AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
            this.debugger = null;
            this.firePropertyChange("currentDebugger", abstractDebugger, null);
            this.firePropertyChange("debuggers", abstractDebuggerArray, this.getDebuggers());
            return;
        }
        if (this.debugger instanceof ThreadsRoot) {
            this.threadProducer.setRemoteThreadGroup(((ThreadsRoot)((Object)this.debugger)).getThreadsRoot());
        }
    }

    protected AbstractDebugger createDebugger(DebuggerInfo debuggerInfo) {
        AbstractDebugger abstractDebugger = DelegatingDebuggerImpl.getDelegatingImpl().createDebugger(debuggerInfo instanceof AbstractDebuggerInfo ? ((AbstractDebuggerInfo)debuggerInfo).getDebuggerImpl() : null);
        if (abstractDebugger instanceof ValidatorHolder) {
            ((ValidatorHolder)((Object)abstractDebugger)).setValidator(this.getValidator());
        }
        return abstractDebugger;
    }

    private void debuggerRunning() {
        CallableSystemAction callableSystemAction = (CallableSystemAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$ConnectAction == null ? (class$org$netbeans$modules$debugger$support$actions$ConnectAction = DelegatingDebugger.class$("org.netbeans.modules.debugger.support.actions.ConnectAction")) : class$org$netbeans$modules$debugger$support$actions$ConnectAction));
        callableSystemAction.setEnabled(false);
        if (this.debugger instanceof AbstractDebugger) {
            Breakpoint[] breakpointArray = this.getBreakpoints();
            int n = breakpointArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (breakpointArray[n2] instanceof DelegatingBreakpoint) {
                    ((DelegatingBreakpoint)breakpointArray[n2]).setDelegatingDebugger(this.debugger);
                }
                ++n2;
            }
        }
    }

    private void debuggerNotRunning() {
        CallableSystemAction callableSystemAction = (CallableSystemAction)SystemAction.get((Class)(class$org$netbeans$modules$debugger$support$actions$ConnectAction == null ? (class$org$netbeans$modules$debugger$support$actions$ConnectAction = DelegatingDebugger.class$("org.netbeans.modules.debugger.support.actions.ConnectAction")) : class$org$netbeans$modules$debugger$support$actions$ConnectAction));
        callableSystemAction.setEnabled(DelegatingDebuggerImpl.getDelegatingImpl().supportsConnectAction());
        try {
            super.finishDebugger();
        }
        catch (DebuggerException debuggerException) {
            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Exception(((InvocationTargetException)((Object)debuggerException)).getTargetException() == null ? debuggerException : ((InvocationTargetException)((Object)debuggerException)).getTargetException(), (Object)(DelegatingDebugger.getLocString("EXC_Debugger") + ": " + debuggerException.getMessage())));
        }
        TopManager.getDefault().setStatusText(DelegatingDebugger.getLocString("CTL_Debugger_end"));
        Breakpoint[] breakpointArray = this.getBreakpoints();
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            ((DelegatingBreakpoint)breakpointArray[n2]).removeDelegatingDebugger();
            ++n2;
        }
        this.debugger.removePropertyChangeListener(this.sessionListener);
        AbstractDebugger abstractDebugger = this.debugger;
        AbstractDebugger[] abstractDebuggerArray = this.getDebuggers();
        this.debugger = null;
        this.firePropertyChange("currentDebugger", abstractDebugger, null);
        this.firePropertyChange("debuggers", abstractDebuggerArray, this.getDebuggers());
    }

    void refreshBreakpoints(Debugger debugger) {
        HashMap<Breakpoint, Breakpoint> hashMap = new HashMap<Breakpoint, Breakpoint>();
        Breakpoint[] breakpointArray = debugger.getBreakpoints();
        HashSet<Breakpoint> hashSet = new HashSet<Breakpoint>(Arrays.asList(this.getBreakpoints()));
        int n = breakpointArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!hashSet.contains(breakpointArray[n2])) {
                this.addBreakpoint(breakpointArray[n2]);
            }
            hashMap.put(breakpointArray[n2], breakpointArray[n2]);
            ++n2;
        }
        Breakpoint[] breakpointArray2 = (Breakpoint[])this.gDebuggerToBreakpoints.get(debugger);
        if (breakpointArray2 != null) {
            n = breakpointArray2.length;
            n2 = 0;
            while (n2 < n) {
                if (!hashMap.containsKey(breakpointArray2[n2])) {
                    this.removeBreakpoint(breakpointArray2[n2]);
                }
                ++n2;
            }
        }
        this.gDebuggerToBreakpoints.put(debugger, breakpointArray);
    }

    void refreshWatches(Debugger debugger) {
        HashMap<AbstractWatch, AbstractWatch> hashMap = new HashMap<AbstractWatch, AbstractWatch>();
        AbstractWatch[] abstractWatchArray = (AbstractWatch[])debugger.getWatches();
        HashSet<Watch> hashSet = new HashSet<Watch>(Arrays.asList(this.getWatches()));
        int n = abstractWatchArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (!hashSet.contains(abstractWatchArray[n2])) {
                this.addWatch(abstractWatchArray[n2]);
            }
            hashMap.put(abstractWatchArray[n2], abstractWatchArray[n2]);
            ++n2;
        }
        AbstractWatch[] abstractWatchArray2 = (AbstractWatch[])this.gDebuggerToWatches.get(debugger);
        if (abstractWatchArray2 != null) {
            n = abstractWatchArray2.length;
            n2 = 0;
            while (n2 < n) {
                if (!hashMap.containsKey(abstractWatchArray2[n2])) {
                    this.removeWatch(abstractWatchArray2[n2]);
                }
                ++n2;
            }
        }
        this.gDebuggerToWatches.put(debugger, abstractWatchArray);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        super.firePropertyChange(string, object, object2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SessionListener
    implements PropertyChangeListener {
        private SessionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = DelegatingDebugger.this.getState();
            int n2 = DelegatingDebugger.this.debugger.getState();
            if (propertyChangeEvent.getPropertyName().equals("state")) {
                if (n == 1 || n == n2) {
                    return;
                }
                DelegatingDebugger.super.setState(n2);
                if (n == 2 && n2 == 3) {
                    DelegatingDebugger.this.debuggerRunning();
                }
                if (n2 == 1) {
                    DelegatingDebugger.this.debuggerNotRunning();
                }
            } else if (propertyChangeEvent.getPropertyName().equals("currentLine")) {
                DelegatingDebugger.this.firePropertyChange("currentLine", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("currentThread")) {
                DelegatingDebugger.this.firePropertyChange("currentThread", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName().equals("lastAction")) {
                DelegatingDebugger.this.firePropertyChange("lastAction", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }
}

