/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.delegator;

import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.modules.debugger.AbstractDebugger;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.delegator.DelegatingDebugger;
import org.netbeans.modules.debugger.support.BreakpointSupport;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerException;
import org.openide.nodes.Node;
import org.openide.text.Line;

public class DelegatingBreakpoint
extends BreakpointSupport {
    static final long serialVersionUID = 2246204002781932191L;
    private transient CoreBreakpoint.Event delEvent;

    DelegatingBreakpoint(boolean bl) {
        super(bl);
    }

    protected void init() {
        this.delEvent = null;
        super.init();
    }

    public CoreBreakpoint.Event getEvent(Debugger debugger) {
        if (debugger == this.debugger) {
            return this.event;
        }
        if (this.delEvent != null && debugger == this.delEvent.getDebugger()) {
            return this.delEvent;
        }
        return null;
    }

    public void remove() {
        super.remove();
        if (this.delEvent != null) {
            this.delEvent.remove();
            this.delEvent.dispose();
            this.delEvent = null;
        }
    }

    protected void setBreakpoint() {
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = false;
        if (this.event != null) {
            Object object;
            if (this.debugger.getState() == 1) {
                if (this.delEvent != null) {
                    this.delEvent.remove();
                    this.delEvent.dispose();
                    this.delEvent = null;
                }
            } else {
                try {
                    CoreBreakpoint.Event event;
                    if (this.delEvent == null && this.event instanceof CoreBreakpoint.SessionEvent && (object = ((DelegatingDebugger)TopManager.getDefault().getDebugger()).getCurrentDebugger()) != null && (event = this.createEvent((AbstractDebugger)object, this.event.getTypeName())) != null) {
                        if (event instanceof CoreBreakpoint.SessionEvent) {
                            ((CoreBreakpoint.SessionEvent)((Object)event)).synchronizeWith(this.event);
                        }
                        this.synchronizeProperties(event);
                        this.delEvent = event;
                    }
                    if (this.event instanceof CoreBreakpoint.SessionEvent) {
                        if (this.delEvent != null) {
                            bl = this.delEvent.set();
                        }
                    } else {
                        bl = this.event.set();
                    }
                }
                catch (DebuggerException debuggerException) {
                    // empty catch block
                }
            }
            object = null;
            object = this.delEvent != null ? this.delEvent.getLines() : this.event.getLines();
            if (object != null) {
                this.remark(new ArrayList<Line>(Arrays.asList(object)));
            } else {
                this.remark(null);
            }
        }
        this.setValid(bl);
    }

    protected void clearBreakpoint() {
        this.remark(false);
        this.lines = null;
        if (this.delEvent != null) {
            this.delEvent.remove();
        }
        this.setValid(false);
    }

    protected void fireEventPropertyChange(CoreBreakpoint.Event event, String string, Object object, Object object2) {
        if (event != this.event) {
            return;
        }
        this.firePropertyChange(null, object, object2);
        if (this.isEnabled()) {
            this.setBreakpoint();
        } else if (this.event instanceof CoreBreakpoint.AnnotatableEvent) {
            ((CoreBreakpoint.AnnotatableEvent)((Object)this.event)).annotate();
        }
    }

    protected void synchronizeProperties() {
        if (this.delEvent != null) {
            this.synchronizeProperties(this.delEvent);
        }
    }

    protected void synchronizeProperties(CoreBreakpoint.Event event) {
        if (this.event == null) {
            return;
        }
        Node.Property[] propertyArray = this.event.getProperties();
        Node.Property[] propertyArray2 = event.getProperties();
        int n = Math.min(propertyArray2.length, propertyArray.length);
        int n2 = 0;
        while (n2 < n) {
            try {
                propertyArray2[n2].setValue(propertyArray[n2].getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    void setDelegatingDebugger(AbstractDebugger abstractDebugger) {
        if (this.event == null) {
            return;
        }
        if (this.event instanceof CoreBreakpoint.SessionEvent) {
            CoreBreakpoint.Event event = this.createEvent(abstractDebugger, this.event.getTypeName());
            if (event == null) {
                return;
            }
            if (event instanceof CoreBreakpoint.SessionEvent) {
                ((CoreBreakpoint.SessionEvent)((Object)event)).synchronizeWith(this.event);
            }
            this.synchronizeProperties(event);
            if (this.delEvent != null) {
                this.delEvent.remove();
                this.delEvent.dispose();
            }
            this.delEvent = event;
        }
        this.setBreakpoint();
    }

    void removeDelegatingDebugger() {
        if (this.delEvent != null) {
            this.delEvent.remove();
            this.delEvent.dispose();
        }
        this.delEvent = null;
        this.setBreakpoint();
    }
}

