/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.debug;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.debugger.debug.ToolsDebugger;
import org.netbeans.modules.debugger.debug.ToolsThread;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.netbeans.modules.debugger.support.util.Protector;
import org.netbeans.modules.debugger.support.util.RequestSynchronizer;
import sun.tools.debug.RemoteThread;
import sun.tools.debug.RemoteThreadGroup;

public class ToolsThreadGroup
extends JavaThreadGroup {
    ToolsDebugger debugger;
    private HashMap oldContent = new HashMap();
    private RemoteThreadGroup threadGroup;

    ToolsThreadGroup(ToolsDebugger toolsDebugger, ToolsThreadGroup toolsThreadGroup) {
        this(toolsDebugger, toolsThreadGroup, null);
    }

    ToolsThreadGroup(ToolsDebugger toolsDebugger, ToolsThreadGroup toolsThreadGroup, RemoteThreadGroup remoteThreadGroup) {
        super((JavaThreadGroup)toolsThreadGroup);
        this.threadGroup = remoteThreadGroup;
        this.debugger = toolsDebugger;
    }

    public String getName() {
        if (this.debugger.synchronizer == null) {
            return ToolsDebugger.bundle.getString("CTL_Thread_group_root");
        }
        if (this.threadGroup == null) {
            return ToolsDebugger.bundle.getString("CTL_Thread_group_root");
        }
        try {
            return (String)new Protector("AbstractThreadGroup.getName"){

                public Object protect() throws Exception {
                    return ToolsThreadGroup.this.threadGroup.getName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    void setRemoteThreadGroup(RemoteThreadGroup remoteThreadGroup) {
        this.threadGroup = remoteThreadGroup;
        try {
            this.threadChanged();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            this.debugger.getIOManager().println(ToolsDebugger.bundle.getString("EXC_Debugger") + ": " + throwable, 1);
            return;
        }
    }

    void threadChanged() {
        block28: {
            RequestSynchronizer requestSynchronizer = this.debugger.synchronizer;
            if (requestSynchronizer == null) {
                return;
            }
            try {
                Object object;
                Object object2;
                Iterator iterator = this.directChildren();
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
                while (iterator.hasNext()) {
                    object2 = (RemoteThread[])iterator.next();
                    ToolsThreadGroup toolsThreadGroup = (ToolsThreadGroup)((Object)this.oldContent.get(object2));
                    if (toolsThreadGroup == null) {
                        block22: {
                            toolsThreadGroup = new ToolsThreadGroup(this.debugger, this, (RemoteThreadGroup)object2);
                            try {
                                this.debugger.getIOManager().println(ToolsDebugger.bundle.getString("CTL_New_thread_group") + ": " + toolsThreadGroup.getName(), 1);
                            }
                            catch (Throwable throwable) {
                                if (!(throwable instanceof ThreadDeath)) break block22;
                                throw (ThreadDeath)throwable;
                            }
                        }
                        this.addThreadGroup(toolsThreadGroup);
                    } else {
                        this.oldContent.remove(object2);
                    }
                    toolsThreadGroup.threadChanged();
                    hashMap.put(object2, (Object)toolsThreadGroup);
                }
                if (this.threadGroup != null) {
                    object2 = this.listThreads();
                    int n = ((RemoteThread[])object2).length;
                    int n2 = 0;
                    while (n2 < n) {
                        block24: {
                            block23: {
                                try {
                                    String string = this.getStatus((RemoteThread)object2[n2]);
                                    if (string == null || !string.equals("zombie")) break block23;
                                    break block24;
                                }
                                catch (Throwable throwable) {
                                    if (!(throwable instanceof ThreadDeath)) break block23;
                                    throw (ThreadDeath)throwable;
                                }
                            }
                            if ((object = (ToolsThread)((Object)this.oldContent.get(object2[n2]))) == null) {
                                block25: {
                                    object = new ToolsThread(this.debugger, this, (RemoteThread)object2[n2]);
                                    try {
                                        this.debugger.getIOManager().println(ToolsDebugger.bundle.getString("CTL_New_thread") + ": " + ((ToolsThread)((Object)object)).getName(), 1);
                                    }
                                    catch (Throwable throwable) {
                                        if (!(throwable instanceof ThreadDeath)) break block25;
                                        throw (ThreadDeath)throwable;
                                    }
                                }
                                this.addThread((JavaThread)object);
                            } else {
                                ((ToolsThread)((Object)object)).threadChanged();
                                this.oldContent.remove(object2[n2]);
                            }
                            hashMap.put(object2[n2], object);
                        }
                        ++n2;
                    }
                }
                object2 = this.oldContent.values().iterator();
                while (object2.hasNext()) {
                    ToolsThreadGroup toolsThreadGroup;
                    block27: {
                        object = object2.next();
                        if (object instanceof ToolsThread) {
                            ToolsThread toolsThread;
                            block26: {
                                toolsThread = (ToolsThread)((Object)object);
                                try {
                                    this.debugger.getIOManager().println(ToolsDebugger.bundle.getString("CTL_Thread_destroyed") + ": " + toolsThread.getName(), 1);
                                }
                                catch (Throwable throwable) {
                                    if (!(throwable instanceof ThreadDeath)) break block26;
                                    throw (ThreadDeath)throwable;
                                }
                            }
                            this.removeThread(toolsThread);
                            continue;
                        }
                        toolsThreadGroup = (ToolsThreadGroup)((Object)object);
                        try {
                            this.debugger.getIOManager().println(ToolsDebugger.bundle.getString("CTL_Thread_group_destroyed") + ": " + toolsThreadGroup.getName(), 1);
                        }
                        catch (Throwable throwable) {
                            if (!(throwable instanceof ThreadDeath)) break block27;
                            throw (ThreadDeath)throwable;
                        }
                    }
                    this.removeThreadGroup(toolsThreadGroup);
                }
                this.oldContent = hashMap;
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ThreadDeath)) break block28;
                throw (ThreadDeath)throwable;
            }
        }
    }

    ToolsThread getThread(RemoteThread remoteThread) {
        ToolsThread toolsThread;
        JavaThread[] javaThreadArray = this.getJavaThreads();
        int n = javaThreadArray.length;
        int n2 = 0;
        while (n2 < n) {
            toolsThread = (ToolsThread)javaThreadArray[n2];
            if (toolsThread.getRemoteThread().equals(remoteThread)) {
                return toolsThread;
            }
            ++n2;
        }
        JavaThreadGroup[] javaThreadGroupArray = this.getThreadGroups();
        n = javaThreadGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            toolsThread = ((ToolsThreadGroup)javaThreadGroupArray[n2]).getThread(remoteThread);
            if (toolsThread != null) {
                return toolsThread;
            }
            ++n2;
        }
        return null;
    }

    private String name(final RemoteThreadGroup remoteThreadGroup) {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        try {
            return (String)new Protector("ToolsThreadGroup.name"){

                public Object protect() throws Exception {
                    return remoteThreadGroup.getName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    ToolsThread getDefaultThread() {
        Object object;
        JavaThreadGroup javaThreadGroup = null;
        JavaThreadGroup[] javaThreadGroupArray = this.getThreadGroups();
        int n = 0;
        while (n < javaThreadGroupArray.length) {
            if (javaThreadGroupArray[n].getName().equals("system")) {
                javaThreadGroup = javaThreadGroupArray[n];
                break;
            }
            ++n;
        }
        if (javaThreadGroup == null) {
            return null;
        }
        javaThreadGroupArray = javaThreadGroup.getThreadGroups();
        javaThreadGroup = null;
        int n2 = 0;
        while (n2 < javaThreadGroupArray.length) {
            object = javaThreadGroupArray[n2].getName();
            if (!((String)object).equals("main") && ((String)object).indexOf("main") > -1) {
                javaThreadGroup = javaThreadGroupArray[n2];
                break;
            }
            ++n2;
        }
        if (javaThreadGroup == null) {
            return null;
        }
        object = javaThreadGroup.getJavaThreads();
        if (((JavaThread[])object).length > 0) {
            return (ToolsThread)((Object)object[0]);
        }
        return null;
    }

    private Iterator directChildren() throws Exception {
        RemoteThreadGroup[] remoteThreadGroupArray = this.listThreadGroups();
        HashSet<RemoteThreadGroup> hashSet = new HashSet<RemoteThreadGroup>(Arrays.asList(remoteThreadGroupArray));
        int n = remoteThreadGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteThreadGroup[] remoteThreadGroupArray2 = this.debugger.remoteDebugger.listThreadGroups(remoteThreadGroupArray[n2]);
            int n3 = remoteThreadGroupArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                hashSet.remove(remoteThreadGroupArray2[n4]);
                ++n4;
            }
            ++n2;
        }
        return hashSet.iterator();
    }

    private RemoteThread[] listThreads() {
        if (this.debugger.synchronizer == null) {
            return new RemoteThread[0];
        }
        return (RemoteThread[])new Protector("ToolsThreadGroup.listThreads"){

            public Object protect() throws Exception {
                try {
                    return ToolsThreadGroup.this.threadGroup.listThreads(false);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    return new RemoteThread[0];
                }
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
    }

    private RemoteThreadGroup[] listThreadGroups() {
        if (this.debugger.synchronizer == null) {
            return new RemoteThreadGroup[0];
        }
        return (RemoteThreadGroup[])new Protector("ToolsThreadGroup.listThreadGroups"){

            public Object protect() throws Exception {
                try {
                    return ToolsThreadGroup.this.debugger.remoteDebugger.listThreadGroups(ToolsThreadGroup.this.threadGroup);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    return new RemoteThreadGroup[0];
                }
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
    }

    private String getStatus(final RemoteThread remoteThread) {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        return (String)new Protector("ToolsThreadGroup.getStatus"){

            public Object protect() throws Exception {
                try {
                    return remoteThread.getStatus();
                }
                catch (Throwable throwable) {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                    return new RemoteThreadGroup[0];
                }
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
    }
}

