/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.debug;

import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.Location;
import org.netbeans.modules.debugger.debug.ToolsCallStackFrame;
import org.netbeans.modules.debugger.debug.ToolsDebugger;
import org.netbeans.modules.debugger.debug.ToolsThreadGroup;
import org.netbeans.modules.debugger.debug.ToolsVariable;
import org.netbeans.modules.debugger.support.java.JavaDebugger;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaThreadGroup;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.ModifiersFilter;
import org.netbeans.modules.debugger.support.util.Protector;
import org.openide.debugger.DebuggerException;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteField;
import sun.tools.debug.RemoteObject;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteStackVariable;
import sun.tools.debug.RemoteThread;

public class ToolsThread
extends JavaThread {
    private ToolsDebugger debugger;
    private RemoteThread thread;
    private HashMap oldLocals = new HashMap();
    private ToolsCallStackFrame[] oldCallStack = new ToolsCallStackFrame[0];
    private RemoteObject oldCurrentContext = null;
    private AbstractVariable[] oldContextFields;
    private transient int lastStackDepth = 0;
    private transient int lastAction = 6;

    ToolsThread(ToolsDebugger toolsDebugger, ToolsThreadGroup toolsThreadGroup, RemoteThread remoteThread) {
        super((JavaDebugger)toolsDebugger, (JavaThreadGroup)toolsThreadGroup);
        this.debugger = toolsDebugger;
        this.thread = remoteThread;
        if (toolsThreadGroup != null && toolsDebugger.lastCurrentThread != null && remoteThread.equals(toolsDebugger.lastCurrentThread)) {
            this.setCurrent(true);
            toolsDebugger.lastCurrentThread = null;
        }
    }

    public String getName() {
        if (this.debugger.synchronizer == null) {
            return "Thread";
        }
        try {
            return (String)new Protector("ToolsThread.getName"){

                public Object protect() throws Exception {
                    return ToolsThread.this.thread.getName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    public int getLineNumber() {
        if (this.debugger.synchronizer == null) {
            return -1;
        }
        try {
            return (Integer)new Protector("ToolsThread.getLineNumber"){

                public Object protect() throws Exception {
                    return new Integer(ToolsThread.this.thread.getCurrentFrame().getLineNumber());
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return -1;
        }
    }

    public String getState() {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        try {
            return (String)new Protector("ToolsThread.getState"){

                public Object protect() throws Exception {
                    return ToolsThread.this.thread.getStatus();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    public String getClassName() {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        try {
            return (String)new Protector("ToolsThread.getClassName"){

                public Object protect() throws Exception {
                    return ToolsThread.this.thread.getCurrentFrame().getRemoteClass().getName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    public String getMethod() {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        try {
            return (String)new Protector("ToolsThread.getClassName"){

                public Object protect() throws Exception {
                    return ToolsThread.this.thread.getCurrentFrame().getMethodName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    public int getStackDepth() {
        if (this.debugger.synchronizer == null) {
            return -1;
        }
        try {
            return (Integer)new Protector("ToolsThread.getStackDepth"){

                public Object protect() throws Exception {
                    return new Integer(ToolsThread.this.thread.dumpStack().length);
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return -1;
        }
    }

    public boolean isSuspended() {
        if (this.debugger.synchronizer == null) {
            return false;
        }
        try {
            return (Boolean)new Protector("ToolsThread.isSuspended"){

                public Object protect() throws Exception {
                    return new Boolean(ToolsThread.this.thread.isSuspended());
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return false;
        }
    }

    public void setSuspended(boolean bl) throws DebuggerException {
        if (this.debugger.synchronizer == null) {
            return;
        }
        boolean bl2 = this.isSuspendedIn();
        if (bl2 == bl) {
            return;
        }
        try {
            if (bl) {
                this.suspendIn();
            } else {
                this.resumeIn();
                this.contIn();
            }
            if (bl2 != this.isSuspendedIn()) {
                super.setSuspended(bl);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new DebuggerException(throwable);
        }
    }

    public void stop() throws DebuggerException {
        if (this.debugger.synchronizer == null) {
            return;
        }
        try {
            new Protector("ToolsThread.setSuspend"){

                public Object protect() throws Exception {
                    ToolsThread.this.thread.stop();
                    return null;
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throw new DebuggerException(throwable);
        }
    }

    public Location[] getCallStack() {
        if (this.debugger.synchronizer == null) {
            return new ToolsCallStackFrame[0];
        }
        RemoteStackFrame[] remoteStackFrameArray = null;
        try {
            if (!this.isSuspended()) {
                return new ToolsCallStackFrame[0];
            }
            remoteStackFrameArray = (RemoteStackFrame[])new Protector("ToolsThread.getCallStack"){

                public Object protect() throws Exception {
                    return ToolsThread.this.thread.dumpStack();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return new ToolsCallStackFrame[0];
        }
        int n = Math.min(remoteStackFrameArray.length, this.oldCallStack.length);
        ToolsCallStackFrame[] toolsCallStackFrameArray = new ToolsCallStackFrame[remoteStackFrameArray.length];
        int n2 = 0;
        while (n2 < n) {
            toolsCallStackFrameArray[toolsCallStackFrameArray.length - n2 - 1] = new ToolsCallStackFrame(this.debugger, remoteStackFrameArray[toolsCallStackFrameArray.length - n2 - 1]);
            toolsCallStackFrameArray[toolsCallStackFrameArray.length - n2 - 1].oldLocals = this.oldCallStack[this.oldCallStack.length - n2 - 1].oldLocals;
            ++n2;
        }
        n2 = n;
        while (n2 < toolsCallStackFrameArray.length) {
            toolsCallStackFrameArray[toolsCallStackFrameArray.length - n2 - 1] = new ToolsCallStackFrame(this.debugger, remoteStackFrameArray[toolsCallStackFrameArray.length - n2 - 1]);
            ++n2;
        }
        this.oldCallStack = toolsCallStackFrameArray;
        return toolsCallStackFrameArray;
    }

    public String getInfo() {
        return null;
    }

    public AbstractVariable[] getVariables() {
        if (this.debugger.synchronizer == null) {
            return new AbstractVariable[0];
        }
        try {
            return (AbstractVariable[])new Protector("ToolsThread.getLocals"){

                public Object protect() throws Exception {
                    RemoteStackVariable[] remoteStackVariableArray = ToolsThread.this.thread.getStackVariables();
                    HashMap<String, ToolsVariable> hashMap = new HashMap<String, ToolsVariable>();
                    ToolsVariable[] toolsVariableArray = new ToolsVariable[remoteStackVariableArray.length];
                    int n = remoteStackVariableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        toolsVariableArray[n2] = (ToolsVariable)ToolsThread.this.oldLocals.get(remoteStackVariableArray[n2].getName());
                        if (toolsVariableArray[n2] == null) {
                            toolsVariableArray[n2] = new ToolsVariable(ToolsThread.this.debugger, remoteStackVariableArray[n2].getName(), remoteStackVariableArray[n2].getValue(), remoteStackVariableArray[n2].getType().toString());
                        } else {
                            toolsVariableArray[n2].update(remoteStackVariableArray[n2].getName(), remoteStackVariableArray[n2].getValue(), remoteStackVariableArray[n2].getType().toString());
                            toolsVariableArray[n2].firePropertyChange();
                        }
                        hashMap.put(remoteStackVariableArray[n2].getName(), toolsVariableArray[n2]);
                        ++n2;
                    }
                    ToolsThread.this.oldLocals = hashMap;
                    return toolsVariableArray;
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return new ToolsVariable[0];
        }
    }

    public JavaVariable[] filterVariables(ModifiersFilter modifiersFilter, int n, int n2) {
        JavaVariable[] javaVariableArray;
        if (this.debugger.synchronizer == null) {
            return new JavaVariable[0];
        }
        try {
            javaVariableArray = (JavaVariable[])new Protector("ToolsThread.getContextVariables"){

                public Object protect() throws Exception {
                    RemoteStackFrame remoteStackFrame = ToolsThread.this.thread.getCurrentFrame();
                    RemoteStackVariable remoteStackVariable = remoteStackFrame.getLocalVariable("this");
                    RemoteClass remoteClass = remoteStackFrame.getRemoteClass();
                    if (remoteStackVariable != null && remoteStackVariable.inScope()) {
                        RemoteObject remoteObject = (RemoteObject)remoteStackVariable.getValue();
                        if (remoteObject.equals(ToolsThread.this.oldCurrentContext)) {
                            return ToolsThread.this.oldContextFields;
                        }
                        RemoteField[] remoteFieldArray = remoteObject.getFields();
                        RemoteField[] remoteFieldArray2 = remoteClass.getFields();
                        JavaVariable[] javaVariableArray = new JavaVariable[remoteFieldArray.length + remoteFieldArray2.length];
                        int n = remoteFieldArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            javaVariableArray[n2] = new ToolsVariable(ToolsThread.this.debugger, remoteObject, remoteFieldArray[n2], n2);
                            ++n2;
                        }
                        int n3 = remoteFieldArray2.length;
                        n2 = 0;
                        while (n2 < n3) {
                            javaVariableArray[n2 + n] = new ToolsVariable(ToolsThread.this.debugger, (RemoteObject)remoteClass, remoteFieldArray2[n2], n2);
                            ++n2;
                        }
                        ToolsThread.this.oldCurrentContext = remoteObject;
                        ToolsThread.access$402(ToolsThread.this, (AbstractVariable[])javaVariableArray);
                        return javaVariableArray;
                    }
                    if (remoteClass.equals(ToolsThread.this.oldCurrentContext)) {
                        return ToolsThread.this.oldContextFields;
                    }
                    RemoteField[] remoteFieldArray = remoteClass.getStaticFields();
                    JavaVariable[] javaVariableArray = new JavaVariable[remoteFieldArray.length];
                    int n = remoteFieldArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        javaVariableArray[n4] = new ToolsVariable(ToolsThread.this.debugger, (RemoteObject)remoteClass, remoteFieldArray[n4], n4);
                        ++n4;
                    }
                    ToolsThread.this.oldCurrentContext = (RemoteObject)remoteClass;
                    ToolsThread.access$402(ToolsThread.this, (AbstractVariable[])javaVariableArray);
                    return javaVariableArray;
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            javaVariableArray = new ToolsVariable[]{};
        }
        return javaVariableArray;
    }

    public String getSourceName() {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        try {
            return (String)new Protector("ToolsThread.getSourceName"){

                public Object protect() throws Exception {
                    return ToolsThread.this.thread.getCurrentFrame().getRemoteClass().getSourceFileName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    int getLastStackDepth() {
        return this.lastStackDepth;
    }

    int getLastAction() {
        return this.lastAction;
    }

    void setLastAction(int n) {
        this.lastAction = n;
        this.lastStackDepth = this.getStackDepth();
    }

    RemoteThread getRemoteThread() {
        return this.thread;
    }

    void threadChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolsThread.this.firePropertyChange();
            }
        });
    }

    protected void firePropertyChange() {
        super.firePropertyChange(null, null, null);
    }

    public void refreshStack() {
        this.firePropertyChange("callstack", null, null);
        this.firePropertyChange("variables", null, null);
        this.firePropertyChange(null, null, null);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ToolsThread)) {
            return false;
        }
        return this.thread.equals(((ToolsThread)((Object)object)).thread);
    }

    public int hashCode() {
        return this.thread.hashCode();
    }

    RemoteStackFrame getCurrentStackIn() throws Exception {
        if (this.debugger.synchronizer == null) {
            return null;
        }
        return (RemoteStackFrame)new Protector("ToolsThread.getCurrentStackIn"){

            public Object protect() throws Exception {
                return ToolsThread.this.thread.getCurrentFrame();
            }
        }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
    }

    boolean isSuspendedIn() {
        if (this.debugger.synchronizer == null) {
            return false;
        }
        return (Boolean)new Protector("ToolsThread.dumpStackIn"){

            public Object protect() {
                return new Boolean(ToolsThread.this.thread.isSuspended());
            }
        }.wait(this.debugger.synchronizer, this.debugger.killer);
    }

    RemoteStackFrame[] dumpStackIn() throws Exception {
        if (this.debugger.synchronizer == null) {
            return null;
        }
        return (RemoteStackFrame[])new Protector("ToolsThread.dumpStackIn"){

            public Object protect() throws Exception {
                return ToolsThread.this.thread.dumpStack();
            }
        }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
    }

    void suspendIn() throws Exception {
        if (this.debugger.synchronizer == null) {
            return;
        }
        new Protector("ToolsThread.suspendIn"){

            public Object protect() throws Exception {
                ToolsThread.this.thread.suspend();
                return null;
            }
        }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
    }

    void resumeIn() throws Exception {
        if (this.debugger.synchronizer == null) {
            return;
        }
        new Protector("ToolsThread.resumeIn"){

            public Object protect() throws Exception {
                ToolsThread.this.thread.resume();
                return null;
            }
        }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
    }

    void contIn() throws Exception {
        if (this.debugger.synchronizer == null) {
            return;
        }
        new Protector("ToolsThread.contIn"){

            public Object protect() throws Exception {
                ToolsThread.this.thread.cont();
                return null;
            }
        }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
    }

    static /* synthetic */ AbstractVariable[] access$402(ToolsThread toolsThread, AbstractVariable[] abstractVariableArray) {
        toolsThread.oldContextFields = abstractVariableArray;
        return abstractVariableArray;
    }
}

