/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.debug;

import java.util.HashMap;
import org.netbeans.modules.debugger.AbstractVariable;
import org.netbeans.modules.debugger.VariablesFilter;
import org.netbeans.modules.debugger.debug.ToolsDebugger;
import org.netbeans.modules.debugger.debug.ToolsVariable;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.util.Protector;
import org.openide.debugger.DebuggerException;
import sun.tools.debug.RemoteStackFrame;
import sun.tools.debug.RemoteStackVariable;

public class ToolsCallStackFrame
extends CallStackFrame {
    private RemoteStackFrame stackFrame;
    private ToolsDebugger debugger;
    private VariablesFilter filter;
    HashMap oldLocals = new HashMap();

    ToolsCallStackFrame(ToolsDebugger toolsDebugger, RemoteStackFrame remoteStackFrame) {
        this.debugger = toolsDebugger;
        this.stackFrame = remoteStackFrame;
    }

    public int getLineNumber() {
        if (this.debugger.synchronizer == null) {
            return -1;
        }
        try {
            return (Integer)new Protector("TheThread.getLineNumber"){

                public Object protect() throws Exception {
                    return new Integer(ToolsCallStackFrame.this.stackFrame.getLineNumber());
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return -1;
        }
    }

    public String getMethodName() {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        try {
            return (String)new Protector("TheThread.getMethodName"){

                public Object protect() throws Exception {
                    return ToolsCallStackFrame.this.stackFrame.getMethodName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    public String getClassName() {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        try {
            return (String)new Protector("TheThread.getClassName"){

                public Object protect() throws Exception {
                    return ToolsCallStackFrame.this.stackFrame.getRemoteClass().getName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return "";
        }
    }

    public String getInfo() {
        return null;
    }

    public AbstractVariable[] getVariables() {
        if (this.debugger.synchronizer == null) {
            return new AbstractVariable[0];
        }
        try {
            return (AbstractVariable[])new Protector("TheThread.getClassName"){

                public Object protect() throws Exception {
                    RemoteStackVariable[] remoteStackVariableArray = ToolsCallStackFrame.this.stackFrame.getLocalVariables();
                    HashMap<String, ToolsVariable> hashMap = new HashMap<String, ToolsVariable>();
                    int n = remoteStackVariableArray.length;
                    ToolsVariable[] toolsVariableArray = new ToolsVariable[n];
                    int n2 = 0;
                    while (n2 < n) {
                        toolsVariableArray[n2] = (ToolsVariable)ToolsCallStackFrame.this.oldLocals.get(remoteStackVariableArray[n2].getName());
                        if (toolsVariableArray[n2] == null) {
                            toolsVariableArray[n2] = new ToolsVariable(ToolsCallStackFrame.this.debugger, remoteStackVariableArray[n2].getName(), remoteStackVariableArray[n2].getValue(), remoteStackVariableArray[n2].getType().toString());
                        } else {
                            toolsVariableArray[n2].update(remoteStackVariableArray[n2].getName(), remoteStackVariableArray[n2].getValue(), remoteStackVariableArray[n2].getType().toString());
                            toolsVariableArray[n2].firePropertyChange();
                        }
                        hashMap.put(remoteStackVariableArray[n2].getName(), toolsVariableArray[n2]);
                        ++n2;
                    }
                    ToolsCallStackFrame.this.oldLocals = hashMap;
                    return toolsVariableArray;
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            return new ToolsVariable[0];
        }
    }

    public VariablesFilter getVariablesFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.debugger.getVariablesFilter();
    }

    public void setVariablesFilter(VariablesFilter variablesFilter) {
        if (variablesFilter == this.filter) {
            return;
        }
        if (variablesFilter != null && variablesFilter.equals(this.filter)) {
            return;
        }
        VariablesFilter variablesFilter2 = this.filter;
        this.filter = variablesFilter;
    }

    public String getSourceName() throws DebuggerException {
        if (this.debugger.synchronizer == null) {
            return "";
        }
        try {
            return (String)new Protector("TheThread.getSourceName"){

                public Object protect() throws Exception {
                    return ToolsCallStackFrame.this.stackFrame.getRemoteClass().getSourceFileName();
                }
            }.throwAndWait(this.debugger.synchronizer, this.debugger.killer);
        }
        catch (Exception exception) {
            throw new DebuggerException((Throwable)exception);
        }
    }
}

