/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.debug;

import org.netbeans.modules.debugger.AbstractThread;
import org.netbeans.modules.debugger.CoreBreakpoint;
import org.netbeans.modules.debugger.debug.ToolsDebugger;
import org.netbeans.modules.debugger.debug.ToolsPrintAction;
import org.netbeans.modules.debugger.debug.ToolsThread;
import org.netbeans.modules.debugger.debug.ToolsThreadGroup;
import org.netbeans.modules.debugger.debug.ToolsVariable;
import org.netbeans.modules.debugger.support.StopEvent;
import org.netbeans.modules.debugger.support.java.CallStackFrame;
import org.netbeans.modules.debugger.support.java.InfoProducer;
import org.netbeans.modules.debugger.support.java.JavaLineBreakpointEvent;
import org.netbeans.modules.debugger.support.java.JavaStopAction;
import org.netbeans.modules.debugger.support.java.JavaThread;
import org.netbeans.modules.debugger.support.java.JavaVariable;
import org.netbeans.modules.debugger.support.java.PrintAction;
import org.netbeans.modules.debugger.support.util.Protector;
import org.netbeans.modules.debugger.support.util.Utils;
import org.openide.TopManager;
import org.openide.debugger.Debugger;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import sun.tools.debug.RemoteClass;
import sun.tools.debug.RemoteStackVariable;
import sun.tools.debug.RemoteThread;

public class LineBreakpoint
extends JavaLineBreakpointEvent
implements StopEvent,
InfoProducer {
    static final long serialVersionUID = -2076421213106468334L;
    private transient RemoteClass remoteClass;
    private transient RemoteThread thread;
    private transient int remoteLineNumber;

    public CoreBreakpoint.Event getNewInstance() {
        return new LineBreakpoint();
    }

    public boolean set() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof ToolsDebugger)) {
            return false;
        }
        final ToolsDebugger toolsDebugger = (ToolsDebugger)debugger;
        if (toolsDebugger.synchronizer == null) {
            return false;
        }
        if (this.remoteClass != null) {
            this.remove();
        }
        final String string = this.getSourceName();
        final int n = this.getLineNumber();
        if (string == null || string.length() < 1 || n < 0) {
            return false;
        }
        try {
            return (Boolean)new Protector("JavaDebugger.addBreakpoint"){

                public Object protect() throws Exception {
                    String string5;
                    CoreBreakpoint coreBreakpoint;
                    int n4 = string.indexOf(36);
                    String string2 = n4 < 0 ? string : string.substring(0, n4);
                    LineBreakpoint.this.remoteClass = toolsDebugger.remoteDebugger.findClass(string2);
                    if (LineBreakpoint.this.remoteClass == null) {
                        return new Boolean(false);
                    }
                    LineBreakpoint.this.remoteLineNumber = n;
                    Line.Set set = Utils.getLineSet((String)LineBreakpoint.this.getSourceName());
                    if (set != null && (coreBreakpoint = set.getOriginal(n)) != null) {
                        LineBreakpoint.this.remoteLineNumber = coreBreakpoint.getLineNumber();
                    }
                    coreBreakpoint = LineBreakpoint.this.getBreakpoint();
                    if (LineBreakpoint.this.getLine() == null && !coreBreakpoint.isHidden() && (string5 = Utils.getLineForSource((String)string, (String)LineBreakpoint.this.remoteClass.getSourceFileName(), (int)n)) != null) {
                        LineBreakpoint.this.setLine((Line)string5);
                    }
                    if ((string5 = LineBreakpoint.this.remoteClass.setBreakpointLine(LineBreakpoint.this.remoteLineNumber)).trim().equals("")) {
                        return new Boolean(true);
                    }
                    String string3 = Utils.getClassName((String)string2);
                    FileObject fileObject = TopManager.getDefault().getRepository().find(Utils.getPackageName((String)string2), string3, "class");
                    FileObject[] fileObjectArray = fileObject.getParent().getChildren();
                    int n2 = fileObjectArray.length;
                    if (n2 > 0) {
                        String string4 = string3 + '$';
                        int n3 = 0;
                        while (n3 < n2) {
                            if (fileObjectArray[n3].getName().startsWith(string4) && fileObjectArray[n3].getExt().equals("class")) {
                                LineBreakpoint.this.remoteClass = toolsDebugger.remoteDebugger.findClass(fileObjectArray[n3].getPackageName('.'));
                                if (LineBreakpoint.this.remoteClass == null) {
                                    return new Boolean(false);
                                }
                                string5 = LineBreakpoint.this.remoteClass.setBreakpointLine(n);
                                if (string5.trim().equals("")) {
                                    return new Boolean(true);
                                }
                            }
                            ++n3;
                        }
                    }
                    toolsDebugger.getIOManager().println(ToolsDebugger.getLocString("CTL_Cannot_set_breakpoint") + ": " + string5, 1);
                    return new Boolean(false);
                }
            }.throwAndWait(toolsDebugger.synchronizer, toolsDebugger.killer);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void remove() {
        Debugger debugger = this.getDebugger();
        if (!(debugger instanceof ToolsDebugger)) {
            return;
        }
        final ToolsDebugger toolsDebugger = (ToolsDebugger)debugger;
        if (toolsDebugger.synchronizer == null) {
            return;
        }
        try {
            new Protector("JavaDebugger.addBreakpoint"){

                public Object protect() throws Exception {
                    String string = LineBreakpoint.this.remoteClass.clearBreakpointLine(LineBreakpoint.this.remoteLineNumber);
                    LineBreakpoint.this.remoteClass = null;
                    if (string.trim().equals("")) {
                        return null;
                    }
                    toolsDebugger.getIOManager().println(ToolsDebugger.getLocString("CTL_Cannot_clear_breakpoint") + ": " + string, 1);
                    return null;
                }
            }.throwAndWait(toolsDebugger.synchronizer, toolsDebugger.killer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void perform() {
        super.perform();
        CoreBreakpoint.Action[] actionArray = this.getBreakpoint().getActions();
        int n = 0;
        while (n < actionArray.length) {
            if (actionArray[n] instanceof JavaStopAction) {
                ((JavaStopAction)actionArray[n]).performStopAction((CoreBreakpoint.Event)this);
            }
            ++n;
        }
    }

    public CoreBreakpoint.Action[] getActions() {
        CoreBreakpoint.Action[] actionArray = new CoreBreakpoint.Action[]{new JavaStopAction(), new ToolsPrintAction(PrintAction.BREAKPOINT_TEXT)};
        CoreBreakpoint.Action[] actionArray2 = new CoreBreakpoint.Action[super.getActions().length + actionArray.length];
        System.arraycopy(super.getActions(), 0, actionArray2, 0, super.getActions().length);
        System.arraycopy(actionArray, 0, actionArray2, super.getActions().length, actionArray.length);
        return actionArray2;
    }

    public boolean supportsMIMEType(String string) {
        return string.equals("text/x-java");
    }

    public JavaThread getThread() {
        ToolsDebugger toolsDebugger = (ToolsDebugger)this.getDebugger();
        ToolsThread toolsThread = ((ToolsThreadGroup)toolsDebugger.getThreadsRoot()).getThread(this.thread);
        if (toolsThread != null) {
            return toolsThread;
        }
        toolsDebugger.lastCurrentThread = this.thread;
        return new ToolsThread((ToolsDebugger)this.getDebugger(), null, this.thread);
    }

    public CallStackFrame[] getCallStack() {
        return (CallStackFrame[])((ToolsThread)this.getThread()).getCallStack();
    }

    public JavaVariable getVariable() {
        try {
            RemoteStackVariable remoteStackVariable = this.thread.getCurrentFrame().getLocalVariable("this");
            return new ToolsVariable((ToolsDebugger)this.getDebugger(), remoteStackVariable.getName(), remoteStackVariable.getValue(), remoteStackVariable.getType().toString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void stop(boolean bl) {
        ((ToolsDebugger)this.getDebugger()).stop(bl, (AbstractThread)this.getThread());
    }

    void perform(RemoteThread remoteThread) {
        this.thread = remoteThread;
        this.perform();
    }
}

