/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.fakepeer;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import org.netbeans.modules.form.fakepeer.FakePeer;
import org.netbeans.modules.form.fakepeer.FakePeerSupport;
import org.netbeans.modules.form.fakepeer.FakePeerUtils;

abstract class FakeComponentPeer
implements FakePeer {
    Component _delegate;
    Component _target;

    FakeComponentPeer(Component component) {
        this._target = component;
        this._delegate = this.createDelegate();
        this.initDelegate();
    }

    void initDelegate() {
        Rectangle rectangle = this._target.getBounds();
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setVisible(this._target.isVisible());
        this.setCursor(this._target.getCursor());
        this.setEnabled(this._target.isEnabled());
        Container container = this._target.getParent();
        Color color = this._target.getBackground();
        if (color != null && (container == null || container.getBackground() != color)) {
            this._delegate.setBackground(color);
        } else {
            this._target.setBackground(this._delegate.getBackground());
        }
        color = this._target.getForeground();
        if (color != null && (container == null || container.getForeground() != color)) {
            this._delegate.setForeground(color);
        } else {
            this._target.setForeground(this._delegate.getForeground());
        }
        Font font = this._target.getFont();
        if (font == null || container != null && container.getFont() == font) {
            font = FakePeerSupport.getDefaultAWTFont();
        }
        this._delegate.setFont(font);
        this._delegate.setName(this._target.getName());
        this._delegate.setDropTarget(this._target.getDropTarget());
        this._delegate.setComponentOrientation(this._target.getComponentOrientation());
        this.repaint();
    }

    abstract Component createDelegate();

    public boolean isObscured() {
        return false;
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    public void setVisible(boolean bl) {
        this._delegate.setVisible(bl);
    }

    public void setEnabled(boolean bl) {
        this._delegate.setEnabled(bl);
    }

    public void paint(Graphics graphics) {
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        try {
            this._delegate.paint(graphics);
            this._target.paint(graphics);
            Object var5_4 = null;
            graphics.setColor(color);
            graphics.setFont(font);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            graphics.setColor(color);
            graphics.setFont(font);
            throw throwable;
        }
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this._delegate.repaint(l, n, n2, n3, n4);
    }

    public void print(Graphics graphics) {
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this._delegate.setBounds(n, n2, n3, n4);
    }

    public void handleEvent(AWTEvent aWTEvent) {
    }

    public void coalescePaintEvent(PaintEvent paintEvent) {
    }

    public Point getLocationOnScreen() {
        return null;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this._delegate.getMinimumSize();
    }

    public ColorModel getColorModel() {
        return this._delegate.getColorModel();
    }

    public Toolkit getToolkit() {
        return this._delegate.getToolkit();
    }

    public Graphics getGraphics() {
        Container container = this._target.getParent();
        if (container != null) {
            Graphics graphics = container.getGraphics();
            if (graphics != null) {
                Rectangle rectangle = this._target.getBounds();
                graphics.translate(rectangle.x, rectangle.y);
                graphics.setClip(0, 0, rectangle.width, rectangle.height);
            }
            return graphics;
        }
        return null;
    }

    public FontMetrics getFontMetrics(Font font) {
        return null;
    }

    public void dispose() {
        this._target = null;
        this._delegate = null;
    }

    public void setForeground(Color color) {
        this._delegate.setForeground(color);
    }

    public void setBackground(Color color) {
        this._delegate.setBackground(color);
    }

    public void setFont(Font font) {
        this._delegate.setFont(font);
    }

    public void setCursor(Cursor cursor) {
        this._delegate.setCursor(cursor);
    }

    public void updateCursorImmediately() {
    }

    public void requestFocus() {
    }

    public boolean requestFocus(Component component, boolean bl, boolean bl2, long l) {
        return false;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean isFocusable() {
        return false;
    }

    public Image createImage(ImageProducer imageProducer) {
        return this._delegate.createImage(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return this._delegate.createImage(n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this._delegate.prepareImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this._delegate.checkImage(image, n, n2, imageObserver);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return null;
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public Image getBackBuffer() {
        return null;
    }

    public void destroyBuffers() {
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    void clearRectBeforePaint(Graphics graphics, Rectangle rectangle) {
        graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void repaint() {
        Dimension dimension = this._target.getSize();
        this.repaint(0L, 0, 0, dimension.width, dimension.height);
    }

    protected class Delegate
    extends Component {
        protected Delegate() {
        }

        public void paint(Graphics graphics) {
            Dimension dimension = FakeComponentPeer.this._target.getSize();
            Color color = FakeComponentPeer.this._target.getBackground();
            if (color == null) {
                color = SystemColor.window;
            }
            graphics.setColor(color);
            FakePeerUtils.drawLoweredBox(graphics, 0, 0, dimension.width, dimension.height);
            graphics.setFont(new Font("Dialog", 1, 12));
            String string = FakeComponentPeer.this._target.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight() - fontMetrics.getDescent();
            int n3 = (dimension.width - n) / 2;
            graphics.setColor(SystemColor.text);
            graphics.drawString(string, n3, (dimension.height - n2) / 2 + n2 - 1);
        }

        public Dimension getMinimumSize() {
            String string = FakeComponentPeer.this._target.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            FontMetrics fontMetrics = this.getFontMetrics(new Font("Dialog", 1, 12));
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            return new Dimension(n + 10, n2 + 4);
        }
    }
}

