/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.netbeans.modules.form.GandalfPersistenceManager;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.PersistenceObjectRegistry;
import org.netbeans.modules.form.compat2.border.BorderDesignSupport;
import org.netbeans.modules.form.compat2.border.BorderInfo;
import org.netbeans.modules.form.compat2.border.BorderInfoSupport;
import org.netbeans.modules.form.palette.CPManager;
import org.netbeans.modules.form.palette.PaletteItem;
import org.openide.awt.SplittedPanel;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheetView;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class BorderEditor
extends PropertyEditorSupport
implements FormAwareEditor,
XMLPropertyEditor,
NamedPropertyEditor {
    private static final String UNKNOWN_BORDER_BASE = "org/netbeans/modules/form/editors2/unknownBorder";
    private static final String NO_BORDER_BASE = "org/netbeans/modules/form/editors2/nullBorder";
    private static final ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$form$editors2$BorderEditor == null ? (class$org$netbeans$modules$form$editors2$BorderEditor = BorderEditor.class$("org.netbeans.modules.form.editors2.BorderEditor")) : class$org$netbeans$modules$form$editors2$BorderEditor));
    private static final String NO_BORDER = bundle.getString("LAB_NoBorder");
    private static final MessageFormat UNKNOWN_BORDER = new MessageFormat(bundle.getString("LAB_FMT_UnknownBorder"));
    private Object current = null;
    private FormModel formModel;
    private FormPropertyContext propertyContext;
    private boolean needsUpdate = false;
    private BorderDesignSupport borderSupport;
    private BorderPanel bPanel = null;
    private static final String XML_BORDER = "Border";
    private static final String ATTR_INFO = "info";
    private static final String PROP_NAME = "PropertyName";
    private static final String ID_BI_NULL_BORDER = "null";
    private static final String XML_TITLED_BORDER = "TitledBorder";
    private static final String ID_BI_TITLED = "org.netbeans.modules.form.compat2.border.TitledBorderInfo";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_TITLE_X = "titleX";
    private static final String ATTR_BORDER = "innerBorder";
    private static final String ATTR_JUSTIFICATION = "justification";
    private static final String ATTR_POSITION = "position";
    private static final String ATTR_FONT = "font";
    private static final String ATTR_TITLE_COLOR = "color";
    private static final String XML_ETCHED_BORDER = "EtchetBorder";
    private static final String ID_BI_ETCHED = "org.netbeans.modules.form.compat2.border.EtchedBorderInfo";
    private static final String ATTR_ETCH_TYPE = "bevelType";
    private static final String ATTR_HIGHLIGHT = "highlight";
    private static final String ATTR_SHADOW = "shadow";
    private static final String XML_LINE_BORDER = "LineBorder";
    private static final String ID_BI_LINE = "org.netbeans.modules.form.compat2.border.LineBorderInfo";
    private static final String ATTR_THICKNESS = "thickness";
    private static final String ATTR_LINE_COLOR = "color";
    private static final String ATTR_CORNERS = "roundedCorners";
    private static final String XML_EMPTY_BORDER = "EmptyBorder";
    private static final String ID_BI_EMPTY = "org.netbeans.modules.form.compat2.border.EmptyBorderInfo";
    private static final String ATTR_TOP = "top";
    private static final String ATTR_LEFT = "left";
    private static final String ATTR_RIGHT = "right";
    private static final String ATTR_BOTTOM = "bottom";
    private static final String XML_COMPOUND_BORDER = "CompundBorder";
    private static final String ID_BI_COMPOUND = "org.netbeans.modules.form.compat2.border.CompoundBorderInfo";
    private static final String ATTR_OUTSIDE = "outside";
    private static final String ATTR_INSIDE = "inside";
    private static final String XML_BEVEL_BORDER = "BevelBorder";
    private static final String ID_BI_BEVEL = "org.netbeans.modules.form.compat2.border.BevelBorderInfo";
    private static final String ID_BI_SOFTBEVEL = "org.netbeans.modules.form.compat2.border.SoftBevelBorderInfo";
    private static final String ATTR_BEVEL_TYPE = "bevelType";
    private static final String ATTR_HIGHLIGHT_OUTER = "highlightOuter";
    private static final String ATTR_HIGHLIGHT_INNER = "highlightInner";
    private static final String ATTR_SHADOW_OUTER = "shadowOuter";
    private static final String ATTR_SHADOW_INNER = "shadowInner";
    private static final String XML_MATTE_COLOR_BORDER = "MatteColorBorder";
    private static final String XML_MATTE_ICON_BORDER = "MatteIconBorder";
    private static final String ID_BI_MATTECOLOR = "org.netbeans.modules.form.compat2.border.MatteColorBorderInfo";
    private static final String ID_BI_MATTEICON = "org.netbeans.modules.form.compat2.border.MatteIconBorderInfo";
    private static final String ATTR_MATTE_COLOR = "color";
    private static final String ATTR_MATTE_ICON = "icon";
    static /* synthetic */ Class class$org$netbeans$modules$form$editors2$BorderEditor;
    static /* synthetic */ Class class$org$netbeans$modules$form$editors2$BorderEditor$BorderPanel;
    static /* synthetic */ Class class$javax$swing$border$TitledBorder;
    static /* synthetic */ Class class$javax$swing$border$EtchedBorder;
    static /* synthetic */ Class class$javax$swing$border$LineBorder;
    static /* synthetic */ Class class$javax$swing$border$EmptyBorder;
    static /* synthetic */ Class class$javax$swing$border$CompoundBorder;
    static /* synthetic */ Class class$javax$swing$border$SoftBevelBorder;
    static /* synthetic */ Class class$javax$swing$border$BevelBorder;
    static /* synthetic */ Class class$javax$swing$border$MatteBorder;

    public void setFormModel(FormModel formModel) {
        this.formModel = formModel;
        this.propertyContext = new FormPropertyContext.DefaultImpl(formModel);
    }

    public Object getValue() {
        if (this.needsUpdate) {
            this.current = this.borderSupport;
            this.needsUpdate = false;
        }
        return this.current;
    }

    public void setValue(Object object) {
        if (this.current == object) {
            return;
        }
        this.current = object;
        this.borderSupport = null;
        if (object instanceof BorderDesignSupport) {
            this.borderSupport = (BorderDesignSupport)object;
        } else if (object instanceof Border) {
            if (!(object instanceof UIResource)) {
                this.borderSupport = new BorderDesignSupport((Border)object);
            }
        } else if (object instanceof BorderInfo) {
            this.borderSupport = new BorderDesignSupport((BorderInfo)object);
        }
        if (this.borderSupport != null) {
            this.borderSupport.setPropertyContext(this.propertyContext);
            this.needsUpdate = false;
            if (this.bPanel != null) {
                this.bPanel.setValue(object);
            }
        }
    }

    public String getAsText() {
        Object object = this.getValue();
        String string = object == null ? NO_BORDER : (this.borderSupport != null ? "[" + this.borderSupport.getDisplayName() + "]" : "[" + Utilities.getShortClassName(object.getClass()) + "]");
        return string;
    }

    public void setAsText(String string) {
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.getAsText(), rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    public String getJavaInitializationString() {
        Object object = this.getValue();
        if (object == null) {
            return ID_BI_NULL_BORDER;
        }
        if (this.borderSupport != null) {
            return this.borderSupport.getJavaInitializationString();
        }
        return null;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.bPanel == null) {
            this.bPanel = new BorderPanel();
            this.bPanel.setValue(this.current);
        }
        return this.bPanel;
    }

    public String getDisplayName() {
        return bundle.getString("CTL_BorderEditor_DisplayName");
    }

    void updateBorder(Node node) {
        if (node instanceof NoBorderNode) {
            this.borderSupport = null;
            this.needsUpdate = true;
        } else if (node instanceof UnknownBorderNode) {
            this.current = ((UnknownBorderNode)node).getBorder();
            this.needsUpdate = false;
        } else {
            try {
                this.borderSupport = new BorderDesignSupport(((BorderNode)node).getBorderSupport());
                this.borderSupport.setPropertyContext(this.propertyContext);
                this.needsUpdate = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public org.w3c.dom.Node storeToXML(Document document) {
        Object object = this.getValue();
        if ((object instanceof BorderDesignSupport || object instanceof Border) && this.borderSupport != null) {
            org.w3c.dom.Node node = null;
            BorderInfo borderInfo = this.borderSupport.getBorderInfo();
            if (borderInfo != null) {
                Element element = this.createBorderInfoNode(document, borderInfo.getClass().getName());
                org.w3c.dom.Node node2 = borderInfo.storeToXML(document);
                if (node2 != null) {
                    element.appendChild(node2);
                    node = element;
                }
            } else {
                Class clazz = this.borderSupport.getBorderClass();
                if (clazz.isAssignableFrom(class$javax$swing$border$TitledBorder == null ? (class$javax$swing$border$TitledBorder = BorderEditor.class$("javax.swing.border.TitledBorder")) : class$javax$swing$border$TitledBorder)) {
                    node = this.storeTitledBorder(document);
                } else if (clazz.isAssignableFrom(class$javax$swing$border$EtchedBorder == null ? (class$javax$swing$border$EtchedBorder = BorderEditor.class$("javax.swing.border.EtchedBorder")) : class$javax$swing$border$EtchedBorder)) {
                    node = this.storeEtchedBorder(document);
                } else if (clazz.isAssignableFrom(class$javax$swing$border$LineBorder == null ? (class$javax$swing$border$LineBorder = BorderEditor.class$("javax.swing.border.LineBorder")) : class$javax$swing$border$LineBorder)) {
                    node = this.storeLineBorder(document);
                } else if (clazz.isAssignableFrom(class$javax$swing$border$EmptyBorder == null ? (class$javax$swing$border$EmptyBorder = BorderEditor.class$("javax.swing.border.EmptyBorder")) : class$javax$swing$border$EmptyBorder)) {
                    node = this.storeEmptyBorder(document);
                } else if (clazz.isAssignableFrom(class$javax$swing$border$CompoundBorder == null ? (class$javax$swing$border$CompoundBorder = BorderEditor.class$("javax.swing.border.CompoundBorder")) : class$javax$swing$border$CompoundBorder)) {
                    node = this.storeCompoundBorder(document);
                } else if ((class$javax$swing$border$SoftBevelBorder == null ? (class$javax$swing$border$SoftBevelBorder = BorderEditor.class$("javax.swing.border.SoftBevelBorder")) : class$javax$swing$border$SoftBevelBorder).isAssignableFrom(clazz)) {
                    node = this.storeBevelBorder(document, ID_BI_SOFTBEVEL);
                } else if ((class$javax$swing$border$BevelBorder == null ? (class$javax$swing$border$BevelBorder = BorderEditor.class$("javax.swing.border.BevelBorder")) : class$javax$swing$border$BevelBorder).isAssignableFrom(clazz)) {
                    node = this.storeBevelBorder(document, ID_BI_BEVEL);
                } else if (clazz.isAssignableFrom(class$javax$swing$border$MatteBorder == null ? (class$javax$swing$border$MatteBorder = BorderEditor.class$("javax.swing.border.MatteBorder")) : class$javax$swing$border$MatteBorder)) {
                    node = this.storeMatteBorder(document);
                }
            }
            return node;
        }
        if (object == null) {
            return this.storeNullBorder(document);
        }
        return null;
    }

    public void readFromXML(org.w3c.dom.Node node) throws IOException {
        if (!XML_BORDER.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            org.w3c.dom.Node node2 = null;
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n).getNodeType() == 1) {
                    node2 = nodeList.item(n);
                    break;
                }
                ++n;
            }
            if (node2 == null) {
                return;
            }
            String string = namedNodeMap.getNamedItem(ATTR_INFO).getNodeValue();
            if (ID_BI_TITLED.equals(string)) {
                this.readTitledBorder(node2);
            } else if (ID_BI_ETCHED.equals(string)) {
                this.readEtchedBorder(node2);
            } else if (ID_BI_LINE.equals(string)) {
                this.readLineBorder(node2);
            } else if (ID_BI_EMPTY.equals(string)) {
                this.readEmptyBorder(node2);
            } else if (ID_BI_COMPOUND.equals(string)) {
                this.readCompoundBorder(node2);
            } else if (ID_BI_SOFTBEVEL.equals(string)) {
                this.readBevelBorder(node2, class$javax$swing$border$SoftBevelBorder == null ? (class$javax$swing$border$SoftBevelBorder = BorderEditor.class$("javax.swing.border.SoftBevelBorder")) : class$javax$swing$border$SoftBevelBorder);
            } else if (ID_BI_BEVEL.equals(string)) {
                this.readBevelBorder(node2, class$javax$swing$border$BevelBorder == null ? (class$javax$swing$border$BevelBorder = BorderEditor.class$("javax.swing.border.BevelBorder")) : class$javax$swing$border$BevelBorder);
            } else if (ID_BI_MATTECOLOR.equals(string) || ID_BI_MATTEICON.equals(string)) {
                this.readMatteBorder(node2);
            } else if (ID_BI_NULL_BORDER.equals(string)) {
                this.borderSupport = null;
                this.needsUpdate = true;
            } else {
                BorderInfo borderInfo = (BorderInfo)PersistenceObjectRegistry.createInstance(string);
                borderInfo.readFromXML(node2);
                this.borderSupport = new BorderDesignSupport(borderInfo);
                this.needsUpdate = true;
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    private Element createBorderInfoNode(Document document, String string) {
        Element element = document.createElement(XML_BORDER);
        element.setAttribute(ATTR_INFO, string);
        return element;
    }

    private static void writeProperty(String string, FormProperty formProperty, Element element, Document document) {
        Object object;
        boolean bl = false;
        org.w3c.dom.Node node = null;
        PropertyEditor propertyEditor = formProperty.getCurrentEditor();
        if (propertyEditor instanceof XMLPropertyEditor) {
            try {
                object = formProperty.getValue();
            }
            catch (Exception exception) {
                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                    exception.printStackTrace();
                }
                return;
            }
            propertyEditor.setValue(object);
            node = ((XMLPropertyEditor)propertyEditor).storeToXML(document);
            if (node != null) {
                element.appendChild(node);
                if (node.getNodeType() == 1) {
                    ((Element)node).setAttribute(PROP_NAME, string);
                }
                return;
            }
        }
        try {
            object = GandalfPersistenceManager.encodeValue(formProperty.getValue());
            if (object != null) {
                element.setAttribute(string, (String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object readProperty(String string, String string2, BorderDesignSupport borderDesignSupport, org.w3c.dom.Node node) throws IOException {
        boolean bl = false;
        Object object = null;
        org.w3c.dom.Node node2 = null;
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n).getNodeType() == 1 && ((Element)nodeList.item(n)).getAttribute(PROP_NAME).equals(string)) {
                node2 = nodeList.item(n);
                break;
            }
            ++n;
        }
        if (node2 != null) {
            FormProperty formProperty = (FormProperty)borderDesignSupport.getPropertyOfName(string2);
            if (formProperty == null) {
                return null;
            }
            IOException iOException = null;
            PropertyEditor[] propertyEditorArray = FormPropertyEditorManager.getAllEditors(formProperty.getValueType());
            int n2 = 0;
            while (n2 < propertyEditorArray.length && !bl) {
                PropertyEditor propertyEditor = propertyEditorArray[n2];
                if (propertyEditor instanceof XMLPropertyEditor) {
                    try {
                        formProperty.getPropertyContext().initPropertyEditor(propertyEditor);
                        ((XMLPropertyEditor)propertyEditor).readFromXML(node2);
                        object = propertyEditor.getValue();
                        formProperty.setValue(object);
                        formProperty.setCurrentEditor(propertyEditor);
                        bl = true;
                    }
                    catch (IOException iOException2) {
                        iOException = iOException2;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++n2;
            }
            if (!bl && iOException != null) {
                throw iOException;
            }
        } else {
            FormProperty formProperty;
            String string3;
            org.w3c.dom.Node node3;
            NamedNodeMap namedNodeMap = node.getAttributes();
            org.w3c.dom.Node node4 = node3 = namedNodeMap == null ? null : namedNodeMap.getNamedItem(string);
            if (node3 != null && (string3 = node3.getNodeValue()) != null && (formProperty = (FormProperty)borderDesignSupport.getPropertyOfName(string2)) != null && (object = GandalfPersistenceManager.decodeValue(string3)) != null) {
                try {
                    formProperty.setValue(object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return object;
    }

    private org.w3c.dom.Node storeNullBorder(Document document) {
        try {
            return this.createBorderInfoNode(document, ID_BI_NULL_BORDER);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private org.w3c.dom.Node storeTitledBorder(Document document) {
        try {
            Object object;
            Element element = document.createElement(XML_TITLED_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("border");
            if (formProperty != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_BORDER, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_TITLE)) != null && formProperty.isChanged()) {
                object = formProperty.getRealValue();
                element.setAttribute(ATTR_TITLE, object instanceof String ? (String)object : "");
                Object object2 = formProperty.getValue();
                if (object2 instanceof FormDesignValue) {
                    BorderEditor.writeProperty(ATTR_TITLE_X, formProperty, element, document);
                }
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titleJustification")) != null && formProperty.isChanged()) {
                element.setAttribute(ATTR_JUSTIFICATION, formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titlePosition")) != null && formProperty.isChanged()) {
                element.setAttribute(ATTR_POSITION, formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titleFont")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_FONT, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titleColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty("color", formProperty, element, document);
            }
            object = this.createBorderInfoNode(document, ID_BI_TITLED);
            object.appendChild(element);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readTitledBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_TITLED_BORDER.equals(node.getNodeName())) {
            throw new IOException();
        }
        try {
            FormProperty formProperty;
            org.w3c.dom.Node node2;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$TitledBorder == null ? (class$javax$swing$border$TitledBorder = BorderEditor.class$("javax.swing.border.TitledBorder")) : class$javax$swing$border$TitledBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_BORDER, "border", this.borderSupport, node);
            Object object = BorderEditor.readProperty(ATTR_TITLE_X, ATTR_TITLE, this.borderSupport, node);
            if (object == null && (node2 = namedNodeMap.getNamedItem(ATTR_TITLE)) != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_TITLE)) != null) {
                formProperty.setValue(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_JUSTIFICATION)) != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titleJustification")) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_POSITION)) != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("titlePosition")) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_FONT, "titleFont", this.borderSupport, node);
            BorderEditor.readProperty("color", "titleColor", this.borderSupport, node);
            this.needsUpdate = true;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public org.w3c.dom.Node storeEtchedBorder(Document document) {
        try {
            Element element = document.createElement(XML_ETCHED_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("etchType");
            if (formProperty != null && formProperty.isChanged()) {
                element.setAttribute("bevelType", formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("highlightColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("shadowColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW, formProperty, element, document);
            }
            Element element2 = this.createBorderInfoNode(document, ID_BI_ETCHED);
            element2.appendChild(element);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readEtchedBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_ETCHED_BORDER.equals(node.getNodeName())) {
            throw new IOException();
        }
        try {
            FormProperty formProperty;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$EtchedBorder == null ? (class$javax$swing$border$EtchedBorder = BorderEditor.class$("javax.swing.border.EtchedBorder")) : class$javax$swing$border$EtchedBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem("bevelType");
            if (node2 != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("etchType")) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_HIGHLIGHT, "highlightColor", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_SHADOW, "shadowColor", this.borderSupport, node);
            this.needsUpdate = true;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public org.w3c.dom.Node storeLineBorder(Document document) {
        try {
            Element element = document.createElement(XML_LINE_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("lineColor");
            if (formProperty != null && formProperty.isChanged()) {
                BorderEditor.writeProperty("color", formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_THICKNESS)) != null && formProperty.isChanged()) {
                element.setAttribute(ATTR_THICKNESS, formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_CORNERS)) != null && formProperty.isChanged()) {
                element.setAttribute(ATTR_CORNERS, formProperty.getRealValue().toString());
            }
            Element element2 = this.createBorderInfoNode(document, ID_BI_LINE);
            element2.appendChild(element);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readLineBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_LINE_BORDER.equals(node.getNodeName())) {
            throw new IOException();
        }
        try {
            FormProperty formProperty;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$LineBorder == null ? (class$javax$swing$border$LineBorder = BorderEditor.class$("javax.swing.border.LineBorder")) : class$javax$swing$border$LineBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty("color", "lineColor", this.borderSupport, node);
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem(ATTR_THICKNESS);
            if (node2 != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_THICKNESS)) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_CORNERS)) != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName(ATTR_CORNERS)) != null) {
                formProperty.setValue(new Boolean(node2.getNodeValue()));
            }
            this.needsUpdate = true;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public org.w3c.dom.Node storeEmptyBorder(Document document) {
        try {
            Object object;
            Object object2;
            Element element = document.createElement(XML_EMPTY_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets");
            if (formProperty != null && formProperty.isChanged() && (object2 = formProperty.getRealValue()) instanceof Insets) {
                object = (Insets)object2;
                element.setAttribute(ATTR_TOP, Integer.toString(((Insets)object).top));
                element.setAttribute(ATTR_LEFT, Integer.toString(((Insets)object).left));
                element.setAttribute(ATTR_BOTTOM, Integer.toString(((Insets)object).bottom));
                element.setAttribute(ATTR_RIGHT, Integer.toString(((Insets)object).right));
            }
            object = this.createBorderInfoNode(document, ID_BI_EMPTY);
            object.appendChild(element);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readEmptyBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_EMPTY_BORDER.equals(node.getNodeName())) {
            throw new IOException();
        }
        try {
            FormProperty formProperty;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = 1;
            int n2 = 1;
            int n3 = 1;
            int n4 = 1;
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem(ATTR_TOP);
            if (node2 != null) {
                n = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_LEFT)) != null) {
                n2 = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_BOTTOM)) != null) {
                n3 = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_RIGHT)) != null) {
                n4 = Integer.parseInt(node2.getNodeValue());
            }
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$EmptyBorder == null ? (class$javax$swing$border$EmptyBorder = BorderEditor.class$("javax.swing.border.EmptyBorder")) : class$javax$swing$border$EmptyBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            if ((n != 1 || n2 != 1 || n3 != 1 || n4 != 1) && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null) {
                formProperty.setValue(new Insets(n, n2, n3, n4));
            }
            this.needsUpdate = true;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    private org.w3c.dom.Node storeCompoundBorder(Document document) {
        try {
            Element element = document.createElement(XML_COMPOUND_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("outsideBorder");
            if (formProperty != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_OUTSIDE, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("insideBorder")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_INSIDE, formProperty, element, document);
            }
            Element element2 = this.createBorderInfoNode(document, ID_BI_COMPOUND);
            element2.appendChild(element);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readCompoundBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_COMPOUND_BORDER.equals(node.getNodeName())) {
            throw new IOException();
        }
        try {
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$CompoundBorder == null ? (class$javax$swing$border$CompoundBorder = BorderEditor.class$("javax.swing.border.CompoundBorder")) : class$javax$swing$border$CompoundBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_OUTSIDE, "outsideBorder", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_INSIDE, "insideBorder", this.borderSupport, node);
            this.needsUpdate = true;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public org.w3c.dom.Node storeBevelBorder(Document document, String string) {
        try {
            Element element = document.createElement(XML_BEVEL_BORDER);
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("bevelType");
            if (formProperty != null && formProperty.isChanged()) {
                element.setAttribute("bevelType", formProperty.getRealValue().toString());
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("highlightOuterColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT_OUTER, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("highlightInnerColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_HIGHLIGHT_INNER, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("shadowOuterColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW_OUTER, formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("shadowInnerColor")) != null && formProperty.isChanged()) {
                BorderEditor.writeProperty(ATTR_SHADOW_INNER, formProperty, element, document);
            }
            Element element2 = this.createBorderInfoNode(document, string);
            element2.appendChild(element);
            return element2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readBevelBorder(org.w3c.dom.Node node, Class clazz) throws IOException {
        if (!XML_BEVEL_BORDER.equals(node.getNodeName())) {
            throw new IOException();
        }
        try {
            FormProperty formProperty;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.borderSupport = new BorderDesignSupport(clazz);
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem("bevelType");
            if (node2 != null && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("bevelType")) != null) {
                formProperty.setValue(new Integer(node2.getNodeValue()));
            }
            BorderEditor.readProperty(ATTR_HIGHLIGHT_OUTER, "highlightOuterColor", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_HIGHLIGHT_INNER, "highlightInnerColor", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_SHADOW_OUTER, "shadowOuterColor", this.borderSupport, node);
            BorderEditor.readProperty(ATTR_SHADOW_INNER, "shadowInnerColor", this.borderSupport, node);
            this.needsUpdate = true;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    public org.w3c.dom.Node storeMatteBorder(Document document) {
        try {
            Object object;
            Object object2;
            String string;
            Element element;
            FormProperty formProperty = (FormProperty)this.borderSupport.getPropertyOfName("tileIcon");
            if (formProperty.isChanged()) {
                element = document.createElement(XML_MATTE_ICON_BORDER);
                string = ID_BI_MATTEICON;
                BorderEditor.writeProperty(ATTR_MATTE_ICON, formProperty, element, document);
            } else {
                element = document.createElement(XML_MATTE_COLOR_BORDER);
                string = ID_BI_MATTECOLOR;
            }
            formProperty = (FormProperty)this.borderSupport.getPropertyOfName("matteColor");
            if (formProperty != null && formProperty.isChanged()) {
                BorderEditor.writeProperty("color", formProperty, element, document);
            }
            if ((formProperty = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null && formProperty.isChanged() && (object2 = formProperty.getRealValue()) instanceof Insets) {
                object = (Insets)object2;
                element.setAttribute(ATTR_TOP, Integer.toString(((Insets)object).top));
                element.setAttribute(ATTR_LEFT, Integer.toString(((Insets)object).left));
                element.setAttribute(ATTR_BOTTOM, Integer.toString(((Insets)object).bottom));
                element.setAttribute(ATTR_RIGHT, Integer.toString(((Insets)object).right));
            }
            object = this.createBorderInfoNode(document, string);
            object.appendChild(element);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void readMatteBorder(org.w3c.dom.Node node) throws IOException {
        if (!XML_MATTE_COLOR_BORDER.equals(node.getNodeName()) && !XML_MATTE_ICON_BORDER.equals(node.getNodeName())) {
            throw new IOException();
        }
        try {
            FormProperty formProperty;
            this.borderSupport = new BorderDesignSupport(class$javax$swing$border$MatteBorder == null ? (class$javax$swing$border$MatteBorder = BorderEditor.class$("javax.swing.border.MatteBorder")) : class$javax$swing$border$MatteBorder);
            this.borderSupport.setPropertyContext(this.propertyContext);
            BorderEditor.readProperty(ATTR_MATTE_ICON, "tileIcon", this.borderSupport, node);
            BorderEditor.readProperty("color", "matteColor", this.borderSupport, node);
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = 1;
            int n2 = 1;
            int n3 = 1;
            int n4 = 1;
            org.w3c.dom.Node node2 = namedNodeMap.getNamedItem(ATTR_TOP);
            if (node2 != null) {
                n = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_LEFT)) != null) {
                n2 = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_BOTTOM)) != null) {
                n3 = Integer.parseInt(node2.getNodeValue());
            }
            if ((node2 = namedNodeMap.getNamedItem(ATTR_RIGHT)) != null) {
                n4 = Integer.parseInt(node2.getNodeValue());
            }
            if ((n != 1 || n2 != 1 || n3 != 1 || n4 != 1) && (formProperty = (FormProperty)this.borderSupport.getPropertyOfName("borderInsets")) != null) {
                formProperty.setValue(new Insets(n, n2, n3, n4));
            }
            this.needsUpdate = true;
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class UnknownBorderNode
    extends AbstractNode {
        private Object border;

        UnknownBorderNode(Object object) {
            super(Children.LEAF);
            this.setBorder(object);
            this.setIconBase(BorderEditor.UNKNOWN_BORDER_BASE);
        }

        void setBorder(Object object) {
            this.border = object;
            String string = object.getClass().getName();
            int n = string.lastIndexOf(46);
            String string2 = n < 0 ? string : string.substring(n + 1);
            this.setDisplayName(UNKNOWN_BORDER.format(new Object[]{string, string2}));
        }

        Object getBorder() {
            return this.border;
        }
    }

    static final class NoBorderNode
    extends AbstractNode {
        NoBorderNode() {
            super(Children.LEAF);
            this.setDisplayName(NO_BORDER);
            this.setIconBase(BorderEditor.NO_BORDER_BASE);
        }
    }

    final class BorderNode
    extends AbstractNode
    implements PropertyChangeListener {
        private BorderDesignSupport borderSupport;
        private Node palItemNode;

        BorderNode(BorderDesignSupport borderDesignSupport, Node node) {
            super(Children.LEAF);
            this.borderSupport = borderDesignSupport;
            this.palItemNode = node;
            this.setName(this.borderSupport.getDisplayName());
        }

        public Image getIcon(int n) {
            return this.palItemNode.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        protected Sheet createSheet() {
            Node.Property[] propertyArray = this.borderSupport.getProperties();
            Sheet.Set set = Sheet.createPropertiesSet();
            set.put(propertyArray);
            Sheet sheet = new Sheet();
            sheet.put(set);
            int n = 0;
            while (n < propertyArray.length) {
                if (propertyArray[n] instanceof FormProperty) {
                    ((FormProperty)propertyArray[n]).addPropertyChangeListener(this);
                } else if (propertyArray[n] instanceof BorderInfoSupport.BorderProp) {
                    ((BorderInfoSupport.BorderProp)propertyArray[n]).setPropertyChangeListener(this);
                }
                ++n;
            }
            return sheet;
        }

        public BorderDesignSupport getBorderSupport() {
            return this.borderSupport;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BorderEditor.this.updateBorder((Node)this);
        }
    }

    final class BorderPanel
    extends ExplorerPanel
    implements PropertyChangeListener,
    VetoableChangeListener {
        private BorderPanel() {
            this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
            this.getExplorerManager().addVetoableChangeListener((VetoableChangeListener)this);
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            SplittedPanel splittedPanel = new SplittedPanel();
            splittedPanel.setSplitType(1);
            splittedPanel.setSplitAbsolute(false);
            splittedPanel.setSplitPosition(45);
            ListView listView = new ListView();
            listView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AvailableBorders"));
            JLabel jLabel = new JLabel(bundle.getString("LAB_AvailableBorders"));
            jLabel.setDisplayedMnemonic(bundle.getString("LAB_AvailableBorders_Mnemonic").charAt(0));
            jLabel.setLabelFor((Component)listView);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout(0, 2));
            jPanel.add((Component)jLabel, "North");
            jPanel.add("Center", (Component)listView);
            splittedPanel.add((Component)jPanel, SplittedPanel.ADD_TOP);
            PropertySheetView propertySheetView = new PropertySheetView();
            splittedPanel.add((Component)propertySheetView, SplittedPanel.ADD_BOTTOM);
            this.add("Center", (Component)splittedPanel);
            this.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_BorderCustomEditor"));
        }

        void setValue(Object object) {
            Object object2;
            Object object3;
            PaletteItem paletteItem;
            ArrayList<Node[]> arrayList = new ArrayList<Node[]>(10);
            Object object4 = null;
            PaletteItem[] paletteItemArray = CPManager.getDefault().getAllItems();
            int n = 0;
            while (n < paletteItemArray.length) {
                paletteItem = paletteItemArray[n];
                if (paletteItem.isBorder()) {
                    object3 = null;
                    try {
                        object2 = paletteItem.createInstance();
                        if (object2 instanceof Border) {
                            object3 = new BorderDesignSupport((Border)object2);
                        } else if (object2 instanceof BorderInfo) {
                            object3 = new BorderDesignSupport((BorderInfo)object2);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (object3 != null) {
                        if (BorderEditor.this.borderSupport != null && BorderEditor.this.borderSupport.getBorderClass() == ((BorderDesignSupport)object3).getBorderClass()) {
                            object4 = object2 = new BorderNode(BorderEditor.this.borderSupport, paletteItem.getItemNode());
                        } else {
                            ((BorderDesignSupport)object3).setPropertyContext(BorderEditor.this.propertyContext);
                            object2 = new BorderNode((BorderDesignSupport)object3, paletteItem.getItemNode());
                        }
                        arrayList.add((Node[])object2);
                    }
                }
                ++n;
            }
            paletteItem = new AbstractNode((Children)new Children.Array());
            object3 = new NoBorderNode();
            if (object == null) {
                object4 = object3;
            }
            paletteItem.getChildren().add(new Node[]{object3});
            object2 = new Node[arrayList.size()];
            arrayList.toArray((T[])object2);
            Arrays.sort(object2, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Node)object).getDisplayName().compareTo(((Node)object2).getDisplayName());
                }
            });
            paletteItem.getChildren().add(object2);
            if (object4 == null) {
                UnknownBorderNode unknownBorderNode = new UnknownBorderNode(object);
                paletteItem.getChildren().add(new Node[]{unknownBorderNode});
                object4 = unknownBorderNode;
            }
            this.getExplorerManager().setRootContext((Node)paletteItem);
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{object4});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length == 1) {
                BorderEditor.this.updateBorder(nodeArray[0]);
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length != 1) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$netbeans$modules$form$editors2$BorderEditor$BorderPanel == null ? (class$org$netbeans$modules$form$editors2$BorderEditor$BorderPanel = BorderEditor.class$("org.netbeans.modules.form.editors2.BorderEditor$BorderPanel")) : class$org$netbeans$modules$form$editors2$BorderEditor$BorderPanel);
        }

        public Dimension getPreferredSize() {
            return new Dimension(360, 440);
        }
    }
}

