/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormCustomEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormPropertyEditorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;

public class FormPropertyEditor
implements PropertyEditor,
PropertyChangeListener,
EnhancedPropertyEditor,
ExPropertyEditor {
    private Object value;
    private Object source;
    private FormProperty property;
    private FormPropertyContext propertyContext;
    private WeakReference propertyEnv;
    private PropertyEditor modifiedEditor;
    private PropertyEditor[] allEditors;
    private Vector listeners;

    FormPropertyEditor(FormProperty formProperty) {
        this.property = formProperty;
        this.propertyContext = formProperty.getPropertyContext();
        this.source = this;
        this.modifiedEditor = formProperty.getCurrentEditor();
        this.modifiedEditor.addPropertyChangeListener(this);
    }

    Class getPropertyType() {
        return this.property.getValueType();
    }

    FormProperty getProperty() {
        return this.property;
    }

    FormPropertyContext getPropertyContext() {
        return this.propertyContext;
    }

    PropertyEnv getPropertyEnv() {
        return this.propertyEnv != null ? (PropertyEnv)this.propertyEnv.get() : null;
    }

    PropertyEditor getModifiedEditor() {
        return this.modifiedEditor;
    }

    void commitModifiedEditor() {
        this.property.setCurrentEditor(this.modifiedEditor);
    }

    void setModifiedEditor(PropertyEditor propertyEditor) {
        this.modifiedEditor.removePropertyChangeListener(this);
        this.modifiedEditor = propertyEditor;
        this.modifiedEditor.addPropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.value = this.modifiedEditor.getValue();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FormPropertyEditor.this.firePropertyChange();
                return null;
            }
        });
    }

    public void setValue(Object object) {
        if (this.modifiedEditor != this.property.getCurrentEditor()) {
            this.setModifiedEditor(this.property.getCurrentEditor());
        }
        this.value = object;
        if (this.value != BeanSupport.NO_VALUE) {
            this.modifiedEditor.setValue(this.value);
        }
        this.firePropertyChange();
    }

    public Object getValue() {
        return this.modifiedEditor.getValue();
    }

    public boolean isPaintable() {
        return this.modifiedEditor.isPaintable();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        this.modifiedEditor.paintValue(graphics, rectangle);
    }

    public String getJavaInitializationString() {
        return this.modifiedEditor.getJavaInitializationString();
    }

    public String getAsText() {
        return this.value != BeanSupport.NO_VALUE ? this.modifiedEditor.getAsText() : FormEditor.getFormBundle().getString("CTL_ValueNotSet");
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.modifiedEditor.setAsText(string);
    }

    public String[] getTags() {
        return this.modifiedEditor.getTags();
    }

    public Component getCustomEditor() {
        Component component;
        if (this.modifiedEditor.supportsCustomEditor() && (component = this.modifiedEditor.getCustomEditor()) instanceof Window) {
            return component;
        }
        return new FormCustomEditor(this);
    }

    public boolean supportsCustomEditor() {
        PropertyEditor[] propertyEditorArray = this.getAllEditors();
        if (propertyEditorArray.length > 1) {
            return true;
        }
        if (propertyEditorArray.length == 1) {
            return propertyEditorArray[0].supportsCustomEditor();
        }
        return false;
    }

    PropertyEditor[] getAllEditors() {
        if (this.allEditors == null) {
            PropertyEditor propertyEditor = this.property.getExpliciteEditor();
            this.allEditors = FormPropertyEditorManager.getAllEditors(this.property.getValueType());
            if (propertyEditor != null) {
                PropertyEditor[] propertyEditorArray = new PropertyEditor[this.allEditors.length + 1];
                propertyEditorArray[0] = propertyEditor;
                System.arraycopy(this.allEditors, 0, propertyEditorArray, 1, this.allEditors.length);
                this.allEditors = propertyEditorArray;
            }
        }
        return this.allEditors;
    }

    public Component getInPlaceCustomEditor() {
        if (this.modifiedEditor instanceof EnhancedPropertyEditor) {
            return ((EnhancedPropertyEditor)this.modifiedEditor).getInPlaceCustomEditor();
        }
        return null;
    }

    public boolean hasInPlaceCustomEditor() {
        if (this.modifiedEditor instanceof EnhancedPropertyEditor) {
            return ((EnhancedPropertyEditor)this.modifiedEditor).hasInPlaceCustomEditor();
        }
        return false;
    }

    public boolean supportsEditingTaggedValues() {
        if (this.modifiedEditor instanceof EnhancedPropertyEditor) {
            return ((EnhancedPropertyEditor)this.modifiedEditor).supportsEditingTaggedValues();
        }
        return false;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void firePropertyChange() {
        Vector vector;
        FormPropertyEditor formPropertyEditor = this;
        synchronized (formPropertyEditor) {
            if (this.listeners == null) {
                return;
            }
            vector = (Vector)this.listeners.clone();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, null, null, null);
        int n = 0;
        while (n < vector.size()) {
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
            propertyChangeListener.propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.propertyEnv = new WeakReference<PropertyEnv>(propertyEnv);
        if (this.modifiedEditor instanceof ExPropertyEditor) {
            ((ExPropertyEditor)this.modifiedEditor).attachEnv(propertyEnv);
        }
    }
}

