/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.netbeans.modules.form.CodeGenerator;
import org.netbeans.modules.form.Event;

public class EventHandler
implements Serializable {
    private CodeGenerator codeGenerator;
    private transient Vector attachedEvents;
    private String handlerName;
    private String[] parameterTypes;
    private String[] exceptionTypes;
    static final long serialVersionUID = -4103904336344477509L;

    EventHandler(CodeGenerator codeGenerator, Event event, String string) {
        this.codeGenerator = codeGenerator;
        this.handlerName = string;
        Class<?>[] classArray = event.getListenerMethod().getParameterTypes();
        this.parameterTypes = new String[classArray.length];
        int n = 0;
        while (n < classArray.length) {
            this.parameterTypes[n] = classArray[n].getName();
            ++n;
        }
        Class<?>[] classArray2 = event.getListenerMethod().getExceptionTypes();
        this.exceptionTypes = new String[classArray2.length];
        int n2 = 0;
        while (n2 < classArray2.length) {
            this.exceptionTypes[n2] = classArray2[n2].getName();
            ++n2;
        }
        event.addHandler(this);
        this.getAttachedEvents().addElement(event);
    }

    void generateHandler(String string) {
        this.codeGenerator.generateEventHandler(this.handlerName, this.parameterTypes, this.exceptionTypes, string);
    }

    void setHandlerText(String string) {
        this.codeGenerator.changeEventHandler(this.handlerName, this.parameterTypes, this.exceptionTypes, string);
    }

    void rename(String string) {
        this.codeGenerator.renameEventHandler(this.handlerName, string, this.parameterTypes, this.exceptionTypes);
        this.handlerName = string;
        Enumeration enumeration = this.getAttachedEvents().elements();
        while (enumeration.hasMoreElements()) {
            Event event = (Event)enumeration.nextElement();
        }
    }

    void delete() {
        this.codeGenerator.deleteEventHandler(this.handlerName);
    }

    void attachEvent(Event event) {
        event.addHandler(this);
        this.getAttachedEvents().addElement(event);
    }

    void detachEvent(Event event) {
        event.removeHandler(this);
        this.getAttachedEvents().removeElement(event);
    }

    public String getName() {
        return this.handlerName;
    }

    public String toString() {
        return this.handlerName;
    }

    public Vector getAttachedEvents() {
        if (this.attachedEvents == null) {
            this.attachedEvents = new Vector();
        }
        return this.attachedEvents;
    }

    public boolean isEmpty() {
        return this.attachedEvents.size() == 0;
    }

    boolean checkCompatibility(Event event) {
        Class<?>[] classArray = event.getListenerMethod().getParameterTypes();
        if (classArray.length != this.parameterTypes.length) {
            return false;
        }
        int n = 0;
        while (n < this.parameterTypes.length) {
            if (!this.parameterTypes[n].equals(classArray[n].getName())) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

