/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;

class ComponentDragger {
    private FormDesigner formDesigner;
    private HandleLayer handleLayer;
    private RADVisualComponent[] selectedComponents;
    private Point hotspot;
    private Point mousePosition;
    private int resizeType;
    private RADVisualContainer targetMetaContainer;
    private Container targetContainer;
    private Container targetContainerDel;
    private static FormLoaderSettings formSettings = FormEditor.getFormSettings();

    ComponentDragger(FormDesigner formDesigner, HandleLayer handleLayer, RADVisualComponent[] rADVisualComponentArray, Point point, int n) {
        this.formDesigner = formDesigner;
        this.handleLayer = handleLayer;
        this.selectedComponents = rADVisualComponentArray;
        this.hotspot = point;
        this.mousePosition = point;
        this.resizeType = n;
    }

    void mouseDragged(Point point) {
        this.mousePosition = point;
        this.handleLayer.repaint();
    }

    void dropComponents(Point point) {
        Object object;
        int n;
        int n2;
        ArrayList arrayList = new ArrayList(this.selectedComponents.length);
        ArrayList arrayList2 = new ArrayList(this.selectedComponents.length);
        if (!this.computeConstraints(point, arrayList, arrayList2)) {
            return;
        }
        LayoutSupportManager layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
        RADVisualComponent[] rADVisualComponentArray = this.targetMetaContainer.getSubComponents();
        HashSet<Object> hashSet = new HashSet<Object>(5);
        hashSet.add(this.targetMetaContainer);
        int n3 = this.selectedComponents.length + rADVisualComponentArray.length;
        ArrayList<RADVisualComponent> arrayList3 = new ArrayList<RADVisualComponent>(n3);
        ArrayList arrayList4 = new ArrayList(n3);
        int n4 = 0;
        while (n4 < n3) {
            arrayList3.add(null);
            arrayList4.add(null);
            ++n4;
        }
        this.adjustIndices(arrayList2);
        int n5 = 0;
        while (n5 < this.selectedComponents.length) {
            n2 = (Integer)arrayList2.get(n5);
            if (n2 >= 0 && n2 < n3) {
                while (arrayList3.get(n2) != null) {
                    if (++n2 != n3) continue;
                    n2 = 0;
                }
                arrayList3.set(n2, this.selectedComponents[n5]);
                arrayList4.set(n2, arrayList.get(n5));
            }
            ++n5;
        }
        n2 = 0;
        int n6 = 0;
        while (n6 < rADVisualComponentArray.length) {
            RADVisualComponent rADVisualComponent = rADVisualComponentArray[n6];
            n = arrayList3.indexOf(rADVisualComponent);
            if (n < 0) {
                while (arrayList3.get(n2) != null) {
                    ++n2;
                }
                arrayList3.set(n2, rADVisualComponent);
                arrayList4.set(n2, layoutSupportManager.getConstraints(rADVisualComponent));
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.selectedComponents.length) {
            RADVisualComponent rADVisualComponent = this.selectedComponents[n7];
            int n8 = arrayList3.indexOf(rADVisualComponent);
            if (n8 >= 0) {
                arrayList4.set(n8, arrayList.get(n7));
            } else if (this.checkTarget(rADVisualComponent)) {
                while (arrayList3.get(n2) != null) {
                    ++n2;
                }
                arrayList3.set(n2, rADVisualComponent);
                arrayList4.set(n2, arrayList.get(n7));
            }
            ++n7;
        }
        layoutSupportManager.removeAll();
        n = 0;
        while (n < n3) {
            RADVisualComponent rADVisualComponent = (RADVisualComponent)arrayList3.get(n);
            if (rADVisualComponent != null) {
                object = rADVisualComponent.getParentContainer();
                if (object != this.targetMetaContainer) {
                    ((RADVisualContainer)object).remove(rADVisualComponent);
                }
                if (arrayList4.get(n) == null) {
                    LayoutConstraints layoutConstraints = rADVisualComponent.getLayoutConstraints(layoutSupportManager.getLayoutDelegate().getClass());
                    arrayList4.set(n, layoutConstraints);
                }
                hashSet.add(object);
            } else {
                arrayList3.remove(n);
                arrayList4.remove(n);
                --n;
                --n3;
            }
            ++n;
        }
        if (n3 == 0) {
            return;
        }
        RADComponent[] rADComponentArray = new RADVisualComponent[n3];
        object = new LayoutConstraints[n3];
        int n9 = 0;
        while (n9 < n3) {
            rADComponentArray[n9] = (RADVisualComponent)arrayList3.get(n9);
            object[n9] = (LayoutConstraints)arrayList4.get(n9);
            ++n9;
        }
        this.targetMetaContainer.initSubComponents(rADComponentArray);
        layoutSupportManager.addComponents((RADVisualComponent[])rADComponentArray, (LayoutConstraints[])object);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            RADVisualContainer rADVisualContainer = (RADVisualContainer)iterator.next();
            this.formDesigner.getModel().fireContainerLayoutChanged(rADVisualContainer, null, null);
        }
        if (this.formDesigner.getSelectedComponents().size() == 0) {
            int n10 = 0;
            while (n10 < this.selectedComponents.length) {
                this.formDesigner.addComponentToSelection(this.selectedComponents[n10]);
                ++n10;
            }
        }
    }

    void paintDragFeedback(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{1.0f, 4.0f}, 0.0f);
        graphics2D.setStroke(basicStroke);
        Color color = graphics2D.getColor();
        graphics2D.setColor(formSettings.getSelectionBorderColor());
        ArrayList arrayList = new ArrayList(this.selectedComponents.length);
        ArrayList arrayList2 = new ArrayList(this.selectedComponents.length);
        boolean bl = this.computeConstraints(this.mousePosition, arrayList, arrayList2);
        Point point = null;
        LayoutSupportManager layoutSupportManager = null;
        if (bl) {
            point = SwingUtilities.convertPoint(this.targetContainerDel, 0, 0, this.handleLayer);
            layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
            if (this.resizeType == 0) {
                this.paintTargetContainerFeedback(graphics2D, this.targetContainerDel);
            }
        }
        int n = 0;
        while (n < this.selectedComponents.length) {
            RADVisualComponent rADVisualComponent = this.selectedComponents[n];
            boolean bl2 = false;
            if (bl) {
                Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
                LayoutConstraints layoutConstraints = (LayoutConstraints)arrayList.get(n);
                int n2 = (Integer)arrayList2.get(n);
                if (layoutConstraints != null || n2 >= 0) {
                    graphics2D.translate(point.x, point.y);
                    bl2 = layoutSupportManager.paintDragFeedback(this.targetContainer, this.targetContainerDel, component, layoutConstraints, n2, graphics2D);
                    graphics2D.translate(-point.x, -point.y);
                }
            }
            if (!bl2) {
                this.paintDragFeedback(graphics2D, rADVisualComponent);
            }
            ++n;
        }
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    private boolean computeConstraints(Point point, List list, List list2) {
        if (this.selectedComponents == null || this.selectedComponents.length == 0) {
            return false;
        }
        RADVisualContainer rADVisualContainer = this.targetMetaContainer = this.resizeType == 0 ? this.handleLayer.getMetaContainerAt(point) : this.selectedComponents[0].getParentContainer();
        if (this.targetMetaContainer == null) {
            return false;
        }
        RADVisualContainer rADVisualContainer2 = null;
        block0: do {
            if (rADVisualContainer2 != null) {
                this.targetMetaContainer = rADVisualContainer2;
                rADVisualContainer2 = null;
            }
            LayoutSupportManager layoutSupportManager = this.targetMetaContainer.getLayoutSupport();
            this.targetContainer = (Container)this.formDesigner.getComponent(this.targetMetaContainer);
            if (this.targetContainer == null) {
                return false;
            }
            this.targetContainerDel = this.targetMetaContainer.getContainerDelegate(this.targetContainer);
            if (this.targetContainerDel == null) {
                return false;
            }
            Point point2 = SwingUtilities.convertPoint(this.handleLayer, point, this.targetContainerDel);
            int n = 0;
            while (n < this.selectedComponents.length) {
                LayoutConstraints layoutConstraints = null;
                int n2 = -1;
                RADVisualComponent rADVisualComponent = this.selectedComponents[n];
                Component component = (Component)this.formDesigner.getComponent(rADVisualComponent);
                if (component != null) {
                    if (!this.checkTarget(rADVisualComponent)) {
                        rADVisualContainer2 = rADVisualComponent.getParentContainer();
                        list.clear();
                        list2.clear();
                        if (rADVisualContainer2 != null) continue block0;
                        return false;
                    }
                    if (this.resizeType == 0) {
                        Point point3 = SwingUtilities.convertPoint(this.handleLayer, this.hotspot, component);
                        n2 = layoutSupportManager.getNewIndex(this.targetContainer, this.targetContainerDel, component, rADVisualComponent.getComponentIndex(), point2, point3);
                        layoutConstraints = layoutSupportManager.getNewConstraints(this.targetContainer, this.targetContainerDel, component, rADVisualComponent.getComponentIndex(), point2, point3);
                    } else {
                        int n3 = 0;
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        if ((this.resizeType & 2) != 0) {
                            n4 = point.y - this.hotspot.y;
                        } else if ((this.resizeType & 1) != 0) {
                            n3 = this.hotspot.y - point.y;
                        }
                        if ((this.resizeType & 8) != 0) {
                            n6 = point.x - this.hotspot.x;
                        } else if ((this.resizeType & 4) != 0) {
                            n5 = this.hotspot.x - point.x;
                        }
                        Insets insets = new Insets(n3, n5, n4, n6);
                        layoutConstraints = layoutSupportManager.getResizedConstraints(component, rADVisualComponent.getComponentIndex(), insets);
                    }
                }
                list.add(layoutConstraints);
                list2.add(new Integer(n2));
                ++n;
            }
        } while (rADVisualContainer2 != null);
        return true;
    }

    private boolean checkTarget(RADVisualComponent rADVisualComponent) {
        if (!(rADVisualComponent instanceof RADVisualContainer)) {
            return true;
        }
        RADComponent rADComponent = this.targetMetaContainer;
        while (rADComponent != null) {
            if (rADComponent == rADVisualComponent) {
                return false;
            }
            rADComponent = rADComponent.getParentComponent();
        }
        return true;
    }

    private void adjustIndices(List list) {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        while (n3 < list.size()) {
            int n4 = (Integer)list.get(n3);
            if (n4 >= 0) {
                int n5;
                if (n4 == n) {
                    n5 = n2;
                } else {
                    n5 = 0;
                    RADVisualComponent[] rADVisualComponentArray = this.targetMetaContainer.getSubComponents();
                    int n6 = 0;
                    while (n6 < n4) {
                        RADVisualComponent rADVisualComponent = rADVisualComponentArray[n6];
                        boolean bl = false;
                        int n7 = 0;
                        while (n7 < this.selectedComponents.length) {
                            if (rADVisualComponent == this.selectedComponents[n7]) {
                                bl = true;
                                break;
                            }
                            ++n7;
                        }
                        if (bl) {
                            ++n5;
                        }
                        ++n6;
                    }
                    n = n4;
                    n2 = n5;
                }
                if (n5 != 0) {
                    list.set(n3, new Integer(n4 -= n5));
                }
            }
            ++n3;
        }
    }

    private void paintDragFeedback(Graphics2D graphics2D, RADVisualComponent rADVisualComponent) {
        Object object = this.formDesigner.getComponent(rADVisualComponent);
        if (!(object instanceof Component) || !((Component)object).isShowing()) {
            return;
        }
        Component component = (Component)object;
        Rectangle rectangle = component.getBounds();
        rectangle = SwingUtilities.convertRectangle(component.getParent(), rectangle, this.handleLayer);
        rectangle.translate(this.mousePosition.x - this.hotspot.x, this.mousePosition.y - this.hotspot.y);
        graphics2D.draw(new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        if (rADVisualComponent instanceof RADVisualContainer) {
            RADVisualComponent[] rADVisualComponentArray = ((RADVisualContainer)rADVisualComponent).getSubComponents();
            int n = 0;
            while (n < rADVisualComponentArray.length) {
                this.paintDragFeedback(graphics2D, rADVisualComponentArray[n]);
                ++n;
            }
        }
    }

    private void paintTargetContainerFeedback(Graphics2D graphics2D, Container container) {
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(2.0f, 2, 0, 10.0f, new float[]{2.0f, 8.0f}, 0.0f);
        graphics2D.setStroke(basicStroke);
        Color color = graphics2D.getColor();
        graphics2D.setColor(formSettings.getDragBorderColor());
        Rectangle rectangle = new Rectangle(new Point(0, 0), container.getSize());
        rectangle = SwingUtilities.convertRectangle(container, rectangle, this.handleLayer);
        graphics2D.draw(new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }
}

