/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.dtd;

import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.DTDParser;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.ReaderProvider;

public class Registry {
    private static Map dtdMap = new HashMap();
    private static List providers = new ArrayList();
    private static LinkedList listeners = new LinkedList();
    private static Map provider2dtds = new HashMap();

    public void addInvalidateListener(InvalidateListener invalidateListener) {
        LinkedList linkedList = listeners;
        synchronized (linkedList) {
            listeners.add(new WeakReference<InvalidateListener>(invalidateListener));
        }
    }

    public void removeInvalidateListener(InvalidateListener invalidateListener) {
        LinkedList linkedList = listeners;
        synchronized (linkedList) {
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                InvalidateListener invalidateListener2 = (InvalidateListener)weakReference.get();
                if (invalidateListener2 != null && invalidateListener2 != invalidateListener) continue;
                iterator.remove();
            }
        }
    }

    public static void fireInvalidateEvent(Set set) {
        InvalidateListener invalidateListener;
        Object object;
        Object object2;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            dtdMap.remove(iterator.next());
        }
        ArrayList<InvalidateListener> arrayList = new ArrayList<InvalidateListener>();
        LinkedList linkedList = listeners;
        synchronized (linkedList) {
            object2 = listeners.iterator();
            while (object2.hasNext()) {
                object = (WeakReference)object2.next();
                invalidateListener = (InvalidateListener)((Reference)object).get();
                if (invalidateListener == null) {
                    object2.remove();
                    continue;
                }
                arrayList.add(invalidateListener);
            }
        }
        object2 = new InvalidateEvent(set);
        object = arrayList.iterator();
        while (object.hasNext()) {
            invalidateListener = (InvalidateListener)object.next();
            invalidateListener.dtdInvalidated((InvalidateEvent)object2);
        }
    }

    public static void registerReaderProvider(ReaderProvider readerProvider) {
        providers.add(readerProvider);
    }

    public static void invalidateReaderProvider(ReaderProvider readerProvider) {
        Set set = (Set)provider2dtds.get(readerProvider);
        if (set != null) {
            Registry.fireInvalidateEvent(set);
            provider2dtds.remove(readerProvider);
        }
    }

    public static void unregisterReaderProvider(ReaderProvider readerProvider) {
        providers.remove(readerProvider);
        Registry.invalidateReaderProvider(readerProvider);
    }

    private static DTD getWeak(String string) {
        WeakReference weakReference = (WeakReference)dtdMap.get(string);
        if (weakReference == null) {
            return null;
        }
        DTD dTD = (DTD)weakReference.get();
        if (dTD == null) {
            dtdMap.remove(string);
        }
        return dTD;
    }

    private static void putWeak(String string, DTD dTD) {
        dtdMap.put(string, new WeakReference<DTD>(dTD));
    }

    private static ReaderProvider getProvider(String string, String string2) {
        Iterator iterator = providers.iterator();
        while (iterator.hasNext()) {
            ReaderProvider readerProvider = (ReaderProvider)iterator.next();
            Reader reader = readerProvider.getReaderForIdentifier(string, string2);
            if (reader == null) continue;
            return readerProvider;
        }
        return null;
    }

    private static DTD parseDTD(String string, String string2) {
        ReaderProvider readerProvider = Registry.getProvider(string, string2);
        if (readerProvider == null) {
            return null;
        }
        try {
            DTD dTD = new DTDParser().createDTD(readerProvider, string, string2);
            if (dTD != null) {
                HashSet<String> hashSet = (HashSet<String>)provider2dtds.get(readerProvider);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    provider2dtds.put(readerProvider, hashSet);
                }
                hashSet.add(string);
                Registry.putWeak(string, dTD);
            }
            return dTD;
        }
        catch (DTDParser.WrongDTDException wrongDTDException) {
            return null;
        }
    }

    public static DTD getDTD(String string, String string2) {
        DTD dTD = Registry.getWeak(string);
        if (dTD == null) {
            dTD = Registry.parseDTD(string, string2);
        }
        return dTD;
    }
}

