/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLCompletionQuery;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;
import org.netbeans.editor.ext.html.dtd.InvalidateEvent;
import org.netbeans.editor.ext.html.dtd.InvalidateListener;
import org.netbeans.editor.ext.html.dtd.Registry;

public class HTMLSyntaxSupport
extends ExtSyntaxSupport
implements InvalidateListener {
    private static final String FALLBACK_DOCTYPE = "-//W3C//DTD HTML 4.01 Transitional//EN";
    private DTD dtd;
    private String docType;

    public HTMLSyntaxSupport(BaseDocument baseDocument) {
        super(baseDocument);
    }

    public void dtdInvalidated(InvalidateEvent invalidateEvent) {
        if (this.dtd != null && invalidateEvent.isInvalidatedIdentifier(this.docType)) {
            this.dtd = null;
        }
    }

    public DTD getDTD() {
        String string = this.getDocType();
        if (string == null) {
            string = FALLBACK_DOCTYPE;
        }
        if (this.dtd != null && string == this.docType) {
            return this.dtd;
        }
        this.docType = string;
        this.dtd = Registry.getDTD(this.docType, null);
        return this.dtd;
    }

    protected String getDocType() {
        try {
            SyntaxElement syntaxElement = this.getElementChain(0);
            if (syntaxElement == null) {
                return null;
            }
            int n = syntaxElement.getType();
            while (n != 1 && n != 4) {
                if ((syntaxElement = syntaxElement.getNext()) == null) break;
                n = syntaxElement.getType();
            }
            if (n == 1) {
                return ((SyntaxElement.Declaration)syntaxElement).getPublicIdentifier();
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private final int getTokenEnd(TokenItem tokenItem) {
        return tokenItem.getOffset() + tokenItem.getImage().length();
    }

    public SyntaxElement getElementChain(int n) throws BadLocationException {
        TokenItem tokenItem = this.getTokenChain(n, Math.min(n + 10, this.getDocument().getLength()));
        TokenItem tokenItem2 = tokenItem;
        if (tokenItem2 == null) {
            return null;
        }
        TokenID tokenID = tokenItem2.getTokenID();
        int n2 = tokenItem2.getOffset();
        if (tokenID == HTMLTokenContext.CHARACTER) {
            while (tokenID != null && tokenID == HTMLTokenContext.CHARACTER) {
                n2 = tokenItem2.getOffset();
                TokenID tokenID2 = tokenID = (tokenItem2 = tokenItem2.getPrevious()) == null ? null : tokenItem2.getTokenID();
            }
            if (tokenID != HTMLTokenContext.VALUE && tokenID != HTMLTokenContext.TEXT) {
                return this.getNextElement(n2);
            }
        }
        if (tokenID == HTMLTokenContext.WS || tokenID == HTMLTokenContext.ARGUMENT || tokenID == HTMLTokenContext.OPERATOR || tokenID == HTMLTokenContext.VALUE) {
            while ((tokenID = (tokenItem2 = tokenItem2.getPrevious()).getTokenID()) != HTMLTokenContext.TAG) {
            }
            return this.getNextElement(tokenItem2.getOffset());
        }
        if (tokenID == HTMLTokenContext.TEXT) {
            while (tokenID != null && (tokenID == HTMLTokenContext.TEXT || tokenID == HTMLTokenContext.CHARACTER)) {
                n2 = tokenItem2.getOffset();
                TokenID tokenID3 = tokenID = (tokenItem2 = tokenItem2.getPrevious()) == null ? null : tokenItem2.getTokenID();
            }
            return this.getNextElement(n2);
        }
        if (tokenID == HTMLTokenContext.TAG) {
            if (tokenItem2.getImage().startsWith("<")) {
                return this.getNextElement(tokenItem2.getOffset());
            }
            while ((tokenID = (tokenItem2 = tokenItem2.getPrevious()).getTokenID()) != HTMLTokenContext.TAG) {
            }
            return this.getNextElement(tokenItem2.getOffset());
        }
        if (tokenID == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, tokenItem2.getOffset(), this.getTokenEnd(tokenItem2), 2);
        }
        if (tokenID == HTMLTokenContext.BLOCK_COMMENT) {
            while (tokenID == HTMLTokenContext.BLOCK_COMMENT && !tokenItem2.getImage().startsWith("<!--")) {
                tokenItem2 = tokenItem2.getPrevious();
                tokenID = tokenItem2.getTokenID();
            }
            return this.getNextElement(tokenItem2.getOffset());
        }
        if (tokenID == HTMLTokenContext.DECLARATION || tokenID == HTMLTokenContext.SGML_COMMENT) {
            while (tokenID != HTMLTokenContext.DECLARATION || !tokenItem2.getImage().startsWith("<!")) {
                tokenItem2 = tokenItem2.getPrevious();
                tokenID = tokenItem2.getTokenID();
            }
            return this.getNextElement(tokenItem2.getOffset());
        }
        return null;
    }

    SyntaxElement getPreviousElement(int n) throws BadLocationException {
        return n == 0 ? null : this.getElementChain(n - 1);
    }

    private static String getQuotedString(StringBuffer stringBuffer) {
        char c;
        int n = 0;
        while (stringBuffer.charAt(n) == ' ') {
            ++n;
        }
        if ((c = stringBuffer.charAt(n++)) == '\"' || c == '\'') {
            int n2 = n;
            while (n2 < stringBuffer.length()) {
                if (stringBuffer.charAt(n2) == c) {
                    String string = stringBuffer.substring(n, n2);
                    stringBuffer.delete(0, n2 + 1);
                    return string;
                }
                ++n2;
            }
        }
        return null;
    }

    public SyntaxElement getNextElement(int n) throws BadLocationException {
        TokenItem tokenItem = this.getTokenChain(n, Math.min(n + 10, this.getDocument().getLength()));
        if (tokenItem == null) {
            return null;
        }
        TokenID tokenID = tokenItem.getTokenID();
        int n2 = this.getTokenEnd(tokenItem);
        if (tokenID == HTMLTokenContext.BLOCK_COMMENT) {
            while (tokenID == HTMLTokenContext.BLOCK_COMMENT) {
                n2 = this.getTokenEnd(tokenItem);
                if ((tokenItem = tokenItem.getNext()) == null) break;
                tokenID = tokenItem.getTokenID();
            }
            return new SyntaxElement(this, n, n2, 0);
        }
        if (tokenID == HTMLTokenContext.DECLARATION) {
            String string;
            String string2;
            StringBuffer stringBuffer = new StringBuffer(tokenItem.getImage());
            while (tokenID == HTMLTokenContext.DECLARATION || tokenID == HTMLTokenContext.SGML_COMMENT) {
                n2 = this.getTokenEnd(tokenItem);
                if ((tokenItem = tokenItem.getNext()) == null) break;
                tokenID = tokenItem.getTokenID();
                if (tokenID != HTMLTokenContext.DECLARATION) continue;
                stringBuffer.append(tokenItem.getImage());
            }
            if (!(string2 = stringBuffer.toString()).startsWith("<!DOCTYPE")) {
                return new SyntaxElement.Declaration(this, n, n2, null, null, null);
            }
            int n3 = (string2 = string2.substring(9).trim()).indexOf(32);
            if (n3 < 0) {
                return new SyntaxElement.Declaration(this, n, n2, null, null, null);
            }
            String string3 = string2.substring(0, n3);
            if ((string2 = string2.substring(n3).trim()).startsWith("PUBLIC")) {
                stringBuffer = new StringBuffer(string2 = string2.substring(6).trim());
                String string4 = HTMLSyntaxSupport.getQuotedString(stringBuffer);
                if (string4 != null) {
                    String string5 = HTMLSyntaxSupport.getQuotedString(stringBuffer);
                    return new SyntaxElement.Declaration(this, n, n2, string3, string4, string5);
                }
            } else if (string2.startsWith("SYSTEM") && (string = HTMLSyntaxSupport.getQuotedString(stringBuffer = new StringBuffer(string2 = string2.substring(6).trim()))) != null) {
                return new SyntaxElement.Declaration(this, n, n2, string3, null, string);
            }
            return new SyntaxElement.Declaration(this, n, n2, null, null, null);
        }
        if (tokenID == HTMLTokenContext.ERROR) {
            return new SyntaxElement(this, tokenItem.getOffset(), n2, 2);
        }
        if (tokenID == HTMLTokenContext.TEXT || tokenID == HTMLTokenContext.CHARACTER) {
            while (tokenID == HTMLTokenContext.TEXT || tokenID == HTMLTokenContext.CHARACTER) {
                n2 = this.getTokenEnd(tokenItem);
                if ((tokenItem = tokenItem.getNext()) == null) break;
                tokenID = tokenItem.getTokenID();
            }
            return new SyntaxElement(this, n, n2, 3);
        }
        String string = tokenItem.getImage();
        if (tokenID == HTMLTokenContext.TAG) {
            if (string.startsWith("</")) {
                String string6 = string.substring(2);
                tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
                while (tokenID == HTMLTokenContext.WS) {
                    n2 = this.getTokenEnd(tokenItem);
                    TokenID tokenID2 = tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
                }
                if (tokenID == HTMLTokenContext.TAG && tokenItem.getImage().equals(">")) {
                    return new SyntaxElement.Named(this, n, this.getTokenEnd(tokenItem), 5, string6);
                }
                return new SyntaxElement.Named(this, n, n2, 5, string6);
            }
            String string7 = string.substring(1);
            ArrayList<String> arrayList = new ArrayList<String>();
            tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
            while (tokenID == HTMLTokenContext.WS || tokenID == HTMLTokenContext.ARGUMENT || tokenID == HTMLTokenContext.OPERATOR || tokenID == HTMLTokenContext.VALUE || tokenID == HTMLTokenContext.CHARACTER) {
                if (tokenID == HTMLTokenContext.ARGUMENT) {
                    arrayList.add(tokenItem.getImage());
                }
                n2 = this.getTokenEnd(tokenItem);
                TokenID tokenID3 = tokenID = (tokenItem = tokenItem.getNext()) == null ? null : tokenItem.getTokenID();
            }
            if (tokenID == HTMLTokenContext.TAG && tokenItem.getImage().equals(">")) {
                return new SyntaxElement.Tag(this, n, this.getTokenEnd(tokenItem), string7, arrayList);
            }
            return new SyntaxElement.Tag(this, n, n2, string7, arrayList);
        }
        throw new BadLocationException("Misuse at " + n, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public List getPossibleEndTags(int n, String string) throws BadLocationException {
        string = string.toUpperCase();
        int n2 = string.length();
        SyntaxElement syntaxElement = this.getElementChain(n);
        Stack<String> stack = new Stack<String>();
        ArrayList<HTMLCompletionQuery.EndTagItem> arrayList = new ArrayList<HTMLCompletionQuery.EndTagItem>();
        HashSet<String> hashSet = new HashSet<String>();
        DTD dTD = this.getDTD();
        if (syntaxElement != null) {
            syntaxElement = syntaxElement.getPrevious();
        } else {
            if (n <= 0) return arrayList;
            syntaxElement = this.getElementChain(n - 1);
        }
        while (syntaxElement != null) {
            DTD.Element element;
            if (syntaxElement.getType() == 5) {
                stack.push(((SyntaxElement.Named)syntaxElement).getName().toUpperCase());
            } else if (syntaxElement.getType() == 4 && (element = dTD.getElement(((SyntaxElement.Tag)syntaxElement).getName().toUpperCase())) != null && !element.isEmpty()) {
                String string2 = element.getName();
                if (stack.empty()) {
                    if (string2.startsWith(string) && !hashSet.contains(string2)) {
                        hashSet.add(string2);
                        arrayList.add(new HTMLCompletionQuery.EndTagItem(string2, n - 2 - n2, n2 + 2));
                    }
                    if (!element.hasOptionalEnd()) {
                        return arrayList;
                    }
                } else if (stack.peek().equals(string2)) {
                    stack.pop();
                } else if (!element.hasOptionalEnd()) {
                    return arrayList;
                }
            }
            syntaxElement = syntaxElement.getPrevious();
        }
        return arrayList;
    }

    public int checkCompletion(JTextComponent jTextComponent, String string, boolean bl) {
        if (!bl) {
            int n = 1;
            switch (string.charAt(string.length() - 1)) {
                case '/': {
                    int n2 = jTextComponent.getCaret().getDot();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    if (n2 < 2) break;
                    try {
                        String string2 = baseDocument.getText(n2 - 2, 2);
                        if (!string2.equals("</")) break;
                        n = 0;
                    }
                    catch (BadLocationException badLocationException) {}
                    break;
                }
                case ' ': 
                case '&': 
                case '<': {
                    n = 0;
                }
            }
            return n;
        }
        switch (string.charAt(0)) {
            case ';': 
            case '>': {
                return 4;
            }
        }
        return 3;
    }
}

