/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.editor.ext.html.HTMLSyntaxSupport;
import org.netbeans.editor.ext.html.HTMLTokenContext;
import org.netbeans.editor.ext.html.SyntaxElement;
import org.netbeans.editor.ext.html.dtd.DTD;

public class HTMLCompletionQuery
implements CompletionQuery {
    static /* synthetic */ Class class$org$netbeans$editor$ext$html$HTMLSyntaxSupport;

    public CompletionQuery.Result query(JTextComponent jTextComponent, int n, SyntaxSupport syntaxSupport) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        if (baseDocument.getLength() == 0) {
            return null;
        }
        HTMLSyntaxSupport hTMLSyntaxSupport = (HTMLSyntaxSupport)syntaxSupport.get(class$org$netbeans$editor$ext$html$HTMLSyntaxSupport == null ? (class$org$netbeans$editor$ext$html$HTMLSyntaxSupport = HTMLCompletionQuery.class$("org.netbeans.editor.ext.html.HTMLSyntaxSupport")) : class$org$netbeans$editor$ext$html$HTMLSyntaxSupport);
        if (hTMLSyntaxSupport == null) {
            return null;
        }
        DTD dTD = hTMLSyntaxSupport.getDTD();
        if (dTD == null) {
            return null;
        }
        try {
            boolean bl;
            TokenItem tokenItem = null;
            TokenItem tokenItem2 = null;
            boolean bl2 = false;
            tokenItem = hTMLSyntaxSupport.getTokenChain(n, n + 1);
            if (tokenItem != null) {
                tokenItem2 = tokenItem.getPrevious();
                bl2 = tokenItem.getOffset() < n;
            } else {
                tokenItem2 = hTMLSyntaxSupport.getTokenChain(n - 1, n);
            }
            boolean bl3 = bl = tokenItem2 == null && !bl2;
            if (bl) {
                return null;
            }
            TokenID tokenID = null;
            List list = null;
            int n2 = 1;
            int n3 = 0;
            String string = null;
            if (bl2) {
                tokenID = tokenItem.getTokenID();
                string = tokenItem.getImage().substring(0, n - tokenItem.getOffset());
                n3 = tokenItem.getOffset();
            } else {
                tokenID = tokenItem2.getTokenID();
                string = tokenItem2.getImage().substring(0, n - tokenItem2.getOffset());
                n3 = tokenItem2.getOffset();
            }
            if ((tokenID == HTMLTokenContext.TEXT || tokenID == HTMLTokenContext.VALUE) && string.endsWith("&")) {
                list = this.translateCharRefs(n - n2, n2, dTD.getCharRefList(""));
            } else if (tokenID == HTMLTokenContext.CHARACTER) {
                if (bl2 || !string.endsWith(";")) {
                    n2 = n - n3;
                    list = this.translateCharRefs(n - n2, n2, dTD.getCharRefList(string.substring(1)));
                }
            } else if (tokenID == HTMLTokenContext.TEXT && string.endsWith("<")) {
                list = this.translateTags(n - n2, n2, dTD.getElementList(""));
            } else if (tokenID == HTMLTokenContext.TAG && string.startsWith("<") && !string.startsWith("</")) {
                n2 = n - n3;
                list = this.translateTags(n - n2, n2, dTD.getElementList(string.substring(1)));
            } else if (tokenID == HTMLTokenContext.TEXT && string.endsWith("</")) {
                n2 = 2;
                list = hTMLSyntaxSupport.getPossibleEndTags(n, "");
            } else if (tokenID == HTMLTokenContext.TAG && string.startsWith("</")) {
                n2 = n - n3;
                list = hTMLSyntaxSupport.getPossibleEndTags(n, string.substring(2));
            } else if (tokenID == HTMLTokenContext.WS || tokenID == HTMLTokenContext.ARGUMENT) {
                SyntaxElement syntaxElement = null;
                try {
                    syntaxElement = hTMLSyntaxSupport.getElementChain(n);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                if (syntaxElement == null) {
                    return null;
                }
                if (syntaxElement.getType() == 4) {
                    SyntaxElement.Tag tag = (SyntaxElement.Tag)syntaxElement;
                    String string2 = tag.getName().toUpperCase();
                    DTD.Element element = dTD.getElement(string2);
                    if (element == null) {
                        return null;
                    }
                    String string3 = tokenID == HTMLTokenContext.ARGUMENT ? string : "";
                    n2 = string3.length();
                    List list2 = element.getAttributeList(string3);
                    Collection collection = tag.getAttributes();
                    String string4 = "";
                    try {
                        string4 = Utilities.getWord(baseDocument, Utilities.getWordStart(baseDocument, n));
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    list = new ArrayList();
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        DTD.Attribute attribute = (DTD.Attribute)iterator.next();
                        String string5 = attribute.getName();
                        if (!string5.equals(string3) && collection.contains(string5) && !string4.equals(string5)) continue;
                        list.add(attribute);
                    }
                    list = this.translateAttribs(n - n2, n2, list);
                }
            } else if (tokenID == HTMLTokenContext.VALUE || tokenID == HTMLTokenContext.OPERATOR || tokenID == HTMLTokenContext.WS && (bl2 ? tokenItem2 : tokenItem2.getPrevious()).getTokenID() == HTMLTokenContext.OPERATOR) {
                SyntaxElement syntaxElement = null;
                try {
                    syntaxElement = hTMLSyntaxSupport.getElementChain(n);
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
                if (syntaxElement == null) {
                    return null;
                }
                if (syntaxElement.getType() == 2 && (syntaxElement = syntaxElement.getPrevious()) == null) {
                    return null;
                }
                if (syntaxElement.getType() == 4) {
                    SyntaxElement.Tag tag = (SyntaxElement.Tag)syntaxElement;
                    String string6 = tag.getName().toUpperCase();
                    DTD.Element element = dTD.getElement(string6);
                    if (element == null) {
                        return null;
                    }
                    TokenItem tokenItem3 = tokenItem2;
                    while (tokenItem3 != null && tokenItem3.getTokenID() != HTMLTokenContext.ARGUMENT) {
                        tokenItem3 = tokenItem3.getPrevious();
                    }
                    if (tokenItem3 == null) {
                        return null;
                    }
                    String string7 = tokenItem3.getImage();
                    DTD.Attribute attribute = element.getAttribute(string7);
                    if (attribute == null || attribute.getType() != 1) {
                        return null;
                    }
                    if (tokenID != HTMLTokenContext.VALUE) {
                        n2 = 0;
                        list = this.translateValues(n - n2, n2, attribute.getValueList(""));
                    } else {
                        n2 = n - n3;
                        list = this.translateValues(n - n2, n2, attribute.getValueList(string));
                    }
                }
            }
            if (list == null) {
                return null;
            }
            return new CompletionQuery.DefaultResult(jTextComponent, "Results for DOCTYPE " + dTD.getIdentifier(), list, n, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    List translateCharRefs(int n, int n2, List list) {
        ArrayList<CharRefItem> arrayList = new ArrayList<CharRefItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new CharRefItem(((DTD.CharRef)iterator.next()).getName(), n, n2));
        }
        return arrayList;
    }

    List translateTags(int n, int n2, List list) {
        ArrayList<TagItem> arrayList = new ArrayList<TagItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new TagItem(((DTD.Element)iterator.next()).getName(), n, n2));
        }
        return arrayList;
    }

    List translateAttribs(int n, int n2, List list) {
        ArrayList<HTMLResultItem> arrayList = new ArrayList<HTMLResultItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DTD.Attribute attribute = (DTD.Attribute)iterator.next();
            String string = attribute.getName();
            switch (attribute.getType()) {
                case 0: {
                    arrayList.add(new BooleanAttribItem(string, n, n2, attribute.isRequired()));
                    break;
                }
                case 1: {
                    arrayList.add(new SetAttribItem(string, n, n2, attribute.isRequired()));
                    break;
                }
                case 2: {
                    arrayList.add(new PlainAttribItem(string, n, n2, attribute.isRequired()));
                }
            }
        }
        return arrayList;
    }

    List translateValues(int n, int n2, List list) {
        if (list == null) {
            return new ArrayList(0);
        }
        ArrayList<ValueItem> arrayList = new ArrayList<ValueItem>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new ValueItem(((DTD.Value)iterator.next()).getName(), n, n2));
        }
        return arrayList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ValueItem
    extends HTMLResultItem {
        public ValueItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        Color getPaintColor() {
            return Color.magenta;
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, bl ? this.baseText + " " : this.baseText);
            return !bl;
        }
    }

    private static class PlainAttribItem
    extends HTMLResultItem {
        boolean required;

        public PlainAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, this.baseText + "=''");
            if (bl) {
                Caret caret = jTextComponent.getCaret();
                caret.setDot(caret.getDot() - 1);
            }
            return false;
        }
    }

    private static class BooleanAttribItem
    extends HTMLResultItem {
        boolean required;

        public BooleanAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, bl ? this.baseText + " " : this.baseText);
            return false;
        }
    }

    private static class SetAttribItem
    extends HTMLResultItem {
        boolean required;

        public SetAttribItem(String string, int n, int n2, boolean bl) {
            super(string, n, n2);
            this.required = bl;
        }

        Color getPaintColor() {
            return this.required ? Color.red : Color.green.darker();
        }

        String getPaintText() {
            return this.baseText;
        }

        public String getItemText() {
            return this.baseText + "=";
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            super.substituteText(jTextComponent, 0, 0, bl);
            return false;
        }
    }

    private static class TagItem
    extends HTMLResultItem {
        public TagItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            this.replaceText(jTextComponent, "<" + this.baseText + (bl ? " >" : ">"));
            if (bl) {
                Caret caret = jTextComponent.getCaret();
                caret.setDot(caret.getDot() - 1);
            }
            return !bl;
        }

        Color getPaintColor() {
            return Color.blue;
        }

        public String getItemText() {
            return "<" + this.baseText + ">";
        }
    }

    private static class CharRefItem
    extends HTMLResultItem {
        public CharRefItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        Color getPaintColor() {
            return Color.red.darker();
        }

        public String getItemText() {
            return "&" + this.baseText + ";";
        }
    }

    static class EndTagItem
    extends HTMLResultItem {
        public EndTagItem(String string, int n, int n2) {
            super(string, n, n2);
        }

        Color getPaintColor() {
            return Color.blue;
        }

        public String getItemText() {
            return "</" + this.baseText + ">";
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return super.substituteText(jTextComponent, n, n2, bl);
        }
    }

    private static abstract class HTMLResultItem
    implements CompletionQuery.ResultItem {
        static JLabel rubberStamp = new JLabel();
        String baseText;
        int offset;
        int length;

        public HTMLResultItem(String string, int n, int n2) {
            this.baseText = string;
            this.offset = n;
            this.length = n2;
        }

        boolean replaceText(JTextComponent jTextComponent, String string) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            baseDocument.atomicLock();
            try {
                try {
                    baseDocument.remove(this.offset, this.length);
                    baseDocument.insertString(this.offset, string, null);
                }
                catch (BadLocationException badLocationException) {
                    boolean bl = false;
                    Object var7_5 = null;
                    baseDocument.atomicUnlock();
                    return bl;
                }
                Object var7_4 = null;
                baseDocument.atomicUnlock();
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                baseDocument.atomicUnlock();
                throw throwable;
            }
            return true;
        }

        public boolean substituteCommonText(JTextComponent jTextComponent, int n, int n2, int n3) {
            return this.replaceText(jTextComponent, this.getItemText().substring(0, n3));
        }

        public boolean substituteText(JTextComponent jTextComponent, int n, int n2, boolean bl) {
            return this.replaceText(jTextComponent, this.getItemText());
        }

        public Component getPaintComponent(JList jList, boolean bl, boolean bl2) {
            rubberStamp.setText(" " + this.getPaintText());
            if (bl) {
                rubberStamp.setBackground(jList.getSelectionBackground());
                rubberStamp.setForeground(jList.getSelectionForeground());
            } else {
                rubberStamp.setBackground(jList.getBackground());
                rubberStamp.setForeground(this.getPaintColor());
            }
            return rubberStamp;
        }

        String getPaintText() {
            return this.getItemText();
        }

        abstract Color getPaintColor();

        public String getItemText() {
            return this.baseText;
        }

        static {
            rubberStamp.setOpaque(true);
        }
    }
}

