/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class KeywordMatchGenerator {
    private static final String USAGE = "Usage: java org.netbeans.editor.ext.KeywordMatchGenerator [options] keyword-file [match-function-name]\n\nOptions:\n  -i Ignore case in matching\n  -s Input is in 'input' String or StringBuffer instead of char buffer\n\nGenerator of method that matches the keywords provided in the file.\nKeywords in the file must be separated by spaces or new-lines and they don't need to be sorted.\n";
    private static final String UNKNOWN_OPTION = " is unknown option.\n";
    public static final String IGNORE_CASE = "-i";
    public static final String USE_STRING = "-s";
    private static final String DEFAULT_METHOD_NAME = "match";
    private static final String[] OPTION_LIST = new String[]{"-i", "-s"};
    private String[] kwds;
    private int maxKwdLen;
    private HashMap options = new HashMap();
    private HashMap kwdConstants = new HashMap();

    private String indent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append("  ");
        }
        return stringBuffer.toString();
    }

    protected void initScan(String string) {
        if (string == null) {
            string = DEFAULT_METHOD_NAME;
        }
        this.appendString("\n");
        int n = 0;
        while (n < this.kwds.length) {
            this.appendString(this.indent(1) + "public static final int " + this.kwdConstants.get(this.kwds[n]) + " = " + n + ";\n");
            ++n;
        }
        this.appendString("\n");
        this.appendString(this.indent(1) + "public static int ");
        this.appendString(string);
        if (this.options.get(USE_STRING) != null) {
            this.appendString("(String buffer, int offset, int len) {\n");
        } else {
            this.appendString("(char[] buffer, int offset, int len) {\n");
        }
        this.appendString(this.indent(2) + "if (len > " + this.maxKwdLen + ")\n");
        this.appendString(this.indent(3) + "return -1;\n");
    }

    public void scan() {
        this.scan(0, this.kwds.length, 0, 2, 0);
    }

    protected void finishScan() {
        this.appendString(this.indent(1) + "}\n\n");
    }

    public void addOption(String string) {
        this.options.put(string, string);
    }

    protected String getKwdConstantPrefix() {
        return "";
    }

    protected String getKwdConstant(String string) {
        return (String)this.kwdConstants.get(string);
    }

    protected boolean upperCaseKeyConstants() {
        return true;
    }

    private void parseKeywords(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            while (true) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.length();
                this.maxKwdLen = Math.max(this.maxKwdLen, n);
                arrayList.add(string2);
                this.kwdConstants.put(string2, this.getKwdConstantPrefix() + (this.upperCaseKeyConstants() ? string2.toUpperCase() : string2));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            this.kwds = new String[arrayList.size()];
            arrayList.toArray(this.kwds);
            Arrays.sort(this.kwds);
            return;
        }
    }

    protected String getCurrentChar() {
        boolean bl;
        boolean bl2 = this.options.get(USE_STRING) != null;
        boolean bl3 = bl = this.options.get(IGNORE_CASE) != null;
        if (bl2) {
            return bl ? "Character.toLowerCase(buffer.charAt(offset++))" : "buffer.charAt(offset++)";
        }
        return bl ? "Character.toLowerCase(buffer[offset++])" : "buffer[offset++]";
    }

    private void appendCheckedReturn(String string, int n, int n2) {
        this.appendString(this.indent(n2) + "return (len == " + string.length());
        int n3 = string.length() - 1;
        int n4 = n;
        while (n4 <= n3) {
            this.appendString("\n" + this.indent(n2 + 1) + "&& ");
            this.appendString(this.getCurrentChar() + " == '" + string.charAt(n4) + "'");
            ++n4;
        }
        this.appendString(")\n" + this.indent(n2 + 2) + "? " + this.getKwdConstant(string) + " : -1;\n");
    }

    protected void appendString(String string) {
        System.out.print(string);
    }

    private void scan(int n, int n2, int n3, int n4, int n5) {
        int n6;
        char c;
        int n7;
        int n8;
        int n9;
        int n10 = 0;
        int n11 = n;
        while (n11 < n2) {
            n10 = Math.max(n10, this.kwds[n11].length());
            ++n11;
        }
        do {
            int n12;
            n8 = Integer.MAX_VALUE;
            n7 = n;
            while (n7 < n2) {
                n8 = Math.min(n8, this.kwds[n7].length());
                ++n7;
            }
            if (n8 > n5) {
                this.appendString(this.indent(n4) + "if (len <= " + (n8 - 1) + ")\n");
                this.appendString(this.indent(n4 + 1) + "return -1;\n");
            }
            n9 = 0;
            c = '\u0000';
            n6 = n3;
            while (n6 < n8) {
                n12 = this.kwds[n].charAt(n6);
                int n13 = n + 1;
                while (n13 < n2) {
                    if (this.kwds[n13].charAt(n6) != n12) {
                        c = '\u0001';
                        break;
                    }
                    ++n13;
                }
                if (c != '\u0000') break;
                ++n9;
                ++n6;
            }
            if (n9 > 0) {
                this.appendString(this.indent(n4) + "if (");
                n12 = 0;
                while (n12 < n9) {
                    if (n12 > 0) {
                        this.appendString(this.indent(n4 + 1) + "|| ");
                    }
                    this.appendString(this.getCurrentChar() + " != '" + this.kwds[n].charAt(n3 + n12) + "'");
                    if (n12 < n9 - '\u0001') {
                        this.appendString("\n");
                    }
                    ++n12;
                }
                this.appendString(")\n" + this.indent(n4 + 2) + "return -1;\n");
            }
            if ((n3 += n9) == this.kwds[n].length()) {
                this.appendString(this.indent(n4) + "if (len == " + n3 + ")\n");
                this.appendString(this.indent(n4 + 1) + "return " + this.getKwdConstant(this.kwds[n]) + ";\n");
                ++n;
                if (n3 >= n8) {
                    n8 = n3 + 1;
                }
            }
            n5 = n8;
        } while (n9 > 0 && n < n2);
        if (n3 < n10) {
            this.appendString(this.indent(n4) + "switch (" + this.getCurrentChar() + ") {\n");
            n7 = n;
            while (n7 < n2) {
                c = this.kwds[n7].charAt(n3);
                this.appendString(this.indent(n4 + 1) + "case '" + c + "':\n");
                n6 = n7 + 1;
                while (n6 < n2 && this.kwds[n6].length() > n3 && this.kwds[n6].charAt(n3) == c) {
                    ++n6;
                }
                if (n6 > n7 + 1) {
                    this.scan(n7, n6, n3 + 1, n4 + 2, n8);
                } else {
                    this.appendCheckedReturn(this.kwds[n7], n3 + 1, n4 + 2);
                }
                n7 = n6;
            }
            this.appendString(this.indent(n4 + 1) + "default:\n");
            this.appendString(this.indent(n4 + 2) + "return -1;\n");
            this.appendString(this.indent(n4) + "}\n");
        } else {
            this.appendString(this.indent(n4) + "return -1;\n");
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        KeywordMatchGenerator keywordMatchGenerator = new KeywordMatchGenerator();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '-') break;
            int n2 = 0;
            while (n2 < OPTION_LIST.length) {
                if (stringArray[n].equals(OPTION_LIST[n2])) {
                    keywordMatchGenerator.addOption(OPTION_LIST[n2]);
                    break;
                }
                ++n2;
            }
            if (n2 == OPTION_LIST.length) {
                System.err.println("'" + stringArray[n] + "'" + UNKNOWN_OPTION);
                System.err.println(USAGE);
                return;
            }
            ++n;
        }
        if (stringArray.length - n < 1) {
            System.err.println(USAGE);
            return;
        }
        String string = null;
        try {
            object = new File(stringArray[n]);
            if (!((File)object).exists()) {
                System.err.println("Non-existent file '" + stringArray[n] + "'");
                return;
            }
            char[] cArray = new char[(int)((File)object).length()];
            FileReader fileReader = new FileReader((File)object);
            int n3 = 0;
            while ((long)n3 < ((File)object).length()) {
                int n4 = ((Reader)fileReader).read(cArray, n3, (int)((File)object).length() - n3);
                if (n4 < 0) break;
                n3 += n4;
            }
            string = new String(cArray);
        }
        catch (IOException iOException) {
            System.err.println("Cannot read from keyword file '" + stringArray[n] + "'");
            return;
        }
        object = null;
        if (stringArray.length - n >= 2) {
            object = stringArray[n + 1];
        }
        keywordMatchGenerator.parseKeywords(string);
        keywordMatchGenerator.initScan((String)object);
        keywordMatchGenerator.scan();
        keywordMatchGenerator.finishScan();
    }
}

