/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.Completion;
import org.netbeans.editor.ext.ExtCaret;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtFormatter;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.FindDialogSupport;
import org.netbeans.editor.ext.GotoDialogSupport;
import org.netbeans.editor.ext.ToolTipSupport;

public class ExtKit
extends BaseKit {
    public static final String buildPopupMenuAction = "build-popup-menu";
    public static final String showPopupMenuAction = "show-popup-menu";
    public static final String buildToolTipAction = "build-tool-tip";
    public static final String findAction = "find";
    public static final String replaceAction = "replace";
    public static final String gotoAction = "goto";
    public static final String gotoDeclarationAction = "goto-declaration";
    public static final String gotoSourceAction = "goto-source";
    public static final String gotoHelpAction = "goto-help";
    public static final String matchBraceAction = "match-brace";
    public static final String selectionMatchBraceAction = "selection-match-brace";
    public static final String toggleCaseIdentifierBeginAction = "toggle-case-identifier-begin";
    public static final String codeSelectAction = "code-select";
    public static final String escapeAction = "escape";
    public static final String completionShowAction = "completion-show";
    public static final String completionHideAction = "completion-hide";
    public static final String shiftInsertBreakAction = "shift-insert-break";
    public static final String commentAction = "comment";
    public static final String uncommentAction = "uncomment";
    private static FindDialogSupport findDialogSupport;

    public Caret createCaret() {
        return new ExtCaret();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new ExtSyntaxSupport(baseDocument);
    }

    public Completion createCompletion(ExtEditorUI extEditorUI) {
        return null;
    }

    protected EditorUI createEditorUI() {
        return new ExtEditorUI();
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new BuildPopupMenuAction(), new ShowPopupMenuAction(), new BuildToolTipAction(), new FindAction(), new ReplaceAction(), new GotoAction(), new GotoDeclarationAction(), new ToggleCaseIdentifierBeginAction(), new MatchBraceAction(matchBraceAction, false), new MatchBraceAction(selectionMatchBraceAction, true), new EscapeAction(), new ExtDefaultKeyTypedAction(), new ExtInsertTabAction(), new ExtInsertBreakAction(), new ExtUpAction("caret-up", false), new ExtPageUpAction("page-up", false), new ExtDownAction("caret-down", false), new ExtPageDownAction("page-down", false), new ExtBeginLineAction("caret-begin-line", false), new ExtBeginLineAction("selection-begin-line", true), new ExtEndLineAction("caret-end-line", false), new ExtEndLineAction("selection-end-line", true), new CompletionShowAction(), new CompletionHideAction(), new ShiftInsertBreakAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public static class ShiftInsertBreakAction
    extends BaseAction {
        public ShiftInsertBreakAction() {
            super(ExtKit.shiftInsertBreakAction, 14);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Completion completion;
            if (jTextComponent != null && (completion = ExtUtilities.getCompletion(jTextComponent)) != null && completion.isPaneVisible() && !completion.substituteText(true)) {
                completion.refresh(false);
            }
        }
    }

    public static class CompletionHideAction
    extends BaseAction {
        static final long serialVersionUID = -9162014350666711948L;

        public CompletionHideAction() {
            super(ExtKit.completionHideAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Completion completion;
            if (jTextComponent != null && (completion = ExtUtilities.getCompletion(jTextComponent)) != null) {
                completion.setPaneVisible(false);
            }
        }
    }

    public static class CompletionShowAction
    extends BaseAction {
        static final long serialVersionUID = 1050644925893851146L;

        public CompletionShowAction() {
            super(ExtKit.completionShowAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            Completion completion;
            if (jTextComponent != null && (completion = ExtUtilities.getCompletion(jTextComponent)) != null) {
                completion.setPaneVisible(true);
            }
        }
    }

    public static class ExtEndLineAction
    extends BaseKit.EndLineAction {
        static final long serialVersionUID = -3703912765497771472L;

        public ExtEndLineAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion(jTextComponent);
                if (completion != null && completion.isPaneVisible()) {
                    if (this.select) {
                        completion.setPaneVisible(false);
                    } else {
                        completion.getView().end();
                        return;
                    }
                }
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }
    }

    public static class ExtBeginLineAction
    extends BaseKit.BeginLineAction {
        static final long serialVersionUID = 1226924439847693361L;

        public ExtBeginLineAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion(jTextComponent);
                if (completion != null && completion.isPaneVisible()) {
                    if (this.select) {
                        completion.setPaneVisible(false);
                    } else {
                        completion.getView().begin();
                        return;
                    }
                }
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }
    }

    public static class ExtPageDownAction
    extends BaseKit.PageDownAction {
        static final long serialVersionUID = -2373608546477823838L;

        ExtPageDownAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion(jTextComponent);
                if (completion != null && completion.isPaneVisible()) {
                    completion.getView().pageDown();
                } else {
                    super.actionPerformed(actionEvent, jTextComponent);
                }
            }
        }
    }

    public static class ExtPageUpAction
    extends BaseKit.PageUpAction {
        static final long serialVersionUID = 4336328849128594564L;

        ExtPageUpAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion(jTextComponent);
                if (completion != null && completion.isPaneVisible()) {
                    completion.getView().pageUp();
                } else {
                    super.actionPerformed(actionEvent, jTextComponent);
                }
            }
        }
    }

    public static class ExtDownAction
    extends BaseKit.DownAction {
        static final long serialVersionUID = 5728488498924841815L;

        ExtDownAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion(jTextComponent);
                if (completion != null && completion.isPaneVisible()) {
                    completion.getView().down();
                } else {
                    super.actionPerformed(actionEvent, jTextComponent);
                }
            }
        }
    }

    public static class ExtUpAction
    extends BaseKit.UpAction {
        static final long serialVersionUID = 9039435547323841544L;

        ExtUpAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion(jTextComponent);
                if (completion != null && completion.isPaneVisible()) {
                    completion.getView().up();
                } else {
                    super.actionPerformed(actionEvent, jTextComponent);
                }
            }
        }
    }

    public static class ExtInsertTabAction
    extends BaseKit.InsertTabAction {
        static final long serialVersionUID = 2711045528538714986L;

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion(jTextComponent);
                if (completion != null && completion.isPaneVisible()) {
                    completion.refresh(false);
                    completion.substituteCommonText();
                } else {
                    super.actionPerformed(actionEvent, jTextComponent);
                }
            }
        }
    }

    public static class ExtInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = 4004043376345356060L;

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Completion completion = ExtUtilities.getCompletion(jTextComponent);
                if (completion != null && completion.isPaneVisible()) {
                    if (completion.substituteText(false)) {
                        completion.setPaneVisible(false);
                    } else {
                        completion.refresh(false);
                    }
                } else {
                    super.actionPerformed(actionEvent, jTextComponent);
                }
            }
        }
    }

    public static class ExtDefaultKeyTypedAction
    extends BaseKit.DefaultKeyTypedAction {
        static final long serialVersionUID = 5273032708909044812L;

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            String string = actionEvent.getActionCommand();
            int n = actionEvent.getModifiers();
            if (string == null || !string.equals(" ") || n != 2) {
                Caret caret = jTextComponent.getCaret();
                if (caret instanceof ExtCaret) {
                    ((ExtCaret)caret).requestMatchBraceUpdateSync();
                }
                super.actionPerformed(actionEvent, jTextComponent);
            }
            if (jTextComponent != null && actionEvent != null && string != null && string.length() == 1 && (n & 8) == 0 && (n & 2) == 0) {
                this.checkIndentHotChars(jTextComponent, string);
                this.checkCompletion(jTextComponent, string);
            }
        }

        protected void checkIndentHotChars(JTextComponent jTextComponent, String string) {
            BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
            if (baseDocument != null) {
                ExtFormatter extFormatter;
                int[] nArray;
                Caret caret = jTextComponent.getCaret();
                int n = caret.getDot();
                Formatter formatter = baseDocument.getFormatter();
                if (formatter instanceof ExtFormatter && (nArray = (extFormatter = (ExtFormatter)formatter).getReformatBlock(jTextComponent, string)) != null) {
                    try {
                        nArray[0] = Utilities.getRowStart(baseDocument, nArray[0]);
                        nArray[1] = Utilities.getRowEnd(baseDocument, nArray[1]);
                        extFormatter.reformat(baseDocument, nArray[0], nArray[1]);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }

        protected void checkCompletion(JTextComponent jTextComponent, String string) {
            Completion completion = ExtUtilities.getCompletion(jTextComponent);
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
            if (completion != null && string.length() > 0) {
                if (!completion.isPaneVisible()) {
                    if (completion.isAutoPopupEnabled()) {
                        int n = extSyntaxSupport.checkCompletion(jTextComponent, string, false);
                        if (n == 0) {
                            completion.popup(true);
                        } else if (n == 1) {
                            completion.cancelRequest();
                        }
                    }
                } else {
                    int n = extSyntaxSupport.checkCompletion(jTextComponent, string, true);
                    switch (n) {
                        case 4: {
                            completion.setPaneVisible(false);
                            break;
                        }
                        case 2: {
                            completion.refresh(false);
                            break;
                        }
                        case 3: {
                            completion.refresh(true);
                        }
                    }
                }
            }
        }
    }

    public static class EscapeAction
    extends BaseAction {
        public EscapeAction() {
            super(ExtKit.escapeAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                ExtUtilities.getExtEditorUI(jTextComponent).hidePopupMenu();
                Completion completion = ExtUtilities.getExtEditorUI(jTextComponent).getCompletion();
                if (completion != null) {
                    completion.setPaneVisible(false);
                }
            }
        }
    }

    public static class UncommentAction
    extends BaseAction {
        static final long serialVersionUID = -7005758666529862034L;
        private String lineCommentString;

        public UncommentAction(String string) {
            super(ExtKit.uncommentAction);
            this.lineCommentString = string;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block11: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    try {
                        if (caret.isSelectionVisible()) {
                            int n = Utilities.getRowStart(baseDocument, jTextComponent.getSelectionStart());
                            int n2 = jTextComponent.getSelectionEnd();
                            baseDocument.atomicLock();
                            try {
                                if (n2 > 0 && Utilities.getRowStart(baseDocument, n2) == n2) {
                                    --n2;
                                }
                                int n3 = n;
                                int n4 = Utilities.getRowCount(baseDocument, n, n2);
                                while (n4 > 0) {
                                    if (Utilities.getRowEnd(baseDocument, n3) - n3 >= 2 && baseDocument.getText(n3, 2).equals(this.lineCommentString)) {
                                        baseDocument.remove(n3, 2);
                                    }
                                    n3 = Utilities.getRowStart(baseDocument, n3, 1);
                                    --n4;
                                }
                                Object var10_11 = null;
                                baseDocument.atomicUnlock();
                                break block11;
                            }
                            catch (Throwable throwable) {
                                Object var10_12 = null;
                                baseDocument.atomicUnlock();
                                throw throwable;
                            }
                        }
                        int n = Utilities.getRowStart(baseDocument, caret.getDot());
                        if (Utilities.getRowEnd(baseDocument, n) - n >= 2 && baseDocument.getText(n, 2).equals(this.lineCommentString)) {
                            baseDocument.remove(n, 2);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class CommentAction
    extends BaseAction {
        static final long serialVersionUID = -1422954906554289179L;
        private String lineCommentString;

        public CommentAction(String string) {
            super(ExtKit.commentAction);
            this.lineCommentString = string;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block9: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    try {
                        if (caret.isSelectionVisible()) {
                            int n = Utilities.getRowStart(baseDocument, jTextComponent.getSelectionStart());
                            int n2 = jTextComponent.getSelectionEnd();
                            baseDocument.atomicLock();
                            try {
                                if (n2 > 0 && Utilities.getRowStart(baseDocument, n2) == n2) {
                                    --n2;
                                }
                                int n3 = n;
                                int n4 = Utilities.getRowCount(baseDocument, n, n2);
                                while (n4 > 0) {
                                    baseDocument.insertString(n3, this.lineCommentString, null);
                                    n3 = Utilities.getRowStart(baseDocument, n3, 1);
                                    --n4;
                                }
                                Object var10_10 = null;
                                baseDocument.atomicUnlock();
                                break block9;
                            }
                            catch (Throwable throwable) {
                                Object var10_11 = null;
                                baseDocument.atomicUnlock();
                                throw throwable;
                            }
                        }
                        baseDocument.insertString(Utilities.getRowStart(baseDocument, jTextComponent.getSelectionStart()), this.lineCommentString, null);
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class PrefixMakerAction
    extends BaseAction {
        static final long serialVersionUID = -2305157963664484920L;
        private String prefix;
        private String[] prefixGroup;

        public PrefixMakerAction(String string, String string2, String[] stringArray) {
            super(string);
            this.prefix = string2;
            this.prefixGroup = stringArray;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int n = jTextComponent.getCaret().getDot();
                try {
                    int[] nArray = Utilities.getIdentifierBlock(baseDocument, n);
                    if (nArray == null) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    String string = baseDocument.getText(nArray[0], nArray[1] - nArray[0]);
                    if (string.startsWith(this.prefix) && Character.isUpperCase(string.charAt(this.prefix.length()))) {
                        return;
                    }
                    int n2 = 0;
                    while (n2 < this.prefixGroup.length) {
                        String string2 = this.prefixGroup[n2];
                        if (string.startsWith(string2) && string.length() > string2.length() && Character.isUpperCase(string.charAt(string2.length()))) {
                            baseDocument.remove(nArray[0], string2.length());
                            baseDocument.insertString(nArray[0], this.prefix, null);
                            return;
                        }
                        ++n2;
                    }
                    Utilities.changeCase(baseDocument, nArray[0], 1, 0);
                    baseDocument.insertString(nArray[0], this.prefix, null);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class CodeSelectAction
    extends BaseAction {
        static final long serialVersionUID = 4033474080778585860L;

        public CodeSelectAction() {
            super(ExtKit.codeSelectAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
        }
    }

    public static class MatchBraceAction
    extends BaseAction {
        boolean select;
        static final long serialVersionUID = -184887499045886231L;

        public MatchBraceAction(String string, boolean bl) {
            super(string, 14);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    int[] nArray;
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                    int n = caret.getDot();
                    ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
                    if (n > 0 && (nArray = extSyntaxSupport.findMatchingBlock(n - 1, false)) != null) {
                        if (this.select) {
                            caret.moveDot(nArray[1]);
                        } else {
                            caret.setDot(nArray[1]);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ToggleCaseIdentifierBeginAction
    extends BaseAction {
        static final long serialVersionUID = 584392193824931979L;

        ToggleCaseIdentifierBeginAction() {
            super(ExtKit.toggleCaseIdentifierBeginAction, 30);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int[] nArray = Utilities.getIdentifierBlock(baseDocument, caret.getDot());
                    if (nArray != null) {
                        Utilities.changeCase(baseDocument, nArray[0], 1, 2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class GotoDeclarationAction
    extends BaseAction {
        static final long serialVersionUID = -6440495023918097760L;

        public GotoDeclarationAction() {
            super(ExtKit.gotoDeclarationAction, 142);
        }

        public boolean gotoDeclaration(JTextComponent jTextComponent) {
            try {
                int n;
                Caret caret = jTextComponent.getCaret();
                int n2 = caret.getDot();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                int[] nArray = Utilities.getIdentifierBlock(baseDocument, n2);
                ExtSyntaxSupport extSyntaxSupport = (ExtSyntaxSupport)baseDocument.getSyntaxSupport();
                if (nArray != null && (n = extSyntaxSupport.findDeclarationPosition(baseDocument.getText(nArray), nArray[1])) >= 0) {
                    caret.setDot(n);
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return false;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                this.gotoDeclaration(jTextComponent);
            }
        }
    }

    public static class GotoAction
    extends BaseAction {
        static final long serialVersionUID = 8425585413146373256L;

        public GotoAction() {
            super(ExtKit.gotoAction, 14);
        }

        protected int getOffsetFromLine(BaseDocument baseDocument, int n) {
            return Utilities.getRowStartFromLineOffset(baseDocument, n);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                new GotoDialogSupport().showGotoDialog();
            }
        }
    }

    public static class ReplaceAction
    extends BaseAction {
        static final long serialVersionUID = 1828017436079834384L;

        public ReplaceAction() {
            super(ExtKit.replaceAction, 78);
        }

        public FindDialogSupport getSupport() {
            if (findDialogSupport == null) {
                ExtKit.findDialogSupport = new FindDialogSupport();
            }
            return findDialogSupport;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                this.getSupport().showReplaceDialog();
            }
        }
    }

    public static class FindAction
    extends BaseAction {
        static final long serialVersionUID = 719554648887497427L;

        public FindAction() {
            super(ExtKit.findAction, 78);
        }

        public FindDialogSupport getSupport() {
            if (findDialogSupport == null) {
                ExtKit.findDialogSupport = new FindDialogSupport();
            }
            return findDialogSupport;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                this.getSupport().showFindDialog();
            }
        }
    }

    public static class BuildToolTipAction
    extends BaseAction {
        static final long serialVersionUID = -2701131863705941250L;

        public BuildToolTipAction() {
            super(ExtKit.buildToolTipAction, 64);
        }

        protected String buildText(JTextComponent jTextComponent) {
            ToolTipSupport toolTipSupport = ExtUtilities.getExtEditorUI(jTextComponent).getToolTipSupport();
            return toolTipSupport != null ? ((JComponent)jTextComponent).getToolTipText(toolTipSupport.getLastMouseEvent()) : jTextComponent.getToolTipText();
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            ToolTipSupport toolTipSupport;
            if (jTextComponent != null && (toolTipSupport = ExtUtilities.getExtEditorUI(jTextComponent).getToolTipSupport()) != null) {
                toolTipSupport.setToolTipText(this.buildText(jTextComponent));
            }
        }
    }

    public static class ShowPopupMenuAction
    extends BaseAction {
        static final long serialVersionUID = 4257043398248915291L;

        public ShowPopupMenuAction() {
            super(ExtKit.showPopupMenuAction, 64);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    int n = jTextComponent.getCaret().getDot();
                    Rectangle rectangle = jTextComponent.getUI().modelToView(jTextComponent, n);
                    if (rectangle != null) {
                        ExtUtilities.getExtEditorUI(jTextComponent).showPopupMenu(rectangle.x, rectangle.y + rectangle.height);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BuildPopupMenuAction
    extends BaseAction {
        static final long serialVersionUID = 4257043398248915291L;

        public BuildPopupMenuAction() {
            super(ExtKit.buildPopupMenuAction, 64);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                JPopupMenu jPopupMenu = this.buildPopupMenu(jTextComponent);
                ExtUtilities.getExtEditorUI(jTextComponent).setPopupMenu(jPopupMenu);
            }
        }

        protected JPopupMenu buildPopupMenu(JTextComponent jTextComponent) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
            List list = (List)Settings.getValue(Utilities.getKitClass(jTextComponent), editorUI == null || editorUI.hasExtComponent() ? "popup-menu-action-name-list" : "dialog-popup-menu-action-name-list");
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.addAction(jTextComponent, jPopupMenu, string);
                }
            }
            return jPopupMenu;
        }

        protected void addAction(JTextComponent jTextComponent, JPopupMenu jPopupMenu, String string) {
            Action action = Utilities.getKit(jTextComponent).getActionByName(string);
            if (action != null) {
                String string2;
                JMenuItem jMenuItem = null;
                if (action instanceof BaseAction) {
                    jMenuItem = ((BaseAction)action).getPopupMenuItem(jTextComponent);
                }
                if (jMenuItem == null && (string2 = this.getItemText(jTextComponent, string, action)) != null) {
                    Object object;
                    jMenuItem = new JMenuItem(string2);
                    jMenuItem.addActionListener(action);
                    Keymap keymap = jTextComponent.getKeymap();
                    if (keymap != null && (object = keymap.getKeyStrokesForAction(action)) != null && ((KeyStroke[])object).length > 0) {
                        jMenuItem.setAccelerator(object[0]);
                    }
                    jMenuItem.setEnabled(action.isEnabled());
                    object = action.getValue("helpID");
                    if (object != null && object instanceof String) {
                        jMenuItem.putClientProperty("HelpID", object);
                    }
                }
                if (jMenuItem != null) {
                    jPopupMenu.add(jMenuItem);
                }
            } else {
                jPopupMenu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent jTextComponent, String string, Action action) {
            String string2 = action instanceof BaseAction ? ((BaseAction)action).getPopupMenuText(jTextComponent) : string;
            return string2;
        }
    }
}

