/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.WeakEventListenerList;

public class Registry {
    private static final WeakReference[] EMPTY = new WeakReference[0];
    private static WeakReference[] docRefs = EMPTY;
    private static int docRefsCount;
    private static final ArrayList docAct;
    private static WeakReference[] compRefs;
    private static int compRefsCount;
    private static final ArrayList compAct;
    private static final WeakEventListenerList listenerList;
    private static int consolidateCounter;
    static /* synthetic */ Class class$org$netbeans$editor$SettingsChangeListener;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$org$netbeans$editor$Registry;

    public static void addChangeListener(ChangeListener changeListener) {
        listenerList.add(class$org$netbeans$editor$SettingsChangeListener == null ? (class$org$netbeans$editor$SettingsChangeListener = Registry.class$("org.netbeans.editor.SettingsChangeListener")) : class$org$netbeans$editor$SettingsChangeListener, changeListener);
    }

    public static void removeChangeListener(SettingsChangeListener settingsChangeListener) {
        listenerList.remove(class$org$netbeans$editor$SettingsChangeListener == null ? (class$org$netbeans$editor$SettingsChangeListener = Registry.class$("org.netbeans.editor.SettingsChangeListener")) : class$org$netbeans$editor$SettingsChangeListener, settingsChangeListener);
    }

    public static synchronized int getID(BaseDocument baseDocument) {
        Integer n = Registry.getIDInteger(baseDocument);
        return n != null ? n : -1;
    }

    public static synchronized int getID(JTextComponent jTextComponent) {
        return Registry.getIDImpl(jTextComponent);
    }

    public static synchronized BaseDocument getDocument(int n) {
        if (n < 0 || n >= docRefsCount) {
            return null;
        }
        WeakReference weakReference = docRefs[n];
        return weakReference != null ? (BaseDocument)weakReference.get() : null;
    }

    public static synchronized JTextComponent getComponent(int n) {
        if (n < 0 || n >= compRefsCount) {
            return null;
        }
        WeakReference weakReference = compRefs[n];
        return weakReference != null ? (JTextComponent)weakReference.get() : null;
    }

    public static synchronized int addDocument(BaseDocument baseDocument) {
        Integer n = Registry.getIDInteger(baseDocument);
        if (n != null) {
            return n;
        }
        if (docRefsCount >= docRefs.length) {
            docRefs = Registry.realloc(docRefs);
        }
        Registry.docRefs[Registry.docRefsCount] = new WeakReference<BaseDocument>(baseDocument);
        baseDocument.putProperty("id", new Integer(docRefsCount));
        return docRefsCount++;
    }

    public static synchronized int addComponent(JTextComponent jTextComponent) {
        int n = Registry.getIDImpl(jTextComponent);
        if (n != -1) {
            return n;
        }
        if (compRefsCount >= compRefs.length) {
            compRefs = Registry.realloc(compRefs);
        }
        Registry.compRefs[Registry.compRefsCount] = new WeakReference<JTextComponent>(jTextComponent);
        ((BaseTextUI)jTextComponent.getUI()).componentID = compRefsCount;
        return compRefsCount++;
    }

    public static synchronized int removeComponent(JTextComponent jTextComponent) {
        int n = Registry.getIDImpl(jTextComponent);
        if (n != -1) {
            Registry.compRefs[n] = null;
            int n2 = compAct.size() - 1;
            while (n2 >= 0) {
                if ((Integer)compAct.get(n2) == n) {
                    compAct.remove(n2);
                    break;
                }
                --n2;
            }
        }
        return n;
    }

    public static synchronized void activate(JTextComponent jTextComponent) {
        Document document;
        boolean bl = false;
        int n = Registry.getIDImpl(jTextComponent);
        if (n == -1) {
            return;
        }
        int n2 = compAct.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (Integer)compAct.get(n3);
            if (n4 == n) {
                if (n3 == 0) break;
                compAct.add(0, compAct.remove(n3));
                bl = true;
                break;
            }
            ++n3;
        }
        if (n3 == n2) {
            compAct.add(0, new Integer(n));
            bl = true;
        }
        if ((document = jTextComponent.getDocument()) instanceof BaseDocument && Registry.doActivate((BaseDocument)document)) {
            bl = true;
        }
        if (bl) {
            Registry.fireChange();
        }
    }

    public static synchronized void activate(BaseDocument baseDocument) {
        if (Registry.doActivate(baseDocument)) {
            Registry.fireChange();
        }
    }

    public static synchronized BaseDocument getMostActiveDocument() {
        return Registry.getValidDoc(0, true);
    }

    public static synchronized BaseDocument getLeastActiveDocument() {
        int n = docAct.size() - 1;
        return Registry.getValidDoc(n, false);
    }

    public static BaseDocument getLessActiveDocument(BaseDocument baseDocument) {
        return Registry.getLessActiveDocument(Registry.getID(baseDocument));
    }

    public static synchronized BaseDocument getLessActiveDocument(int n) {
        return Registry.getNextActiveDoc(n, true);
    }

    public static BaseDocument getMoreActiveDocument(BaseDocument baseDocument) {
        return Registry.getMoreActiveDocument(Registry.getID(baseDocument));
    }

    public static synchronized BaseDocument getMoreActiveDocument(int n) {
        return Registry.getNextActiveDoc(n, false);
    }

    public static synchronized Iterator getDocumentIterator() {
        Registry.consolidate();
        ArrayList arrayList = new ArrayList();
        int n = docAct.size();
        int n2 = 0;
        while (n2 < n) {
            Object t;
            int n3 = (Integer)docAct.get(n2);
            WeakReference weakReference = docRefs[n3];
            if (weakReference != null && (t = weakReference.get()) != null) {
                arrayList.add(t);
            }
            ++n2;
        }
        return ((AbstractList)arrayList).iterator();
    }

    public static synchronized JTextComponent getMostActiveComponent() {
        return Registry.getValidComp(0, true);
    }

    public static synchronized JTextComponent getLeastActiveComponent() {
        int n = compAct.size() - 1;
        return Registry.getValidComp(n, false);
    }

    public static JTextComponent getLessActiveComponent(JTextComponent jTextComponent) {
        return Registry.getLessActiveComponent(Registry.getID(jTextComponent));
    }

    public static synchronized JTextComponent getLessActiveComponent(int n) {
        return Registry.getNextActiveComp(n, true);
    }

    public static JTextComponent getMoreActiveComponent(JTextComponent jTextComponent) {
        return Registry.getMoreActiveComponent(Registry.getID(jTextComponent));
    }

    public static synchronized JTextComponent getMoreActiveComponent(int n) {
        return Registry.getNextActiveComp(n, false);
    }

    public static synchronized Iterator getComponentIterator() {
        Registry.consolidate();
        ArrayList arrayList = new ArrayList();
        int n = compAct.size();
        int n2 = 0;
        while (n2 < n) {
            Object t;
            int n3 = (Integer)compAct.get(n2);
            WeakReference weakReference = compRefs[n3];
            if (weakReference != null && (t = weakReference.get()) != null) {
                arrayList.add(t);
            }
            ++n2;
        }
        return ((AbstractList)arrayList).iterator();
    }

    private static WeakReference[] realloc(WeakReference[] weakReferenceArray) {
        WeakReference[] weakReferenceArray2 = new WeakReference[weakReferenceArray.length * 2 + 4];
        System.arraycopy(weakReferenceArray, 0, weakReferenceArray2, 0, weakReferenceArray.length);
        return weakReferenceArray2;
    }

    private static void consolidate() {
        while (++consolidateCounter >= 20) {
            int n;
            consolidateCounter = 0;
            int n2 = docAct.size() - 1;
            while (n2 >= 0) {
                n = (Integer)docAct.get(n2);
                WeakReference weakReference = docRefs[n];
                if (weakReference != null && weakReference.get() == null) {
                    docAct.remove(n2);
                    Registry.docRefs[n] = null;
                }
                --n2;
            }
            n = compAct.size() - 1;
            while (n >= 0) {
                int n3 = (Integer)compAct.get(n);
                WeakReference weakReference = compRefs[n3];
                if (weakReference != null && weakReference.get() == null) {
                    compAct.remove(n);
                    Registry.compRefs[n3] = null;
                }
                --n;
            }
        }
    }

    private static int getIDImpl(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return -1;
        }
        return ((BaseTextUI)jTextComponent.getUI()).componentID;
    }

    private static Integer getIDInteger(BaseDocument baseDocument) {
        if (baseDocument == null) {
            return null;
        }
        return (Integer)baseDocument.getProperty("id");
    }

    private static boolean doActivate(BaseDocument baseDocument) {
        Integer n = Registry.getIDInteger(baseDocument);
        if (n == null) {
            return false;
        }
        int n2 = n != null ? n : -1;
        int n3 = docAct.size();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = (Integer)docAct.get(n4);
            if (n5 == n2) {
                if (n4 == 0) {
                    return false;
                }
                docAct.add(0, docAct.remove(n4));
                return true;
            }
            ++n4;
        }
        docAct.add(0, n);
        return true;
    }

    private static BaseDocument getValidDoc(int n, boolean bl) {
        Registry.consolidate();
        int n2 = docAct.size();
        while (n >= 0 && n < n2) {
            BaseDocument baseDocument;
            int n3 = (Integer)docAct.get(n);
            WeakReference weakReference = docRefs[n3];
            BaseDocument baseDocument2 = baseDocument = weakReference != null ? (BaseDocument)weakReference.get() : null;
            if (baseDocument != null) {
                return baseDocument;
            }
            n += bl ? 1 : -1;
        }
        return null;
    }

    private static BaseDocument getNextActiveDoc(int n, boolean bl) {
        Registry.consolidate();
        int n2 = docAct.size();
        int n3 = bl ? 0 : n2 - 1;
        while (n3 >= 0 && n3 < n2) {
            if ((Integer)docAct.get(n3) == n) {
                return Registry.getValidDoc(n3 += bl ? 1 : -1, bl);
            }
            n3 += bl ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getValidComp(int n, boolean bl) {
        Registry.consolidate();
        int n2 = compAct.size();
        while (n >= 0 && n < n2) {
            JTextComponent jTextComponent;
            int n3 = (Integer)compAct.get(n);
            WeakReference weakReference = compRefs[n3];
            JTextComponent jTextComponent2 = jTextComponent = weakReference != null ? (JTextComponent)weakReference.get() : null;
            if (jTextComponent != null) {
                return jTextComponent;
            }
            n += bl ? 1 : -1;
        }
        return null;
    }

    private static JTextComponent getNextActiveComp(int n, boolean bl) {
        int n2 = compAct.size();
        int n3 = bl ? 0 : n2 - 1;
        while (n3 >= 0 && n3 < n2) {
            if ((Integer)compAct.get(n3) == n) {
                return Registry.getValidComp(n3 += bl ? 1 : -1, bl);
            }
            n3 += bl ? 1 : -1;
        }
        return null;
    }

    private static void fireChange() {
        ChangeListener[] changeListenerArray = (ChangeListener[])listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = Registry.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
        ChangeEvent changeEvent = new ChangeEvent(class$org$netbeans$editor$Registry == null ? (class$org$netbeans$editor$Registry = Registry.class$("org.netbeans.editor.Registry")) : class$org$netbeans$editor$Registry);
        int n = 0;
        while (n < changeListenerArray.length) {
            changeListenerArray[n].stateChanged(changeEvent);
            ++n;
        }
    }

    public static synchronized String registryToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Document References:\n");
        int n = 0;
        while (n < docRefsCount) {
            WeakReference weakReference = docRefs[n];
            stringBuffer.append("docRefs[" + n + "]=" + (weakReference != null ? weakReference.get() : "null") + "\n");
            ++n;
        }
        stringBuffer.append("Component References:\n");
        int n2 = 0;
        while (n2 < compRefsCount) {
            WeakReference weakReference = compRefs[n2];
            stringBuffer.append("compRefs[" + n2 + "]=" + (weakReference != null ? weakReference.get() : "null") + "\n");
            ++n2;
        }
        stringBuffer.append("\nActive Document Indexes:\n");
        int n3 = 0;
        while (n3 < docAct.size()) {
            stringBuffer.append(docAct.get(n3));
            if (n3 != docAct.size() - 1) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        stringBuffer.append("\nActive Component Indexes:\n");
        int n4 = 0;
        while (n4 < compAct.size()) {
            stringBuffer.append(compAct.get(n4));
            if (n4 != compAct.size() - 1) {
                stringBuffer.append(", ");
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        docAct = new ArrayList();
        compRefs = EMPTY;
        compAct = new ArrayList();
        listenerList = new WeakEventListenerList();
    }
}

