/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.JComponent;
import org.netbeans.editor.DrawContext;

public final class Coloring
implements Serializable {
    public static final int FONT_MODE_APPLY_NAME = 1;
    public static final int FONT_MODE_APPLY_STYLE = 2;
    public static final int FONT_MODE_APPLY_SIZE = 4;
    public static final int FONT_MODE_DEFAULT = 7;
    private Font font;
    private int fontMode;
    private Color foreColor;
    private Color backColor;
    private Color underlineColor;
    private Color strikeThroughColor;
    private transient HashMap fontAndForeColorCache;
    private transient HashMap backColorCache;
    static final long serialVersionUID = -1382649127124476675L;

    public Coloring() {
        this(null, null, null);
    }

    public Coloring(Font font, Color color, Color color2) {
        this(font, 7, color, color2, null, null);
    }

    public Coloring(Font font, int n, Color color, Color color2) {
        this(font, n, color, color2, null, null);
    }

    public Coloring(Font font, int n, Color color, Color color2, Color color3, Color color4) {
        font = n != 0 ? font : null;
        n = font != null ? n : 7;
        this.font = font;
        this.fontMode = n;
        this.foreColor = color;
        this.backColor = color2;
        this.underlineColor = color3;
        this.strikeThroughColor = color4;
        this.checkCaches();
    }

    private void checkCaches() {
        boolean bl;
        boolean bl2 = this.font != null && this.fontMode != 0 && this.fontMode != 7;
        boolean bl3 = bl = this.foreColor != null && this.hasAlpha(this.foreColor);
        if (bl2 || bl) {
            this.fontAndForeColorCache = new HashMap(bl2 && bl ? 47 : 23);
        }
        if (this.backColor != null && this.hasAlpha(this.backColor)) {
            this.backColorCache = new HashMap(23);
        }
    }

    private boolean hasAlpha(Color color) {
        return (color.getRGB() & 0xFF000000) != -16777216;
    }

    public Font getFont() {
        return this.font;
    }

    public int getFontMode() {
        return this.fontMode;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public Color getUnderlineColor() {
        return this.underlineColor;
    }

    public Color getStrikeThroughColor() {
        return this.strikeThroughColor;
    }

    private Font modifyFont(Font font) {
        return new Font((this.fontMode & 1) != 0 ? this.font.getName() : font.getName(), (this.fontMode & 2) != 0 ? this.font.getStyle() : font.getStyle(), (this.fontMode & 4) != 0 ? this.font.getSize() : font.getSize());
    }

    private Color modifyForeColor(Color color) {
        int n = this.foreColor.getAlpha();
        int n2 = this.foreColor.getRGB();
        int n3 = color.getRGB();
        int n4 = ((this.foreColor.getRed() * n + color.getRed() * (255 - n)) / 255 & 0xFF) << 16;
        return new Color(n4 += (((n2 & 0xFF00) * n + (n3 & 0xFF00) * (255 - n)) / 255 & 0xFF00) + (((n2 & 0xFF) * n + (n3 & 0xFF) * (255 - n)) / 255 & 0xFF), false);
    }

    private Color modifyBackColor(Color color) {
        int n = this.backColor.getAlpha();
        int n2 = this.backColor.getRGB();
        int n3 = color.getRGB();
        int n4 = ((this.backColor.getRed() * n + color.getRed() * (255 - n)) / 255 & 0xFF) << 16;
        return new Color(n4 += (((n2 & 0xFF00) * n + (n3 & 0xFF00) * (255 - n)) / 255 & 0xFF00) + (((n2 & 0xFF) * n + (n3 & 0xFF) * (255 - n)) / 255 & 0xFF), false);
    }

    public void apply(DrawContext drawContext) {
        Serializable serializable;
        HashMap hashMap;
        Serializable serializable2;
        if (this.font != null) {
            if (this.fontMode == 7) {
                drawContext.setFont(this.font);
            } else {
                serializable2 = drawContext.getFont();
                if (serializable2 != null) {
                    hashMap = this.fontAndForeColorCache;
                    synchronized (hashMap) {
                        serializable = (Font)this.fontAndForeColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyFont((Font)serializable2);
                            this.fontAndForeColorCache.put(serializable2, serializable);
                        }
                        drawContext.setFont((Font)serializable);
                    }
                }
            }
        }
        if (this.foreColor != null) {
            if (!this.hasAlpha(this.foreColor)) {
                drawContext.setForeColor(this.foreColor);
            } else {
                serializable2 = drawContext.getForeColor();
                if (serializable2 != null) {
                    hashMap = this.fontAndForeColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.fontAndForeColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyForeColor((Color)serializable2);
                            this.fontAndForeColorCache.put(serializable2, serializable);
                        }
                        drawContext.setForeColor((Color)serializable);
                    }
                }
            }
        }
        if (this.backColor != null) {
            if (!this.hasAlpha(this.backColor)) {
                drawContext.setBackColor(this.backColor);
            } else {
                serializable2 = drawContext.getBackColor();
                if (serializable2 != null) {
                    hashMap = this.backColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.backColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyBackColor((Color)serializable2);
                            this.backColorCache.put(serializable2, serializable);
                        }
                        drawContext.setBackColor((Color)serializable);
                    }
                }
            }
        }
        if (this.underlineColor != null) {
            drawContext.setUnderlineColor(this.underlineColor);
        }
        if (this.strikeThroughColor != null) {
            drawContext.setStrikeThroughColor(this.strikeThroughColor);
        }
    }

    public void apply(JComponent jComponent) {
        Serializable serializable;
        HashMap hashMap;
        Serializable serializable2;
        if (this.font != null) {
            if (this.fontMode == 7) {
                jComponent.setFont(this.font);
            } else {
                serializable2 = jComponent.getFont();
                if (serializable2 != null) {
                    hashMap = this.fontAndForeColorCache;
                    synchronized (hashMap) {
                        serializable = (Font)this.fontAndForeColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyFont((Font)serializable2);
                            this.fontAndForeColorCache.put(serializable2, serializable);
                        }
                        jComponent.setFont((Font)serializable);
                    }
                }
            }
        }
        if (this.foreColor != null) {
            if (!this.hasAlpha(this.foreColor)) {
                jComponent.setForeground(this.foreColor);
            } else {
                serializable2 = jComponent.getForeground();
                if (serializable2 != null) {
                    hashMap = this.fontAndForeColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.fontAndForeColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyForeColor((Color)serializable2);
                            this.fontAndForeColorCache.put(serializable2, serializable);
                        }
                        jComponent.setForeground((Color)serializable);
                    }
                }
            }
        }
        if (this.backColor != null) {
            if (!this.hasAlpha(this.backColor)) {
                jComponent.setBackground(this.backColor);
            } else {
                serializable2 = jComponent.getBackground();
                if (serializable2 != null) {
                    hashMap = this.backColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.backColorCache.get(serializable2);
                        if (serializable == null) {
                            serializable = this.modifyBackColor((Color)serializable2);
                            this.backColorCache.put(serializable2, serializable);
                        }
                        jComponent.setBackground((Color)serializable);
                    }
                }
            }
        }
    }

    public Coloring apply(Coloring coloring) {
        Serializable serializable;
        HashMap hashMap;
        if (coloring == null) {
            return this;
        }
        Font font = coloring.font;
        Serializable serializable2 = coloring.foreColor;
        Serializable serializable3 = coloring.backColor;
        Color color = coloring.underlineColor;
        Color color2 = coloring.strikeThroughColor;
        if (this.font != null) {
            if (this.fontMode == 7) {
                font = this.font;
            } else if (font != null) {
                hashMap = this.fontAndForeColorCache;
                synchronized (hashMap) {
                    serializable = (Font)this.fontAndForeColorCache.get(font);
                    if (serializable == null) {
                        serializable = this.modifyFont(font);
                        this.fontAndForeColorCache.put(font, serializable);
                    }
                    font = serializable;
                }
            }
        }
        if (this.foreColor != null) {
            if (!this.hasAlpha(this.foreColor)) {
                serializable2 = this.foreColor;
            } else if (serializable2 != null) {
                hashMap = this.fontAndForeColorCache;
                synchronized (hashMap) {
                    serializable = (Color)this.fontAndForeColorCache.get(serializable2);
                    if (serializable == null) {
                        serializable = this.modifyForeColor((Color)serializable2);
                        this.fontAndForeColorCache.put(serializable2, serializable);
                    }
                    serializable2 = serializable;
                }
            }
        }
        if (this.backColor != null) {
            if (!this.hasAlpha(this.backColor)) {
                serializable3 = this.backColor;
            } else {
                serializable3 = this.backColor;
                if (serializable3 != null) {
                    hashMap = this.backColorCache;
                    synchronized (hashMap) {
                        serializable = (Color)this.backColorCache.get(serializable3);
                        if (serializable == null) {
                            serializable = this.modifyBackColor((Color)serializable3);
                            this.backColorCache.put(serializable3, serializable);
                        }
                        serializable3 = serializable;
                    }
                }
            }
        }
        if (this.underlineColor != null) {
            color = this.underlineColor;
        }
        if (this.strikeThroughColor != null) {
            color2 = this.strikeThroughColor;
        }
        if (coloring.fontMode != 7 || font != coloring.font || serializable2 != coloring.foreColor || serializable3 != coloring.backColor || color != coloring.underlineColor || color2 != coloring.strikeThroughColor) {
            return new Coloring(font, 7, (Color)serializable2, (Color)serializable3, color, color2);
        }
        return coloring;
    }

    public boolean equals(Object object) {
        if (object instanceof Coloring) {
            Coloring coloring = (Coloring)object;
            return (this.font == null && coloring.font == null || this.font != null && this.font.equals(coloring.font)) && this.fontMode == coloring.fontMode && (this.foreColor == null && coloring.foreColor == null || this.foreColor != null && this.foreColor.equals(coloring.foreColor)) && (this.backColor == null && coloring.backColor == null || this.backColor != null && this.backColor.equals(coloring.backColor)) && (this.underlineColor == null && coloring.underlineColor == null || this.underlineColor != null && this.underlineColor.equals(coloring.underlineColor)) && (this.strikeThroughColor == null && coloring.strikeThroughColor == null || this.strikeThroughColor != null && this.strikeThroughColor.equals(coloring.strikeThroughColor));
        }
        return false;
    }

    public int hashCode() {
        return this.font.hashCode() ^ this.foreColor.hashCode() ^ this.backColor.hashCode();
    }

    public static Coloring changeFont(Coloring coloring, Font font) {
        return Coloring.changeFont(coloring, font, coloring.getFontMode());
    }

    public static Coloring changeFont(Coloring coloring, Font font, int n) {
        if (font == null && coloring.font == null || font != null && font.equals(coloring.font) && coloring.fontMode == n) {
            return coloring;
        }
        return new Coloring(font, coloring.foreColor, coloring.backColor);
    }

    public static Coloring changeForeColor(Coloring coloring, Color color) {
        if (color == null && coloring.foreColor == null || color != null && color.equals(coloring.foreColor)) {
            return coloring;
        }
        return new Coloring(coloring.font, color, coloring.backColor);
    }

    public static Coloring changeBackColor(Coloring coloring, Color color) {
        if (color == null && coloring.backColor == null || color != null && color.equals(coloring.backColor)) {
            return coloring;
        }
        return new Coloring(coloring.font, coloring.foreColor, color);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.fontMode == 0) {
            this.fontMode = 7;
        }
        this.checkCaches();
    }

    public String toString() {
        return "font=" + this.font + ", fontMode=" + this.fontMode + ", foreColor=" + this.foreColor + ", backColor=" + this.backColor + ", underlineColor=" + this.underlineColor + ", strikeThroughColor=" + this.strikeThroughColor;
    }
}

