/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.IconBases;
import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.src.ClassElement;
import org.openide.src.Identifier;
import org.openide.src.MethodElement;
import org.openide.src.MethodParameter;
import org.openide.src.Type;

public abstract class BiFeature
implements IconBases,
Node.Cookie {
    private static final String TEXT_EXPERT = "setExpert";
    private static final String TEXT_HIDDEN = "setHidden";
    private static final String TEXT_PREFERRED = "setPreferred";
    private static final String TEXT_DISPLAY_NAME = "setDisplayName";
    private static final String TEXT_SHORT_DESCRIPTION = "setShortDescription";
    private String displayName = null;
    private boolean expert = false;
    private boolean hidden = false;
    private String name = null;
    private boolean preferred = false;
    private String shortDescription = null;
    private boolean included = true;
    private String brackets = "]";

    public BiFeature(Pattern pattern) {
        this.name = pattern.getName();
    }

    public BiFeature(MethodElement methodElement) {
        this.displayName = "\"\"";
        this.name = methodElement.getName().getName();
    }

    public BiFeature(ClassElement classElement) {
        this.name = "beanDescriptor";
    }

    abstract String getCreationString();

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public boolean isExpert() {
        return this.expert;
    }

    public void setExpert(boolean bl) {
        this.expert = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean bl) {
        this.preferred = bl;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    String getBrackets() {
        return this.brackets;
    }

    void setBrackets(String string) {
        this.brackets = string;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public void setIncluded(boolean bl) {
        this.included = bl;
    }

    public String getToolTip() {
        return this.getName();
    }

    Collection getCustomizationStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.expert) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_EXPERT).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.hidden) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_HIDDEN).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.preferred) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_PREFERRED).append(" ( true )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.displayName != null && this.displayName.trim().length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_DISPLAY_NAME).append(" ( ");
            stringBuffer.append(this.displayName).append(" )");
            arrayList.add(stringBuffer.toString());
        }
        if (this.shortDescription != null && this.shortDescription.trim().length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append(TEXT_SHORT_DESCRIPTION).append(" ( ");
            stringBuffer.append(this.shortDescription).append(" )");
            arrayList.add(stringBuffer.toString());
        }
        return arrayList;
    }

    void analyzeCustomization(Collection collection) {
        this.setIncluded(false);
        Iterator iterator = collection.iterator();
        String string = new String(this.getName() + this.getBrackets() + "=new");
        String string2 = new String(this.getName() + this.getBrackets() + "." + TEXT_EXPERT);
        String string3 = new String(this.getName() + this.getBrackets() + "." + TEXT_HIDDEN);
        String string4 = new String(this.getName() + this.getBrackets() + "." + TEXT_PREFERRED);
        String string5 = new String(this.getName() + this.getBrackets() + "." + TEXT_DISPLAY_NAME);
        String string6 = new String(this.getName() + this.getBrackets() + "." + TEXT_SHORT_DESCRIPTION);
        while (iterator.hasNext()) {
            String string7;
            String string8 = (String)iterator.next();
            if (string8.indexOf(string) != -1) {
                this.setIncluded(true);
                this.analyzeCreationString(string8);
                continue;
            }
            if (string8.indexOf(string2) != -1) {
                this.setExpert(true);
                continue;
            }
            if (string8.indexOf(string3) != -1) {
                this.setHidden(true);
                continue;
            }
            if (string8.indexOf(string4) != -1) {
                this.setPreferred(true);
                continue;
            }
            if (string8.indexOf(string5) != -1) {
                string7 = BiAnalyser.getArgumentParameter(string8);
                if (string7 == null) continue;
                this.setDisplayName(string7);
                continue;
            }
            if (string8.indexOf(string6) != -1) {
                string7 = BiAnalyser.getArgumentParameter(string8);
                if (string7 == null) continue;
                this.setShortDescription(string7);
                continue;
            }
            this.analyzeCustomizationString(string8);
        }
    }

    abstract String getIconBase(boolean var1);

    abstract void analyzeCreationString(String var1);

    abstract void analyzeCustomizationString(String var1);

    public static class Method
    extends BiFeature {
        MethodElement element;
        private String varName;
        private MethodElement me;

        Method(MethodElement methodElement) {
            super(methodElement);
            this.element = methodElement;
            this.me = methodElement;
        }

        private static String getSignature(ClassElement classElement) {
            Identifier identifier = classElement.getName();
            if (!classElement.isInner()) {
                return identifier.getFullName();
            }
            StringBuffer stringBuffer = new StringBuffer(identifier.getFullName());
            ClassElement classElement2 = classElement;
            int n = stringBuffer.length();
            while (true) {
                stringBuffer.setCharAt(n -= identifier.getSourceName().length() + 1, '$');
                classElement2 = classElement2.getDeclaringClass();
                if (!classElement2.isInner()) break;
                identifier = classElement2.getName();
            }
            return stringBuffer.toString();
        }

        private static String getVMClassName(Type type) {
            try {
                if (!type.isArray()) {
                    String string = type.getClassName().getFullName();
                    ClassElement classElement = ClassElement.forName((String)string);
                    if (classElement == null) {
                        return string;
                    }
                    return Method.getSignature(classElement);
                }
                int n = 0;
                Type type2 = type;
                do {
                    ++n;
                } while ((type2 = type2.getElementType()).isArray());
                StringBuffer stringBuffer = new StringBuffer(n + 1);
                int n2 = 0;
                while (n2 < n) {
                    stringBuffer.append('[');
                    ++n2;
                }
                if (type2.isPrimitive()) {
                    stringBuffer.append(Method.getPrimitiveCode(type2));
                } else {
                    stringBuffer.append('L');
                    stringBuffer.append(Method.getVMClassName(type2));
                    stringBuffer.append(';');
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                TopManager.getDefault().notifyException((Throwable)exception);
                return "";
            }
        }

        private static String getPrimitiveCode(Type type) {
            if (type.equals((Object)Type.INT)) {
                return "I";
            }
            if (type.equals((Object)Type.BOOLEAN)) {
                return "Z";
            }
            if (type.equals((Object)Type.CHAR)) {
                return "C";
            }
            if (type.equals((Object)Type.LONG)) {
                return "J";
            }
            if (type.equals((Object)Type.SHORT)) {
                return "S";
            }
            if (type.equals((Object)Type.BYTE)) {
                return "B";
            }
            if (type.equals((Object)Type.FLOAT)) {
                return "F";
            }
            if (type.equals((Object)Type.DOUBLE)) {
                return "D";
            }
            return "V";
        }

        private static String getTypeClass(Type type) {
            if (type.isPrimitive()) {
                if (type.equals((Object)Type.INT)) {
                    return "Integer.TYPE";
                }
                if (type.equals((Object)Type.BOOLEAN)) {
                    return "Boolean.TYPE";
                }
                if (type.equals((Object)Type.CHAR)) {
                    return "Character.TYPE";
                }
                if (type.equals((Object)Type.LONG)) {
                    return "Long.TYPE";
                }
                if (type.equals((Object)Type.SHORT)) {
                    return "Short.TYPE";
                }
                if (type.equals((Object)Type.BYTE)) {
                    return "Byte.TYPE";
                }
                if (type.equals((Object)Type.FLOAT)) {
                    return "Float.TYPE";
                }
                return "Double.TYPE";
            }
            if (type.isClass()) {
                try {
                    return type.getClassName().getFullName() + ".class";
                }
                catch (Exception exception) {
                    TopManager.getDefault().notifyException((Throwable)exception);
                    return type.toString() + ".class";
                }
            }
            return "Class.forName(\"" + Method.getVMClassName(type) + "\")";
        }

        public String getToolTip() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(this.element.getName().getFullName() + "(");
            MethodParameter[] methodParameterArray = this.element.getParameters();
            int n = 0;
            while (n < methodParameterArray.length) {
                stringBuffer.append(methodParameterArray[n].getType().getFullString());
                if (n < methodParameterArray.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        MethodElement getElement() {
            return this.element;
        }

        String getCreationString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("new MethodDescriptor ( ");
            stringBuffer.append(this.element.getDeclaringClass().getName().getFullName() + ".class.getMethod(\"" + this.element.getName().getFullName() + "\", ");
            stringBuffer.append("new Class[] {");
            MethodParameter[] methodParameterArray = this.element.getParameters();
            int n = 0;
            while (n < methodParameterArray.length) {
                try {
                    stringBuffer.append(Method.getTypeClass(methodParameterArray[n].getType()));
                }
                catch (Exception exception) {
                    TopManager.getDefault().notifyException((Throwable)exception);
                }
                if (n < methodParameterArray.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
            stringBuffer.append("}))");
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            if (bl) {
                return "/org/netbeans/modules/beans/resources/bifMethod_S";
            }
            return "/org/netbeans/modules/beans/resources/bifMethod_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCustomizationString(String string) {
        }

        void analyzeCreationString(String string) {
        }

        void analyzeCustomization(Collection collection) {
            String string;
            if (this.me != null) {
                string = (String)BiAnalyser.normalizeText(this.getCreationString()).toArray()[0];
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    int n = string2.indexOf(string);
                    if (n <= -1) continue;
                    this.varName = string2.substring(string2.indexOf("methods[METHOD_") + 15, n - 2);
                    break;
                }
                this.me = null;
            }
            string = this.getName();
            this.setName(this.varName);
            super.analyzeCustomization(collection);
            this.setName(string);
        }
    }

    public static class EventSet
    extends BiFeature {
        EventSetPattern pattern;
        private static final String TEXT_UNICAST = "setUnicast";
        private static final String TEXT_IN_DEFAULT = "setInDefaultEventSet";
        private boolean isInDefaultEventSet = true;

        EventSet(EventSetPattern eventSetPattern) {
            super(eventSetPattern);
            this.pattern = eventSetPattern;
        }

        public boolean isUnicast() {
            return this.pattern.isUnicast();
        }

        public boolean isInDefaultEventSet() {
            return this.isInDefaultEventSet;
        }

        public void setInDefaultEventSet(boolean bl) {
            this.isInDefaultEventSet = bl;
        }

        String getCreationString() {
            MethodElement[] methodElementArray;
            StringBuffer stringBuffer = new StringBuffer(100);
            try {
                Type type = this.pattern.getType();
                ClassElement classElement = ClassElement.forName((String)type.getClassName().getFullName());
                methodElementArray = classElement.getMethods();
            }
            catch (IllegalStateException illegalStateException) {
                TopManager.getDefault().notifyException((Throwable)illegalStateException);
                methodElementArray = new MethodElement[]{};
            }
            stringBuffer.append("new EventSetDescriptor ( ");
            stringBuffer.append(this.pattern.getDeclaringClass().getName().getFullName() + ".class, ");
            stringBuffer.append("\"" + this.getName() + "\", ");
            try {
                stringBuffer.append(this.pattern.getType().getClassName().getFullName() + ".class, ");
            }
            catch (IllegalStateException illegalStateException) {
                TopManager.getDefault().notifyException((Throwable)illegalStateException);
                methodElementArray = new MethodElement[]{};
            }
            stringBuffer.append("new String[] {");
            int n = 0;
            while (n < methodElementArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("\"" + methodElementArray[n].getName() + "\"");
                ++n;
            }
            stringBuffer.append("}, ");
            stringBuffer.append("\"" + this.pattern.getAddListenerMethod().getName().getName() + "\", ");
            stringBuffer.append("\"" + this.pattern.getRemoveListenerMethod().getName().getName() + "\" )");
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            if (bl) {
                if (this.isUnicast()) {
                    return "/org/netbeans/modules/beans/resources/bifEventSetUC_S";
                }
                return "/org/netbeans/modules/beans/resources/bifEventSetMC_S";
            }
            if (this.isUnicast()) {
                return "/org/netbeans/modules/beans/resources/bifEventSetUC_" + (this.isIncluded() ? "S" : "N");
            }
            return "/org/netbeans/modules/beans/resources/bifEventSetMC_" + (this.isIncluded() ? "S" : "N");
        }

        Collection getCustomizationStrings() {
            Collection collection = super.getCustomizationStrings();
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.isUnicast()) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_UNICAST).append(" ( true )");
                collection.add(stringBuffer.toString());
            }
            if (!this.isInDefaultEventSet) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_IN_DEFAULT).append(" ( false )");
                collection.add(stringBuffer.toString());
            }
            return collection;
        }

        void analyzeCustomizationString(String string) {
            String string2 = new String(this.getName() + "]." + TEXT_UNICAST);
            String string3 = new String(this.getName() + "]." + TEXT_IN_DEFAULT);
            if (string.indexOf(string3) != -1) {
                this.setInDefaultEventSet(false);
                return;
            }
        }

        void analyzeCreationString(String string) {
        }
    }

    public static class IdxProperty
    extends Property {
        private boolean niGetter;
        private boolean niSetter;
        IdxPropertyPattern pattern;

        IdxProperty(IdxPropertyPattern idxPropertyPattern) {
            super(idxPropertyPattern);
            this.pattern = idxPropertyPattern;
            this.niGetter = this.hasNiGetter();
            this.niSetter = this.hasNiSetter();
        }

        boolean isNiGetter() {
            return this.niGetter;
        }

        void setNiGetter(boolean bl) {
            this.niGetter = this.hasNiGetter() ? bl : false;
        }

        boolean isNiSetter() {
            return this.niSetter;
        }

        void setNiSetter(boolean bl) {
            this.niGetter = this.hasNiSetter() ? bl : false;
        }

        boolean hasNiGetter() {
            return this.pattern.getGetterMethod() != null;
        }

        boolean hasNiSetter() {
            return this.pattern.getGetterMethod() != null;
        }

        String getCreationString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("new IndexedPropertyDescriptor ( ");
            stringBuffer.append("\"" + this.getName() + "\", ");
            stringBuffer.append(this.pattern.getDeclaringClass().getName().getName() + ".class, ");
            if (this.pattern.getGetterMethod() != null && this.niGetter) {
                stringBuffer.append("\"" + this.pattern.getGetterMethod().getName().getName() + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.pattern.getSetterMethod() != null && this.niSetter) {
                stringBuffer.append("\"" + this.pattern.getSetterMethod().getName().getName() + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.pattern.getIndexedGetterMethod() != null && this.getMode() != 4) {
                stringBuffer.append("\"" + this.pattern.getIndexedGetterMethod().getName().getName() + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.pattern.getIndexedSetterMethod() != null && this.getMode() != 2) {
                stringBuffer.append("\"" + this.pattern.getIndexedSetterMethod().getName().getName() + "\" )");
            } else {
                stringBuffer.append("null )");
            }
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            if (bl) {
                return "/org/netbeans/modules/beans/resources/bifIndexedPropertyRW_S";
            }
            if (this.getMode() == 2) {
                return "/org/netbeans/modules/beans/resources/bifIndexedPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.getMode() == 4) {
                return "/org/netbeans/modules/beans/resources/bifIndexedPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "/org/netbeans/modules/beans/resources/bifIndexedPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        void analyzeCreationString(String string) {
            String[] stringArray = BiAnalyser.getParameters(string);
            if (stringArray.length == 6 && this.getMode() == 1) {
                if (stringArray[4].equals("null")) {
                    this.setMode(4);
                } else if (stringArray[5].equals("null")) {
                    this.setMode(2);
                }
                if (this.hasNiGetter() && stringArray[2].equals(null)) {
                    this.niGetter = false;
                }
                if (this.hasNiGetter() && stringArray[3].equals(null)) {
                    this.niSetter = false;
                }
            }
        }
    }

    public static class Property
    extends BiFeature {
        private PropertyPattern pattern;
        private static final String TEXT_BOUND = "setBound";
        private static final String TEXT_CONSTRAINED = "setConstrained";
        private static final String TEXT_PROPERTY_EDITOR = "setPropertyEditorClass";
        private boolean bound;
        private boolean constrained;
        private int mode;
        private String propertyEditorClass;

        Property(PropertyPattern propertyPattern) {
            super(propertyPattern);
            this.mode = propertyPattern.getMode();
            this.pattern = propertyPattern;
        }

        public boolean isBound() {
            return this.bound;
        }

        public void setBound(boolean bl) {
            this.bound = bl;
        }

        public boolean isConstrained() {
            return this.constrained;
        }

        public void setConstrained(boolean bl) {
            this.constrained = bl;
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int n) {
            this.mode = n;
        }

        public boolean modeChangeable() {
            return this.pattern.getMode() == 1;
        }

        public String getPropertyEditorClass() {
            return this.propertyEditorClass;
        }

        public void setPropertyEditorClass(String string) {
            this.propertyEditorClass = string;
        }

        String getCreationString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("new PropertyDescriptor ( ");
            stringBuffer.append("\"" + this.getName() + "\", ");
            stringBuffer.append(this.pattern.getDeclaringClass().getName().getName() + ".class, ");
            if (this.pattern.getGetterMethod() != null && this.getMode() != 4) {
                stringBuffer.append("\"" + this.pattern.getGetterMethod().getName().getName() + "\", ");
            } else {
                stringBuffer.append("null, ");
            }
            if (this.pattern.getSetterMethod() != null && this.getMode() != 2) {
                stringBuffer.append("\"" + this.pattern.getSetterMethod().getName().getName() + "\" )");
            } else {
                stringBuffer.append("null )");
            }
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            if (bl) {
                return "/org/netbeans/modules/beans/resources/bifPropertyRW_S";
            }
            if (this.mode == 2) {
                return "/org/netbeans/modules/beans/resources/bifPropertyRO_" + (this.isIncluded() ? "S" : "N");
            }
            if (this.mode == 4) {
                return "/org/netbeans/modules/beans/resources/bifPropertyWO_" + (this.isIncluded() ? "S" : "N");
            }
            return "/org/netbeans/modules/beans/resources/bifPropertyRW_" + (this.isIncluded() ? "S" : "N");
        }

        Collection getCustomizationStrings() {
            Collection collection = super.getCustomizationStrings();
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.bound) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_BOUND).append(" ( true )");
                collection.add(stringBuffer.toString());
            }
            if (this.constrained) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_CONSTRAINED).append(" ( true )");
                collection.add(stringBuffer.toString());
            }
            if (this.propertyEditorClass != null && this.propertyEditorClass.trim().length() > 0) {
                stringBuffer.setLength(0);
                stringBuffer.append(TEXT_PROPERTY_EDITOR).append(" ( ");
                stringBuffer.append(this.propertyEditorClass).append(" )");
                collection.add(stringBuffer.toString());
            }
            return collection;
        }

        void analyzeCustomizationString(String string) {
            String string2 = new String(this.getName() + "]." + TEXT_BOUND);
            String string3 = new String(this.getName() + "]." + TEXT_CONSTRAINED);
            String string4 = new String(this.getName() + "]." + TEXT_PROPERTY_EDITOR);
            if (string.indexOf(string2) != -1) {
                this.setBound(true);
                return;
            }
            if (string.indexOf(string3) != -1) {
                this.setConstrained(true);
                return;
            }
            if (string.indexOf(string4) != -1) {
                String[] stringArray = BiAnalyser.getParameters(string);
                if (stringArray.length > 0) {
                    this.setPropertyEditorClass(stringArray[0]);
                }
                return;
            }
        }

        void analyzeCreationString(String string) {
            String[] stringArray = BiAnalyser.getParameters(string);
            if (stringArray.length == 4 && this.mode == 1) {
                if (stringArray[2].equals("null")) {
                    this.mode = 4;
                } else if (stringArray[3].equals("null")) {
                    this.mode = 2;
                }
            }
        }
    }

    public static class Descriptor
    extends BiFeature {
        ClassElement element;
        private String varName;
        private ClassElement ce;
        String customizer;

        Descriptor(ClassElement classElement) {
            super(classElement);
            this.element = classElement;
            this.ce = classElement;
        }

        String getCreationString() {
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("new BeanDescriptor  ( ");
            stringBuffer.append(this.getBeanName() + ".class , ");
            stringBuffer.append(String.valueOf(this.getCustomizer()) + " )");
            return stringBuffer.toString();
        }

        String getIconBase(boolean bl) {
            return "/org/netbeans/modules/beans/resources/bifDescriptor";
        }

        Collection getCustomizationStrings() {
            Collection collection = super.getCustomizationStrings();
            StringBuffer stringBuffer = new StringBuffer(100);
            return collection;
        }

        void analyzeCustomizationString(String string) {
        }

        void analyzeCreationString(String string) {
            int n = string.indexOf(44);
            int n2 = string.lastIndexOf(41);
            if (n != -1 && n2 != -1 && ++n < n2) {
                this.setCustomizer(string.substring(n, n2));
            } else {
                this.setCustomizer(null);
            }
        }

        String getBrackets() {
            return "";
        }

        public String getCustomizer() {
            return this.customizer;
        }

        public void setCustomizer(String string) {
            this.customizer = string;
        }

        public boolean isIncluded() {
            return true;
        }

        public String getBeanName() {
            return this.element.getName().getName();
        }
    }
}

