/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.PatternGroupNode;
import org.netbeans.modules.beans.PatternNode;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.src.ClassElement;
import org.openide.src.Type;
import org.openide.util.HelpCtx;

public class EventSetPatternPanel
extends JPanel
implements ActionListener {
    private Dialog dialog;
    private PatternGroupNode groupNode;
    private boolean forInterface;
    static final long serialVersionUID = -6439362166672698327L;
    private JRadioButton alRadioButton;
    private JPanel eventSetPanel;
    private JRadioButton ellRadioButton;
    private JLabel typeLabel;
    private JCheckBox passEventCheckBox;
    private JCheckBox fireCheckBox;
    private JPanel optionsPanel;
    private JLabel textLabel;
    private JRadioButton emptyRadioButton;
    private JPanel mainPanel;
    private JComboBox typeComboBox;

    public EventSetPatternPanel() {
        this.initComponents();
        this.initAccessibility();
        int n = 0;
        while (n < EventSetPattern.WELL_KNOWN_LISTENERS.length) {
            this.typeComboBox.addItem(EventSetPattern.WELL_KNOWN_LISTENERS[n]);
            ++n;
        }
        this.typeComboBox.setSelectedItem("");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.emptyRadioButton);
        buttonGroup.add(this.alRadioButton);
        buttonGroup.add(this.ellRadioButton);
        ((TitledBorder)this.eventSetPanel.getBorder()).setTitle(PatternNode.getString("CTL_EventSetPanel_eventSetPanel"));
        ((TitledBorder)this.optionsPanel.getBorder()).setTitle(PatternNode.getString("CTL_EventSetPanel_optionsPanel"));
        this.typeLabel.setText(PatternNode.getString("CTL_EventSetPanel_typeLabel"));
        this.typeLabel.setDisplayedMnemonic(PatternNode.getString("CTL_EventSetPanel_typeLabel_Mnemonic").charAt(0));
        this.typeLabel.setLabelFor(this.typeComboBox);
        this.typeComboBox.setToolTipText(PatternNode.getString("ACS_EventSetPanel_typeComboBoxA11yDesc"));
        this.textLabel.setText(PatternNode.getString("CTL_EventSetPanel_textLabel"));
        this.emptyRadioButton.setText(PatternNode.getString("CTL_EventSetPanel_emptyRadioButton"));
        this.emptyRadioButton.setMnemonic(PatternNode.getString("CTL_EventSetPanel_emptyRadioButton_Mnemonic").charAt(0));
        this.emptyRadioButton.setToolTipText(PatternNode.getString("ACS_EventSetPanel_emptyRadioButtonA11yDesc"));
        this.alRadioButton.setText(PatternNode.getString("CTL_EventSetPanel_alRadioButton"));
        this.alRadioButton.setMnemonic(PatternNode.getString("CTL_EventSetPanel_alRadioButton_Mnemonic").charAt(0));
        this.alRadioButton.setToolTipText(PatternNode.getString("ACS_EventSetPanel_alRadioButtonA11yDesc"));
        this.ellRadioButton.setText(PatternNode.getString("CTL_EventSetPanel_ellRadioButton"));
        this.ellRadioButton.setMnemonic(PatternNode.getString("CTL_EventSetPanel_ellRadioButton_Mnemonic").charAt(0));
        this.ellRadioButton.setToolTipText(PatternNode.getString("ACS_EventSetPanel_ellRadioButtonA11yDesc"));
        this.fireCheckBox.setText(PatternNode.getString("CTL_EventSetPanel_fireCheckBox"));
        this.fireCheckBox.setMnemonic(PatternNode.getString("CTL_EventSetPanel_fireCheckBox_Mnemonic").charAt(0));
        this.fireCheckBox.setToolTipText(PatternNode.getString("ACS_EventSetPanel_fireCheckBoxA11yDesc"));
        this.passEventCheckBox.setText(PatternNode.getString("CTL_EventSetPanel_passEventCheckBox"));
        this.passEventCheckBox.setMnemonic(PatternNode.getString("CTL_EventSetPanel_passEventCheckBox_Mnemonic").charAt(0));
        this.passEventCheckBox.setToolTipText(PatternNode.getString("ACS_EventSetPanel_passEventCheckBoxA11yDesc"));
        HelpCtx.setHelpIDString((JComponent)this, (String)"beans.eventsets");
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACSD_EventSetPanelDialog"));
        this.typeLabel.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACS_EventSetPanel_typeLabelA11yDesc"));
        this.typeComboBox.getAccessibleContext().setAccessibleName(PatternNode.getString("ACS_EventSetPanel_typeComboBoxA11yName"));
        this.textLabel.getAccessibleContext().setAccessibleDescription(PatternNode.getString("ACS_EventSetPanel_textLabelA11yDesc"));
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.eventSetPanel = new JPanel();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.textLabel = new JLabel();
        this.optionsPanel = new JPanel();
        this.emptyRadioButton = new JRadioButton();
        this.alRadioButton = new JRadioButton();
        this.ellRadioButton = new JRadioButton();
        this.fireCheckBox = new JCheckBox();
        this.passEventCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.eventSetPanel.setLayout(new GridBagLayout());
        this.eventSetPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "eventSetPanel", 0, 0, new Font("Dialog", 0, 11), Color.black));
        this.typeLabel.setText("typeLabel");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.eventSetPanel.add((Component)this.typeLabel, gridBagConstraints);
        this.typeComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.eventSetPanel.add((Component)this.typeComboBox, gridBagConstraints);
        this.textLabel.setText("textLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 2);
        this.eventSetPanel.add((Component)this.textLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.eventSetPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setBorder(new TitledBorder(new EtchedBorder(null, new Color(149, 142, 130)), "optionsPanel", 0, 0, new Font("Dialog", 0, 11), Color.black));
        this.emptyRadioButton.setSelected(true);
        this.emptyRadioButton.setLabel("emptyRadioButton");
        this.emptyRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventSetPatternPanel.this.emptyRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.optionsPanel.add((Component)this.emptyRadioButton, gridBagConstraints);
        this.alRadioButton.setLabel("alRadioButton");
        this.alRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventSetPatternPanel.this.alRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.optionsPanel.add((Component)this.alRadioButton, gridBagConstraints);
        this.ellRadioButton.setText("ellradioButton");
        this.ellRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventSetPatternPanel.this.ellRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 2, 4);
        this.optionsPanel.add((Component)this.ellRadioButton, gridBagConstraints);
        this.fireCheckBox.setText("fireCheckBox");
        this.fireCheckBox.setEnabled(false);
        this.fireCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventSetPatternPanel.this.fireCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.optionsPanel.add((Component)this.fireCheckBox, gridBagConstraints);
        this.passEventCheckBox.setText("passEventCheckBox");
        this.passEventCheckBox.setEnabled(false);
        this.passEventCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EventSetPatternPanel.this.passEventCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 2, 4);
        this.optionsPanel.add((Component)this.passEventCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    private void emptyRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void fireCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void ellRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void alRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    private void passEventCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.protectControls();
    }

    Result getResult() {
        Result result = new Result();
        result.type = this.typeComboBox.getEditor().getItem().toString();
        if (this.alRadioButton.isSelected()) {
            result.implementation = 1;
        } else if (this.ellRadioButton.isSelected()) {
            result.implementation = 2;
        }
        if (this.fireCheckBox.isSelected()) {
            result.firing = true;
        }
        if (this.passEventCheckBox.isSelected()) {
            result.passEvent = true;
        }
        return result;
    }

    private void protectControls() {
        this.alRadioButton.setEnabled(!this.forInterface);
        this.ellRadioButton.setEnabled(!this.forInterface);
        this.fireCheckBox.setEnabled(!this.emptyRadioButton.isSelected());
        this.passEventCheckBox.setEnabled(!this.emptyRadioButton.isSelected() && this.fireCheckBox.isSelected());
    }

    void setDialog(Dialog dialog) {
        this.dialog = dialog;
    }

    void setForInterface(boolean bl) {
        this.forInterface = bl;
        this.protectControls();
    }

    void setGroupNode(PatternGroupNode patternGroupNode) {
        this.groupNode = patternGroupNode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.dialog != null) {
            if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                Type type;
                if (this.typeComboBox.getEditor().getItem().toString().trim().length() <= 0) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Type"), 0));
                    this.typeComboBox.requestFocus();
                    return;
                }
                try {
                    type = Type.parse((String)this.typeComboBox.getEditor().getItem().toString());
                    if (this.groupNode.eventSetExists(type)) {
                        String string = MessageFormat.format(PatternNode.getString("MSG_EventSet_Exists"), type.toString());
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                        this.typeComboBox.requestFocus();
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Type"), 0));
                    this.typeComboBox.requestFocus();
                    return;
                }
                if (!PatternAnalyser.isSubclass(ClassElement.forName((String)type.getClassName().getFullName()), ClassElement.forName((String)"java.util.EventListener"))) {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_InvalidListenerInterface"), 0));
                    return;
                }
            }
            ((Component)this.dialog).setVisible(false);
            this.dialog.dispose();
        }
    }

    class Result {
        String type;
        int implementation = 0;
        boolean firing = false;
        boolean passEvent = false;

        Result() {
        }
    }
}

