/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.revision;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.vcscore.revision.RevisionItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class RevisionList
extends TreeSet {
    private FileSystem fileSystem = null;
    private FileObject fo = null;
    private Vector listeners = new Vector();
    static final long serialVersionUID = -8578787400541124223L;

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public void setFileObject(FileObject fileObject) {
        this.fo = fileObject;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    public boolean add(Object object) {
        boolean bl = super.add(object);
        this.fireChanged();
        return bl;
    }

    public boolean addAll(Collection collection) {
        boolean bl = super.addAll(collection);
        this.fireChanged();
        return bl;
    }

    public boolean remove(Object object) {
        boolean bl = super.remove(object);
        this.fireChanged();
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = super.removeAll(collection);
        this.fireChanged();
        return bl;
    }

    public boolean removeRevision(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RevisionItem revisionItem = (RevisionItem)iterator.next();
            String string2 = revisionItem.getRevision();
            if (!string2.equals(string)) continue;
            this.remove(revisionItem);
            return true;
        }
        return false;
    }

    public void fireChanged() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ChangeListener changeListener = (ChangeListener)enumeration.nextElement();
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean containsSubRevisions(String string) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RevisionItem revisionItem = (RevisionItem)iterator.next();
            String string2 = revisionItem.getRevision();
            if (string2.length() <= string.length() || !string2.regionMatches(0, string, 0, string.length()) || string2.charAt(string.length()) != '.') continue;
            return true;
        }
        return false;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public boolean removeChangeListener(ChangeListener changeListener) {
        return this.listeners.remove(changeListener);
    }
}

