/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.grouping;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import org.netbeans.modules.vcscore.grouping.VcsGroupNode;
import org.openide.TopManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.WeakListener;

public class MainVcsGroupChildren
extends Children.Keys {
    private VcsGroupFileChangeList fsListener = new VcsGroupFileChangeList();
    private FileChangeListener wfsListener = WeakListener.fileChange((FileChangeListener)this.fsListener, null);
    private FileObject rootFo;
    private static final String DEFAULT_FOLDER_NAME = "default";
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$grouping$MainVcsGroupChildren;

    public MainVcsGroupChildren() {
        FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
        this.rootFo = fileSystem.findResource("vcs/Groups");
        if (this.rootFo != null) {
            this.rootFo.addFileChangeListener((FileChangeListener)this.fsListener);
        }
    }

    public static DataFolder getMainVcsGroupFolder() {
        FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("vcs/Groups");
        DataFolder dataFolder = null;
        try {
            dataFolder = (DataFolder)DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        return dataFolder;
    }

    VcsGroupNode getDefaultGroupNode() {
        Object object;
        FileObject fileObject;
        Node[] nodeArray = this.getNodes();
        int n = 0;
        while (n < nodeArray.length) {
            fileObject = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? MainVcsGroupChildren.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (fileObject != null && (object = fileObject.getPrimaryFile()).getName().equalsIgnoreCase(DEFAULT_FOLDER_NAME)) {
                return (VcsGroupNode)nodeArray[n];
            }
            ++n;
        }
        try {
            fileObject = this.rootFo.getFileObject(DEFAULT_FOLDER_NAME, "properties");
            if (fileObject == null) {
                fileObject = this.rootFo.createData(DEFAULT_FOLDER_NAME, "properties");
            }
            object = new PrintWriter(fileObject.getOutputStream(fileObject.lock()));
            ((PrintWriter)object).println("name=" + NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$grouping$MainVcsGroupChildren == null ? (class$org$netbeans$modules$vcscore$grouping$MainVcsGroupChildren = MainVcsGroupChildren.class$("org.netbeans.modules.vcscore.grouping.MainVcsGroupChildren")) : class$org$netbeans$modules$vcscore$grouping$MainVcsGroupChildren)).getString("LBL_DefaultGroupName"));
            ((PrintWriter)object).close();
            FileObject fileObject2 = this.rootFo.getFileObject(DEFAULT_FOLDER_NAME);
            if (fileObject2 == null) {
                this.rootFo.createFolder(DEFAULT_FOLDER_NAME);
            }
        }
        catch (IOException iOException) {
            object = TopManager.getDefault().getErrorManager();
            object.notify(16, (Throwable)iOException);
            return null;
        }
        this.refreshAll();
        return this.getDefaultGroupNode();
    }

    private Node createVcsGroupNode(FileObject fileObject) {
        DataFolder dataFolder = null;
        try {
            dataFolder = (DataFolder)DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        VcsGroupNode vcsGroupNode = new VcsGroupNode(dataFolder);
        return vcsGroupNode;
    }

    protected void addNotify() {
        this.setKeys(this.getGroups());
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    private void refreshAll() {
        this.setKeys(this.getGroups());
    }

    private Collection getGroups() {
        Enumeration enumeration;
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        FileSystem fileSystem = TopManager.getDefault().getRepository().getDefaultFileSystem();
        this.rootFo = fileSystem.findResource("vcs/Groups");
        if (this.rootFo != null && (enumeration = this.rootFo.getChildren(false)) != null) {
            while (enumeration.hasMoreElements()) {
                FileObject fileObject = (FileObject)enumeration.nextElement();
                if (!fileObject.isFolder()) continue;
                linkedList.add(fileObject);
            }
        }
        return linkedList;
    }

    protected Node[] createNodes(Object object) {
        DataFolder dataFolder = DataFolder.findFolder((FileObject)((FileObject)object));
        if (dataFolder != null) {
            return new Node[]{new VcsGroupNode(dataFolder)};
        }
        return new Node[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class VcsGroupFileChangeList
    extends FileChangeAdapter {
        private VcsGroupFileChangeList() {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            if (fileRenameEvent.getFile().isFolder()) {
                MainVcsGroupChildren.this.refreshAll();
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            if (fileEvent.getFile().isFolder()) {
                MainVcsGroupChildren.this.refreshAll();
            }
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (fileEvent.getFile().isFolder()) {
                MainVcsGroupChildren.this.refreshAll();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
        }
    }
}

