/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.caching;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.ref.Reference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.netbeans.modules.vcscore.DirReaderListener;
import org.netbeans.modules.vcscore.FileReaderListener;
import org.netbeans.modules.vcscore.VcsDirContainer;
import org.netbeans.modules.vcscore.VcsFactory;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.util.Debug;
import org.openide.filesystems.FileObject;

public class VcsCache
extends FileSystemCache
implements DirReaderListener,
FileReaderListener {
    private Debug E;
    private Debug D;
    private Reference fileSystem;
    private String fsRoot;
    private int rootNameLength;
    private HashMap cacheDirs;
    private HashMap refreshStrategyWhenNonLocal;

    public VcsCache(Reference reference, String string) {
        super(string);
        this.D = this.E = new Debug("VcsCache", true);
        this.fileSystem = reference;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)reference.get();
        this.fsRoot = vcsFileSystem.getRootDirectory().getAbsolutePath();
        vcsFileSystem.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VcsCache.this.updateFSRoot();
            }
        });
        this.rootNameLength = this.fsRoot.length();
        this.cacheDirs = new HashMap();
        this.refreshStrategyWhenNonLocal = new HashMap();
    }

    public void updateFSRoot() {
        this.fsRoot = ((VcsFileSystem)this.fileSystem.get()).getRootDirectory().getAbsolutePath();
        this.rootNameLength = this.fsRoot.length();
    }

    String getPath(File file) {
        String string = file.getAbsolutePath();
        if (string.length() <= this.rootNameLength) {
            return "";
        }
        String string2 = string.charAt(this.rootNameLength) == '/' || string.charAt(this.rootNameLength) == File.separatorChar ? string.substring(this.rootNameLength + 1) : string.substring(this.rootNameLength);
        string2 = string2.replace(File.separatorChar, '/');
        return string2;
    }

    String getAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    private VcsFactory getFactory() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        return vcsFileSystem.getVcsFactory();
    }

    synchronized void runVcsDirReader(File file) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        VcsCacheDir vcsCacheDir = (VcsCacheDir)this.getDir(this.getAbsolutePath(file));
        if (vcsCacheDir.isBeingLoaded()) {
            return;
        }
        vcsCacheDir.setBeingLoaded(true);
        VcsFactory vcsFactory = vcsFileSystem.getVcsFactory();
        VcsCommandExecutor vcsCommandExecutor = vcsFactory.getVcsDirReader(this, this.getPath(file));
        if (vcsCommandExecutor != null) {
            vcsFileSystem.getCommandsPool().startExecutor(vcsCommandExecutor, vcsFileSystem);
        }
    }

    synchronized void runVcsDirReaderRecursive(File file) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        VcsFactory vcsFactory = vcsFileSystem.getVcsFactory();
        VcsCommandExecutor vcsCommandExecutor = vcsFactory.getVcsDirReaderRecursive(this, this.getPath(file));
        if (vcsCommandExecutor != null) {
            vcsFileSystem.getCommandsPool().startExecutor(vcsCommandExecutor, vcsFileSystem);
        }
    }

    String getCacheFileName(File file) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        return vcsFileSystem.getCacheFileName(this.getPath(file));
    }

    FilenameFilter getLocalFileFilter() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        return vcsFileSystem.getLocalFileFilter();
    }

    String getLocalFileStatus() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return "";
        }
        FileStatusProvider fileStatusProvider = vcsFileSystem.getStatusProvider();
        if (fileStatusProvider == null) {
            return "";
        }
        return fileStatusProvider.getLocalFileStatus();
    }

    public void writeAllToDisk() {
    }

    protected void loadDir(CacheDir cacheDir, int n) {
        if (n == 11 || n == 12) {
            ((VcsCacheDir)cacheDir).refreshLocal(n == 12);
            cacheDir.setComplete(true);
            if (cacheDir.isLocal()) {
                return;
            }
            if (this.doesStrategyApply(cacheDir, n, 11)) {
                cacheDir.checkServer();
                cacheDir.setComplete(true);
            }
            if (this.doesStrategyApply(cacheDir, n, 10)) {
                cacheDir.setComplete(true);
                cacheDir.setAppliedLevel(10);
            }
            if (this.doesStrategyApply(cacheDir, n, 12)) {
                cacheDir.checkServerRecursive();
                cacheDir.setComplete(true);
            }
        } else {
            super.loadDir(cacheDir, n);
        }
        if (cacheDir.isLocal() && (this.doesStrategyApply(cacheDir, n, 11) || this.doesStrategyApply(cacheDir, n, 3))) {
            this.refreshStrategyWhenNonLocal.put(cacheDir.getAbsolutePath(), new Integer(n));
        }
    }

    public CacheFile getCacheFile(File file, int n) {
        String string;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return null;
        }
        boolean bl = false;
        if (vcsFileSystem.getRootDirectory().equals(file) || file.getParentFile() == null) {
            string = file.getAbsolutePath();
            file = vcsFileSystem.getRootDirectory();
            bl = true;
        } else {
            string = file.getParentFile().getAbsolutePath();
        }
        CacheDir cacheDir = this.getDir(string);
        if (cacheDir == null && (cacheDir = this.initCacheDir(new File(string))) == null) {
            return null;
        }
        if (n != 5 && n != 3 && n != -1 || cacheDir.getAppliedLevel() < 3 || !cacheDir.isComplete()) {
            this.loadDir(cacheDir, n);
        }
        if (bl) {
            return cacheDir;
        }
        String string2 = file.getName();
        CacheFile cacheFile = cacheDir.getFile(string2);
        if (cacheFile != null) {
            return cacheFile;
        }
        CacheDir cacheDir2 = cacheDir.getSubDir(string2);
        return cacheDir2;
    }

    public void doRefreshDir(CacheDir cacheDir, boolean bl) {
        int n = bl ? 12 : 11;
        this.loadDir(cacheDir, n);
    }

    private CacheDir initCacheDir(File file) {
        File file2 = file.getParentFile();
        CacheDir cacheDir = null;
        if (file2 != null) {
            this.getDir(file2.getAbsolutePath());
        }
        CacheDir cacheDir2 = null;
        if (cacheDir == null) {
            VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
            if (vcsFileSystem == null) {
                return null;
            }
            VcsFactory vcsFactory = vcsFileSystem.getVcsFactory();
            cacheDir2 = new VcsCacheDir(this.getId(), file);
            cacheDir2.setParent(null);
            cacheDir2.setLocal(false);
            this.registerDir(cacheDir2);
        } else {
            cacheDir2 = cacheDir.getSubDir(file.getName());
            if (cacheDir2 == null) {
                cacheDir2 = new VcsCacheDir(this.getId(), file);
                cacheDir.addChildDir(cacheDir2, false);
                cacheDir2.setParent(cacheDir);
                cacheDir2.setLocal(false);
                this.registerDir(cacheDir2);
            }
        }
        return cacheDir2;
    }

    public void registerDir(CacheDir cacheDir) {
        if (cacheDir != null) {
            String string = cacheDir.getAbsolutePath();
            while (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            this.cacheDirs.put(string, cacheDir);
        }
    }

    public void registerDirRecursive(CacheDir cacheDir) {
        this.registerDir(cacheDir);
        CacheDir[] cacheDirArray = cacheDir.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            this.registerDirRecursive(cacheDirArray[n]);
            ++n;
        }
    }

    public void unregisterDir(CacheDir cacheDir) {
        if (cacheDir != null) {
            String string = cacheDir.getAbsolutePath();
            while (string.endsWith(File.separator)) {
                string = string.substring(0, string.length() - 1);
            }
            this.cacheDirs.remove(string);
            CacheDir[] cacheDirArray = cacheDir.getSubDirs();
            int n = 0;
            while (n < cacheDirArray.length) {
                this.unregisterDir(cacheDirArray[n]);
                ++n;
            }
        }
    }

    public CacheDir getDir(String string) {
        int n;
        while (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        while ((n = string.indexOf(File.separator + File.separator)) > 0) {
            string = string.substring(0, n) + string.substring(n + 1, string.length());
        }
        CacheDir cacheDir = (CacheDir)this.cacheDirs.get(string);
        return cacheDir;
    }

    private void heyDoRefreshDir(String string) {
        FileObject fileObject;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem != null && (fileObject = vcsFileSystem.findResource(string)) != null) {
            fileObject.refresh();
        }
    }

    private void heyDoRefreshDirRecursive(VcsCacheDir vcsCacheDir) {
        this.heyDoRefreshDir(this.getPath(vcsCacheDir.getFile()));
        CacheDir[] cacheDirArray = vcsCacheDir.getSubDirs();
        int n = 0;
        while (n < cacheDirArray.length) {
            this.heyDoRefreshDirRecursive((VcsCacheDir)cacheDirArray[n]);
            ++n;
        }
    }

    private ArrayList getNonLocalSubfiles(VcsCacheDir vcsCacheDir) {
        String[] stringArray = vcsCacheDir.getFilesAndSubdirs();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = 0;
        while (n < arrayList.size()) {
            CacheDir cacheDir;
            String string = arrayList.get(n);
            CacheFile cacheFile = vcsCacheDir.getFile(string);
            if (cacheFile instanceof VcsCacheFile) {
                if (((VcsCacheFile)cacheFile).isLocal()) {
                    arrayList.remove(n--);
                }
            } else if (cacheFile instanceof VcsCacheDir && ((VcsCacheDir)cacheFile).isLocal()) {
                arrayList.remove(n--);
            }
            if ((cacheDir = vcsCacheDir.getSubDir(string)) instanceof VcsCacheDir && ((VcsCacheDir)cacheDir).isLocal()) {
                arrayList.remove(n--);
            }
            ++n;
        }
        return arrayList;
    }

    private VcsCacheDir createSubFiles(VcsFileSystem vcsFileSystem, String string, Collection collection) {
        Object object;
        Object object2;
        Object object3;
        VcsCacheDir vcsCacheDir = (VcsCacheDir)vcsFileSystem.getCacheProvider().getDir(string);
        if (vcsCacheDir == null) {
            vcsCacheDir = (VcsCacheDir)this.initCacheDir(vcsFileSystem.getFile(string));
        }
        ArrayList arrayList = this.getNonLocalSubfiles(vcsCacheDir);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object4;
            String[] stringArray = (String[])iterator.next();
            object3 = RefreshCommandSupport.matchToFile(stringArray, vcsFileSystem.getCacheIdStr(), vcsCacheDir.getFile());
            object2 = ((CacheFile)object3).getName();
            if (object3 instanceof VcsCacheFile) {
                ((VcsCacheFile)object3).setLocal(false);
                if (arrayList.contains(object2)) {
                    vcsCacheDir.removeFile((String)object2, false);
                    vcsCacheDir.addFile((CacheFile)object3, false);
                    ((AbstractCollection)arrayList).remove(object2);
                    continue;
                }
                vcsCacheDir.addFile((CacheFile)object3, true);
                continue;
            }
            if (!(object3 instanceof VcsCacheDir)) continue;
            object = (VcsCacheDir)object3;
            ((CacheDir)object).setLocal(false);
            if (arrayList.contains(object2)) {
                ((AbstractCollection)arrayList).remove(object2);
            } else {
                vcsCacheDir.addChildDir((CacheDir)object, true);
            }
            if (object != vcsCacheDir.getSubDir((String)object2)) {
                object4 = (VcsCacheDir)vcsCacheDir.getSubDir((String)object2);
                ((CacheFile)object4).setStatus(((CacheFile)object).getStatus());
                ((CacheFile)object4).setSticky(((CacheFile)object).getSticky());
                ((CacheFile)object4).setLocker(((CacheFile)object).getLocker());
                ((CacheFile)object4).setRevision(((CacheFile)object).getRevision());
                ((CacheFile)object4).setSize(((CacheFile)object).getSize());
                ((CacheFile)object4).setDate(((CacheFile)object).getDate());
                ((CacheFile)object4).setTime(((CacheFile)object).getTime());
                ((CacheFile)object4).setAttr(((CacheFile)object).getAttr());
                ((CacheDir)object4).setLocal(false);
                object = object4;
            }
            if ((object4 = (Integer)this.refreshStrategyWhenNonLocal.get(((CacheDir)object).getAbsolutePath())) == null) continue;
            this.loadDir((CacheDir)object, (Integer)object4);
        }
        if (arrayList.size() > 0) {
            int n = arrayList.size() - 1;
            while (n >= 0) {
                object3 = (String)arrayList.get(n);
                object2 = vcsCacheDir.getFile((String)object3);
                if (object2 != null) {
                    vcsCacheDir.removeFile((String)object3, true);
                } else {
                    object = vcsCacheDir.getSubDir((String)object3);
                    if (object != null) {
                        vcsCacheDir.removeChildDir((String)object3, true);
                    }
                }
                --n;
            }
            vcsCacheDir.refreshLocal(false);
        }
        vcsCacheDir.setLoaded(true);
        return vcsCacheDir;
    }

    private VcsCacheDir createSubFiles(VcsFileSystem vcsFileSystem, VcsDirContainer vcsDirContainer) {
        Hashtable hashtable = (Hashtable)vcsDirContainer.getElement();
        Collection<Object> collection = hashtable == null ? Collections.EMPTY_LIST : hashtable.values();
        VcsCacheDir vcsCacheDir = this.createSubFiles(vcsFileSystem, vcsDirContainer.getPath(), collection);
        VcsDirContainer[] vcsDirContainerArray = vcsDirContainer.getSubdirContainers();
        int n = 0;
        while (n < vcsDirContainerArray.length) {
            vcsCacheDir.addChildDir(this.createSubFiles(vcsFileSystem, vcsDirContainerArray[n]), true);
            ++n;
        }
        return vcsCacheDir;
    }

    public void readFileFinished(String string, Collection collection) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        VcsCacheDir vcsCacheDir = (VcsCacheDir)vcsFileSystem.getCacheProvider().getDir(string);
        if (vcsCacheDir == null) {
            vcsCacheDir = (VcsCacheDir)this.initCacheDir(vcsFileSystem.getFile(string));
            this.registerDir(vcsCacheDir);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CacheFile cacheFile;
            String[] stringArray = (String[])iterator.next();
            if (stringArray.length == 1) {
                cacheFile = vcsCacheDir.getFile(stringArray[0]);
                if (cacheFile != null) {
                    vcsCacheDir.removeFile(stringArray[0], true);
                    continue;
                }
                cacheFile = vcsCacheDir.getSubDir(stringArray[0]);
                if (cacheFile == null) continue;
                vcsCacheDir.removeChildDir(stringArray[0], true);
                continue;
            }
            cacheFile = RefreshCommandSupport.matchToExistingFile(stringArray, vcsFileSystem.getCacheIdStr(), vcsCacheDir.getFile());
            String string2 = cacheFile.getName();
            boolean bl = false;
            if (cacheFile instanceof VcsCacheFile && vcsCacheDir.getFile(string2) == null) {
                vcsCacheDir.addFile(cacheFile, true);
                bl = true;
            } else if (cacheFile instanceof VcsCacheDir && vcsCacheDir.getSubDir(string2) == null) {
                vcsCacheDir.addChildDir((CacheDir)cacheFile, true);
                bl = true;
            }
            if (bl) {
                this.fireCacheHandlerEvent(0, cacheFile);
                continue;
            }
            this.fireCacheHandlerEvent(2, cacheFile);
        }
        vcsCacheDir.writeToDisk();
        this.heyDoRefreshDir(this.getPath(vcsCacheDir.getFile()));
    }

    public void readDirFinished(String string, Collection collection, boolean bl) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        String string2 = this.fsRoot + File.separatorChar + string.replace('/', File.separatorChar);
        if (!bl && collection.size() == 0) {
            CacheDir cacheDir = this.getDir(string2);
            if (cacheDir instanceof VcsCacheDir) {
                ((VcsCacheDir)cacheDir).setBeingLoaded(false);
            }
            return;
        }
        this.lockFileObjects(string2, false);
        VcsCacheDir vcsCacheDir = this.createSubFiles(vcsFileSystem, string, collection);
        this.registerDir(vcsCacheDir);
        vcsCacheDir.writeToDisk();
        vcsCacheDir.setBeingLoaded(false);
        this.fireCacheHandlerEvent(2, vcsCacheDir);
        this.removeLockedFileObjects(string2);
        this.heyDoRefreshDir(this.getPath(vcsCacheDir.getFile()));
    }

    public void readDirFinishedRecursive(String string, VcsDirContainer vcsDirContainer, boolean bl) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return;
        }
        String string2 = this.fsRoot + File.separatorChar + string.replace('/', File.separatorChar);
        this.lockFileObjects(string2, true);
        VcsCacheDir vcsCacheDir = this.createSubFiles(vcsFileSystem, vcsDirContainer);
        this.registerDirRecursive(vcsCacheDir);
        vcsCacheDir.writeToDiskRecursively();
        this.fireCacheHandlerEvent(3, vcsCacheDir);
        this.removeLockedFileObjects(string2);
        this.heyDoRefreshDirRecursive(vcsCacheDir);
    }

    boolean lockFileObjects(String string, boolean bl) {
        String string2 = this.fsRoot;
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (string.length() <= string2.length()) {
            return false;
        }
        String string3 = string.substring(string2.length());
        if ((string3 = string3.replace(File.separatorChar, '/')).startsWith("/")) {
            string3 = string3.substring(1);
        }
        FileObject fileObject = vcsFileSystem.findResource(string3);
        return this.doLockFileObjects(fileObject, string, bl);
    }

    boolean lockFileObjects(CacheDir cacheDir, boolean bl) {
        String string = cacheDir.getAbsolutePath();
        return this.lockFileObjects(string, bl);
    }
}

