/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore.cache;

import java.io.File;
import java.lang.ref.ReferenceQueue;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.cache.FileSystemCache;

public class CacheQueue
extends Thread {
    ReferenceQueue refQueue = new ReferenceQueue();

    public CacheQueue() {
        this.setName("FileSystem Cache Queue");
    }

    public void run() {
        try {
            block2: while (true) {
                Thread.sleep(5000L);
                CacheReference cacheReference = (CacheReference)this.refQueue.poll();
                while (true) {
                    if (cacheReference == null) continue block2;
                    File file = cacheReference.getCacheFile();
                    CacheFile cacheFile = CacheHandler.getInstance().getCacheFile(file, -1, cacheReference.getCacheName());
                    if (cacheFile != null) {
                        CacheDir cacheDir;
                        cacheFile.removeReference(cacheReference);
                        if (!(cacheFile instanceof CacheDir)) {
                            cacheDir = cacheFile.getParent();
                            if (cacheDir != null && cacheFile.getReferenceCount() <= 0) {
                                cacheDir.setComplete(false);
                                cacheDir.removeFile(cacheFile.getName(), false);
                            }
                        } else {
                            cacheDir = (CacheDir)cacheFile;
                            if (cacheDir.isEmpty()) {
                                CacheDir cacheDir2 = cacheDir.getParent();
                                if (cacheDir2 != null) {
                                    if (cacheDir.getReferenceCount() <= 0) {
                                        cacheDir2.setComplete(false);
                                        cacheDir2.removeChildDir(cacheDir.getName(), false);
                                    }
                                } else if (cacheDir.getReferenceCount() <= 0) {
                                    FileSystemCache fileSystemCache = CacheHandler.getInstance().getCache(cacheReference.getCacheName());
                                    fileSystemCache.unregisterDir(cacheDir);
                                }
                            }
                        }
                    }
                    cacheReference = (CacheReference)this.refQueue.poll();
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    ReferenceQueue getQueue() {
        return this.refQueue;
    }
}

