/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.netbeans.modules.vcscore.DefaultVcsFactory;
import org.netbeans.modules.vcscore.Variables;
import org.netbeans.modules.vcscore.VcsAction;
import org.netbeans.modules.vcscore.VcsActionSupporter;
import org.netbeans.modules.vcscore.VcsAttributes;
import org.netbeans.modules.vcscore.VcsConfigVariable;
import org.netbeans.modules.vcscore.VcsFactory;
import org.netbeans.modules.vcscore.VcsVersioningSystem;
import org.netbeans.modules.vcscore.cache.CacheDir;
import org.netbeans.modules.vcscore.cache.CacheFile;
import org.netbeans.modules.vcscore.cache.CacheHandler;
import org.netbeans.modules.vcscore.cache.CacheHandlerEvent;
import org.netbeans.modules.vcscore.cache.CacheHandlerListener;
import org.netbeans.modules.vcscore.cache.CacheReference;
import org.netbeans.modules.vcscore.cache.FileSystemCache;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.caching.RefreshCommandSupport;
import org.netbeans.modules.vcscore.caching.VcsCacheDir;
import org.netbeans.modules.vcscore.caching.VcsCacheFile;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.commands.CommandExecutorSupport;
import org.netbeans.modules.vcscore.commands.CommandsPool;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.commands.VcsCommandNode;
import org.netbeans.modules.vcscore.grouping.AddToGroupDialog;
import org.netbeans.modules.vcscore.grouping.GroupUtils;
import org.netbeans.modules.vcscore.grouping.VcsGroupSettings;
import org.netbeans.modules.vcscore.runtime.RuntimeSupport;
import org.netbeans.modules.vcscore.search.VcsSearchTypeFileSystem;
import org.netbeans.modules.vcscore.settings.GeneralVcsSettings;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VariableInputDescriptorCompat;
import org.netbeans.modules.vcscore.util.VariableInputDialog;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.util.virtuals.VcsRefreshRequest;
import org.netbeans.modules.vcscore.util.virtuals.VirtualsDataLoader;
import org.netbeans.modules.vcscore.util.virtuals.VirtualsRefreshing;
import org.netbeans.modules.vcscore.versioning.RevisionEvent;
import org.netbeans.modules.vcscore.versioning.RevisionListener;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.netbeans.modules.vcscore.versioning.VersioningRepository;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;

public abstract class VcsFileSystem
extends AbstractFileSystem
implements VariableInputDialog.FilePromptDocumentListener,
VcsSearchTypeFileSystem,
VirtualsRefreshing,
AbstractFileSystem.List,
AbstractFileSystem.Info,
AbstractFileSystem.Change,
FileSystem.Status,
CacheHandlerListener,
Serializable {
    private Debug E;
    private Debug D;
    private static final int BADGE_ICON_SHIFT_X = 16;
    private static final int BADGE_ICON_SHIFT_Y = 8;
    public static final String VCS_PROVIDER_ATTRIBUTE = "VCS Provider";
    public static final String VCS_FILESYSTEM_ICON_BASE = "VCS Icon Base";
    public static final String PROP_VARIABLES = "variables";
    public static final String PROP_COMMANDS = "commands";
    public static final String PROP_DEBUG = "debug";
    public static final String PROP_CALL_EDIT = "edit";
    public static final String PROP_CALL_EDIT_PROMPT = "editPrompt";
    public static final String PROP_CALL_LOCK = "lock";
    public static final String PROP_CALL_LOCK_PROMPT = "lockPrompt";
    public static final String PROP_EXPERT_MODE = "expertMode";
    public static final String PROP_PROCESS_UNIMPORTANT_FILES = "processUnimportantFiles";
    public static final String PROP_ANNOTATION_PATTERN = "annotationPattern";
    public static final String PROP_ANNOTATION_TYPES = "annotationTypes";
    public static final String PROP_COMMAND_NOTIFICATION = "commandNotification";
    public static final String PROP_IGNORED_GARBAGE_FILES = "ignoredGarbageFiles";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_REMEMBER_PASSWORD = "rememberPassword";
    public static final String PROP_CREATE_RUNTIME_COMMANDS = "createRuntimeCommands";
    public static final String PROP_CREATE_VERSIONING_EXPLORER = "createVersioningExplorer";
    public static final String PROP_CREATE_BACKUP_FILES = "createBackupFiles";
    public static final String PROP_FILTER_BACKUP_FILES = "filterBackupFiles";
    public static final String PROP_PROMPT_FOR_VARS_FOR_EACH_FILE = "promptForVarsForEachFile";
    protected static final String PROP_USE_UNIX_SHELL = "useUnixShell";
    protected static final String PROP_NOT_MODIFIABLE_STATUSES = "notModifiableStatuses";
    public static final String VAR_TRUE = "true";
    public static final String VAR_FALSE = "false";
    public static final String VAR_QUOTING = "QUOTE";
    public static final String VAR_EXPERT_MODE = "EXPERT_MODE";
    public static final String VAR_CTRL_DOWN_IN_ACTION = "CTRL_DOWN_IN_ACTION";
    public static final String VAR_FS_DISPLAY_NAME = "FS_DISPLAY_NAME";
    public static final String VAR_FS_DISPLAY_NAME_ANNOTATION = "FS_DISPLAY_NAME_ANNOTATION";
    public static final String VAR_FS_SYSTEM_NAME_ANNOTATION = "FS_SYSTEM_NAME_ANNOTATION";
    public static final String VAR_ENVIRONMENT_PREFIX = "ENVIRONMENT_VAR_";
    public static final String VAR_ENVIRONMENT_REMOVE_PREFIX = "ENVIRONMENT_REMOVE_VAR_";
    public static final String VAR_STATUS_SCHEDULED_ADD = "STATUS_SCHEDULED_ADD";
    public static final String VAR_STATUS_SCHEDULED_REMOVE = "STATUS_SCHEDULED_REMOVE";
    protected static final int REFRESH_TIME = 15000;
    protected volatile int refreshTimeToSet;
    private static final String LOCAL_FILES_ADD_VAR = "SHOWLOCALFILES";
    private static final String LOCK_FILES_ON = "LOCKFILES";
    private static final String PROMPT_FOR_LOCK_ON = "PROMPTFORLOCK";
    private static final String EDIT_FILES_ON = "CALLEDITONFILES";
    private static final String PROMPT_FOR_EDIT_ON = "PROMPTFOREDIT";
    private static final String DEFAULT_QUOTING_VALUE = "\\\"";
    private static final String DEFAULT_CACHE_ID = "VCS_Cache";
    private static final String FILE_PROMPT_PREFIX = "tmppf";
    private static int last_refreshTime = 15000;
    private static volatile File last_rootFile = new File(System.getProperty("user.home"));
    private static boolean last_useUnixShell = false;
    private transient Hashtable commandsByName;
    private volatile File rootFile;
    private boolean useUnixShell;
    private boolean readOnly;
    protected Hashtable variablesByName;
    private boolean lockFilesOn;
    private boolean promptForLockOn;
    private boolean promptForEditOn;
    private boolean callEditFilesOn;
    private boolean debug;
    private Vector variables;
    private transient String[] environmentVars;
    private String password;
    private boolean rememberPassword;
    private Object advanced;
    private transient Node commandsRoot;
    private String cacheID;
    protected transient FileCacheProvider cache;
    protected transient FileStatusProvider statusProvider;
    private int[] multiFilesAnnotationTypes;
    private String annotationPattern;
    private transient VcsAction action;
    private transient VcsFactory factory;
    private Boolean processUnimportantFiles;
    protected HashMap possibleFileStatusesMap;
    protected transient HashMap statusIconMap;
    protected transient Image statusIconDefault;
    protected boolean ready;
    private boolean askIfDownloadRecursively;
    private volatile Hashtable numDoAutoRefreshes;
    private transient boolean deserialized;
    private boolean promptForVarsForEachFile;
    private Vector tempFiles;
    private volatile String[] userParams;
    private volatile String[] userParamsLabels;
    private volatile String[] userLocalParamsLabels;
    private volatile boolean acceptUserParams;
    private boolean expertMode;
    private volatile transient CommandsPool commandsPool;
    private Integer numberOfFinishedCmdsToCollect;
    private int versioningFileSystemMessageLength;
    private boolean versioningFileSystemShowMessage;
    private String versioningFileSystemShowGarbageFiles;
    private boolean versioningFileSystemShowLocalFiles;
    private boolean versioningFileSystemShowUnimportantFiles;
    private boolean versioningFileSystemShowDeadFiles;
    private transient ArrayList revisionListeners;
    private volatile boolean offLine;
    private volatile int autoRefresh;
    private volatile boolean hideShadowFiles;
    private transient PropertyChangeListener settingsChangeListener;
    private VariableValueAdjustment varValueAdjustment;
    private volatile boolean commandNotification;
    private Collection notModifiableStatuses;
    private String missingFileStatus;
    private String missingFolderStatus;
    private Collection notMissingableFileStatuses;
    private Collection notMissingableFolderStatuses;
    private Boolean createRuntimeCommands;
    private Boolean createVersioningSystem;
    private transient VcsActionSupporter actionSupporter;
    private transient IgnoreListSupport ignoreListSupport;
    private transient Set unimportantFiles;
    private String ignoredGarbageFiles;
    private transient RE ignoredGarbageRE;
    private Boolean createBackupFiles;
    private Boolean filterBackupFiles;
    private transient VersioningFileSystem versioningSystem;
    private transient AbstractFileSystem.List vcsList;
    private transient VcsRefreshRequest refresher;
    private static RequestProcessor statusRequestProcessor;
    private static final Object STATUS_REQUEST_PROCESSOR_LOCK;
    private static ArrayList createIgnoreListQueue;
    private static Thread ignoreListCreationThread;
    private static final long serialVersionUID = 8108342718973310275L;
    private transient WeakHashMap versioningFolderListeners;
    private static final Object versioningFolderListenersLock;
    private transient Vector scheduledFilesToBeProcessed;
    private transient ArrayList deleteFileCommandQueue;
    private transient ArrayList deleteFolderCommandQueue;
    private transient Thread deleteCommandThread;
    private static final Object GROUP_LOCK;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$VcsCommand;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsFileSystem;

    public boolean isLockFilesOn() {
        return this.lockFilesOn && this.isEnabledLockFiles();
    }

    public void setLockFilesOn(boolean bl) {
        if (bl != this.lockFilesOn) {
            this.lockFilesOn = bl;
            VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(LOCK_FILES_ON);
            if (vcsConfigVariable == null) {
                vcsConfigVariable = new VcsConfigVariable(LOCK_FILES_ON, null, "", false, false, false, null);
                this.variables.add(vcsConfigVariable);
                this.variablesByName.put(vcsConfigVariable.getName(), vcsConfigVariable);
            }
            vcsConfigVariable.setValue(new Boolean(bl).toString());
            this.firePropertyChange(PROP_CALL_LOCK, new Boolean(!this.lockFilesOn), new Boolean(this.lockFilesOn));
        }
    }

    public boolean isPromptForLockOn() {
        return this.promptForLockOn;
    }

    public void setPromptForLockOn(boolean bl) {
        if (bl != this.promptForLockOn) {
            this.promptForLockOn = bl;
            VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(PROMPT_FOR_LOCK_ON);
            if (vcsConfigVariable == null) {
                vcsConfigVariable = new VcsConfigVariable(PROMPT_FOR_LOCK_ON, null, "", false, false, false, null);
                this.variables.add(vcsConfigVariable);
                this.variablesByName.put(vcsConfigVariable.getName(), vcsConfigVariable);
            }
            vcsConfigVariable.setValue(new Boolean(bl).toString());
            this.firePropertyChange(PROP_CALL_LOCK_PROMPT, new Boolean(!this.promptForLockOn), new Boolean(this.promptForLockOn));
        }
    }

    public boolean getAskIfDownloadRecursively() {
        return this.askIfDownloadRecursively;
    }

    public void setAskIfDownloadRecursively(boolean bl) {
        this.askIfDownloadRecursively = bl;
    }

    public boolean isCallEditFilesOn() {
        return this.callEditFilesOn && this.isEnabledEditFiles();
    }

    public void setCallEditFilesOn(boolean bl) {
        if (bl != this.callEditFilesOn) {
            this.callEditFilesOn = bl;
            VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(EDIT_FILES_ON);
            if (vcsConfigVariable == null) {
                vcsConfigVariable = new VcsConfigVariable(EDIT_FILES_ON, null, "", false, false, false, null);
                this.variables.add(vcsConfigVariable);
                this.variablesByName.put(vcsConfigVariable.getName(), vcsConfigVariable);
            }
            vcsConfigVariable.setValue(new Boolean(bl).toString());
            this.firePropertyChange(PROP_CALL_EDIT, new Boolean(!this.callEditFilesOn), new Boolean(this.callEditFilesOn));
        }
    }

    public boolean isPromptForEditOn() {
        return this.promptForEditOn;
    }

    public void setPromptForEditOn(boolean bl) {
        if (bl != this.promptForEditOn) {
            this.promptForEditOn = bl;
            VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(PROMPT_FOR_EDIT_ON);
            if (vcsConfigVariable == null) {
                vcsConfigVariable = new VcsConfigVariable(PROMPT_FOR_EDIT_ON, null, "", false, false, false, null);
                this.variables.add(vcsConfigVariable);
                this.variablesByName.put(vcsConfigVariable.getName(), vcsConfigVariable);
            }
            vcsConfigVariable.setValue(new Boolean(bl).toString());
            this.firePropertyChange(PROP_CALL_EDIT_PROMPT, new Boolean(!this.promptForEditOn), new Boolean(this.promptForEditOn));
        }
    }

    public boolean isUseUnixShell() {
        return this.useUnixShell;
    }

    public boolean isEnabledLockFiles() {
        return this.getCommand("LOCK") != null;
    }

    public boolean isEnabledEditFiles() {
        return this.getCommand("EDIT") != null;
    }

    protected void setUseUnixShell(boolean bl) {
        if (bl != this.useUnixShell) {
            this.useUnixShell = bl;
            last_useUnixShell = bl;
            this.firePropertyChange(PROP_USE_UNIX_SHELL, new Boolean(!bl), new Boolean(bl));
        }
    }

    public void setAcceptUserParams(boolean bl) {
        this.acceptUserParams = bl;
    }

    public boolean isAcceptUserParams() {
        return this.acceptUserParams;
    }

    public void setUserLocalParamsLabels(String[] stringArray) {
        this.userLocalParamsLabels = stringArray;
    }

    public String[] getUserLocalParamsLabels() {
        return this.userLocalParamsLabels;
    }

    public void setUserParamsLabels(String[] stringArray) {
        this.userParamsLabels = stringArray;
        this.userParams = new String[stringArray.length];
    }

    public String[] getUserParamsLabels() {
        return this.userParamsLabels;
    }

    public void setUserParams(String[] stringArray) {
        this.userParams = stringArray;
    }

    public String[] getUserParams() {
        return this.userParams;
    }

    public void setExpertMode(boolean bl) {
        if (bl != this.expertMode) {
            this.expertMode = bl;
            this.setAcceptUserParams(bl);
            this.firePropertyChange(PROP_EXPERT_MODE, new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void setCommandNotification(boolean bl) {
        if (bl != this.commandNotification) {
            this.commandNotification = bl;
            this.firePropertyChange(PROP_COMMAND_NOTIFICATION, new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isCommandNotification() {
        return this.commandNotification;
    }

    public void setPromptForVarsForEachFile(boolean bl) {
        if (this.promptForVarsForEachFile != bl) {
            this.promptForVarsForEachFile = bl;
            this.firePropertyChange(PROP_PROMPT_FOR_VARS_FOR_EACH_FILE, new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isPromptForVarsForEachFile() {
        return this.promptForVarsForEachFile;
    }

    public CommandsPool getCommandsPool() {
        return this.commandsPool;
    }

    public void setProcessUnimportantFiles(boolean bl) {
        boolean bl2 = false;
        Boolean bl3 = null;
        Boolean bl4 = this.processUnimportantFiles;
        synchronized (bl4) {
            if (bl != this.processUnimportantFiles) {
                bl3 = this.processUnimportantFiles;
                this.processUnimportantFiles = new Boolean(bl);
                bl2 = true;
            }
        }
        if (bl2) {
            this.firePropertyChange(PROP_PROCESS_UNIMPORTANT_FILES, bl3, this.processUnimportantFiles);
        }
    }

    public boolean isProcessUnimportantFiles() {
        Boolean bl = this.processUnimportantFiles;
        synchronized (bl) {
            boolean bl2 = this.processUnimportantFiles;
            return bl2;
        }
    }

    public String getIgnoredGarbageFiles() {
        return this.ignoredGarbageFiles;
    }

    public synchronized void setIgnoredGarbageFiles(String string) throws IllegalArgumentException {
        if (!string.equals(this.ignoredGarbageFiles)) {
            if (string.length() > 0) {
                try {
                    this.ignoredGarbageRE = new RE(string);
                }
                catch (RESyntaxException rESyntaxException) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                    TopManager.getDefault().getErrorManager().annotate((Throwable)illegalArgumentException, (Throwable)rESyntaxException);
                    throw illegalArgumentException;
                }
            } else {
                this.ignoredGarbageRE = null;
            }
            this.ignoredGarbageFiles = string;
            this.firePropertyChange(PROP_IGNORED_GARBAGE_FILES, null, null);
            this.refreshExistingFolders();
        }
    }

    public void numOfFinishedCmdsToCollectChanged() {
        this.firePropertyChange("numOfFinishedCmdsToCollect", null, null);
    }

    protected void refreshExistingFolders() {
        this.refreshExistingFolders(null);
    }

    protected void refreshExistingFolders(final String string) {
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                FileObject fileObject = string == null ? VcsFileSystem.this.getRoot() : VcsFileSystem.this.findResource(string);
                if (fileObject == null) {
                    return;
                }
                Enumeration enumeration = VcsFileSystem.super.existingFileObjects(fileObject);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    if (!fileObject2.isFolder()) continue;
                    fileObject2.refresh(true);
                }
            }
        });
    }

    protected boolean isCreateBackupFilesSet() {
        return this.createBackupFiles != null;
    }

    public boolean isCreateBackupFiles() {
        return this.createBackupFiles != null && this.createBackupFiles != false;
    }

    public void setCreateBackupFiles(boolean bl) {
        if (!new Boolean(bl).equals(this.createBackupFiles)) {
            this.createBackupFiles = new Boolean(bl);
            this.firePropertyChange(PROP_CREATE_BACKUP_FILES, null, this.createBackupFiles);
        }
    }

    protected boolean isFilterBackupFilesSet() {
        return this.filterBackupFiles != null;
    }

    public boolean isFilterBackupFiles() {
        return this.filterBackupFiles != null && this.filterBackupFiles != false;
    }

    public void setFilterBackupFiles(boolean bl) {
        if (!new Boolean(bl).equals(this.filterBackupFiles)) {
            this.filterBackupFiles = new Boolean(bl);
            this.firePropertyChange(PROP_FILTER_BACKUP_FILES, null, this.filterBackupFiles);
        }
    }

    public void setOffLine(boolean bl) {
        if (bl != this.offLine) {
            this.offLine = bl;
            this.firePropertyChange("offLine", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isOffLine() {
        return this.offLine;
    }

    public int getAutoRefresh() {
        return this.autoRefresh;
    }

    public void setAutoRefresh(int n) {
        if (n != this.autoRefresh) {
            int n2 = this.autoRefresh;
            this.autoRefresh = n;
            this.firePropertyChange("autoRefresh", new Integer(n2), new Integer(this.autoRefresh));
        }
    }

    public boolean isHideShadowFiles() {
        return this.hideShadowFiles;
    }

    public void setHideShadowFiles(boolean bl) {
        if (bl != this.hideShadowFiles) {
            this.hideShadowFiles = bl;
            this.firePropertyChange("hideShadowFiles", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isShowDeadFiles() {
        VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get("SHOW_DEAD_FILES");
        if (vcsConfigVariable == null) {
            return false;
        }
        return vcsConfigVariable.getValue().trim().length() > 0;
    }

    public void setShowDeadFiles(boolean bl) {
        VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get("SHOW_DEAD_FILES");
        if (vcsConfigVariable == null) {
            if (bl) {
                vcsConfigVariable = new VcsConfigVariable("SHOW_DEAD_FILES", null, VAR_TRUE, false, false, false, null);
                VcsFileSystem vcsFileSystem = this;
                synchronized (vcsFileSystem) {
                    this.variablesByName.put("SHOW_DEAD_FILES", vcsConfigVariable);
                    this.variables.add(vcsConfigVariable);
                }
            }
        } else {
            vcsConfigVariable.setValue(bl ? VAR_TRUE : "");
        }
    }

    public int getNumberOfFinishedCmdsToCollect() {
        return RuntimeSupport.getInstance().getCollectFinishedCmdsNum(this.getSystemName());
    }

    public void setNumberOfFinishedCmdsToCollect(int n) {
        this.numberOfFinishedCmdsToCollect = new Integer(n);
        RuntimeSupport.getInstance().setCollectFinishedCmdsNum(n, this.getSystemName());
    }

    public int getVFSMessageLength() {
        return this.versioningFileSystemMessageLength;
    }

    public void setVFSMessageLength(int n) {
        this.versioningFileSystemMessageLength = n;
    }

    public boolean getVFSShowLocalFiles() {
        return this.versioningFileSystemShowLocalFiles;
    }

    public void setVFSShowLocalFiles(boolean bl) {
        this.versioningFileSystemShowLocalFiles = bl;
    }

    public boolean getVFSShowMessage() {
        return this.versioningFileSystemShowMessage;
    }

    public void setVFSShowMessage(boolean bl) {
        this.versioningFileSystemShowMessage = bl;
    }

    public boolean getVFSShowUnimportantFiles() {
        return this.versioningFileSystemShowUnimportantFiles;
    }

    public void setVFSShowUnimportantFiles(boolean bl) {
        this.versioningFileSystemShowUnimportantFiles = bl;
    }

    public String getVFSShowGarbageFiles() {
        return this.versioningFileSystemShowGarbageFiles;
    }

    public void setVFSShowGarbageFiles(String string) {
        this.versioningFileSystemShowGarbageFiles = string;
    }

    public boolean getVFSShowDeadFiles() {
        return this.versioningFileSystemShowDeadFiles;
    }

    public void setVFSShowDeadFiles(boolean bl) {
        this.versioningFileSystemShowDeadFiles = bl;
    }

    private void copyFromVersioningFs() {
        if (this.versioningSystem != null && this.versioningSystem instanceof VcsVersioningSystem) {
            VcsVersioningSystem vcsVersioningSystem = (VcsVersioningSystem)this.versioningSystem;
            this.setVFSMessageLength(vcsVersioningSystem.getMessageLength());
            this.setVFSShowGarbageFiles(vcsVersioningSystem.getIgnoredGarbageFiles());
            this.setVFSShowLocalFiles(vcsVersioningSystem.isShowLocalFiles());
            this.setVFSShowMessage(vcsVersioningSystem.isShowMessages());
            this.setVFSShowUnimportantFiles(vcsVersioningSystem.isShowUnimportantFiles());
            this.setVFSShowDeadFiles(vcsVersioningSystem.isShowDeadFiles());
        }
    }

    public void saveVersioningFileSystemProperties(String string, Object object) {
        this.copyFromVersioningFs();
        this.firePropertyChange(string, null, object);
    }

    public void addRevisionListener(RevisionListener revisionListener) {
        if (this.revisionListeners == null) {
            this.revisionListeners = new ArrayList();
        }
        this.revisionListeners.add(revisionListener);
    }

    public boolean removeRevisionListener(RevisionListener revisionListener) {
        if (this.revisionListeners == null) {
            return false;
        }
        return ((AbstractCollection)this.revisionListeners).remove(revisionListener);
    }

    public void fireRevisionsChanged(RevisionEvent revisionEvent) {
        if (this.revisionListeners == null) {
            return;
        }
        Iterator iterator = ((AbstractList)this.revisionListeners).iterator();
        while (iterator.hasNext()) {
            ((RevisionListener)iterator.next()).stateChanged(revisionEvent);
        }
    }

    protected void setNotModifiableStatuses(Collection collection) {
        this.notModifiableStatuses = collection;
        this.firePropertyChange(PROP_NOT_MODIFIABLE_STATUSES, null, collection);
    }

    protected void setMissingFileStatus(String string) {
        this.missingFileStatus = string;
    }

    protected void setMissingFolderStatus(String string) {
        this.missingFolderStatus = string;
    }

    protected void setNotMissingableFileStatuses(Collection collection) {
        this.notMissingableFileStatuses = collection;
    }

    protected void setNotMissingableFolderStatuses(Collection collection) {
        this.notMissingableFolderStatuses = collection;
    }

    public boolean getDoAutoRefresh(String string) {
        Hashtable hashtable = this.numDoAutoRefreshes;
        synchronized (hashtable) {
            this.D.deb("getDoAutoRefresh(" + string + ") ...");
            int n = this.getNumDoAutoRefresh(string);
            if (n > 0) {
                if (--n > 0) {
                    this.setNumDoAutoRefresh(n, string);
                } else {
                    this.removeNumDoAutoRefresh(string);
                }
                this.D.deb("  return " + (n == 0));
                boolean bl = n == 0;
                return bl;
            }
            this.D.deb("  return true");
            boolean bl = true;
            return bl;
        }
    }

    public void setNumDoAutoRefresh(int n, String string) {
        Hashtable hashtable = this.numDoAutoRefreshes;
        synchronized (hashtable) {
            this.D.deb("setNumDoAutoRefresh(" + n + ", " + string + ")");
            this.numDoAutoRefreshes.put(string, new Integer(n));
        }
    }

    public int getNumDoAutoRefresh(String string) {
        Hashtable hashtable = this.numDoAutoRefreshes;
        synchronized (hashtable) {
            Integer n = (Integer)this.numDoAutoRefreshes.get(string);
            int n2 = 0;
            if (n != null) {
                n2 = n;
            }
            this.D.deb("getNumDoAutoRefresh(" + string + ") = " + n2);
            int n3 = n2;
            return n3;
        }
    }

    public void removeNumDoAutoRefresh(String string) {
        if (string == null) {
            return;
        }
        Hashtable hashtable = this.numDoAutoRefreshes;
        synchronized (hashtable) {
            this.D.deb("removeNumDoAutoRefresh(" + string + ")");
            this.numDoAutoRefreshes.remove(string);
        }
    }

    protected final synchronized void setVcsRefreshTime(int n) {
        if (this.refresher != null) {
            this.refresher.stop();
        }
        this.refresher = n <= 0 || System.getProperty("netbeans.debug.heap") != null ? null : new VcsRefreshRequest(this, n, this);
    }

    protected final int getVcsRefreshTime() {
        VcsRefreshRequest vcsRefreshRequest = this.refresher;
        return vcsRefreshRequest == null ? 0 : vcsRefreshRequest.getRefreshTime();
    }

    public Enumeration getExistingFolders() {
        return this.existingFileObjects(this.getRoot());
    }

    public void doVirtualsRefresh(FileObject fileObject) {
        fileObject.refresh();
        if (fileObject.isFolder()) {
            Enumeration enumeration = this.existingFileObjects(fileObject);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (fileObject2 != null && (fileObject2.getParent() == null || !fileObject2.getParent().equals(fileObject))) break;
                if (fileObject2.isFolder()) continue;
                this.setVirtualDataLoader(fileObject2);
            }
        }
    }

    public String getFSRoot() {
        return VcsFileSystem.substractRootDir(this.getRootDirectory().toString(), this.getRelativeMountPoint());
    }

    public synchronized String getRelativeMountPoint() {
        Hashtable hashtable = this.variablesByName;
        VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)hashtable.get("MODULE");
        if (vcsConfigVariable == null) {
            return "";
        }
        return vcsConfigVariable.getValue();
    }

    public void setRelativeMountPoint(final String string) throws PropertyVetoException, IOException {
        this.runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                2 var1_1 = this;
                synchronized (var1_1) {
                    Hashtable hashtable = VcsFileSystem.this.variablesByName;
                    String string3 = VcsFileSystem.this.getFSRoot();
                    VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)hashtable.get("MODULE");
                    if (vcsConfigVariable != null && string.equals(vcsConfigVariable.getValue())) {
                        return;
                    }
                    if (vcsConfigVariable == null) {
                        vcsConfigVariable = new VcsConfigVariable("MODULE", "", string, false, false, false, null);
                        VcsFileSystem.this.variables.add(vcsConfigVariable);
                        VcsFileSystem.this.variablesByName.put("MODULE", vcsConfigVariable);
                    }
                    String string2 = vcsConfigVariable.getValue();
                    vcsConfigVariable.setValue(string);
                    try {
                        VcsFileSystem.this.setRootDirectory(new File(string3));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        vcsConfigVariable.setValue(string2);
                        throw (IOException)TopManager.getDefault().getErrorManager().annotate((Throwable)new IOException(), (Throwable)propertyVetoException);
                    }
                    catch (IOException iOException) {
                        vcsConfigVariable.setValue(string2);
                        throw iOException;
                    }
                }
            }
        });
    }

    public void markUnimportant(String string) {
        Reference reference = this.findReference(string);
        if (reference != null && reference instanceof CacheReference) {
            ((CacheReference)reference).markUnimportant();
        } else {
            this.unimportantFiles.add(string);
        }
    }

    public void markImportant(String string, boolean bl) {
        FileChangeListener fileChangeListener;
        FileObject fileObject;
        FileObject fileObject2;
        Reference reference = this.findReference(string);
        if (reference != null && reference instanceof CacheReference) {
            if (bl) {
                ((CacheReference)reference).markImportant();
            } else {
                ((CacheReference)reference).markUnimportant();
            }
        } else if (bl) {
            this.unimportantFiles.remove(string);
        } else {
            this.unimportantFiles.add(string);
        }
        if (this.versioningFolderListeners != null && (fileObject2 = this.findResource(string)) != null && (fileObject = fileObject2.getParent()) != null && (fileChangeListener = (FileChangeListener)this.versioningFolderListeners.get(fileObject)) != null) {
            fileChangeListener.fileChanged(null);
        }
    }

    public boolean isImportant(String string) {
        Reference reference = this.findReference(string);
        if (reference != null && reference instanceof CacheReference) {
            return ((CacheReference)reference).isImportant();
        }
        return !this.unimportantFiles.contains(string);
    }

    public static RequestProcessor getStatusChangeRequestProcessor() {
        Object object = STATUS_REQUEST_PROCESSOR_LOCK;
        synchronized (object) {
            if (statusRequestProcessor == null) {
                statusRequestProcessor = new RequestProcessor("VCS Status Update Request Processor");
            }
        }
        return statusRequestProcessor;
    }

    public void statusChanged(final String string, final boolean bl) {
        VcsFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fileObject;
                FileObject fileObject2 = VcsFileSystem.this.findResource(string);
                if (fileObject2 == null) {
                    return;
                }
                Enumeration enumeration = VcsFileSystem.super.existingFileObjects(fileObject2);
                HashSet hashSet = new HashSet();
                if (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
                while (enumeration.hasMoreElements()) {
                    fileObject = (FileObject)enumeration.nextElement();
                    if (!fileObject2.equals(fileObject.getParent()) && !bl) break;
                    hashSet.add(fileObject);
                }
                fileObject = Collections.synchronizedSet(hashSet);
                VcsFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VcsFileSystem.this, (Set)fileObject, true, true));
                VcsFileSystem.this.checkScheduledStates((Set)fileObject);
                VcsFileSystem.this.checkVirtualFiles((Set)fileObject);
            }
        });
        if (this.versioningSystem != null) {
            this.versioningSystem.statusChanged(string, bl);
        }
    }

    public void statusChanged(final String string) {
        VcsFileSystem.getStatusChangeRequestProcessor().post(new Runnable(){

            public void run() {
                FileObject fileObject = VcsFileSystem.this.findExistingResource(string);
                if (fileObject == null) {
                    return;
                }
                VcsFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VcsFileSystem.this, fileObject, true, true));
                Set<FileObject> set = Collections.singleton(fileObject);
                VcsFileSystem.this.checkScheduledStates(set);
                VcsFileSystem.this.checkVirtualFiles(set);
            }
        });
        if (this.versioningSystem != null) {
            this.versioningSystem.statusChanged(string);
        }
    }

    protected FileObject findExistingResource(String string) {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        FileObject fileObject = null;
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!string.equals(fileObject2.getPackageNameExt('/', '.'))) continue;
            fileObject = fileObject2;
            break;
        }
        return fileObject;
    }

    private void checkScheduledStates(Set set) {
        FileStatusProvider fileStatusProvider = this.getStatusProvider();
        if (fileStatusProvider == null) {
            return;
        }
        VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(VAR_STATUS_SCHEDULED_ADD);
        String string = vcsConfigVariable != null ? vcsConfigVariable.getValue() : null;
        vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(VAR_STATUS_SCHEDULED_REMOVE);
        String string2 = vcsConfigVariable != null ? vcsConfigVariable.getValue() : null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            String string3 = (String)fileObject.getAttribute("VCS_SCHEDULED_FILE");
            if (!"ADD".equals(string3) || string == null || string.equals(fileStatusProvider.getFileStatus(fileObject.getPackageNameExt('/', '.'))) || !this.isSchedulingDone(fileObject.getPackageNameExt('/', '.'))) continue;
            try {
                fileObject.setAttribute("VCS_SCHEDULED_FILE", null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            VcsFileSystem.removeScheduledFromPrimary(fileObject, 1);
        }
    }

    private static void removeScheduledFromPrimary(FileObject fileObject, int n) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        FileObject fileObject2 = dataObject.getPrimaryFile();
        Set[] setArray = (Set[])fileObject2.getAttribute("VCS_SCHEDULED_FILES");
        if (setArray != null && setArray[n] != null) {
            setArray[n].remove(fileObject.getPackageNameExt('/', '.'));
            setArray = VcsFileSystem.cleanScheduledAttrs(setArray);
            try {
                fileObject2.setAttribute("VCS_SCHEDULED_FILES", (Object)setArray);
                if (setArray == null) {
                    fileObject2.setAttribute("VCS_SCHEDULING_MASTER_FILE_NAME", null);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void removeScheduledFromPrimary(String string, String string2, int n) {
        Set[] setArray = (Set[])this.attr.readAttribute(string2, "VCS_SCHEDULED_FILES");
        if (setArray != null && setArray[n] != null) {
            setArray[n].remove(string);
            setArray = VcsFileSystem.cleanScheduledAttrs(setArray);
            try {
                this.attr.writeAttribute(string2, "VCS_SCHEDULED_FILES", (Object)setArray);
                if (setArray == null) {
                    this.attr.writeAttribute(string2, "VCS_SCHEDULING_MASTER_FILE_NAME", null);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void disableRefresh() {
        VcsFileSystem vcsFileSystem = this;
        synchronized (vcsFileSystem) {
            this.refreshTimeToSet = this.getVcsRefreshTime();
            this.setVcsRefreshTime(0);
        }
    }

    public void enableRefresh() {
        VcsFileSystem vcsFileSystem = this;
        synchronized (vcsFileSystem) {
            this.setVcsRefreshTime(this.refreshTimeToSet);
        }
    }

    public void setRefreshTimeToSet() {
        this.setVcsRefreshTime(this.refreshTimeToSet);
    }

    public void setCustomRefreshTime(int n) {
        if (this.isValid()) {
            this.D.deb("Filesystem valid, setting the refresh time to " + n);
            this.setVcsRefreshTime(n);
        } else {
            this.D.deb("Filesystem not valid yet for refresh time " + n);
            this.refreshTimeToSet = n;
        }
        last_refreshTime = n;
    }

    public int getCustomRefreshTime() {
        if (this.isValid()) {
            return this.getVcsRefreshTime();
        }
        return this.refreshTimeToSet;
    }

    public void setZeroRefreshTime() {
        this.setVcsRefreshTime(0);
    }

    public void debugClear() {
        if (this.getDebug()) {
            try {
                TopManager.getDefault().getStdOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void debug(String string) {
        if (this.getDebug()) {
            TopManager.getDefault().getStdOut().println(string);
        }
    }

    public void debugErr(String string) {
        TopManager.getDefault().getStdOut().println(string);
    }

    static void addCreateIgnoreList(FileObject fileObject) {
        ArrayList arrayList = createIgnoreListQueue;
        synchronized (arrayList) {
            if (createIgnoreListQueue == null) {
                createIgnoreListQueue = new ArrayList();
            }
            createIgnoreListQueue.add(fileObject);
            createIgnoreListQueue.notifyAll();
            if (ignoreListCreationThread == null || !ignoreListCreationThread.isAlive()) {
                ignoreListCreationThread = VcsFileSystem.createIgnoreListCreationThread();
                ignoreListCreationThread.start();
            }
        }
    }

    private static void waitForIgnoreListToCreate() {
        ArrayList arrayList = createIgnoreListQueue;
        synchronized (arrayList) {
            try {
                createIgnoreListQueue.wait(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static Thread createIgnoreListCreationThread() {
        return new Thread(new Runnable(){

            public void run() {
                while (true) {
                    if (createIgnoreListQueue.size() > 0) {
                        FileObject fileObject = (FileObject)createIgnoreListQueue.remove(0);
                        FileSystem fileSystem = null;
                        try {
                            fileSystem = fileObject.getFileSystem();
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {
                            // empty catch block
                        }
                        VcsFileSystem vcsFileSystem = null;
                        if (fileSystem == null || !(fileSystem instanceof VcsFileSystem)) {
                            if (!(fileSystem instanceof VcsVersioningSystem)) continue;
                            vcsFileSystem = (VcsFileSystem)((VcsVersioningSystem)fileSystem).getFileSystem();
                        } else {
                            vcsFileSystem = (VcsFileSystem)fileSystem;
                        }
                        IgnoreListSupport ignoreListSupport = vcsFileSystem.getIgnoreListSupport();
                        String string = fileObject.getPackageNameExt('/', '.');
                        vcsFileSystem.createIgnoreList(fileObject, string, ignoreListSupport);
                        continue;
                    }
                    VcsFileSystem.waitForIgnoreListToCreate();
                    if (createIgnoreListQueue.size() <= 0) break;
                }
            }
        }, "VCS Ignore List Creation Thread");
    }

    protected Reference createReference(FileObject fileObject) {
        if (this.cache != null) {
            String string;
            Reference reference = this.cache.createReference(fileObject);
            IgnoreListSupport ignoreListSupport = this.getIgnoreListSupport();
            if (ignoreListSupport != null && this.cache.isDir(string = fileObject.getPackageNameExt('/', '.'))) {
                VcsFileSystem.addCreateIgnoreList(fileObject);
            }
            return reference;
        }
        return super.createReference(fileObject);
    }

    protected CacheReference getCacheReference(String string) {
        Reference reference = this.findReference(string);
        if (reference != null && reference instanceof CacheReference) {
            CacheReference cacheReference = (CacheReference)reference;
            return cacheReference;
        }
        return null;
    }

    private void createIgnoreList(FileObject fileObject, String string, IgnoreListSupport ignoreListSupport) {
        CacheDir cacheDir = this.cache.getDir(string);
        if (cacheDir == null || cacheDir.isIgnoreListSet()) {
            return;
        }
        cacheDir.setIgnoreList(VcsUtilities.createIgnoreList(cacheDir, string, ignoreListSupport));
        Enumeration enumeration = this.existingFileObjects(fileObject);
        if (!enumeration.hasMoreElements()) {
            return;
        }
        enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            this.statusChanged(string, false);
        } else {
            this.statusChanged(string);
        }
    }

    public FileCacheProvider getCacheProvider() {
        return this.cache;
    }

    public FileStatusProvider getStatusProvider() {
        return this.statusProvider;
    }

    public void setCache(FileCacheProvider fileCacheProvider) {
        this.cache = fileCacheProvider;
    }

    public abstract String getCacheFileName(String var1);

    public String initCacheIdStr() {
        return DEFAULT_CACHE_ID + new Object().hashCode();
    }

    public String getCacheIdStr() {
        VcsFileSystem vcsFileSystem = this;
        synchronized (vcsFileSystem) {
            if (this.cacheID == null) {
                this.cacheID = this.initCacheIdStr();
                this.firePropertyChange("cacheID", null, this.cacheID);
            }
        }
        return this.cacheID;
    }

    public VcsFactory getVcsFactory() {
        if (this.factory == null) {
            VcsFileSystem vcsFileSystem = this;
            synchronized (vcsFileSystem) {
                if (this.factory == null) {
                    this.factory = new DefaultVcsFactory(this);
                }
            }
        }
        return this.factory;
    }

    protected void init() {
        this.D.deb("init()");
        if (this.tempFiles == null) {
            this.tempFiles = new Vector();
        }
        this.unimportantFiles = Collections.synchronizedSet(new HashSet());
        this.cache = this.getVcsFactory().getFileCacheProvider();
        this.statusProvider = this.getVcsFactory().getFileStatusProvider();
        if (this.possibleFileStatusesMap == null) {
            this.possibleFileStatusesMap = this.statusProvider != null ? this.statusProvider.getPossibleFileStatusesTable() : new HashMap();
        }
        if (this.statusIconMap == null) {
            this.statusIconMap = this.statusProvider != null ? this.statusProvider.getStatusIconMap() : new HashMap();
        }
        try {
            this.setInitRootDirectory(this.rootFile);
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.multiFilesAnnotationTypes == null) {
            this.multiFilesAnnotationTypes = RefreshCommandSupport.DEFAULT_MULTI_FILES_ANNOTATION_TYPES;
        }
        if (this.annotationPattern == null) {
            this.annotationPattern = "${fileName}$[? status] [ [${status}$[? revision] [; ${revision}] []]] [$[? revision] [ ${revision}] []]$[? locker][ (${locker})] []$[? sticky][ (${sticky})] []";
        }
        if (this.notModifiableStatuses == null) {
            this.notModifiableStatuses = Collections.EMPTY_SET;
        }
        if (this.createRuntimeCommands == null) {
            this.createRuntimeCommands = Boolean.TRUE;
        }
        if (this.createVersioningSystem == null) {
            this.createVersioningSystem = Boolean.FALSE;
        }
        this.commandsPool = CommandsPool.getInstance();
        if (this.numberOfFinishedCmdsToCollect == null) {
            this.numberOfFinishedCmdsToCollect = new Integer(20);
        }
        RuntimeSupport.getInstance().setCollectFinishedCmdsNum(this.numberOfFinishedCmdsToCollect, this.getSystemName());
        if (this.varValueAdjustment == null) {
            this.varValueAdjustment = new VariableValueAdjustment();
        }
        this.initListeners();
    }

    private void initListeners() {
        this.settingsChangeListener = new SettingsPropertyChangeListener();
        GeneralVcsSettings generalVcsSettings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = VcsFileSystem.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        generalVcsSettings.addPropertyChangeListener(WeakListener.propertyChange((PropertyChangeListener)this.settingsChangeListener, (Object)((Object)generalVcsSettings)));
        this.addPropertyChangeListener(new FSPropertyChangeListener());
    }

    protected AbstractFileSystem.List getVcsList() {
        return this.vcsList;
    }

    protected AbstractFileSystem.Info getVcsInfo() {
        return this.info;
    }

    private void assignVersioningProperties(VcsVersioningSystem vcsVersioningSystem) {
        vcsVersioningSystem.setShowDeadFiles(this.versioningFileSystemShowDeadFiles);
        vcsVersioningSystem.setIgnoredGarbageFiles(this.versioningFileSystemShowGarbageFiles);
        vcsVersioningSystem.setShowLocalFiles(this.versioningFileSystemShowLocalFiles);
        vcsVersioningSystem.setShowMessages(this.versioningFileSystemShowMessage);
        vcsVersioningSystem.setShowUnimportantFiles(this.versioningFileSystemShowUnimportantFiles);
        vcsVersioningSystem.setMessageLength(this.versioningFileSystemMessageLength);
    }

    public void addNotify() {
        if (!this.isOffLine() && (this.getAutoRefresh() == 4 || this.deserialized && this.getAutoRefresh() == 3 || !this.deserialized && this.getAutoRefresh() == 2)) {
            CommandExecutorSupport.doRefresh(this, "", true);
        }
        super.addNotify();
        if (this.isCreateVersioningSystem()) {
            RequestProcessor.postRequest((Runnable)new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$vcscore$cache$CacheHandlerListener;

                public void run() {
                    if (VcsFileSystem.this.versioningSystem == null) {
                        FileSystemCache fileSystemCache;
                        VcsFileSystem.this.versioningSystem = new VcsVersioningSystem(VcsFileSystem.this);
                        VcsFileSystem.this.assignVersioningProperties((VcsVersioningSystem)VcsFileSystem.this.versioningSystem);
                        if (VcsFileSystem.this.cache != null && (fileSystemCache = CacheHandler.getInstance().getCache(VcsFileSystem.this.cache)) != null) {
                            fileSystemCache.addCacheHandlerListener((CacheHandlerListener)WeakListener.create((Class)(class$org$netbeans$modules$vcscore$cache$CacheHandlerListener == null ? (class$org$netbeans$modules$vcscore$cache$CacheHandlerListener = 6.class$("org.netbeans.modules.vcscore.cache.CacheHandlerListener")) : class$org$netbeans$modules$vcscore$cache$CacheHandlerListener), (EventListener)((CacheHandlerListener)((Object)VcsFileSystem.this.versioningSystem)), (Object)fileSystemCache));
                        }
                        VersioningRepository.getRepository().addVersioningFileSystem(VcsFileSystem.this.versioningSystem);
                    }
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
        this.enableRefresh();
    }

    public void removeNotify() {
        this.disableRefresh();
        super.removeNotify();
        if (this.versioningSystem != null) {
            RequestProcessor.postRequest((Runnable)new Runnable(){

                public void run() {
                    if (VcsFileSystem.this.versioningSystem == null) {
                        return;
                    }
                    VersioningRepository.getRepository().removeVersioningFileSystem(VcsFileSystem.this.versioningSystem);
                    try {
                        VcsFileSystem.this.runAtomicAction(new FileSystem.AtomicAction(this){
                            private final /* synthetic */ 7 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                if (VcsFileSystem.access$1300(7.access$1200(this.this$1)) != null) {
                                    Iterator<K> iterator = ((AbstractMap)VcsFileSystem.access$1300(7.access$1200(this.this$1))).keySet().iterator();
                                    while (iterator.hasNext()) {
                                        FileObject fileObject = (FileObject)iterator.next();
                                        FileChangeListener fileChangeListener = (FileChangeListener)VcsFileSystem.access$1300(7.access$1200(this.this$1)).get(fileObject);
                                        fileObject.removeFileChangeListener(fileChangeListener);
                                    }
                                    VcsFileSystem.access$1302(7.access$1200(this.this$1), null);
                                }
                                VcsFileSystem.access$1002(7.access$1200(this.this$1), null);
                            }
                        });
                    }
                    catch (IOException iOException) {
                        TopManager.getDefault().notifyException((Throwable)iOException);
                    }
                }

                static /* synthetic */ VcsFileSystem access$1200(7 var0) {
                    return var0.VcsFileSystem.this;
                }
            });
        }
    }

    protected void setCreateRuntimeCommands(boolean bl) {
        if (!new Boolean(bl).equals(this.createRuntimeCommands)) {
            this.createRuntimeCommands = new Boolean(bl);
            this.firePropertyChange(PROP_CREATE_RUNTIME_COMMANDS, null, this.createRuntimeCommands);
        }
    }

    public boolean isCreateRuntimeCommands() {
        return this.createRuntimeCommands;
    }

    protected void setCreateVersioningSystem(boolean bl) {
        if (!new Boolean(bl).equals(this.createVersioningSystem)) {
            this.createVersioningSystem = new Boolean(bl);
            this.firePropertyChange(PROP_CREATE_VERSIONING_EXPLORER, null, this.createVersioningSystem);
        }
    }

    protected boolean isCreateVersioningSystem() {
        return this.createVersioningSystem;
    }

    public VersioningFileSystem getVersioningFileSystem() {
        return this.versioningSystem;
    }

    protected VcsActionSupporter getVcsActionSupporter() {
        return this.actionSupporter;
    }

    protected VcsAttributes getVcsAttributes() {
        return (VcsAttributes)this.attr;
    }

    public VcsFileSystem() {
        this.D = this.E = new Debug("VcsFileSystem", false);
        this.refreshTimeToSet = 15000;
        this.commandsByName = null;
        this.rootFile = last_rootFile;
        this.useUnixShell = last_useUnixShell;
        this.variablesByName = new Hashtable();
        this.lockFilesOn = false;
        this.promptForLockOn = true;
        this.promptForEditOn = true;
        this.callEditFilesOn = true;
        this.debug = false;
        this.variables = new Vector(10);
        this.environmentVars = null;
        this.password = null;
        this.rememberPassword = false;
        this.advanced = null;
        this.commandsRoot = null;
        this.cacheID = null;
        this.cache = null;
        this.statusProvider = null;
        this.multiFilesAnnotationTypes = null;
        this.annotationPattern = null;
        this.action = null;
        this.factory = null;
        this.processUnimportantFiles = Boolean.FALSE;
        this.possibleFileStatusesMap = null;
        this.statusIconMap = null;
        this.statusIconDefault = null;
        this.ready = false;
        this.askIfDownloadRecursively = true;
        this.numDoAutoRefreshes = new Hashtable();
        this.promptForVarsForEachFile = false;
        this.tempFiles = new Vector();
        this.userParams = null;
        this.userParamsLabels = null;
        this.userLocalParamsLabels = null;
        this.acceptUserParams = false;
        this.expertMode = false;
        this.commandsPool = null;
        this.numberOfFinishedCmdsToCollect = new Integer(20);
        this.versioningFileSystemMessageLength = 20;
        this.versioningFileSystemShowMessage = true;
        this.versioningFileSystemShowGarbageFiles = "";
        this.versioningFileSystemShowLocalFiles = true;
        this.versioningFileSystemShowUnimportantFiles = false;
        this.versioningFileSystemShowDeadFiles = false;
        this.settingsChangeListener = null;
        this.commandNotification = true;
        this.notModifiableStatuses = Collections.EMPTY_SET;
        this.missingFileStatus = null;
        this.missingFolderStatus = null;
        this.notMissingableFileStatuses = Collections.EMPTY_SET;
        this.notMissingableFolderStatuses = Collections.EMPTY_SET;
        this.createRuntimeCommands = Boolean.TRUE;
        this.createVersioningSystem = Boolean.FALSE;
        this.actionSupporter = null;
        this.ignoreListSupport = null;
        this.ignoredGarbageFiles = "";
        this.ignoredGarbageRE = null;
        this.createBackupFiles = null;
        this.filterBackupFiles = null;
        this.versioningSystem = null;
        this.vcsList = null;
        this.deleteFileCommandQueue = new ArrayList();
        this.deleteFolderCommandQueue = new ArrayList();
        this.deleteCommandThread = null;
        this.D.deb("VcsFileSystem()");
        this.deserialized = false;
        this.info = this;
        this.change = this;
        this.actionSupporter = new VcsActionSupporter(this);
        VcsAttributes vcsAttributes = new VcsAttributes(this.info, this.change, this, this, this.actionSupporter);
        this.attr = vcsAttributes;
        this.list = vcsAttributes;
        this.vcsList = new VcsList();
        this.setRefreshTime(0);
        this.setVcsRefreshTime(0);
        this.refreshTimeToSet = last_refreshTime;
        GeneralVcsSettings generalVcsSettings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = VcsFileSystem.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        this.setOffLine(generalVcsSettings.isOffLine());
        this.setAutoRefresh(generalVcsSettings.getAutoRefresh());
        this.setHideShadowFiles(generalVcsSettings.isHideShadowFiles());
        this.init();
        this.D.deb("constructor done.");
    }

    public String[] getPossibleFileStatuses() {
        String[] stringArray;
        if (this.possibleFileStatusesMap == null) {
            return null;
        }
        HashMap hashMap = this.possibleFileStatusesMap;
        synchronized (hashMap) {
            stringArray = new String[this.possibleFileStatusesMap.size()];
            int n = 0;
            Iterator iterator = this.possibleFileStatusesMap.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (v instanceof String) {
                    stringArray[n] = (String)v;
                }
                ++n;
            }
        }
        this.D.deb("getPossibleFileStatuses() return = " + VcsUtilities.array2string(stringArray));
        return stringArray;
    }

    public HashMap getPossibleFileStatusesTable() {
        HashMap hashMap;
        if (this.possibleFileStatusesMap == null) {
            return null;
        }
        HashMap hashMap2 = this.possibleFileStatusesMap;
        synchronized (hashMap2) {
            hashMap = new HashMap(this.possibleFileStatusesMap);
        }
        return hashMap;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, NotActiveException {
        this.deserialized = true;
        boolean bl = objectInputStream.readBoolean();
        objectInputStream.defaultReadObject();
        this.actionSupporter = new VcsActionSupporter(this);
        if (!(this.attr instanceof VcsAttributes)) {
            VcsAttributes vcsAttributes = new VcsAttributes(this.info, this.change, this, this, this.actionSupporter);
            this.attr = vcsAttributes;
            this.list = vcsAttributes;
        } else {
            ((VcsAttributes)this.attr).setCurrentSupporter(this.actionSupporter);
        }
        if (this.vcsList == null) {
            this.vcsList = new VcsList();
        }
        last_refreshTime = this.getCustomRefreshTime();
        last_useUnixShell = this.useUnixShell;
        this.updateEnvironmentVars();
        this.init();
        if (this.ignoredGarbageFiles == null) {
            this.ignoredGarbageFiles = "";
        } else if (this.ignoredGarbageFiles.length() > 0) {
            try {
                this.ignoredGarbageRE = new RE(this.ignoredGarbageFiles);
            }
            catch (RESyntaxException rESyntaxException) {
                TopManager.getDefault().notifyException((Throwable)rESyntaxException);
            }
        }
        if (null == this.processUnimportantFiles) {
            this.processUnimportantFiles = Boolean.FALSE;
        }
        last_rootFile = new File(this.getFSRoot());
        this.setExpertMode(this.isAcceptUserParams());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.numberOfFinishedCmdsToCollect = new Integer(RuntimeSupport.getInstance().getCollectFinishedCmdsNum(this.getSystemName()));
        objectOutputStream.writeBoolean(true);
        String string = this.password;
        if (!this.rememberPassword) {
            this.password = null;
        }
        objectOutputStream.defaultWriteObject();
        this.password = string;
    }

    public void setDebug(boolean bl) {
        if (this.debug != bl) {
            this.debug = bl;
            this.firePropertyChange(PROP_DEBUG, new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public String[] getEnvironmentVars() {
        return this.environmentVars;
    }

    public void addEnvironmentVar(String string, String string2) {
        String[] stringArray = new String[this.environmentVars.length + 1];
        System.arraycopy(this.environmentVars, 0, stringArray, 0, this.environmentVars.length);
        stringArray[this.environmentVars.length] = string + "=" + string2;
        this.environmentVars = stringArray;
    }

    public void setEnvironmentVar(String string, String string2) {
        int n = 0;
        while (n < this.environmentVars.length) {
            block3: {
                String string3;
                block4: {
                    StringTokenizer stringTokenizer;
                    block2: {
                        stringTokenizer = new StringTokenizer(this.environmentVars[n], "=");
                        if (stringTokenizer.countTokens() == 2) break block2;
                        if (!this.environmentVars[n].endsWith("=")) break block3;
                        string3 = this.environmentVars[n].substring(0, this.environmentVars[n].length() - 1);
                        break block4;
                    }
                    string3 = stringTokenizer.nextToken();
                }
                if (string3.equals(string)) {
                    this.environmentVars[n] = string + "=" + string2;
                    return;
                }
            }
            ++n;
        }
        this.addEnvironmentVar(string, string2);
    }

    private void updateEnvironmentVars() {
        Map map = VcsUtilities.getSystemEnvVars();
        Map map2 = VcsUtilities.addEnvVars(map, this.getVariablesAsHashtable(), VAR_ENVIRONMENT_PREFIX, VAR_ENVIRONMENT_REMOVE_PREFIX);
        this.environmentVars = VcsUtilities.getEnvString(map2);
    }

    public Vector getVariables() {
        return this.variables;
    }

    public VariableValueAdjustment getVarValueAdjustment() {
        return this.varValueAdjustment;
    }

    public void variableChanged(String string) {
        this.firePropertyChange(PROP_VARIABLES, null, this.variables);
    }

    public void setVariables(Vector vector) {
        VcsConfigVariable vcsConfigVariable;
        boolean bl = false;
        int n = Utilities.getOperatingSystem();
        String string = Utilities.isWindows() && n != 2 && n != 4 ? "cd /D" : "cd";
        int n2 = vector.size();
        int n3 = 0;
        while (n3 < n2) {
            vcsConfigVariable = (VcsConfigVariable)vector.get(n3);
            if (vcsConfigVariable.getName().equalsIgnoreCase(LOCK_FILES_ON)) {
                if (vcsConfigVariable.getValue().equalsIgnoreCase(VAR_TRUE)) {
                    this.setLockFilesOn(true);
                }
                if (vcsConfigVariable.getValue().equalsIgnoreCase(VAR_FALSE)) {
                    this.setLockFilesOn(false);
                }
            }
            if (vcsConfigVariable.getName().equalsIgnoreCase(PROMPT_FOR_LOCK_ON)) {
                if (vcsConfigVariable.getValue().equalsIgnoreCase(VAR_TRUE)) {
                    this.setPromptForLockOn(true);
                }
                if (vcsConfigVariable.getValue().equalsIgnoreCase(VAR_FALSE)) {
                    this.setPromptForLockOn(false);
                }
            }
            if (vcsConfigVariable.getName().equalsIgnoreCase(EDIT_FILES_ON)) {
                if (vcsConfigVariable.getValue().equalsIgnoreCase(VAR_TRUE)) {
                    this.setCallEditFilesOn(true);
                }
                if (vcsConfigVariable.getValue().equalsIgnoreCase(VAR_FALSE)) {
                    this.setCallEditFilesOn(false);
                }
            }
            if (vcsConfigVariable.getName().equalsIgnoreCase(PROMPT_FOR_EDIT_ON)) {
                if (vcsConfigVariable.getValue().equalsIgnoreCase(VAR_TRUE)) {
                    this.setPromptForEditOn(true);
                }
                if (vcsConfigVariable.getValue().equalsIgnoreCase(VAR_FALSE)) {
                    this.setPromptForEditOn(false);
                }
            }
            if (vcsConfigVariable.getName().equals("CD")) {
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            vector.add(new VcsConfigVariable("CD", "cd", string, false, false, false, "", 0));
        }
        Vector vector2 = this.variables;
        VcsFileSystem vcsFileSystem = this;
        synchronized (vcsFileSystem) {
            this.variables = vector;
        }
        VcsConfigVariable vcsConfigVariable2 = (VcsConfigVariable)this.variablesByName.get("MODULE");
        HashMap<String, VcsConfigVariable> hashMap = new HashMap<String, VcsConfigVariable>();
        int n4 = 0;
        int n5 = vector.size();
        while (n4 < n5) {
            vcsConfigVariable = (VcsConfigVariable)vector.get(n4);
            hashMap.put(vcsConfigVariable.getName(), vcsConfigVariable);
            ++n4;
        }
        if (!hashMap.containsKey("MODULE") && vcsConfigVariable2 != null) {
            this.variables.add(vcsConfigVariable2);
            hashMap.put(vcsConfigVariable2.getName(), vcsConfigVariable2);
        }
        VcsFileSystem vcsFileSystem2 = this;
        synchronized (vcsFileSystem2) {
            this.variablesByName = new Hashtable(hashMap);
        }
        this.updateEnvironmentVars();
        this.varValueAdjustment.setAdjust(this.getVariablesAsHashtable());
        this.firePropertyChange(PROP_VARIABLES, vector2, vector);
        this.setAdjustedSystemName(this.computeSystemName(this.rootFile));
    }

    public static String substractRootDir(String string, String string2) {
        String string3;
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        String string4 = string2.charAt(string2.length() - 1) == File.separatorChar ? string2.substring(0, string2.length() - 1) : string2.substring(0);
        boolean bl = false;
        if (File.separatorChar != '/' && string.indexOf(File.separatorChar) > 0) {
            string3 = string.replace(File.separatorChar, '/');
            bl = true;
        } else {
            string3 = string;
        }
        String string5 = File.separatorChar != '/' && string4.indexOf(File.separatorChar) > 0 ? string4.replace(File.separatorChar, '/') : string4;
        int n = string3.lastIndexOf(string5);
        if (n <= 0) {
            return string;
        }
        if (bl) {
            return string.substring(0, n - 1).replace('/', File.separatorChar);
        }
        return string.substring(0, n - 1);
    }

    public synchronized Hashtable getVariablesAsHashtable() {
        Object object;
        int n = this.getVariables().size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n + 10);
        int n2 = 0;
        while (n2 < n) {
            object = (VcsConfigVariable)this.getVariables().elementAt(n2);
            hashtable.put(((VcsConfigVariable)object).getName(), ((VcsConfigVariable)object).getValue());
            ++n2;
        }
        hashtable.put("netbeans.home", System.getProperty("netbeans.home"));
        hashtable.put("netbeans.user", System.getProperty("netbeans.user"));
        hashtable.put("java.home", System.getProperty("java.home"));
        object = System.getProperty("os.name");
        hashtable.put("classpath.separator", File.pathSeparator);
        hashtable.put("path.separator", "" + File.separator);
        if (hashtable.get("PS") == null) {
            hashtable.put("PS", "" + File.separator);
        }
        String string = this.getRootDirectory().toString();
        String string2 = (String)hashtable.get("MODULE");
        hashtable.put("ROOTDIR", VcsFileSystem.substractRootDir(string, string2));
        hashtable.put(VAR_EXPERT_MODE, this.expertMode ? "expert" : "");
        return hashtable;
    }

    public String getQuoting() {
        VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(VAR_QUOTING);
        String string = null;
        if (vcsConfigVariable != null) {
            string = vcsConfigVariable.getValue();
        }
        if (string == null) {
            string = DEFAULT_QUOTING_VALUE;
        }
        return string;
    }

    public void setPassword(String string) {
        if (this.password == null && string != null || this.password != null && !this.password.equals(string)) {
            this.password = string;
            this.firePropertyChange(PROP_PASSWORD, null, string);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setRememberPassword(boolean bl) {
        if (this.rememberPassword != bl) {
            this.rememberPassword = bl;
            this.firePropertyChange(PROP_REMEMBER_PASSWORD, new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isRememberPassword() {
        return this.rememberPassword;
    }

    private void createTempPromptFiles(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            try {
                File file;
                File file2 = File.createTempFile(FILE_PROMPT_PREFIX, null);
                file2.deleteOnExit();
                this.tempFiles.add(file2);
                hashtable.put(string, file2.getAbsolutePath());
                if (string2.length() <= 0 || !(file = new File(string2)).exists() || !file.canRead()) continue;
                try {
                    FileWriter fileWriter = new FileWriter(file2);
                    FileReader fileReader = new FileReader(file);
                    char[] cArray = new char[500];
                    int n = 0;
                    while ((n = fileReader.read(cArray)) > 0) {
                        fileWriter.write(cArray, 0, n);
                    }
                    fileReader.close();
                    fileWriter.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    TopManager.getDefault().notifyException((Throwable)fileNotFoundException);
                }
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
            }
        }
    }

    public void removeTempFiles() {
        Enumeration enumeration = this.tempFiles.elements();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            boolean bl = file.delete();
        }
        this.tempFiles.removeAllElements();
    }

    public void filePromptDocumentCleanup(JTextArea jTextArea, int n, Object object) {
    }

    protected void warnDirectoriesDoNotExists() {
        File file;
        String string;
        String string2;
        Object object;
        this.D.deb("warnDirectoriesDoNotExists()");
        VcsFileSystem vcsFileSystem = this;
        synchronized (vcsFileSystem) {
            object = this.getVariablesAsHashtable();
            string2 = (String)((Hashtable)object).get("MODULE");
            if (string2 == null) {
                string2 = "";
            }
            string = VcsFileSystem.substractRootDir(this.getRootDirectory().toString(), string2);
            file = new File(string);
        }
        if (file == null || !file.isDirectory()) {
            this.D.deb("NOT DIRECTORY: " + file);
            object = file.toString();
            SwingUtilities.invokeLater(new Runnable((String)object){
                static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsFileSystem;
                private final /* synthetic */ String val$badDir;
                {
                    this.val$badDir = string;
                }

                public void run() {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$VcsFileSystem == null ? (class$org$netbeans$modules$vcscore$VcsFileSystem = 9.class$("org.netbeans.modules.vcscore.VcsFileSystem")) : class$org$netbeans$modules$vcscore$VcsFileSystem)).getString("Filesystem.notRootDirectory"), this.val$badDir)));
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
            return;
        }
        object = new File(file, string2);
        this.D.deb("moduleDir = " + object);
        if (object == null || !((File)object).isDirectory()) {
            this.D.deb("NOT DIRECTORY: " + object);
            string = string2;
            SwingUtilities.invokeLater(new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsFileSystem;

                public void run() {
                    TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$VcsFileSystem == null ? (class$org$netbeans$modules$vcscore$VcsFileSystem = 10.class$("org.netbeans.modules.vcscore.VcsFileSystem")) : class$org$netbeans$modules$vcscore$VcsFileSystem)).getString("Filesystem.notModuleDirectory"), string)));
                }

                static /* synthetic */ Class class$(String string2) {
                    try {
                        return Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
    }

    public String getAnnotationPattern() {
        return this.annotationPattern;
    }

    public void setAnnotationPattern(String string) {
        String string2 = this.annotationPattern;
        this.annotationPattern = string;
        this.firePropertyChange(PROP_ANNOTATION_PATTERN, string2, this.annotationPattern);
    }

    public int[] getMultiFileAnnotationTypes() {
        return this.multiFilesAnnotationTypes;
    }

    public void setMultiFileAnnotationTypes(int[] nArray) {
        if (this.multiFilesAnnotationTypes.length != 9) {
            throw new IllegalArgumentException("Wrong length of the array (" + nArray.length + " != " + 9 + ")");
        }
        int[] nArray2 = this.multiFilesAnnotationTypes;
        this.multiFilesAnnotationTypes = this.multiFilesAnnotationTypes;
        this.firePropertyChange(PROP_ANNOTATION_TYPES, nArray2, this.multiFilesAnnotationTypes);
    }

    public FileSystem.Status getStatus() {
        return this;
    }

    public String getStatus(FileObject fileObject) {
        String string;
        if (this.statusProvider != null) {
            String string2 = fileObject.getPackageNameExt('/', '.');
            string = this.statusProvider.getFileStatus(string2).trim();
        } else {
            string = "";
        }
        return string;
    }

    public String getStatus(DataObject dataObject) {
        Set set = dataObject.files();
        Object[] objectArray = set.toArray();
        int n = objectArray.length;
        if (n == 0) {
            return null;
        }
        if (this.statusProvider != null) {
            if (n == 1) {
                return RefreshCommandSupport.getStatusAnnotation("", ((FileObject)objectArray[0]).getPackageNameExt('/', '.'), "${status}", this.statusProvider);
            }
            return RefreshCommandSupport.getStatusAnnotation("", this.getImportantFiles(objectArray), "${status}", this.statusProvider, this.multiFilesAnnotationTypes);
        }
        return "";
    }

    public String getLocker(FileObject fileObject) {
        String string;
        if (this.statusProvider != null) {
            String string2 = fileObject.getPackageNameExt('/', '.');
            string = this.statusProvider.getFileLocker(string2).trim();
        } else {
            string = "";
        }
        return string;
    }

    Image annotateIcon(Image image, int n, String string) {
        String string2;
        if (this.statusProvider != null && (string2 = this.statusProvider.getFileStatus(string)) != null) {
            Image image2 = (Image)this.statusIconMap.get(string2);
            if (image2 == null) {
                image2 = this.statusIconDefault;
            }
            if (image2 != null) {
                image = Utilities.mergeImages((Image)image, (Image)image2, (int)16, (int)8);
            }
        }
        return image;
    }

    public Image annotateIcon(Image image, int n, Set set) {
        Object[] objectArray = set.toArray();
        int n2 = objectArray.length;
        if (n2 == 0) {
            return image;
        }
        if (this.statusProvider != null) {
            Object object;
            ArrayList arrayList = this.getImportantFiles(objectArray);
            n2 = arrayList.size();
            String string = null;
            if (n2 == 1) {
                object = (String)arrayList.get(0);
                if ("".equals(object)) {
                    return image;
                }
                string = this.statusProvider.getFileStatus((String)object);
            } else {
                object = ((AbstractList)arrayList).iterator();
                while (object.hasNext()) {
                    String string2 = (String)object.next();
                    String string3 = this.statusProvider.getFileStatus(string2);
                    if (string == null) {
                        string = string3;
                    }
                    if (string.equals(string3)) continue;
                    string = this.statusProvider.getNotInSynchStatus();
                    break;
                }
            }
            if (string != null) {
                object = (Image)this.statusIconMap.get(string);
                if (object == null) {
                    object = this.statusIconDefault;
                }
                if (object != null) {
                    image = Utilities.mergeImages((Image)image, (Image)object, (int)16, (int)8);
                }
            }
        }
        return image;
    }

    String annotateName(String string, String string2) {
        String string3 = this.statusProvider != null ? RefreshCommandSupport.getStatusAnnotation(string2, string, this.annotationPattern, this.statusProvider) : string2;
        return string3;
    }

    public String annotateName(String string) {
        FileObject fileObject = this.findResource(string);
        if (fileObject == null) {
            throw new IllegalArgumentException(string);
        }
        HashSet<FileObject> hashSet = new HashSet<FileObject>(1);
        hashSet.add(fileObject);
        String string2 = fileObject.getExt();
        String string3 = fileObject.getName();
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + "." + string2;
        }
        return this.annotateName(string3, Collections.synchronizedSet(hashSet));
    }

    public FileObject findFileObject(String string) {
        return this.findResource(string);
    }

    public String annotateDOName(String string) throws DataObjectNotFoundException {
        FileObject fileObject = this.findResource(string);
        if (fileObject == null) {
            throw new IllegalArgumentException(string);
        }
        DataObject dataObject = DataObject.find((FileObject)fileObject);
        return this.annotateName(fileObject.getName(), dataObject.files());
    }

    public String annotateName(String string, Set set) {
        String string2 = string;
        if (string2 == null) {
            return string2;
        }
        int n = set.size();
        if (n == 0 || string.indexOf(this.getRootDirectory().toString()) >= 0) {
            return string2;
        }
        if (this.statusProvider != null) {
            ArrayList arrayList = this.getImportantFiles(set.toArray());
            n = arrayList.size();
            if (n == 1) {
                String string3 = (String)arrayList.get(0);
                string2 = RefreshCommandSupport.getStatusAnnotation(string, string3, this.annotationPattern, this.statusProvider);
            } else {
                arrayList = VcsUtilities.reorderFileObjects(arrayList);
                string2 = RefreshCommandSupport.getStatusAnnotation(string, arrayList, this.annotationPattern, this.statusProvider, this.multiFilesAnnotationTypes);
            }
        }
        return string2;
    }

    private ArrayList getImportantFiles(Object[] objectArray) {
        ArrayList<Set[]> arrayList = new ArrayList<Set[]>();
        int n = objectArray.length;
        boolean bl = this.isProcessUnimportantFiles();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            FileObject fileObject = (FileObject)objectArray[n2];
            boolean bl2 = true;
            try {
                bl2 = fileObject.getFileSystem().equals(this);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                bl2 = true;
            }
            if (bl2) {
                object = fileObject.getPackageNameExt('/', '.');
                if (bl || this.isImportant((String)object)) {
                    arrayList.add((Set[])object);
                }
            } else {
                try {
                    if (fileObject.getFileSystem() instanceof VersioningFileSystem) {
                        object = fileObject.getPackageNameExt('/', '.');
                        arrayList.add((Set[])object);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if ((object = (Set[])fileObject.getAttribute("VCS_SCHEDULED_FILES")) != null && object[0] != null) {
                File file;
                String string = (String)fileObject.getAttribute("VCS_SCHEDULING_MASTER_FILE_NAME");
                if (string != null && (file = NbClassPath.toFile((FileObject)fileObject)) != null && !string.equals(file.getAbsolutePath())) {
                    try {
                        fileObject.setAttribute("VCS_SCHEDULING_MASTER_FILE_NAME", null);
                        fileObject.setAttribute("VCS_SCHEDULED_FILES", null);
                        object[0].clear();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                arrayList.addAll(object[0]);
            }
            ++n2;
        }
        return arrayList;
    }

    public SystemAction[] getActions() {
        return this.getVcsFactory().getActions(null);
    }

    public SystemAction[] getActions(Set set) {
        return this.getVcsFactory().getActions(set);
    }

    public String getDisplayName() {
        String string;
        Hashtable hashtable = this.getVariablesAsHashtable();
        String string2 = (String)hashtable.get(VAR_FS_DISPLAY_NAME_ANNOTATION);
        if (string2 != null) {
            string2 = this.statusProvider != null ? RefreshCommandSupport.getStatusAnnotation("", "", string2, this.statusProvider, hashtable) : Variables.expand(hashtable, string2, false);
            return string2;
        }
        VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(VAR_FS_DISPLAY_NAME);
        if (vcsConfigVariable != null) {
            return vcsConfigVariable.getValue() + " " + this.rootFile.toString();
        }
        if (this.commandsRoot != null && (string = this.commandsRoot.getDisplayName()) != null && string.length() > 0) {
            return string + " " + this.rootFile.toString();
        }
        return this.g("LAB_FileSystemValid", this.rootFile.toString());
    }

    private synchronized void setInitRootDirectory(File file) throws PropertyVetoException, IOException {
        int n;
        Hashtable hashtable = this.getVariablesAsHashtable();
        String string = (String)hashtable.get("MODULE");
        if (string == null) {
            string = "";
        }
        String string2 = file.getCanonicalPath();
        if (string.length() > 0 && (n = string2.lastIndexOf(string)) > 0) {
            string2 = string2.substring(0, n - 1);
        }
        file = new File(string2);
        this.setRootDirectory(file);
    }

    public synchronized void setRootDirectory(File file) throws PropertyVetoException, IOException {
        this.setRootDirectory(file, false);
    }

    protected final synchronized void setRootDirectory(File file, boolean bl) throws PropertyVetoException, IOException {
        if (file.isFile()) {
            throw new IOException(this.g("EXC_RootNotExist", file.toString()));
        }
        Hashtable hashtable = this.getVariablesAsHashtable();
        String string = (String)hashtable.get("MODULE");
        if (string == null) {
            string = "";
        }
        File file2 = new File(file, string);
        if (!bl && this.rootFile.equals(file2)) {
            return;
        }
        String string2 = this.computeSystemName(file2);
        this.D.deb("Setting system name '" + string2 + "'");
        this.setAdjustedSystemName(string2);
        this.rootFile = file2;
        last_rootFile = new File(this.getFSRoot());
        this.ready = true;
        if (this.cache != null) {
            this.cache.setFSRoot(file.getAbsolutePath());
            this.cache.setRelativeMountPoint(string);
        }
        this.firePropertyChange("root", null, this.refreshRoot());
    }

    public void setAdjustedSystemName(String string) {
        int n = 0;
        String string2 = string;
        do {
            try {
                this.setSystemName(string2);
                string2 = null;
            }
            catch (PropertyVetoException propertyVetoException) {
                string2 = string + " - " + ++n;
            }
        } while (string2 != null);
    }

    public File getRootDirectory() {
        return this.rootFile;
    }

    public void setReadOnly(boolean bl) {
        this.D.deb("setReadOnly(" + bl + ")");
        if (bl != this.readOnly) {
            this.readOnly = bl;
            this.firePropertyChange("readOnly", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        this.D.deb("prepareEnvironment() ->" + this.rootFile.toString());
        environment.addClassPath(this.rootFile.toString());
    }

    private String computeSystemNameBase(File file) {
        Hashtable hashtable = this.getVariablesAsHashtable();
        String string = (String)hashtable.get(VAR_FS_SYSTEM_NAME_ANNOTATION);
        if (string != null) {
            string = this.statusProvider != null ? RefreshCommandSupport.getStatusAnnotation("", "", string, this.statusProvider, hashtable) : Variables.expand(hashtable, string, false);
            return string;
        }
        return this.getClass().getName() + " " + file.toString().replace(File.separatorChar, '/');
    }

    protected String computeSystemName(File file) {
        String string;
        String string2 = string = this.computeSystemNameBase(file);
        int n = 0;
        do {
            Enumeration enumeration = TopManager.getDefault().getRepository().fileSystems();
            while (enumeration.hasMoreElements()) {
                FileSystem fileSystem = (FileSystem)enumeration.nextElement();
                if (fileSystem == this || !fileSystem.getSystemName().equals(string2)) continue;
                string2 = string + " - " + ++n;
                break;
            }
            if (enumeration.hasMoreElements()) continue;
            string = string2;
            string2 = null;
        } while (string2 != null);
        return string;
    }

    public File getFile(String string) {
        File file = new File(this.rootFile, string);
        String string2 = file.getAbsolutePath();
        boolean bl = false;
        if (string2.endsWith(File.separator + ".")) {
            string2 = string2.substring(0, string2.length() - 2);
            bl = true;
        }
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
            bl = true;
        }
        if (bl) {
            return new File(string2);
        }
        return file;
    }

    String[] getLocalFiles(String string) {
        File file = new File(this.getRootDirectory(), string);
        if (file == null || !file.exists() || !file.canRead()) {
            return new String[0];
        }
        String[] stringArray = file.list(this.getLocalFileFilter());
        return stringArray;
    }

    private void checkScheduledLocals(String string, Collection collection, Map map) {
        String string2;
        FileStatusProvider fileStatusProvider = this.getStatusProvider();
        if (fileStatusProvider == null) {
            return;
        }
        VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get(VAR_STATUS_SCHEDULED_REMOVE);
        String string3 = string2 = vcsConfigVariable != null ? vcsConfigVariable.getValue() : null;
        if (string2 == null) {
            return;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string4;
            String string5 = string4 = string.length() > 0 ? string + "/" + iterator.next() : "" + iterator.next();
            if (!map.containsKey(string4)) continue;
            String string6 = (String)map.get(string4);
            String string7 = (String)this.attr.readAttribute(string4, "VCS_SCHEDULED_FILE");
            if ("REMOVE".equals(string7) || !this.isSchedulingDone(string4)) continue;
            this.removeScheduledFromPrimary(string4, string6, 0);
        }
    }

    String[] addLocalFiles(String string, String[] stringArray, Map map) {
        String[] stringArray2;
        String[] stringArray3 = this.getLocalFiles(string);
        if (stringArray3 == null || stringArray3.length == 0) {
            stringArray3 = new String[]{};
            stringArray2 = stringArray;
        } else {
            Vector<String> vector = new Vector<String>(Arrays.asList(stringArray));
            Vector<String> vector2 = new Vector<String>(Arrays.asList(stringArray3));
            vector2.removeAll(vector);
            this.checkScheduledLocals(string, vector2, map);
            vector.addAll(vector2);
            stringArray2 = vector.toArray(new String[0]);
        }
        if (this.cache != null && (this.missingFileStatus != null || this.missingFolderStatus != null)) {
            this.markAsMissingFiles(string, stringArray3, stringArray);
        }
        return stringArray2;
    }

    private void markAsMissingFiles(String string, String[] stringArray, String[] stringArray2) {
        List<String> list = Arrays.asList(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.missingFileStatus != null && this.missingFileStatus.equals(this.missingFolderStatus) && this.notMissingableFileStatuses.equals(this.notMissingableFolderStatuses)) {
            int n = 0;
            while (n < stringArray2.length) {
                if (!list.contains(stringArray2[n])) {
                    arrayList.add(stringArray2[n]);
                }
                ++n;
            }
            if (arrayList.size() > 0) {
                this.cache.setExistingFileStatus(string, arrayList.toArray(new String[0]), this.missingFileStatus, this.notMissingableFileStatuses, true);
            }
        } else {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string2 = string.length() > 0 ? string + "/" : string;
            int n = 0;
            while (n < stringArray2.length) {
                if (!list.contains(stringArray2[n])) {
                    if (this.folder(string2 + stringArray2[n])) {
                        arrayList2.add(stringArray2[n]);
                    } else {
                        arrayList.add(stringArray2[n]);
                    }
                }
                ++n;
            }
            if (this.missingFileStatus != null && arrayList.size() > 0) {
                this.cache.setExistingFileStatus(string, arrayList.toArray(new String[0]), this.missingFileStatus, this.notMissingableFileStatuses, true);
            }
            if (this.missingFolderStatus != null && arrayList2.size() > 0) {
                this.cache.setExistingFileStatus(string, arrayList2.toArray(new String[0]), this.missingFolderStatus, this.notMissingableFolderStatuses, true);
            }
        }
    }

    public String[] children(String string) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (!this.ready) {
            this.D.deb("not ready");
            return new String[0];
        }
        HashMap hashMap = new HashMap();
        if (this.cache != null && !this.isHideShadowFiles()) {
            this.cache.readDirFromDiskCache(string);
            stringArray = this.cache.getFilesAndSubdirs(string);
            if (!this.isShowDeadFiles()) {
                stringArray = this.filterDeadFilesOut(string, stringArray);
            }
            if (stringArray != null) {
                stringArray = this.filterScheduledSecondaryFiles(string, stringArray, hashMap);
            }
        }
        stringArray2 = stringArray == null ? this.getLocalFiles(string) : this.addLocalFiles(string, stringArray, hashMap);
        if (this.cache != null) {
            VcsCacheDir vcsCacheDir = (VcsCacheDir)this.cache.getDir(string);
            if (stringArray2.length == 0 && (vcsCacheDir == null || !vcsCacheDir.isLoaded() && !vcsCacheDir.isLocal()) || (vcsCacheDir == null || !vcsCacheDir.isLoaded() && !vcsCacheDir.isLocal()) && this.areOnlyHiddenFiles(stringArray2)) {
                this.cache.readDir(string);
            }
        }
        if (this.versioningSystem != null) {
            this.addVersioningFolderListener(string);
        }
        int n = 0;
        while (n < stringArray2.length) {
            if (this.isFilterBackupFiles() && stringArray2[n].endsWith(this.getBackupExtension()) || this.ignoredGarbageRE != null && this.ignoredGarbageRE.match(stringArray2[n])) {
                stringArray2[n] = null;
            }
            ++n;
        }
        return stringArray2;
    }

    boolean areOnlyHiddenFiles(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        ((AbstractCollection)arrayList).remove(".nbattrs");
        ((AbstractCollection)arrayList).remove("fileSystem.attributes");
        int n = 0;
        while (n < arrayList.size()) {
            String string = arrayList.get(n);
            if (string.endsWith("~")) {
                arrayList.remove(n--);
            }
            ++n;
        }
        return arrayList.size() == 0;
    }

    String[] filterDeadFilesOut(String string, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        FileStatusProvider fileStatusProvider = this.getStatusProvider();
        if (fileStatusProvider == null) {
            return stringArray;
        }
        FileCacheProvider fileCacheProvider = this.getCacheProvider();
        if (fileCacheProvider != null && !fileCacheProvider.isDir(string)) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            String string2;
            String string3 = string2 = string.length() > 0 ? string + "/" + arrayList.get(n2) : arrayList.get(n2);
            if ((fileCacheProvider == null || fileCacheProvider.isFile(string2)) && "Dead".equals(fileStatusProvider.getFileStatus(string2))) {
                arrayList.remove(n2--);
                --n;
            }
            ++n2;
        }
        return arrayList.toArray(new String[0]);
    }

    private void addVersioningFolderListener(String string) {
        FileObject fileObject = this.findResource(string);
        if (fileObject != null) {
            Object object = versioningFolderListenersLock;
            synchronized (object) {
                FileChangeListener fileChangeListener;
                if (this.versioningFolderListeners == null) {
                    this.versioningFolderListeners = new WeakHashMap();
                }
                if ((fileChangeListener = (FileChangeListener)this.versioningFolderListeners.get(fileObject)) == null) {
                    VersioningFolderChangeListener versioningFolderChangeListener = new VersioningFolderChangeListener(string);
                    fileChangeListener = WeakListener.fileChange((FileChangeListener)versioningFolderChangeListener, (Object)fileObject);
                    fileObject.addFileChangeListener(fileChangeListener);
                    this.versioningFolderListeners.put(fileObject, versioningFolderChangeListener);
                }
            }
        }
    }

    void addScheduledFileToBeProcessed(String string) {
        if (this.scheduledFilesToBeProcessed == null) {
            this.scheduledFilesToBeProcessed = new Vector();
        }
        this.scheduledFilesToBeProcessed.add(string);
    }

    void removeScheduledFileToBeProcessed(String string) {
        if (this.scheduledFilesToBeProcessed == null) {
            this.scheduledFilesToBeProcessed = new Vector();
        }
        this.scheduledFilesToBeProcessed.remove(string);
    }

    private boolean isSchedulingDone(String string) {
        return this.scheduledFilesToBeProcessed == null || !this.scheduledFilesToBeProcessed.contains(string);
    }

    private String[] filterScheduledSecondaryFiles(String string, String[] stringArray, Map map) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        boolean bl = string.length() == 0;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = bl ? stringArray[n] : string + "/" + stringArray[n];
            Set[] setArray = (Set[])this.attr.readAttribute(string2, "VCS_SCHEDULED_FILES");
            if (setArray != null && setArray[0] != null) {
                LinkedList<String> linkedList = new LinkedList<String>();
                Iterator iterator = setArray[0].iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if ((bl || !string3.startsWith(string)) && (!bl || string3.indexOf(47) >= 0)) continue;
                    String string4 = bl ? string3 : string3.substring(string.length() + 1);
                    boolean bl2 = ((AbstractCollection)arrayList).remove(string4);
                    if (!bl2) {
                        linkedList.add(string3);
                        try {
                            this.attr.writeAttribute(string3, "VCS_SCHEDULED_FILE", null);
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    map.put(string3, string2);
                }
                if (linkedList.size() > 0) {
                    setArray[0].removeAll(linkedList);
                    setArray = VcsFileSystem.cleanScheduledAttrs(setArray);
                    try {
                        this.attr.writeAttribute(string2, "VCS_SCHEDULED_FILES", (Object)setArray);
                        if (setArray == null) {
                            this.attr.writeAttribute(string2, "VCS_SCHEDULING_MASTER_FILE_NAME", null);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            ++n;
        }
        return arrayList.toArray(new String[0]);
    }

    private void cleanupNonExistingAddedFiles(String string, String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        boolean bl = string.length() == 0;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 0;
        while (n < stringArray.length) {
            object3 = bl ? stringArray[n] : string + "/" + stringArray[n];
            object2 = (Set[])this.attr.readAttribute((String)object3, "VCS_SCHEDULED_FILES");
            if (object2 != null && object2[1] != null) {
                object = object2[1].iterator();
                while (object.hasNext()) {
                    String string2;
                    String string3 = (String)object.next();
                    if ((bl || !string3.startsWith(string)) && (!bl || string3.indexOf(47) >= 0)) continue;
                    String string4 = string2 = bl ? string3 : string3.substring(string.length() + 1);
                    if (arrayList.contains(string2)) continue;
                    hashMap.put(string3, object3);
                }
            }
            ++n;
        }
        if (hashMap.size() > 0) {
            object3 = hashMap.keySet().iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                object = (String)hashMap.get(object2);
                this.removeScheduledFromPrimary((String)object2, (String)object, 1);
            }
        }
    }

    private static final Set[] cleanScheduledAttrs(Set[] setArray) {
        boolean bl = true;
        int n = 0;
        while (n < setArray.length) {
            if (setArray[n] != null && setArray[n].size() == 0) {
                setArray[n] = null;
            }
            if (setArray[n] != null) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            setArray = null;
        }
        return setArray;
    }

    public void checkForModifications(String string) {
        Enumeration enumeration = this.existingFileObjects(this.findResource(string));
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            String string2 = fileObject.getPackageNameExt('/', '.');
            this.refreshResource(string2, true);
        }
    }

    public void createFolder(String string) throws IOException {
        File file;
        this.D.deb("createFolder('" + string + "')");
        if (string.startsWith("/")) {
            string = string.substring(1);
            this.D.deb("corrected name='" + string + "'");
        }
        File file2 = this.getFile(string);
        Object[] objectArray = new Object[]{file2.getName(), this.getDisplayName(), file2.toString()};
        if (string.equals("")) {
            throw new IOException(MessageFormat.format(this.g("EXC_CannotCreateF"), objectArray));
        }
        if (file2.exists()) {
            throw new IOException(MessageFormat.format(this.g("EXC_FolderAlreadyExist"), objectArray));
        }
        int n = string.lastIndexOf("/");
        if (n > 0 && !(file = this.getFile(string.substring(0, n))).exists() && !file.mkdirs()) {
            throw new IOException(MessageFormat.format(this.g("EXC_CannotCreateF"), file.getName(), this.getDisplayName(), file.toString()));
        }
        boolean bl = file2.mkdir();
        if (!bl) {
            throw new IOException(MessageFormat.format(this.g("EXC_CannotCreateF"), objectArray));
        }
        if (this.cache != null) {
            this.cache.addFolder(string);
        }
    }

    public void createData(String string) throws IOException {
        File file;
        this.D.deb("createData(" + string + ")");
        if (string.startsWith("/")) {
            string = string.substring(1);
            this.D.deb("corrected name='" + string + "'");
        }
        File file2 = this.getFile(string);
        int n = string.lastIndexOf("/");
        if (n > 0 && !(file = this.getFile(string.substring(0, n))).exists() && !file.mkdirs()) {
            throw new IOException(MessageFormat.format(this.g("EXC_CannotCreateF"), file.getName(), this.getDisplayName(), file.toString()));
        }
        if (!file2.createNewFile()) {
            throw new IOException(MessageFormat.format(this.g("EXC_DataAlreadyExist"), file2.getName(), this.getDisplayName(), file2.toString()));
        }
        if (this.statusProvider != null) {
            this.statusProvider.setFileStatus(string, this.statusProvider.getLocalFileStatus());
        }
    }

    private void addParentToRefresher(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n > 0 ? string.substring(0, n) : "";
        if (this.refresher != null) {
            this.refresher.addPrefferedFolder(string2);
        }
    }

    public void rename(String string, String string2) throws IOException {
        this.D.deb("rename(oldName=" + string + ",newName=" + string2 + ")");
        File file = this.getFile(string);
        File file2 = this.getFile(string2);
        if (file2.exists() && !file2.equals(file) || !file.renameTo(file2)) {
            final String string3 = this.g("EXC_CannotRename", string, this.getDisplayName(), string2);
            throw new IOException(string3){

                public String getLocalizedMessage() {
                    return string3;
                }
            };
        }
        if (this.cache != null) {
            this.cache.rename(string, string2);
        }
        this.addParentToRefresher(string);
    }

    public void delete(final String string) throws IOException {
        this.D.deb("delete('" + string + "')");
        final File file = this.getFile(string);
        if (!this.deleteFile(file, string)) {
            throw new IOException(){

                public String getLocalizedMessage() {
                    return VcsFileSystem.this.g("EXC_CannotDelete", string, VcsFileSystem.this.getDisplayName(), file.toString());
                }
            };
        }
    }

    protected boolean deleteFile(final File file, String string) throws IOException {
        File[] fileArray;
        if (!file.exists()) {
            return true;
        }
        if (!file.canWrite()) {
            throw new IOException(){

                public String getLocalizedMessage() {
                    return VcsFileSystem.this.g("EXC_CannotDeleteReadOnly", file.toString());
                }
            };
        }
        boolean bl = file.isDirectory();
        if (bl && (fileArray = file.listFiles()) != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (!this.deleteFile(fileArray[n], string + "/" + fileArray[n].getName())) {
                    return false;
                }
                ++n;
            }
        }
        boolean bl2 = file.delete();
        if (this.cache != null) {
            if (!bl) {
                if (this.missingFileStatus == null) {
                    this.cache.remove(string, bl);
                }
            } else if (this.missingFolderStatus == null) {
                this.cache.remove(string, bl);
            }
        }
        this.addParentToRefresher(string);
        this.callDeleteCommand(string, bl);
        return bl2;
    }

    protected void callDeleteCommand(String string, boolean bl) {
        VcsCommand vcsCommand = bl ? this.getCommand("DELETE_DIR") : this.getCommand("DELETE_FILE");
        if (vcsCommand != null) {
            if (VcsCommandIO.getBooleanProperty(vcsCommand, "runOnMultipleFiles")) {
                this.addDeleteCommand(string, bl);
            } else {
                Table table = new Table();
                table.put(string, this.findResource(string));
                VcsAction.doCommand(table, vcsCommand, null, this);
            }
        }
    }

    private void addDeleteCommand(String string, boolean bl) {
        ArrayList arrayList = this.deleteFileCommandQueue;
        synchronized (arrayList) {
            if (bl) {
                this.deleteFolderCommandQueue.add(string);
            } else {
                this.deleteFileCommandQueue.add(string);
            }
            this.deleteFileCommandQueue.notifyAll();
            if (this.deleteCommandThread == null || !this.deleteCommandThread.isAlive()) {
                this.deleteCommandThread = this.createDeleteCommandThread();
                this.deleteCommandThread.start();
            }
        }
    }

    private Thread createDeleteCommandThread() {
        return new Thread(new Runnable(){

            public void run() {
                do {
                    ArrayList arrayList;
                    boolean bl = true;
                    int n = VcsFileSystem.this.deleteFolderCommandQueue.size() + VcsFileSystem.this.deleteFileCommandQueue.size();
                    while (bl) {
                        arrayList = VcsFileSystem.this.deleteFileCommandQueue;
                        synchronized (arrayList) {
                            try {
                                VcsFileSystem.this.deleteFileCommandQueue.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        int n2 = VcsFileSystem.this.deleteFolderCommandQueue.size() + VcsFileSystem.this.deleteFileCommandQueue.size();
                        bl = n != n2;
                        n = n2;
                    }
                    arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    ArrayList arrayList3 = VcsFileSystem.this.deleteFileCommandQueue;
                    synchronized (arrayList3) {
                        arrayList.addAll(VcsFileSystem.this.deleteFileCommandQueue);
                        VcsFileSystem.this.deleteFileCommandQueue.clear();
                        arrayList2.addAll(VcsFileSystem.this.deleteFolderCommandQueue);
                        VcsFileSystem.this.deleteFolderCommandQueue.clear();
                    }
                    if (arrayList.size() > 0) {
                        VcsFileSystem.this.runDeleteFilesCommand(arrayList, VcsFileSystem.this.getCommand("DELETE_FILE"));
                    }
                    if (arrayList2.size() > 0) {
                        VcsFileSystem.this.runDeleteFilesCommand(arrayList2, VcsFileSystem.this.getCommand("DELETE_DIR"));
                    }
                    ArrayList arrayList4 = VcsFileSystem.this.deleteFileCommandQueue;
                    synchronized (arrayList4) {
                        try {
                            VcsFileSystem.this.deleteFileCommandQueue.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (VcsFileSystem.this.deleteFolderCommandQueue.size() + VcsFileSystem.this.deleteFileCommandQueue.size() > 0);
            }
        }, "VCS Delete file/dir command");
    }

    private void runDeleteFilesCommand(List list, VcsCommand vcsCommand) {
        Table table = new Table();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            table.put(string, this.findResource(string));
        }
        VcsAction.doCommand(table, vcsCommand, null, this);
    }

    public Date lastModified(String string) {
        this.D.deb("lastModified(" + string + ")");
        File file = this.getFile(string);
        if (!file.exists()) {
            if (this.cache != null) {
                CacheFile cacheFile = this.cache.getDir(string);
                if (cacheFile == null) {
                    cacheFile = this.cache.getFile(string);
                }
                if (cacheFile != null) {
                    String string2 = cacheFile.getDate();
                    String string3 = cacheFile.getTime();
                    if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                        Date date = null;
                        try {
                            date = DateFormat.getInstance().parse(string2 + " " + string3);
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                        if (date != null) {
                            return date;
                        }
                    }
                }
            }
            return new Date(System.currentTimeMillis());
        }
        return new Date(file.lastModified());
    }

    public boolean folder(String string) {
        boolean bl;
        if (this.cache != null) {
            bl = this.cache.isDir(string);
            if (!bl && !this.cache.isFile(string)) {
                bl = this.getFile(string).isDirectory();
            }
        } else {
            bl = this.getFile(string).isDirectory();
        }
        return bl;
    }

    public boolean readOnly(String string) {
        this.D.deb("readOnly(" + string + ") return " + !this.getFile(string).canWrite());
        if (this.folder(string)) {
            return false;
        }
        return !this.getFile(string).canWrite();
    }

    public String mimeType(String string) {
        this.D.deb("mimeType('" + string + "')");
        FileObject fileObject = this.findResource(string);
        String string2 = fileObject != null ? FileUtil.getMIMEType((FileObject)fileObject) : "content/unknown";
        return string2;
    }

    public long size(String string) {
        this.D.deb("size(" + string + ")");
        return this.getFile(string).length();
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.getFile(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            final String string2 = string;
            throw (FileNotFoundException)TopManager.getDefault().getErrorManager().annotate((Throwable)new FileNotFoundException(){

                public String getLocalizedMessage() {
                    return VcsFileSystem.this.g("MSG_FileNotExist", string2);
                }
            }, this.g("MSG_FileNotExist", string2));
        }
        return fileInputStream;
    }

    private void fileChanged(final String string) {
        this.D.deb("fileChanged(" + string + ")");
        if (this.statusProvider != null) {
            RequestProcessor.postRequest((Runnable)new Runnable(){
                static /* synthetic */ Class class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings;

                public void run() {
                    FileObject fileObject;
                    VcsGroupSettings vcsGroupSettings;
                    String string2 = VcsFileSystem.this.statusProvider.getFileStatus(string);
                    if (!VcsFileSystem.this.notModifiableStatuses.contains(string2)) {
                        VcsFileSystem.this.statusProvider.setFileModified(string);
                    }
                    if (!((vcsGroupSettings = (VcsGroupSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings == null ? (class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings = 16.class$("org.netbeans.modules.vcscore.grouping.VcsGroupSettings")) : class$org$netbeans$modules$vcscore$grouping$VcsGroupSettings), (boolean)true)).isDisableGroups() || vcsGroupSettings.getAutoAddition() != 1 && vcsGroupSettings.getAutoAddition() != 2 || (fileObject = VcsFileSystem.this.findResource(string)) == null)) {
                        try {
                            DataObject dataObject = DataObject.find((FileObject)fileObject);
                            Object object = GROUP_LOCK;
                            synchronized (object) {
                                DataShadow dataShadow = GroupUtils.findDOInGroups(dataObject);
                                if (dataShadow == null) {
                                    if (vcsGroupSettings.getAutoAddition() == 2) {
                                        AddToGroupDialog.openChooseDialog(dataObject);
                                    } else {
                                        GroupUtils.addToDefaultGroup(new Node[]{dataObject.getNodeDelegate()});
                                    }
                                }
                            }
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            // empty catch block
                        }
                    }
                }

                static /* synthetic */ Class class$(String string2) {
                    try {
                        return Class.forName(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
    }

    protected String getBackupExtension() {
        return "~";
    }

    private boolean isIDESettingsFile(String string) {
        return (string = string.replace(File.separatorChar, '/')).equals(".nbattrs") || string.endsWith("/.nbattrs") || string.equals("filesystem.attributes") || string.endsWith("/filesystem.attributes");
    }

    protected void createBackupFile(String string) throws IOException {
        if (this.isIDESettingsFile(string)) {
            return;
        }
        if (!this.isImportant(string) || string.endsWith(this.getBackupExtension())) {
            return;
        }
        if (!this.getFile(string).exists()) {
            return;
        }
        InputStream inputStream = this.inputStream(string);
        try {
            OutputStream outputStream = this.outputStream(string + this.getBackupExtension());
            try {
                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public OutputStream outputStream(String string) throws IOException {
        this.D.deb("outputStream(" + string + ")");
        if (this.isCreateBackupFiles()) {
            this.createBackupFile(string);
        }
        FileOutputStreamPlus fileOutputStreamPlus = new FileOutputStreamPlus(this.getFile(string), string);
        return fileOutputStreamPlus;
    }

    protected boolean shouldLock(String string) {
        String string2;
        if (this.getCommand("LOCK") == null) {
            return false;
        }
        return this.statusProvider == null || (string2 = this.statusProvider.getFileLocker(string)) == null || !string2.equals(System.getProperty("user.name"));
    }

    public void lock(String string) throws IOException {
        Object object;
        VcsCacheFile vcsCacheFile;
        if (!this.isImportant(string)) {
            return;
        }
        final String string2 = string;
        final File file = this.getFile(string2);
        if (!file.exists()) {
            return;
        }
        if (this.isReadOnly()) {
            throw new IOException("Cannot Lock " + string2);
        }
        if (this.isCallEditFilesOn() && !file.canWrite()) {
            VcsCacheFile vcsCacheFile2 = vcsCacheFile = this.cache != null ? (VcsCacheFile)this.cache.getFile(string2) : null;
            if (vcsCacheFile != null && !vcsCacheFile.isLocal() && !string2.endsWith(".orig")) {
                if (this.isPromptForEditOn()) {
                    VcsConfigVariable vcsConfigVariable = (VcsConfigVariable)this.variablesByName.get("MSG_PROMPT_FOR_AUTO_EDIT");
                    String string3 = vcsConfigVariable != null && vcsConfigVariable.getValue().length() > 0 ? vcsConfigVariable.getValue() : this.g("MSG_EditFileCh");
                    throw (UserQuestionException)TopManager.getDefault().getErrorManager().annotate((Throwable)new UserQuestionException(string3){

                        public void confirmed() {
                            Table table = new Table();
                            table.put(string2, VcsFileSystem.this.findResource(string2));
                            VcsAction.doEdit(table, VcsFileSystem.this);
                        }
                    }, this.g("EXC_CannotDeleteReadOnly", file.toString()));
                }
                object = new Table();
                ((Table)object).put(string2, this.findResource(string2));
                VcsAction.doEdit((Table)object, this);
            }
        }
        if (this.isLockFilesOn()) {
            VcsCacheFile vcsCacheFile3 = vcsCacheFile = this.cache != null ? (VcsCacheFile)this.cache.getFile(string2) : null;
            if (vcsCacheFile == null || vcsCacheFile.isLocal() || string2.endsWith(".orig")) {
                return;
            }
            if (this.shouldLock(string2)) {
                if (this.isPromptForLockOn()) {
                    object = (VcsConfigVariable)this.variablesByName.get("MSG_PROMPT_FOR_AUTO_LOCK");
                    String string4 = object != null && ((VcsConfigVariable)object).getValue().length() > 0 ? ((VcsConfigVariable)object).getValue() : this.g("MSG_LockFileCh");
                    throw new UserQuestionException(string4){

                        public void confirmed() {
                            Table table = new Table();
                            table.put(string2, VcsFileSystem.this.findResource(string2));
                            VcsAction.doLock(table, VcsFileSystem.this);
                        }
                    };
                }
                object = new Table();
                ((Table)object).put(string2, this.findResource(string2));
                VcsAction.doLock((Table)object, this);
            }
        }
        if (!file.canWrite() && file.exists()) {
            throw new IOException(){

                public String getLocalizedMessage() {
                    return VcsFileSystem.this.g("EXC_CannotLockReadOnly", file.toString());
                }
            };
        }
    }

    public void unlock(String string) {
        if (!this.isImportant(string)) {
            return;
        }
        this.D.deb("unlock('" + string + "')");
        if (this.isLockFilesOn()) {
            VcsCacheFile vcsCacheFile;
            VcsCacheFile vcsCacheFile2 = vcsCacheFile = this.cache != null ? (VcsCacheFile)this.cache.getFile(string) : null;
            if (vcsCacheFile != null && !vcsCacheFile.isLocal() && !string.endsWith(".orig")) {
                Table table = new Table();
                table.put(string, this.findResource(string));
                VcsAction.doUnlock(table, this);
            }
        }
    }

    public void cacheAdded(CacheHandlerEvent cacheHandlerEvent) {
        String string = this.getRootDirectory().getAbsolutePath();
        String string2 = cacheHandlerEvent.getCacheFile().getAbsolutePath();
        if (string2.startsWith(string)) {
            String string3 = string.length() == string2.length() ? "" : string2.substring(string.length() + 1, string2.length());
            string3 = string3.replace(File.separatorChar, '/');
            this.statusChanged(string3);
        }
    }

    public void cacheRemoved(CacheHandlerEvent cacheHandlerEvent) {
        String string = this.getRootDirectory().getAbsolutePath();
        CacheFile cacheFile = cacheHandlerEvent.getCacheFile();
        String string2 = cacheFile.getAbsolutePath();
        if (string2.startsWith(string)) {
            String string3 = string.length() == string2.length() ? "" : string2.substring(string.length() + 1, string2.length());
            string3 = string3.replace(File.separatorChar, '/');
            if (cacheFile instanceof CacheDir) {
                this.refreshExistingFolders(string3);
                this.statusChanged(string3, true);
            } else {
                this.statusChanged(string3);
            }
        }
    }

    public void statusChanged(CacheHandlerEvent cacheHandlerEvent) {
        String string = this.getRootDirectory().getAbsolutePath();
        String string2 = cacheHandlerEvent.getCacheFile().getAbsolutePath();
        if (string2.startsWith(string)) {
            String string3 = string.length() == string2.length() ? "" : string2.substring(string.length() + 1, string2.length());
            string3 = string3.replace(File.separatorChar, '/');
            if (cacheHandlerEvent.getCacheFile() instanceof CacheDir) {
                this.statusChanged(string3, cacheHandlerEvent.isRecursive());
            } else {
                this.statusChanged(string3);
            }
        }
    }

    private void addCommandsToHashTable(Node node) {
        Children children = node.getChildren();
        Enumeration enumeration = children.nodes();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)enumeration.nextElement();
            VcsCommand vcsCommand = (VcsCommand)node2.getCookie(class$org$netbeans$modules$vcscore$commands$VcsCommand == null ? VcsFileSystem.class$("org.netbeans.modules.vcscore.commands.VcsCommand") : class$org$netbeans$modules$vcscore$commands$VcsCommand);
            if (vcsCommand == null) continue;
            this.commandsByName.put(vcsCommand.getName(), vcsCommand);
            if (node2.isLeaf()) continue;
            this.addCommandsToHashTable(node2);
        }
    }

    private void setAdvancedConfig(Object object) {
        this.advanced = object;
        Vector vector = (Vector)object;
        int n = vector.size();
        if (n == 0) {
            return;
        }
        this.commandsByName = new Hashtable(n * 4 / 3 + 1, 0.75f);
        UserCommand userCommand = new UserCommand();
        userCommand.setName("ROOT");
        userCommand.setDisplayName("VCS");
        Children.Array array = new Children.Array();
        this.commandsRoot = new VcsCommandNode((Children)array, (VcsCommand)userCommand);
        VcsCommand vcsCommand = (VcsCommand)vector.elementAt(0);
        Children.Array array2 = new Children.Array();
        array.add(new Node[]{new VcsCommandNode((Children)array2, vcsCommand)});
        int n2 = 1;
        while (n2 < n) {
            VcsCommand vcsCommand2 = (VcsCommand)vector.elementAt(n2);
            this.commandsByName.put(vcsCommand2.getName(), vcsCommand2);
            array2.add(new Node[]{new VcsCommandNode(Children.LEAF, vcsCommand2)});
            ++n2;
        }
    }

    public void setCommands(Node node) {
        Node node2 = this.commandsRoot;
        if (node == null) {
            if (this.advanced != null) {
                this.setAdvancedConfig(this.advanced);
            }
        } else {
            if (this.commandsByName != null) {
                this.removeCmdActionsFromSupporter();
            }
            this.commandsRoot = node;
            this.commandsByName = new Hashtable();
            this.addCommandsToHashTable(node);
            this.addCmdActionsToSupporter();
        }
        VariableInputDescriptorCompat.createInputDescriptorFormExec(this.commandsByName);
        this.firePropertyChange(PROP_COMMANDS, node2, this.commandsRoot);
    }

    public Node getCommands() {
        return this.commandsRoot;
    }

    public VcsCommand getCommand(String string) {
        if (this.commandsByName == null) {
            Node node = this.getCommands();
            if (node == null) {
                return null;
            }
            this.setCommands(node);
        }
        return (VcsCommand)this.commandsByName.get(string);
    }

    private void addCmdActionsToSupporter() {
        Iterator iterator = this.commandsByName.values().iterator();
        while (iterator.hasNext()) {
            VcsCommand vcsCommand = (VcsCommand)iterator.next();
            Class<?> clazz = (Class<?>)vcsCommand.getProperty("_For_Internal_Use_Only_generalCommandActionClass");
            if (clazz == null) {
                Object object = vcsCommand.getProperty("generalCommandActionClassName");
                if (object instanceof String) {
                    String string = (String)object;
                    try {
                        clazz = Class.forName(string, false, TopManager.getDefault().currentClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        TopManager.getDefault().notifyException(TopManager.getDefault().getErrorManager().annotate((Throwable)classNotFoundException, this.g("EXC_CouldNotFindAction", string)));
                        continue;
                    }
                }
                vcsCommand.setProperty("_For_Internal_Use_Only_generalCommandActionClass", clazz);
            }
            this.actionSupporter.addSupportForAction(clazz, vcsCommand.getName());
        }
    }

    private void removeCmdActionsFromSupporter() {
        Iterator iterator = this.commandsByName.values().iterator();
        while (iterator.hasNext()) {
            VcsCommand vcsCommand = (VcsCommand)iterator.next();
            Class clazz = (Class)vcsCommand.getProperty("_For_Internal_Use_Only_generalCommandActionClass");
            if (clazz == null) continue;
            this.actionSupporter.removeSupportForAction(clazz);
        }
    }

    public FilenameFilter getLocalFileFilter() {
        return null;
    }

    protected boolean checkVirtual(String string) {
        File file = this.getFile(string);
        return !file.exists();
    }

    protected void checkVirtualFiles(Set set) {
    }

    protected boolean setVirtualDataLoader(FileObject fileObject) {
        boolean bl = false;
        try {
            if (this.checkVirtual(fileObject.getPackageNameExt('/', '.'))) {
                Object object;
                if (this.statusProvider != null) {
                    object = this.statusProvider.getFileStatus(fileObject.getPackageNameExt('/', '.'));
                    if (this.statusProvider.getLocalFileStatus().equals(object)) {
                        return bl;
                    }
                }
                if ((object = DataLoaderPool.getPreferredLoader((FileObject)fileObject)) == null || !object.getClass().equals(class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader == null ? (class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader = VcsFileSystem.class$("org.netbeans.modules.vcscore.util.virtuals.VirtualsDataLoader")) : class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader)) {
                    DataLoaderPool.setPreferredLoader((FileObject)fileObject, (DataLoader)((VirtualsDataLoader)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader == null ? (class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader = VcsFileSystem.class$("org.netbeans.modules.vcscore.util.virtuals.VirtualsDataLoader")) : class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader), (boolean)true)));
                    bl = true;
                }
            } else {
                DataLoader dataLoader = DataLoaderPool.getPreferredLoader((FileObject)fileObject);
                if (dataLoader != null && dataLoader.getClass().equals(class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader == null ? (class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader = VcsFileSystem.class$("org.netbeans.modules.vcscore.util.virtuals.VirtualsDataLoader")) : class$org$netbeans$modules$vcscore$util$virtuals$VirtualsDataLoader)) {
                    DataLoaderPool.setPreferredLoader((FileObject)fileObject, null);
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    private void settingsChanged(String string, Object object, Object object2) {
        GeneralVcsSettings generalVcsSettings = (GeneralVcsSettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings == null ? (class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings = VcsFileSystem.class$("org.netbeans.modules.vcscore.settings.GeneralVcsSettings")) : class$org$netbeans$modules$vcscore$settings$GeneralVcsSettings), (boolean)true);
        if ("useGlobal".equals(string)) {
            if (((Boolean)object2).booleanValue()) {
                this.setOffLine(generalVcsSettings.isOffLine());
                this.setAutoRefresh(generalVcsSettings.getAutoRefresh());
                this.setHideShadowFiles(generalVcsSettings.isHideShadowFiles());
            }
        } else if (generalVcsSettings.isUseGlobal()) {
            if ("offLine".equals(string)) {
                this.setOffLine(generalVcsSettings.isOffLine());
            } else if ("autoRefresh".equals(string)) {
                this.setAutoRefresh(generalVcsSettings.getAutoRefresh());
            } else if ("home".equals(string)) {
                this.updateEnvironmentVars();
            } else if ("hideShadowFiles".equals(string)) {
                this.setHideShadowFiles(generalVcsSettings.isHideShadowFiles());
            }
        }
    }

    public String getBundleProperty(String string) {
        return this.g(string);
    }

    public String getBundleProperty(String string, Object object) {
        return this.g(string, object);
    }

    public IgnoreListSupport getIgnoreListSupport() {
        return this.ignoreListSupport;
    }

    public void setIgnoreListSupport(IgnoreListSupport ignoreListSupport) {
        this.ignoreListSupport = ignoreListSupport;
    }

    protected String g(String string) {
        this.D.deb("getting " + string);
        return NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$VcsFileSystem == null ? (class$org$netbeans$modules$vcscore$VcsFileSystem = VcsFileSystem.class$("org.netbeans.modules.vcscore.VcsFileSystem")) : class$org$netbeans$modules$vcscore$VcsFileSystem), (String)string);
    }

    protected String g(String string, Object object) {
        return MessageFormat.format(this.g(string), object);
    }

    protected String g(String string, Object object, Object object2) {
        return MessageFormat.format(this.g(string), object, object2);
    }

    protected String g(String string, Object object, Object object2, Object object3) {
        return MessageFormat.format(this.g(string), object, object2, object3);
    }

    private void D(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ WeakHashMap access$1300(VcsFileSystem vcsFileSystem) {
        return vcsFileSystem.versioningFolderListeners;
    }

    static /* synthetic */ WeakHashMap access$1302(VcsFileSystem vcsFileSystem, WeakHashMap weakHashMap) {
        vcsFileSystem.versioningFolderListeners = weakHashMap;
        return vcsFileSystem.versioningFolderListeners;
    }

    static {
        STATUS_REQUEST_PROCESSOR_LOCK = new Object();
        createIgnoreListQueue = new ArrayList();
        ignoreListCreationThread = null;
        versioningFolderListenersLock = new Object();
        GROUP_LOCK = new Object();
    }

    private class VersioningFolderChangeListener
    implements FileChangeListener {
        private String name;

        public VersioningFolderChangeListener(String string) {
            this.name = string;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            this.refreshVersioning();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.refreshVersioning();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.refreshVersioning();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.refreshVersioning();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.refreshVersioning();
        }

        private void refreshVersioning() {
            VcsFileSystem.getStatusChangeRequestProcessor().post(new Runnable(this){
                private final /* synthetic */ VersioningFolderChangeListener this$1;
                {
                    this.this$1 = versioningFolderChangeListener;
                }

                public void run() {
                    FileObject fileObject;
                    if (VcsFileSystem.access$1000(VersioningFolderChangeListener.access$2500(this.this$1)) != null && (fileObject = VcsFileSystem.access$1000(VersioningFolderChangeListener.access$2500(this.this$1)).findExistingResource(VersioningFolderChangeListener.access$2600(this.this$1))) != null) {
                        fileObject.refresh();
                    }
                }
            });
        }

        static /* synthetic */ VcsFileSystem access$2500(VersioningFolderChangeListener versioningFolderChangeListener) {
            return versioningFolderChangeListener.VcsFileSystem.this;
        }

        static /* synthetic */ String access$2600(VersioningFolderChangeListener versioningFolderChangeListener) {
            return versioningFolderChangeListener.name;
        }
    }

    private class VcsList
    implements AbstractFileSystem.List {
        private static final long serialVersionUID = 9164232967348550668L;

        private VcsList() {
        }

        public String[] children(String string) {
            return VcsFileSystem.this.list.children(string);
        }
    }

    private class SettingsPropertyChangeListener
    implements PropertyChangeListener {
        private SettingsPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            VcsFileSystem.this.settingsChanged(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private class FSPropertyChangeListener
    implements PropertyChangeListener {
        private String oldFsSystemName;

        public FSPropertyChangeListener() {
            this.oldFsSystemName = VcsFileSystem.this.getSystemName();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (VcsFileSystem.PROP_ANNOTATION_PATTERN.equals(string)) {
                FileObject fileObject = VcsFileSystem.this.findResource("");
                HashSet hashSet = new HashSet();
                Enumeration enumeration = VcsFileSystem.super.existingFileObjects(fileObject);
                while (enumeration.hasMoreElements()) {
                    hashSet.add(enumeration.nextElement());
                }
                VcsFileSystem.super.fireFileStatusChanged(new FileStatusEvent((FileSystem)VcsFileSystem.this, hashSet, false, true));
            } else if ("systemName".equals(propertyChangeEvent.getPropertyName())) {
                RuntimeSupport.getInstance().updateRuntime((FileSystem)VcsFileSystem.this, this.oldFsSystemName);
                this.oldFsSystemName = VcsFileSystem.this.getSystemName();
            }
        }
    }

    private class FileOutputStreamPlus
    extends FileOutputStream {
        private String name;

        public FileOutputStreamPlus(File file, String string) throws IOException {
            super(file);
            this.name = string;
        }

        public void close() throws IOException {
            super.close();
            if (this.name != null) {
                VcsFileSystem.this.fileChanged(this.name);
            }
        }
    }

    public static interface IgnoreListSupport {
        public ArrayList createInitialIgnoreList();

        public ArrayList createIgnoreList(String var1, ArrayList var2);
    }
}

