/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vcscore;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.caching.FileCacheProvider;
import org.netbeans.modules.vcscore.caching.FileStatusProvider;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandExecutorSupport;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.CommandsPool;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsCommandIO;
import org.netbeans.modules.vcscore.grouping.VcsGroupNode;
import org.netbeans.modules.vcscore.util.Debug;
import org.netbeans.modules.vcscore.util.Table;
import org.netbeans.modules.vcscore.util.VariableValueAdjustment;
import org.netbeans.modules.vcscore.util.VcsUtilities;
import org.netbeans.modules.vcscore.util.WeakList;
import org.netbeans.modules.vcscore.versioning.VersioningFileSystem;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.awt.JInlineMenu;
import org.openide.awt.JMenuPlus;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public class VcsAction
extends NodeAction
implements ActionListener {
    private Debug E;
    private Debug D;
    private static final String PROPERTY_PARSED_ATTR_NAMES = "_For_Internal_Use_Only_FOAttributesNamesParsed";
    private static final String PROPERTY_PARSED_ATTR_NEMPTY_VARS = "_For_Internal_Use_Only_FOAttributesNotEmptyVars";
    private static final String PROPERTY_PARSED_ATTR_VALUES_VARS = "_For_Internal_Use_Only_FOAttributesValuesVars";
    protected boolean REMOVE_DISABLED;
    protected WeakReference fileSystem;
    protected Collection selectedFileObjects;
    protected HashMap variablesForSelectedFiles;
    private ArrayList switchableList;
    private Node[] actionCommandsSubTrees;
    boolean CTRL_Down;
    private final String advancedOptionsSign;
    private static final long serialVersionUID = -4196511763565479366L;
    private static RequestProcessor actionRequestProcesor;
    private static final Object ACTION_LOCK;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$VcsAction;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$openide$cookies$SaveCookie;
    static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$VcsCommand;

    public VcsAction() {
        this.D = this.E = new Debug("VcsAction", true);
        this.REMOVE_DISABLED = false;
        this.fileSystem = new WeakReference<Object>(null);
        this.selectedFileObjects = null;
        this.variablesForSelectedFiles = null;
        this.actionCommandsSubTrees = null;
        this.CTRL_Down = false;
        this.advancedOptionsSign = NbBundle.getMessage((Class)(class$org$netbeans$modules$vcscore$VcsAction == null ? (class$org$netbeans$modules$vcscore$VcsAction = VcsAction.class$("org.netbeans.modules.vcscore.VcsAction")) : class$org$netbeans$modules$vcscore$VcsAction), (String)"CTL_AdvancedOptionsSign");
    }

    public void setFileSystem(VcsFileSystem vcsFileSystem) {
        this.fileSystem = new WeakReference<VcsFileSystem>(vcsFileSystem);
    }

    public void setSelectedFileObjects(Collection collection) {
        this.variablesForSelectedFiles = null;
        if (collection == null) {
            this.selectedFileObjects = this.getSelectedFileObjectsFromActivatedNodes();
            return;
        }
        ArrayList arrayList = VcsUtilities.reorderFileObjects(collection);
        this.selectedFileObjects = new WeakList(arrayList);
    }

    private Collection getSelectedFileObjectsFromActivatedNodes() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Node[] nodeArray = this.getActivatedNodes();
        TreeSet treeSet = new TreeSet(new VcsUtilities.FileObjectNameComparator());
        int n = 0;
        while (n < nodeArray.length) {
            VcsGroupNode vcsGroupNode;
            if (nodeArray[n] instanceof VcsGroupNode) {
                vcsGroupNode = (VcsGroupNode)nodeArray[n];
                if (this.variablesForSelectedFiles == null) {
                    this.variablesForSelectedFiles = new HashMap();
                }
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("GROUP_NAME", vcsGroupNode.getDisplayName());
                String string = vcsGroupNode.getShortDescription();
                if (string != null) {
                    hashtable.put("GROUP_DESCRIPTION", string);
                }
                WeakList weakList = new WeakList();
                Enumeration enumeration = nodeArray[n].getChildren().nodes();
                while (enumeration.hasMoreElements()) {
                    Node node = (Node)enumeration.nextElement();
                    DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? VcsAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    if (dataObject == null) continue;
                    FileObject fileObject = dataObject.getPrimaryFile();
                    arrayList.add(fileObject);
                    weakList.add(fileObject);
                    treeSet.addAll(dataObject.files());
                    treeSet.remove(dataObject.getPrimaryFile());
                    arrayList.addAll(treeSet);
                    weakList.addAll(treeSet);
                    this.variablesForSelectedFiles.put(hashtable, weakList);
                    treeSet.clear();
                }
            } else {
                vcsGroupNode = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? VcsAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (vcsGroupNode != null) {
                    arrayList.add(vcsGroupNode.getPrimaryFile());
                    treeSet.addAll(vcsGroupNode.files());
                    treeSet.remove(vcsGroupNode.getPrimaryFile());
                    arrayList.addAll(treeSet);
                    treeSet.clear();
                }
            }
            ++n;
        }
        return new WeakList(arrayList);
    }

    public void setCommandsSubTrees(Node[] nodeArray) {
        this.actionCommandsSubTrees = nodeArray;
    }

    public String getName() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (vcsFileSystem == null) {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$vcscore$VcsAction == null ? (class$org$netbeans$modules$vcscore$VcsAction = VcsAction.class$("org.netbeans.modules.vcscore.VcsAction")) : class$org$netbeans$modules$vcscore$VcsAction)).getString("CTL_Version_Control");
        }
        return vcsFileSystem.getBundleProperty("CTL_Version_Control");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    private void killAllCommands() {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        CommandsPool commandsPool = vcsFileSystem.getCommandsPool();
        String[] stringArray = commandsPool.getRunningCommandsLabels();
        if (stringArray.length > 0 && NotifyDescriptor.YES_OPTION.equals(TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)vcsFileSystem.getBundleProperty("MSG_KILL_ALL_CMDS", VcsUtilities.arrayToString(stringArray)), 0)))) {
            commandsPool.killAll();
        }
    }

    public void doList(String string) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        VcsAction.doList(vcsFileSystem, string);
    }

    public static void doList(VcsFileSystem vcsFileSystem, String string) {
        FileStatusProvider fileStatusProvider = vcsFileSystem.getStatusProvider();
        FileCacheProvider fileCacheProvider = vcsFileSystem.getCacheProvider();
        if (fileStatusProvider == null) {
            return;
        }
        if (fileCacheProvider == null || fileCacheProvider.isDir(string)) {
            fileStatusProvider.refreshDir(string);
        } else {
            String string2 = VcsUtilities.getDirNamePart(string);
            fileStatusProvider.refreshDir(string2);
        }
    }

    public void doListSub(String string) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        CommandExecutorSupport.doRefresh(vcsFileSystem, string, true);
    }

    public static void doLock(Table table, VcsFileSystem vcsFileSystem) {
        VcsCommand vcsCommand = vcsFileSystem.getCommand("LOCK");
        if (vcsCommand != null) {
            VcsAction.doCommand(table, vcsCommand, null, vcsFileSystem, null, null, null, null, false);
        }
    }

    public static void doUnlock(Table table, VcsFileSystem vcsFileSystem) {
        VcsCommand vcsCommand = vcsFileSystem.getCommand("UNLOCK");
        if (vcsCommand != null) {
            VcsAction.doCommand(table, vcsCommand, null, vcsFileSystem);
        }
    }

    public static void doEdit(Table table, VcsFileSystem vcsFileSystem) {
        VcsCommand vcsCommand = vcsFileSystem.getCommand("EDIT");
        if (vcsCommand != null) {
            VcsAction.doCommand(table, vcsCommand, null, vcsFileSystem);
        }
    }

    public static VcsCommandExecutor[] doCommand(Table table, VcsCommand vcsCommand, Hashtable hashtable, VcsFileSystem vcsFileSystem) {
        return VcsAction.doCommand(table, vcsCommand, hashtable, vcsFileSystem, null, null, null, null);
    }

    public static VcsCommandExecutor[] doCommand(Table table, VcsCommand vcsCommand, Hashtable hashtable, VcsFileSystem vcsFileSystem, CommandOutputListener commandOutputListener, CommandOutputListener commandOutputListener2, CommandDataOutputListener commandDataOutputListener, CommandDataOutputListener commandDataOutputListener2) {
        return VcsAction.doCommand(table, vcsCommand, hashtable, vcsFileSystem, commandOutputListener, commandOutputListener2, commandDataOutputListener, commandDataOutputListener2, true);
    }

    public static VcsCommandExecutor[] doCommand(Table table, VcsCommand vcsCommand, Hashtable hashtable, VcsFileSystem vcsFileSystem, CommandOutputListener commandOutputListener, CommandOutputListener commandOutputListener2, CommandDataOutputListener commandDataOutputListener, CommandDataOutputListener commandDataOutputListener2, boolean bl) {
        int n;
        if (table.size() == 0) {
            return new VcsCommandExecutor[0];
        }
        if (bl) {
            VcsAction.assureFilesSaved(table.values());
        }
        if (VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "needsHierarchicalOrder")) {
            table = VcsAction.createHierarchicalOrder(table);
        }
        ArrayList arrayList = new ArrayList();
        boolean[] blArray = null;
        String string = "${QUOTE}";
        boolean bl2 = VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "runOnMultipleFiles");
        boolean bl3 = VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "runOnMultipleFilesInFolder");
        VariableValueAdjustment variableValueAdjustment = vcsFileSystem.getVarValueAdjustment();
        Map map = VcsAction.extractScheduledFiles(table, vcsCommand);
        String string2 = null;
        VcsCommand vcsCommand2 = vcsCommand;
        do {
            Object object;
            Table table2;
            Hashtable hashtable2 = vcsFileSystem.getVariablesAsHashtable();
            if (hashtable != null) {
                hashtable2.putAll(hashtable);
            }
            if (table.size() > 1) {
                blArray = new boolean[]{true};
            }
            Object[] objectArray = new Object[]{blArray};
            Object[] objectArray2 = new Object[]{hashtable2};
            do {
                table2 = VcsAction.setupRestrictedFileMap(table, objectArray2, vcsCommand2);
                object = new ArrayList();
                Iterator iterator = table2.keySet().iterator();
                while (iterator.hasNext()) {
                    ((ArrayList)object).add(iterator.next());
                }
                while (0 != (n = table.size() == 0 ? 2 : VcsAction.doCommandExecution(table2, objectArray2, hashtable, vcsFileSystem, vcsCommand2, bl2, bl3, string, objectArray, variableValueAdjustment, arrayList, commandOutputListener, commandOutputListener2, commandDataOutputListener, commandDataOutputListener2)) && 1 == n) {
                }
                Iterator iterator2 = ((AbstractList)object).iterator();
                while (iterator2.hasNext()) {
                    table.remove(iterator2.next());
                }
            } while (0 != n && table.size() > 0);
            if (0 == n || map.size() <= 0) continue;
            string2 = (String)map.keySet().iterator().next();
            table = table2 = (Table)map.get(string2);
            map.remove(string2);
            n = 1;
            object = (String)vcsCommand.getProperty("execScheduledCommand_" + string2);
            if (object == null || (vcsCommand2 = vcsFileSystem.getCommand((String)object)) != null) continue;
            vcsCommand2 = vcsCommand;
        } while (1 == n);
        return arrayList.toArray(new VcsCommandExecutor[arrayList.size()]);
    }

    private static Table setupRestrictedFileMap(Table table, Object[] objectArray, VcsCommand vcsCommand) {
        String[] stringArray = (String[])vcsCommand.getProperty("loadAttributesToVars");
        if (stringArray != null) {
            table = VcsAction.getAttributeRestrictedFileMap(table, objectArray, vcsCommand, stringArray);
        }
        if (Boolean.TRUE.equals(vcsCommand.getProperty("distinguishBinaryFiles"))) {
            table = VcsAction.getBinaryRestrictedFileMap(table, objectArray, vcsCommand);
        }
        return table;
    }

    private static Table getAttributeRestrictedFileMap(Table table, Object[] objectArray, VcsCommand vcsCommand, String[] stringArray) {
        Map map = null;
        Map map2 = null;
        String[] stringArray2 = (String[])vcsCommand.getProperty(PROPERTY_PARSED_ATTR_NAMES);
        if (stringArray2 != null) {
            map = (Map)vcsCommand.getProperty(PROPERTY_PARSED_ATTR_NEMPTY_VARS);
            map2 = (Map)vcsCommand.getProperty(PROPERTY_PARSED_ATTR_VALUES_VARS);
        } else {
            map = new HashMap();
            map2 = new HashMap();
            stringArray2 = VcsAction.getAttrNamesAndVars(map, map2, stringArray);
            vcsCommand.setProperty(PROPERTY_PARSED_ATTR_NAMES, stringArray2);
            vcsCommand.setProperty(PROPERTY_PARSED_ATTR_NEMPTY_VARS, map);
            vcsCommand.setProperty(PROPERTY_PARSED_ATTR_VALUES_VARS, map2);
        }
        Table table2 = stringArray2 != null ? VcsAction.setVarsFromAttrs(table, (Hashtable)objectArray[0], stringArray2, map, map2) : table;
        return table2;
    }

    private static Table getBinaryRestrictedFileMap(Table table, Object[] objectArray, VcsCommand vcsCommand) {
        Table table2 = new Table();
        Iterator iterator = table.keySet().iterator();
        if (!iterator.hasNext()) {
            return table;
        }
        String string = (String)iterator.next();
        FileObject fileObject = (FileObject)table.get(string);
        boolean bl = fileObject == null ? false : VcsAction.isFOBinary(fileObject);
        table2.put(string, fileObject);
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            fileObject = (FileObject)table.get(string);
            if (fileObject == null ? bl : bl != VcsAction.isFOBinary(fileObject)) continue;
            table2.put(string, fileObject);
        }
        Hashtable hashtable = (Hashtable)objectArray[0];
        hashtable.put("PROCESSING_BINARY_FILES", bl ? Boolean.TRUE.toString() : "");
        return table2;
    }

    private static boolean isFOBinary(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        return !string.startsWith("text") && !"content/unknown".equals(string);
    }

    private void doCommand(Table table, VcsCommand vcsCommand) {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>(1);
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        if (!vcsFileSystem.isExpertMode() && this.CTRL_Down) {
            hashtable.put("CTRL_DOWN_IN_ACTION", Boolean.TRUE);
        }
        VcsAction.doCommand(table, vcsCommand, hashtable, vcsFileSystem);
    }

    private static int doCommandExecution(Table table, Object[] objectArray, Hashtable hashtable, VcsFileSystem vcsFileSystem, VcsCommand vcsCommand, boolean bl, boolean bl2, String string, Object[] objectArray2, VariableValueAdjustment variableValueAdjustment, List list, CommandOutputListener commandOutputListener, CommandOutputListener commandOutputListener2, CommandDataOutputListener commandDataOutputListener, CommandDataOutputListener commandDataOutputListener2) {
        Object object;
        Object object2;
        boolean[] blArray = (boolean[])objectArray2[0];
        Hashtable hashtable2 = (Hashtable)objectArray[0];
        VcsAction.setVariables(table, hashtable2, string, variableValueAdjustment);
        VcsCommandExecutor vcsCommandExecutor = vcsFileSystem.getVcsFactory().getCommandExecutor(vcsCommand, hashtable2);
        CommandsPool commandsPool = vcsFileSystem.getCommandsPool();
        int n = commandsPool.preprocessCommand(vcsCommandExecutor, hashtable2, vcsFileSystem, blArray);
        if (0 == n) {
            return n;
        }
        if (!bl && !bl2) {
            n = 1;
        }
        if (table.size() == 1) {
            n = 2;
        }
        Table table2 = null;
        if (1 == n) {
            object2 = new Table();
            object = table.keys().nextElement();
            ((Table)object2).put(object, table.get(object));
            VcsAction.setVariables((Table)object2, hashtable2, string, variableValueAdjustment);
        } else if (bl2) {
            table2 = new Table();
            object2 = table.keys();
            object = (String)object2.nextElement();
            table2.put(object, table.get(object));
            String string2 = "";
            int n2 = ((String)object).lastIndexOf(47);
            if (n2 >= 0) {
                string2 = ((String)object).substring(0, n2);
            }
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                String string3 = "";
                n2 = ((String)object).lastIndexOf(47);
                if (n2 >= 0) {
                    string3 = ((String)object).substring(0, n2);
                }
                if (!string2.equals(string3)) continue;
                table2.put(object, table.get(object));
            }
            VcsAction.setVariables(table2, hashtable2, string, variableValueAdjustment);
        }
        list.add(vcsCommandExecutor);
        if (commandOutputListener != null) {
            vcsCommandExecutor.addOutputListener(commandOutputListener);
        }
        if (commandOutputListener2 != null) {
            vcsCommandExecutor.addErrorOutputListener(commandOutputListener2);
        }
        if (commandDataOutputListener != null) {
            vcsCommandExecutor.addDataOutputListener(commandDataOutputListener);
        }
        if (commandDataOutputListener2 != null) {
            vcsCommandExecutor.addDataErrorOutputListener(commandDataOutputListener2);
        }
        commandsPool.startExecutor(vcsCommandExecutor);
        object2 = hashtable2;
        synchronized (object2) {
            if (blArray != null && blArray[0]) {
                hashtable2 = new Hashtable(vcsFileSystem.getVariablesAsHashtable());
                if (hashtable != null) {
                    hashtable2.putAll(hashtable);
                }
            } else {
                hashtable2 = new Hashtable(hashtable2);
            }
        }
        if (1 == n) {
            table.remove(table.keys().nextElement());
            if (table.size() == 1 && blArray != null && blArray[0]) {
                blArray = null;
            }
        } else if (bl2) {
            Enumeration enumeration = table2.keys();
            while (enumeration.hasMoreElements()) {
                table.remove(enumeration.nextElement());
            }
            if (table.size() == 1 && blArray != null && blArray[0]) {
                blArray = null;
            }
            if (table.size() > 0) {
                n = 1;
            }
        }
        objectArray[0] = hashtable2;
        objectArray2[0] = blArray;
        return n;
    }

    private static Map extractScheduledFiles(Table table, VcsCommand vcsCommand) {
        HashMap<String, Table> hashMap = new HashMap<String, Table>();
        LinkedList linkedList = new LinkedList();
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            linkedList.add(enumeration.nextElement());
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            FileObject fileObject = (FileObject)table.get(string2);
            String string3 = fileObject == null ? "REMOVE" : (String)fileObject.getAttribute("VCS_SCHEDULED_FILE");
            if (string3 == null || (string = (String)vcsCommand.getProperty("execScheduledCommand_" + string3)) == null) continue;
            Table table2 = (Table)hashMap.get(string3);
            if (table2 == null) {
                table2 = new Table();
                hashMap.put(string3, table2);
            }
            table.remove(string2);
            table2.put(string2, fileObject);
        }
        return hashMap;
    }

    private static void assureFilesSaved(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            FileObject fileObject = (FileObject)iterator.next();
            if (fileObject == null) continue;
            DataObject dataObject = null;
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            if (dataObject == null || !dataObject.isModified()) continue;
            Node.Cookie cookie = dataObject.getCookie(class$org$openide$cookies$SaveCookie == null ? VcsAction.class$("org.openide.cookies.SaveCookie") : class$org$openide$cookies$SaveCookie);
            try {
                if (cookie == null) continue;
                ((SaveCookie)cookie).save();
            }
            catch (IOException iOException) {
                TopManager.getDefault().notifyException((Throwable)iOException);
            }
        }
    }

    private static Table createHierarchicalOrder(Table table) {
        TreeMap treeMap = new TreeMap(table);
        Table table2 = new Table();
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            table2.put(k, table.get(k));
        }
        return table2;
    }

    protected boolean isOnDirectory() {
        boolean bl = false;
        if (this.selectedFileObjects != null) {
            Iterator iterator = this.selectedFileObjects.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                if (!fileObject.isFolder()) continue;
                bl = true;
            }
        }
        return bl && !this.isOnRoot();
    }

    protected boolean isOnFile() {
        if (this.selectedFileObjects != null) {
            Iterator iterator = this.selectedFileObjects.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                if (fileObject.isFolder()) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isOnRoot() {
        if (this.selectedFileObjects != null) {
            Iterator iterator = this.selectedFileObjects.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                if (fileObject.getPackageNameExt('/', '.').length() != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected void addImportantFiles(Collection collection, Table table, boolean bl, boolean bl2) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        VcsAction.addImportantFiles(collection, table, bl, vcsFileSystem, bl2);
    }

    public static void addImportantFiles(Collection collection, Table table, boolean bl, VcsFileSystem vcsFileSystem) {
        VcsAction.addImportantFiles(collection, table, bl, vcsFileSystem, false);
    }

    public static void addImportantFiles(Collection collection, Table table, boolean bl, VcsFileSystem vcsFileSystem, boolean bl2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Set[] setArray;
            FileObject fileObject = (FileObject)iterator.next();
            try {
                if (fileObject.getFileSystem() instanceof VersioningFileSystem) {
                    table.put(fileObject.getPackageNameExt('/', '.'), fileObject);
                    continue;
                }
                if (!bl2 && fileObject.getFileSystem() != vcsFileSystem) {
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {}
            continue;
            String string = fileObject.getPackageNameExt('/', '.');
            if (bl || vcsFileSystem.isImportant(string)) {
                table.put(string, fileObject);
            }
            if ((setArray = (Set[])fileObject.getAttribute("VCS_SCHEDULED_FILES")) == null || setArray[0] == null) continue;
            Iterator iterator2 = setArray[0].iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                table.put(string2, (Object)null);
            }
        }
    }

    private Set getSelectedFileStatusAttributes() {
        HashSet<Object> hashSet = new HashSet<Object>();
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        FileStatusProvider fileStatusProvider = vcsFileSystem.getStatusProvider();
        boolean bl = vcsFileSystem.isProcessUnimportantFiles();
        if (fileStatusProvider != null && this.selectedFileObjects != null) {
            Iterator iterator = this.selectedFileObjects.iterator();
            while (iterator.hasNext()) {
                Set[] setArray;
                FileObject fileObject = (FileObject)iterator.next();
                String string = fileObject.getPackageNameExt('/', '.');
                FileSystem fileSystem = null;
                try {
                    fileSystem = fileObject.getFileSystem();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                if ((fileSystem instanceof VersioningFileSystem || bl || vcsFileSystem.isImportant(string)) && (setArray = fileStatusProvider.getFileStatus(string)) != null) {
                    hashSet.add(setArray);
                }
                if ((setArray = (Set[])fileObject.getAttribute("VCS_SCHEDULED_FILES")) == null || setArray[0] == null) continue;
                Iterator iterator2 = setArray[0].iterator();
                while (iterator2.hasNext()) {
                    string = (String)iterator2.next();
                    String string2 = fileStatusProvider.getFileStatus(string);
                    hashSet.add(string2);
                }
            }
        }
        return hashSet;
    }

    private static JMenuItem createItem(VcsCommand vcsCommand, boolean bl, List list, String string, ActionListener actionListener) {
        String[] stringArray;
        JMenuItem jMenuItem = null;
        String string2 = vcsCommand.getDisplayName();
        boolean bl2 = VcsCommandIO.getBooleanProperty(vcsCommand, "supportsAdvancedMode");
        if (bl2 && bl) {
            string2 = string2 + string;
        }
        jMenuItem = new JMenuItem(string2);
        String string3 = (String)vcsCommand.getProperty("labelMnemonic");
        if (string3 != null && string3.length() > 0) {
            jMenuItem.setMnemonic(string3.charAt(0));
        }
        if ((stringArray = vcsCommand.getPropertyNames()) != null && stringArray.length > 0) {
            jMenuItem.setActionCommand(vcsCommand.getName());
            jMenuItem.addActionListener(actionListener);
        }
        if (bl2 && !bl) {
            list.add(jMenuItem);
        }
        return jMenuItem;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPresenter(true);
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter(false);
    }

    private JMenuItem getPresenter(boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = this.isOnRoot();
        this.switchableList = new ArrayList();
        if (bl4) {
            bl3 = false;
            bl2 = false;
        } else {
            bl2 = this.isOnDirectory();
            bl3 = this.isOnFile();
        }
        Set set = this.getSelectedFileStatusAttributes();
        JInlineMenu jInlineMenu = new JInlineMenu();
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        int n = 0;
        while (n < this.actionCommandsSubTrees.length) {
            JMenuItem jMenuItem = this.getPopupPresenter(this.actionCommandsSubTrees[n], bl2, bl3, bl4, set, bl);
            if (jMenuItem != null) {
                arrayList.add(jMenuItem);
            }
            ++n;
        }
        jInlineMenu.setMenuItems(arrayList.toArray(new JMenuItem[arrayList.size()]));
        return jInlineMenu;
    }

    private JMenuItem getPopupPresenter(Node node, boolean bl, boolean bl2, boolean bl3, Set set, boolean bl4) {
        Object object;
        String string = node.getDisplayName();
        if (!node.isLeaf()) {
            object = new CommandMenu(node, bl3, bl2, bl, (VcsFileSystem)this.fileSystem.get(), set, this.switchableList, this.advancedOptionsSign, this.REMOVE_DISABLED, this);
            if (bl4) {
                ((AbstractButton)object).setIcon(this.getIcon());
            }
            JMenu jMenu = (JMenu)object;
            ((JMenuItem)object).addMenuKeyListener(new CtrlMenuKeyListener());
            jMenu.addMenuListener(new MenuListener(){

                public void menuDeselected(MenuEvent menuEvent) {
                }

                public void menuCanceled(MenuEvent menuEvent) {
                }

                public void menuSelected(MenuEvent menuEvent) {
                    VcsAction.this.deselectedMenu();
                }
            });
        } else {
            VcsCommand vcsCommand = (VcsCommand)node.getCookie(class$org$netbeans$modules$vcscore$commands$VcsCommand == null ? (class$org$netbeans$modules$vcscore$commands$VcsCommand = VcsAction.class$("org.netbeans.modules.vcscore.commands.VcsCommand")) : class$org$netbeans$modules$vcscore$commands$VcsCommand);
            if (vcsCommand == null) {
                return null;
            }
            object = VcsAction.getCommandMenuItem(vcsCommand, bl2, bl, bl3, (VcsFileSystem)this.fileSystem.get(), this.switchableList, this.advancedOptionsSign, this);
            if (object != null) {
                boolean bl5;
                if (bl4) {
                    ((AbstractButton)object).setIcon(this.getIcon());
                }
                if ((bl5 = VcsUtilities.isSetContainedInQuotedStrings((String)vcsCommand.getProperty("disabledOnStatus"), set)) && this.REMOVE_DISABLED) {
                    object = null;
                } else {
                    ((JMenuItem)object).setEnabled(!bl5);
                }
            }
        }
        return object;
    }

    private static JMenuItem getCommandMenuItem(VcsCommand vcsCommand, boolean bl, boolean bl2, boolean bl3, VcsFileSystem vcsFileSystem, List list, String string, ActionListener actionListener) {
        JMenuItem jMenuItem;
        if (vcsCommand.getDisplayName() == null || bl2 && !VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "onDir") || bl && !VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "onFile") || bl3 && !VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "onRoot") || VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "hidden")) {
            jMenuItem = null;
        } else {
            boolean bl4 = vcsFileSystem.isOffLine();
            jMenuItem = "LIST".equals(vcsCommand.getName()) && bl4 && vcsFileSystem.getCommand("LIST_OFFLINE") != null ? null : ("LIST_OFFLINE".equals(vcsCommand.getName()) && !bl4 && vcsFileSystem.getCommand("LIST") != null ? null : ("LIST_SUB".equals(vcsCommand.getName()) && bl4 ? null : ("LIST_SUB_OFFLINE".equals(vcsCommand.getName()) && !bl4 && vcsFileSystem.getCommand("LIST_SUB") != null ? null : VcsAction.createItem(vcsCommand, vcsFileSystem.isExpertMode(), list, string, actionListener))));
        }
        return jMenuItem;
    }

    public boolean enable(Node[] nodeArray) {
        FileSystem fileSystem = null;
        int n = 0;
        while (n < nodeArray.length) {
            FileSystem fileSystem2;
            Node node;
            Enumeration enumeration;
            if (nodeArray[n] instanceof VcsGroupNode) {
                enumeration = nodeArray[n].getChildren().nodes();
                while (enumeration.hasMoreElements()) {
                    node = (Node)enumeration.nextElement();
                    fileSystem2 = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? VcsAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    if (fileSystem2 == null) {
                        return false;
                    }
                    FileObject fileObject = fileSystem2.getPrimaryFile();
                    try {
                        FileSystem fileSystem3 = fileObject.getFileSystem();
                        if (fileSystem == null) {
                            fileSystem = fileSystem3;
                            continue;
                        }
                        if (fileSystem == fileSystem3) continue;
                        return false;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        return false;
                    }
                }
            } else {
                enumeration = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? VcsAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (enumeration == null) {
                    return false;
                }
                node = enumeration.getPrimaryFile();
                try {
                    fileSystem2 = node.getFileSystem();
                    if (fileSystem == null) {
                        fileSystem = fileSystem2;
                    } else if (fileSystem != fileSystem2) {
                        return false;
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return false;
                }
            }
            ++n;
        }
        return nodeArray.length > 0;
    }

    protected static void setVariables(Table table, Hashtable hashtable, String string, VariableValueAdjustment variableValueAdjustment) {
        CharSequence charSequence;
        CharSequence charSequence2;
        String string2;
        String string3 = (String)table.keys().nextElement();
        FileObject fileObject = (FileObject)table.get(string3);
        boolean bl = fileObject != null && fileObject.isFolder();
        String string4 = VcsUtilities.getDirNamePart(string3);
        String string5 = VcsUtilities.getFileNamePart(string3);
        String string6 = (String)hashtable.get("PS");
        char c = string6 != null && string6.length() == 1 ? string6.charAt(0) : File.separatorChar;
        string4 = string4.replace('/', c);
        string3 = string3.replace('/', c);
        string5 = variableValueAdjustment.adjustVarValue(string5);
        string4 = variableValueAdjustment.adjustVarValue(string4);
        if ((string3 = variableValueAdjustment.adjustVarValue(string3)).length() == 0) {
            string3 = ".";
        }
        if ((string2 = (String)hashtable.get("MODULE")) == null) {
            string2 = "";
        }
        if (string2.length() > 0) {
            string2 = string2 + string6;
        }
        hashtable.put("PATH", string3);
        hashtable.put("QPATH", string3.length() > 0 ? string + string3 + string : string3);
        hashtable.put("DIR", string4);
        if (string4.length() == 0 && string5.length() > 0 && string5.charAt(0) == '/') {
            string5 = string5.substring(1, string5.length());
        }
        hashtable.put("FILE", string5);
        hashtable.put("QFILE", string + string5 + string);
        if (fileObject != null) {
            hashtable.put("MIMETYPE", fileObject.getMIMEType());
        } else {
            int n = string5.lastIndexOf(46);
            charSequence2 = n >= 0 && n < string5.length() - 1 ? string5.substring(n + 1) : "";
            charSequence = FileUtil.getMIMEType((String)charSequence2);
            if (charSequence != null) {
                hashtable.put("MIMETYPE", charSequence);
            }
        }
        hashtable.put("FILE_IS_FOLDER", bl ? Boolean.TRUE.toString() : "");
        StringBuffer stringBuffer = new StringBuffer();
        charSequence2 = new StringBuffer();
        charSequence = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        StringBuffer stringBuffer4 = new StringBuffer();
        int n = 6;
        int n2 = table.size();
        int[][] nArray = new int[6][n2];
        int n3 = 0;
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            fileObject = (FileObject)table.get(string3);
            if (string3.length() == 0) {
                string3 = ".";
            }
            bl |= fileObject != null && fileObject.isFolder();
            string5 = VcsUtilities.getFileNamePart(string3);
            string3 = string3.replace('/', c);
            string5 = variableValueAdjustment.adjustVarValue(string5);
            string3 = variableValueAdjustment.adjustVarValue(string3);
            nArray[0][n3] = stringBuffer3.length();
            nArray[1][n3] = stringBuffer4.length();
            nArray[2][n3] = ((StringBuffer)charSequence2).length();
            nArray[3][n3] = stringBuffer.length();
            nArray[4][n3] = ((StringBuffer)charSequence).length();
            nArray[5][n3] = stringBuffer2.length();
            stringBuffer3.append(string5);
            stringBuffer3.append(c);
            stringBuffer4.append(string);
            stringBuffer4.append(string5);
            stringBuffer4.append(string);
            stringBuffer4.append(" ");
            ((StringBuffer)charSequence2).append(string3);
            ((StringBuffer)charSequence2).append("" + c + c);
            stringBuffer.append(string);
            stringBuffer.append(string3);
            stringBuffer.append(string);
            stringBuffer.append(" ");
            ((StringBuffer)charSequence).append(string2 + string3);
            ((StringBuffer)charSequence).append(" ");
            stringBuffer2.append(string);
            stringBuffer2.append(string2 + string3);
            stringBuffer2.append(string);
            stringBuffer2.append(" ");
            ++n3;
        }
        hashtable.put("FILES", stringBuffer3.delete(stringBuffer3.length() - 1, stringBuffer3.length()).toString());
        hashtable.put("QFILES", stringBuffer4.toString().trim());
        hashtable.put("PATHS", ((StringBuffer)charSequence2).delete(((StringBuffer)charSequence2).length() - 2, ((StringBuffer)charSequence2).length()).toString());
        hashtable.put("QPATHS", stringBuffer.toString().trim());
        hashtable.put("MPATHS", ((StringBuffer)charSequence).toString().trim());
        hashtable.put("QMPATHS", stringBuffer2.toString().trim());
        try {
            hashtable.put("FILES_FILE_POS_INDEXES", VcsUtilities.encodeValue(nArray[0]));
            hashtable.put("QFILES_FILE_POS_INDEXES", VcsUtilities.encodeValue(nArray[1]));
            hashtable.put("PATHS_FILE_POS_INDEXES", VcsUtilities.encodeValue(nArray[2]));
            hashtable.put("QPATHS_FILE_POS_INDEXES", VcsUtilities.encodeValue(nArray[3]));
            hashtable.put("MPATHS_FILE_POS_INDEXES", VcsUtilities.encodeValue(nArray[4]));
            hashtable.put("QMPATHS_FILE_POS_INDEXES", VcsUtilities.encodeValue(nArray[5]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        hashtable.put("NUM_FILES", "" + table.size());
        hashtable.put("MULTIPLE_FILES", table.size() > 1 ? Boolean.TRUE.toString() : "");
        hashtable.put("FILES_IS_FOLDER", bl ? Boolean.TRUE.toString() : "");
    }

    private static String[] getAttrNamesAndVars(Map map, Map map2, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length / 3];
        int n = 0;
        while (n < stringArray.length - 2) {
            String string;
            stringArray2[n / 3] = string = stringArray[n];
            map.put(string, stringArray[n + 1]);
            map2.put(string, stringArray[n + 2]);
            n += 3;
        }
        return stringArray2;
    }

    private static Table setVarsFromAttrs(Table table, Hashtable hashtable, String[] stringArray, Map map, Map map2) {
        if (stringArray.length == 0) {
            return table;
        }
        Table table2 = new Table();
        Object[] objectArray = VcsAction.getAttributes(table2, table, stringArray);
        int n = 0;
        while (n < objectArray.length) {
            hashtable.put(map.get(stringArray[n]), objectArray[n] != null ? Boolean.TRUE.toString() : "");
            if (objectArray[n] != null) {
                hashtable.put(map2.get(stringArray[n]), objectArray[n].toString());
            } else {
                hashtable.remove(map2.get(stringArray[n]));
            }
            ++n;
        }
        return table2;
    }

    private static Object[] getAttributes(Table table, Table table2, String[] stringArray) {
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = table2.keySet().iterator();
        if (!iterator.hasNext()) {
            return arrayList.toArray();
        }
        String string = (String)iterator.next();
        FileObject fileObject = (FileObject)table2.get(string);
        if (fileObject == null) {
            arrayList.addAll(Collections.nCopies(stringArray.length, null));
        } else {
            n = 0;
            while (n < stringArray.length) {
                arrayList.add(fileObject.getAttribute(stringArray[n]));
                ++n;
            }
        }
        table.put(string, fileObject);
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            fileObject = (FileObject)table2.get(string);
            if (fileObject == null) {
                if (!Arrays.equals(arrayList.toArray(), Collections.nCopies(stringArray.length, null).toArray())) {
                    continue;
                }
            } else {
                n = 0;
                while (n < stringArray.length) {
                    Object e = arrayList.get(n);
                    Object object = fileObject.getAttribute(stringArray[n]);
                    if (!(e == null && object == null || e != null && e.equals(object))) break;
                    ++n;
                }
                if (n < stringArray.length) continue;
            }
            table.put(string, fileObject);
        }
        return arrayList.toArray();
    }

    private static Table removeDisabled(FileStatusProvider fileStatusProvider, Table table, VcsCommand vcsCommand) {
        if (fileStatusProvider == null) {
            return table;
        }
        String string = (String)vcsCommand.getProperty("disabledOnStatus");
        if (string == null) {
            return table;
        }
        Table table2 = new Table();
        Enumeration enumeration = table.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = fileStatusProvider.getFileStatus(string2);
            boolean bl = VcsUtilities.isSetContainedInQuotedStrings(string, Collections.singleton(string3));
            if (bl) continue;
            table2.put(string2, table.get(string2));
        }
        return table2;
    }

    public static void performVcsCommand(VcsCommand vcsCommand, VcsFileSystem vcsFileSystem, Collection collection, boolean bl) {
        VcsAction.performVcsCommand(vcsCommand, vcsFileSystem, collection, bl, null);
    }

    public static void performVcsCommand(VcsCommand vcsCommand, VcsFileSystem vcsFileSystem, Collection collection, boolean bl, Hashtable hashtable) {
        boolean bl2 = VcsCommandIO.getBooleanPropertyAssumeDefault(vcsCommand, "processAllFiles") || vcsFileSystem.isProcessUnimportantFiles();
        Table table = new Table();
        VcsAction.addImportantFiles(collection, table, bl2, vcsFileSystem, true);
        table = VcsAction.removeDisabled(vcsFileSystem.getStatusProvider(), table, vcsCommand);
        if ("LIST".equals(vcsCommand.getName()) || "LIST_OFFLINE".equals(vcsCommand.getName())) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = table.values().iterator();
            while (iterator.hasNext()) {
                String string;
                FileObject fileObject = (FileObject)iterator.next();
                if (fileObject == null || arrayList.contains(string = fileObject.getPackageName('/'))) continue;
                VcsAction.doList(vcsFileSystem, string);
                arrayList.add(string);
            }
        } else if ("LIST_SUB".equals(vcsCommand.getName()) || "LIST_SUB_OFFLINE".equals(vcsCommand.getName())) {
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = table.values().iterator();
            while (iterator.hasNext()) {
                String string;
                FileObject fileObject = (FileObject)iterator.next();
                if (fileObject == null || arrayList.contains(string = fileObject.getPackageName('/'))) continue;
                CommandExecutorSupport.doRefresh(vcsFileSystem, string, true);
                arrayList.add(string);
            }
        } else if (table.size() > 0) {
            if (bl && !vcsFileSystem.isExpertMode()) {
                if (hashtable == null) {
                    hashtable = new Hashtable<String, Boolean>();
                }
                hashtable.put("CTRL_DOWN_IN_ACTION", Boolean.TRUE);
            }
            VcsAction.doCommand(table, vcsCommand, hashtable, vcsFileSystem);
        }
    }

    protected void performCommand(String string, Node[] nodeArray) {
        VcsFileSystem vcsFileSystem = (VcsFileSystem)this.fileSystem.get();
        VcsCommand vcsCommand = vcsFileSystem.getCommand(string);
        if (vcsCommand == null) {
            return;
        }
        if (this.selectedFileObjects != null) {
            ArrayList arrayList = new ArrayList(this.selectedFileObjects);
            if (this.variablesForSelectedFiles != null) {
                Iterator iterator = this.variablesForSelectedFiles.keySet().iterator();
                while (iterator.hasNext()) {
                    Hashtable hashtable = (Hashtable)iterator.next();
                    Collection collection = (Collection)this.variablesForSelectedFiles.get(hashtable);
                    VcsAction.performVcsCommand(vcsCommand, vcsFileSystem, collection, this.CTRL_Down, hashtable);
                    ((AbstractCollection)arrayList).removeAll(collection);
                }
                if (arrayList.size() > 0) {
                    VcsAction.performVcsCommand(vcsCommand, vcsFileSystem, arrayList, this.CTRL_Down);
                }
            } else {
                VcsAction.performVcsCommand(vcsCommand, vcsFileSystem, this.selectedFileObjects, this.CTRL_Down);
            }
        } else {
            ArrayList arrayList = new ArrayList();
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            int n = 0;
            while (n < nodeArray.length) {
                VcsGroupNode vcsGroupNode;
                if (nodeArray[n] instanceof VcsGroupNode) {
                    vcsGroupNode = (VcsGroupNode)nodeArray[n];
                    hashtable.put("GROUP_NAME", vcsGroupNode.getDisplayName());
                    hashtable.put("GROUP_DESCRIPTION", vcsGroupNode.getShortDescription());
                    Enumeration enumeration = nodeArray[n].getChildren().nodes();
                    while (enumeration.hasMoreElements()) {
                        Node node = (Node)enumeration.nextElement();
                        DataObject dataObject = (DataObject)node.getCookie(class$org$openide$loaders$DataObject == null ? VcsAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                        if (dataObject == null) continue;
                        arrayList.addAll(dataObject.files());
                    }
                } else {
                    vcsGroupNode = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? VcsAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                    if (vcsGroupNode != null) {
                        arrayList.addAll(vcsGroupNode.files());
                    }
                }
                ++n;
            }
            VcsAction.performVcsCommand(vcsCommand, vcsFileSystem, arrayList, this.CTRL_Down, hashtable);
        }
    }

    public void performAction(Node[] nodeArray) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Runnable runnable;
        final String string = actionEvent.getActionCommand();
        if (this.selectedFileObjects != null) {
            runnable = new Runnable(){

                public void run() {
                    VcsAction.this.performCommand(string, null);
                }
            };
        } else {
            object = this.getActivatedNodes();
            runnable = new Runnable((Node[])object){
                private final /* synthetic */ Node[] val$nodes;
                {
                    this.val$nodes = nodeArray;
                }

                public void run() {
                    VcsAction.this.performCommand(string, this.val$nodes);
                }
            };
        }
        object = ACTION_LOCK;
        synchronized (object) {
            if (actionRequestProcesor == null) {
                actionRequestProcesor = new RequestProcessor("Vcs Action Request Processor");
            }
        }
        actionRequestProcesor.post(runnable);
    }

    private void deselectedMenu() {
        this.changeCtrlSigns(false);
        this.CTRL_Down = false;
    }

    private void changeCtrlSigns(boolean bl) {
        if (bl == this.CTRL_Down) {
            return;
        }
        Iterator iterator = ((AbstractList)this.switchableList).iterator();
        while (iterator.hasNext()) {
            JMenuItem jMenuItem = (JMenuItem)iterator.next();
            String string = jMenuItem.getText();
            if (bl) {
                if (!string.endsWith(this.advancedOptionsSign)) {
                    string = string + this.advancedOptionsSign;
                }
            } else if (string.endsWith(this.advancedOptionsSign)) {
                string = string.substring(0, string.length() - this.advancedOptionsSign.length());
            }
            jMenuItem.setText(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ACTION_LOCK = new Object();
    }

    private static class CommandMenu
    extends JMenuPlus {
        private Node commandRoot;
        private boolean onRoot;
        private boolean onFile;
        private boolean onDir;
        private VcsFileSystem fileSystem;
        private Set statuses;
        private List switchableList;
        private String advancedOptionsSign;
        private boolean removeDisabled;
        private ActionListener listener;
        private boolean popupCreated = false;
        static /* synthetic */ Class class$org$netbeans$modules$vcscore$commands$VcsCommand;

        public CommandMenu(Node node, boolean bl, boolean bl2, boolean bl3, VcsFileSystem vcsFileSystem, Set set, List list, String string, boolean bl4, ActionListener actionListener) {
            this.commandRoot = node;
            this.onRoot = bl;
            this.onFile = bl2;
            this.onDir = bl3;
            this.fileSystem = vcsFileSystem;
            this.statuses = set;
            this.switchableList = list;
            this.advancedOptionsSign = string;
            this.removeDisabled = bl4;
            this.listener = actionListener;
            VcsCommand vcsCommand = (VcsCommand)node.getCookie(class$org$netbeans$modules$vcscore$commands$VcsCommand == null ? (class$org$netbeans$modules$vcscore$commands$VcsCommand = CommandMenu.class$("org.netbeans.modules.vcscore.commands.VcsCommand")) : class$org$netbeans$modules$vcscore$commands$VcsCommand);
            if (vcsCommand != null) {
                ((AbstractButton)((Object)this)).setText(vcsCommand.getDisplayName());
                String string2 = (String)vcsCommand.getProperty("labelMnemonic");
                if (string2 != null && string2.length() > 0) {
                    ((AbstractButton)((Object)this)).setMnemonic(string2.charAt(0));
                }
            }
        }

        public JPopupMenu getPopupMenu() {
            if (!this.popupCreated) {
                this.createPopup();
            }
            return super.getPopupMenu();
        }

        private void createPopup() {
            boolean bl = false;
            boolean bl2 = false;
            Children children = this.commandRoot.getChildren();
            Enumeration enumeration = children.nodes();
            while (enumeration.hasMoreElements()) {
                Object object;
                boolean bl3;
                Node node = (Node)enumeration.nextElement();
                VcsCommand vcsCommand = (VcsCommand)node.getCookie(class$org$netbeans$modules$vcscore$commands$VcsCommand == null ? CommandMenu.class$("org.netbeans.modules.vcscore.commands.VcsCommand") : class$org$netbeans$modules$vcscore$commands$VcsCommand);
                if (vcsCommand == null) {
                    if (!bl || bl2) {
                        ((JMenu)((Object)this)).addSeparator();
                    }
                    bl = true;
                    bl2 = true;
                    continue;
                }
                bl2 = false;
                JMenuItem jMenuItem = VcsAction.getCommandMenuItem(vcsCommand, this.onFile, this.onDir, this.onRoot, this.fileSystem, this.switchableList, this.advancedOptionsSign, this.listener);
                if (jMenuItem == null || (bl3 = VcsUtilities.isSetContainedInQuotedStrings((String)vcsCommand.getProperty("disabledOnStatus"), this.statuses)) && this.removeDisabled) continue;
                bl = false;
                if (!node.isLeaf()) {
                    CommandMenu commandMenu = new CommandMenu(node, this.onRoot, this.onFile, this.onDir, this.fileSystem, this.statuses, this.switchableList, this.advancedOptionsSign, this.removeDisabled, this.listener);
                    ((JMenu)((Object)this)).add((JMenuItem)((Object)commandMenu));
                    object = commandMenu;
                } else {
                    object = jMenuItem;
                    ((JMenu)((Object)this)).add((JMenuItem)object);
                }
                if (!bl3) continue;
                object.setEnabled(false);
            }
            this.popupCreated = true;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class CtrlMenuKeyListener
    implements MenuKeyListener {
        private CtrlMenuKeyListener() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            boolean bl = "Ctrl".equals(KeyEvent.getKeyText(menuKeyEvent.getKeyCode())) || menuKeyEvent.isControlDown();
            VcsAction.this.changeCtrlSigns(bl);
            VcsAction.this.CTRL_Down = bl;
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
            boolean bl = "Ctrl".equals(KeyEvent.getKeyText(menuKeyEvent.getKeyCode())) || !menuKeyEvent.isControlDown();
            VcsAction.this.changeCtrlSigns(!bl);
            VcsAction.this.CTRL_Down = !bl;
        }
    }
}

