/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.util.HelpCtx;

public class ParamsPanel
extends JPanel {
    private ArrayList arguments = new ArrayList();
    private int editingRow = -1;
    private ParamsListModel model;
    static final long serialVersionUID = -3754019215574878093L;
    private JScrollPane codeScroll;
    private JPanel addRemovePanel;
    private JEditorPane codePane;
    private JLabel codeLabel;
    private JList paramsList;
    private JButton addParamButton;
    private JLabel paramLabel;
    private JScrollPane paramsScroll;
    private JButton removeParamButton;

    public ParamsPanel() {
        this.initComponents();
        this.initAccessibility();
        this.paramsList.setModel(this.getListModel());
        this.paramsList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ParamsPanel.this.paramsList.getSelectedIndex() != -1) {
                    ParamsPanel.this.updateEditor(ParamsPanel.this.paramsList.getSelectedIndex());
                }
                ParamsPanel.this.removeParamButton.setEnabled(ParamsPanel.this.paramsList.getSelectedIndex() != -1);
            }
        });
        this.removeParamButton.setEnabled(this.paramsList.getSelectedIndex() != -1);
        HelpCtx.setHelpIDString((JComponent)this, (String)"internation.addparams");
    }

    public void setArguments(String[] stringArray) {
        this.arguments.clear();
        int n = 0;
        while (n < stringArray.length) {
            this.arguments.add(stringArray[n]);
            ++n;
        }
        if (this.getListModel().getSize() > 0) {
            this.getListModel().fireIntervalAdded(0, this.getListModel().getSize() - 1);
        }
        if (this.getListModel().getSize() > 0) {
            this.editRow(0);
        } else {
            this.editRow(-1);
        }
    }

    public String[] getArguments() {
        this.commitChanges();
        int n = -1;
        int n2 = 0;
        while (n2 < this.arguments.size()) {
            if (((String)this.arguments.get(n2)).trim().length() > 0) {
                n = n2;
            }
            ++n2;
        }
        String[] stringArray = new String[n + 1];
        int n3 = 0;
        while (n3 <= n) {
            stringArray[n3] = (String)this.arguments.get(n3);
            ++n3;
        }
        return stringArray;
    }

    private void commitChanges() {
        if (this.editingRow != -1) {
            this.arguments.set(this.editingRow, this.codePane.getText());
            this.getListModel().fireContentsChanged(this.editingRow, this.editingRow);
        }
    }

    private void editRow(int n) {
        if (n != -1) {
            this.paramsList.setSelectedIndex(n);
        } else {
            this.paramsList.setSelectedIndices(new int[0]);
        }
    }

    private void updateEditor(int n) {
        this.commitChanges();
        this.editingRow = n;
        if (n == -1) {
            this.codePane.setText("");
            this.codePane.setEnabled(false);
        } else {
            this.codePane.setText((String)this.arguments.get(this.editingRow));
            this.codePane.setEnabled(true);
            this.codePane.requestFocus();
        }
    }

    private ParamsListModel getListModel() {
        if (this.model == null) {
            this.model = new ParamsListModel();
        }
        return this.model;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_ParamsPanel"));
        this.codeLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Code_Mnem").charAt(0));
        this.paramLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Parameters_Mnem").charAt(0));
        this.removeParamButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_RemoveButton"));
        this.addParamButton.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_CTL_AddButton"));
        this.paramsList.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_paramsList"));
    }

    private void initComponents() {
        this.paramLabel = new JLabel();
        this.codeLabel = new JLabel();
        this.paramsScroll = new JScrollPane();
        this.paramsList = new JList();
        this.addRemovePanel = new JPanel();
        this.addParamButton = new JButton();
        this.removeParamButton = new JButton();
        this.codeScroll = new JScrollPane();
        this.codePane = new JEditorPane();
        this.setLayout(new GridBagLayout());
        this.paramLabel.setText(I18nUtil.getBundle().getString("LBL_Parameters"));
        this.paramLabel.setLabelFor(this.paramsList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.paramLabel, gridBagConstraints);
        this.codeLabel.setText(I18nUtil.getBundle().getString("LBL_Code"));
        this.codeLabel.setLabelFor(this.codePane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.codeLabel, gridBagConstraints);
        this.paramsList.setVisibleRowCount(3);
        this.paramsList.setSelectionMode(0);
        this.paramsScroll.setViewportView(this.paramsList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.paramsScroll, gridBagConstraints);
        this.addRemovePanel.setLayout(new GridBagLayout());
        this.addParamButton.setMnemonic(I18nUtil.getBundle().getString("CTL_AddButton_Mnem").charAt(0));
        this.addParamButton.setText(I18nUtil.getBundle().getString("CTL_AddButton"));
        this.addParamButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParamsPanel.this.addParamButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.addRemovePanel.add((Component)this.addParamButton, gridBagConstraints);
        this.removeParamButton.setMnemonic(I18nUtil.getBundle().getString("CTL_RemoveButton_Mnem").charAt(0));
        this.removeParamButton.setText(I18nUtil.getBundle().getString("CTL_RemoveButton"));
        this.removeParamButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParamsPanel.this.removeParamButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.addRemovePanel.add((Component)this.removeParamButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 11, 0, 11);
        this.add((Component)this.addRemovePanel, gridBagConstraints);
        this.codePane.setFont(new Font("Courier New", 0, 11));
        this.codePane.setContentType("text/x-java");
        this.codePane.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ParamsPanel.this.codePaneFocusLost(focusEvent);
            }
        });
        this.codeScroll.setViewportView(this.codePane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 11, 11);
        this.add((Component)this.codeScroll, gridBagConstraints);
    }

    private void codePaneFocusLost(FocusEvent focusEvent) {
        this.commitChanges();
    }

    private void removeParamButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.paramsList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.arguments.remove(n);
        this.getListModel().fireIntervalRemoved(n, n);
        if (n >= this.arguments.size()) {
            --n;
        }
        this.editingRow = -1;
        this.editRow(n);
    }

    private void addParamButtonActionPerformed(ActionEvent actionEvent) {
        this.arguments.add("");
        this.getListModel().fireIntervalAdded(this.getListModel().getSize() - 1, this.getListModel().getSize() - 1);
        this.editRow(this.getListModel().getSize() - 1);
    }

    protected class ParamsListModel
    extends AbstractListModel {
        static final long serialVersionUID = 6832148996617470334L;

        public int getSize() {
            return ParamsPanel.this.arguments.size();
        }

        public Object getElementAt(int n) {
            return "{" + n + "}  " + (String)ParamsPanel.this.arguments.get(n);
        }

        public void fireContentsChanged(int n, int n2) {
            super.fireContentsChanged(this, n, n2);
        }

        public void fireIntervalAdded(int n, int n2) {
            super.fireIntervalAdded(this, n, n2);
        }

        public void fireIntervalRemoved(int n, int n2) {
            super.fireIntervalRemoved(this, n, n2);
        }
    }
}

