/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.io.IOException;
import java.util.Arrays;
import org.openide.loaders.DataObject;

public abstract class ResourceHolder {
    protected DataObject resource;
    protected final Class[] resourceClasses;

    public ResourceHolder(Class[] classArray) {
        if (classArray == null || classArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.resourceClasses = classArray;
    }

    public void setResource(DataObject dataObject) {
        Class<?> clazz = dataObject.getClass();
        if (!Arrays.asList(this.resourceClasses).contains(clazz)) {
            throw new IllegalArgumentException();
        }
        if (!dataObject.equals(this.resource)) {
            this.resource = dataObject;
        }
    }

    public DataObject getResource() {
        return this.resource;
    }

    public Class[] getResourceClasses() {
        return this.resourceClasses;
    }

    public abstract String[] getAllKeys();

    public abstract String getValueForKey(String var1);

    public abstract String getCommentForKey(String var1);

    public abstract void addProperty(Object var1, Object var2, String var3);

    public abstract void addProperty(Object var1, Object var2, String var3, boolean var4);

    public final DataObject getTemplate(Class clazz) throws IOException {
        if (!Arrays.asList(this.resourceClasses).contains(clazz)) {
            throw new IllegalArgumentException();
        }
        return this.createTemplate(clazz);
    }

    protected abstract DataObject createTemplate(Class var1) throws IOException;
}

