/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nOptions;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public final class I18nUtil {
    public static final String HELP_ID_I18N = "internation.internation";
    public static final String HELP_ID_AUTOINSERT = "internation.autoinsert";
    public static final String HELP_ID_MANINSERT = "internation.maninsert";
    public static final String HELP_ID_FORMED = "internation.formed";
    public static final String HELP_ID_TESTING = "internation.testing";
    public static final String HELP_ID_WIZARD = "internation.wizard";
    public static final String HELP_ID_CUSTOM = "internation.custom";
    public static final String HELP_ID_ADDPARAMS = "internation.addparams";
    public static final String HELP_ID_REPLFORMAT = "internation.replformat";
    public static final String HELP_ID_RUNLOCALE = "internation.runlocale";
    private static List initFormatItems;
    private static List initHelpItems;
    private static List replaceFormatItems;
    private static List replaceHelpItems;
    private static List regExpItems;
    private static List regExpHelpItems;
    private static List i18nRegExpItems;
    private static ResourceBundle bundle;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$I18nModule;
    static /* synthetic */ Class class$org$netbeans$modules$i18n$I18nOptions;

    public static List getInitFormatItems() {
        if (initFormatItems == null) {
            initFormatItems = new ArrayList(2);
            initFormatItems.add("java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\")");
            initFormatItems.add("org.openide.util.NbBundle.getBundle({sourceFileName}.class)");
        }
        return initFormatItems;
    }

    public static List getInitHelpItems() {
        if (initHelpItems == null) {
            initHelpItems = new ArrayList(3);
            initHelpItems.add("{bundleNameSlashes} - " + I18nUtil.getBundle().getString("TXT_PackageNameSlashes"));
            initHelpItems.add("{bundleNameDots} - " + I18nUtil.getBundle().getString("TXT_PackageNameDots"));
            initHelpItems.add("{sourceFileName} - " + I18nUtil.getBundle().getString("TXT_SourceDataObjectName"));
        }
        return initHelpItems;
    }

    public static List getReplaceFormatItems() {
        if (replaceFormatItems == null) {
            replaceFormatItems = new ArrayList(7);
            replaceFormatItems.add("{identifier}.getString(\"{key}\")");
            replaceFormatItems.add("Utilities.getString(\"{key}\")");
            replaceFormatItems.add("java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\").getString(\"{key}\")");
            replaceFormatItems.add("org.openide.util.NbBundle.getBundle({sourceFileName}.class).getString(\"{key}\")");
            replaceFormatItems.add("java.text.MessageFormat(java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\").getString(\"{key}\"), {arguments})");
            replaceFormatItems.add("org.openide.util.NbBundle.getMessage({sourceFileName}.class, \"{key}\")");
            replaceFormatItems.add("org.openide.util.NbBundle.getMessage({sourceFileName}.class, \"{key}\", {arguments})");
        }
        return replaceFormatItems;
    }

    public static List getReplaceHelpItems() {
        if (replaceHelpItems == null) {
            replaceHelpItems = new ArrayList(5);
            replaceHelpItems.add("{identifier} - " + I18nUtil.getBundle().getString("TXT_FieldIdentifier"));
            replaceHelpItems.add("{key} - " + I18nUtil.getBundle().getString("TXT_KeyHelp"));
            replaceHelpItems.add("{bundleNameSlashes} - " + I18nUtil.getBundle().getString("TXT_PackageNameSlashes"));
            replaceHelpItems.add("{bundleNameDots} - " + I18nUtil.getBundle().getString("TXT_PackageNameDots"));
            replaceHelpItems.add("{sourceFileName} - " + I18nUtil.getBundle().getString("TXT_SourceDataObjectName"));
            replaceHelpItems.add("{arguments} - " + I18nUtil.getBundle().getString("TXT_Arguments"));
        }
        return replaceHelpItems;
    }

    public static List getRegExpItems() {
        if (regExpItems == null) {
            regExpItems = new ArrayList(4);
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*{hardString}");
            regExpItems.add("// NOI18N");
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*{hardString}|// NOI18N");
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*{hardString}|// NOI18N");
        }
        return regExpItems;
    }

    public static List getI18nRegExpItems() {
        if (i18nRegExpItems == null) {
            i18nRegExpItems = new ArrayList(2);
            i18nRegExpItems.add("getString[:space:]*\\([:space:]*{hardString}");
            i18nRegExpItems.add("(getString[:space:]*\\([:space:]*|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*){hardString}");
        }
        return i18nRegExpItems;
    }

    public static List getRegExpHelpItems() {
        if (regExpHelpItems == null) {
            regExpHelpItems = new ArrayList(15);
            regExpHelpItems.add("{hardString} - " + I18nUtil.getBundle().getString("TXT_HardString"));
            regExpHelpItems.add("[:alnum:] - " + I18nUtil.getBundle().getString("TXT_Alnum"));
            regExpHelpItems.add("[:alpha:] - " + I18nUtil.getBundle().getString("TXT_Alpha"));
            regExpHelpItems.add("[:blank:] - " + I18nUtil.getBundle().getString("TXT_Blank"));
            regExpHelpItems.add("[:cntrl:] - " + I18nUtil.getBundle().getString("TXT_Cntrl"));
            regExpHelpItems.add("[:digit:] - " + I18nUtil.getBundle().getString("TXT_Digit"));
            regExpHelpItems.add("[:graph:] - " + I18nUtil.getBundle().getString("TXT_Graph"));
            regExpHelpItems.add("[:lower:] - " + I18nUtil.getBundle().getString("TXT_Lower"));
            regExpHelpItems.add("[:print:] - " + I18nUtil.getBundle().getString("TXT_Print"));
            regExpHelpItems.add("[:punct:] - " + I18nUtil.getBundle().getString("TXT_Punct"));
            regExpHelpItems.add("[:space:] - " + I18nUtil.getBundle().getString("TXT_Space"));
            regExpHelpItems.add("[:upper:] - " + I18nUtil.getBundle().getString("TXT_Upper"));
            regExpHelpItems.add("[:xdigit:] - " + I18nUtil.getBundle().getString("TXT_Xdigit"));
            regExpHelpItems.add("[:javastart:] - " + I18nUtil.getBundle().getString("TXT_Javastart"));
            regExpHelpItems.add("[:javapart:] - " + I18nUtil.getBundle().getString("TXT_Javapart"));
        }
        return regExpHelpItems;
    }

    public static boolean containsAcceptedDataObject(DataFolder dataFolder) {
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (dataObjectArray[n] instanceof DataFolder ? I18nUtil.containsAcceptedDataObject((DataFolder)dataObjectArray[n]) : FactoryRegistry.hasFactory(dataObjectArray[n].getClass())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static List getAcceptedDataObjects(DataFolder dataFolder) {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (dataObjectArray[n] instanceof DataFolder) {
                arrayList.addAll(I18nUtil.getAcceptedDataObjects((DataFolder)dataObjectArray[n]));
            } else if (FactoryRegistry.hasFactory(dataObjectArray[n].getClass())) {
                arrayList.add(dataObjectArray[n]);
            }
            ++n;
        }
        return arrayList;
    }

    public static Map createWizardSettings() {
        return new TreeMap(new DataObjectComparator());
    }

    public static Map createWizardSettings(Node[] nodeArray) {
        Map map = I18nUtil.createWizardSettings();
        if (nodeArray != null && nodeArray.length > 0) {
            int n = 0;
            while (n < nodeArray.length) {
                DataObject dataObject = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? I18nUtil.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
                if (dataObject != null) {
                    if (dataObject instanceof DataFolder) {
                        Iterator iterator = I18nUtil.getAcceptedDataObjects((DataFolder)dataObject).iterator();
                        while (iterator.hasNext()) {
                            I18nUtil.addSource(map, (DataObject)iterator.next());
                        }
                    } else if (FactoryRegistry.hasFactory(dataObject.getClass())) {
                        I18nUtil.addSource(map, dataObject);
                    }
                }
                ++n;
            }
        }
        return map;
    }

    public static void addSource(Map map, DataObject dataObject) {
        if (map.containsKey(dataObject)) {
            return;
        }
        DataFolder dataFolder = dataObject.getFolder();
        if (dataFolder == null) {
            map.put(dataObject, null);
            return;
        }
        DataObject[] dataObjectArray = dataFolder.getChildren();
        int n = 0;
        while (n < dataObjectArray.length) {
            if (dataObjectArray[n] instanceof PropertiesDataObject) {
                map.put(dataObject, new SourceData(dataObjectArray[n]));
                return;
            }
            ++n;
        }
        map.put(dataObject, null);
    }

    public static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$i18n$I18nModule == null ? (class$org$netbeans$modules$i18n$I18nModule = I18nUtil.class$("org.netbeans.modules.i18n.I18nModule")) : class$org$netbeans$modules$i18n$I18nModule));
        }
        return bundle;
    }

    public static I18nOptions getOptions() {
        return (I18nOptions)SharedClassObject.findObject((Class)(class$org$netbeans$modules$i18n$I18nOptions == null ? (class$org$netbeans$modules$i18n$I18nOptions = I18nUtil.class$("org.netbeans.modules.i18n.I18nOptions")) : class$org$netbeans$modules$i18n$I18nOptions), (boolean)true);
    }

    public static boolean isDebug() {
        return Boolean.getBoolean("netbeans.debug.exceptions");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class DataObjectComparator
    implements Comparator {
        private DataObjectComparator() {
        }

        public int compare(Object object, Object object2) {
            if (!(object instanceof DataObject) || !(object2 instanceof DataObject)) {
                return 0;
            }
            DataObject dataObject = (DataObject)object;
            DataObject dataObject2 = (DataObject)object2;
            if (dataObject == dataObject2) {
                return 0;
            }
            if (dataObject == null) {
                return -1;
            }
            if (dataObject2 == null) {
                return 1;
            }
            return dataObject.getPrimaryFile().getPackageName('.').compareTo(dataObject2.getPrimaryFile().getPackageName('.'));
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

