/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.HashMap;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;

public abstract class I18nString {
    protected I18nSupport support;
    protected String key;
    protected String value;
    protected String comment;
    protected String replaceFormat;

    public I18nString(I18nSupport i18nSupport) {
        if (i18nSupport == null) {
            throw new IllegalArgumentException();
        }
        this.support = i18nSupport;
        this.replaceFormat = I18nUtil.getOptions().getReplaceJavaCode();
    }

    public I18nSupport getSupport() {
        return this.support;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String string) {
        if (this.key == string || this.key != null && this.key.equals(string)) {
            return;
        }
        this.key = string;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (this.value == string || this.value != null && this.value.equals(string)) {
            return;
        }
        this.value = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        if (this.comment == string || this.comment != null && this.comment.equals(string)) {
            return;
        }
        this.comment = string;
    }

    public String getReplaceFormat() {
        return this.replaceFormat;
    }

    public void setReplaceFormat(String string) {
        this.replaceFormat = string;
    }

    public String getReplaceString() {
        if (this.getKey() == null || this.getSupport() == null || this.getSupport().getResourceHolder().getResource() == null) {
            return null;
        }
        if (this.replaceFormat == null) {
            this.replaceFormat = I18nUtil.getOptions().getReplaceJavaCode();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("key", this.getKey());
        hashMap.put("bundleNameSlashes", this.getSupport().getResourceHolder().getResource().getPrimaryFile().getPackageName('/'));
        hashMap.put("bundleNameDots", this.getSupport().getResourceHolder().getResource().getPrimaryFile().getPackageName('.'));
        DataObject dataObject = this.getSupport().getSourceDataObject();
        hashMap.put("sourceFileName", dataObject == null ? "" : dataObject.getPrimaryFile().getName());
        return MapFormat.format((String)this.replaceFormat, hashMap);
    }
}

