/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditorSupport;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import org.netbeans.beaninfo.editors.StringEditor;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;

public class HelpStringCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private JScrollPane scrollPane;
    private JLabel listLabel;
    private JComboBox combo;
    private JLabel comboLabel;
    private JList list;

    public HelpStringCustomEditor(String string, List list, List list2, String string2) {
        this.initComponents();
        this.combo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.combo.setSelectedItem(string);
        this.list.setListData(list2.toArray());
        this.list.setBackground(new Color(SystemColor.window.getRGB()));
        this.comboLabel.setText(string2);
        this.comboLabel.setDisplayedMnemonic(string2.charAt(0));
        this.listLabel.setText(I18nUtil.getBundle().getString("LBL_Arguments"));
        this.listLabel.setDisplayedMnemonic(I18nUtil.getBundle().getString("LBL_Arguments_Mnem").charAt(0));
        this.initAccessibility();
        HelpCtx.setHelpIDString((JComponent)this, (String)"internation.custom");
    }

    public Object getPropertyValue() throws IllegalStateException {
        return (String)this.combo.getSelectedItem();
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringCustomEditor"));
        this.combo.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringCombo"));
        this.list.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_HelpStringList"));
    }

    private void initComponents() {
        this.combo = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.comboLabel = new JLabel();
        this.listLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.combo.setEditable(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add((Component)this.combo, gridBagConstraints);
        this.list.setSelectionMode(0);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                HelpStringCustomEditor.this.listKeyPressed(keyEvent);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                HelpStringCustomEditor.this.listMouseClicked(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 11, 11);
        this.add((Component)this.scrollPane, gridBagConstraints);
        this.comboLabel.setText("comboLabel");
        this.comboLabel.setLabelFor(this.combo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.comboLabel, gridBagConstraints);
        this.listLabel.setText("listLabel");
        this.listLabel.setLabelFor(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.listLabel, gridBagConstraints);
    }

    private void listKeyPressed(KeyEvent keyEvent) {
        String string = (String)this.list.getSelectedValue();
        if (keyEvent.getKeyCode() == 10 && string != null) {
            keyEvent.consume();
            this.insertInFormat(string);
        }
    }

    private void listMouseClicked(MouseEvent mouseEvent) {
        String string = (String)this.list.getSelectedValue();
        if (mouseEvent.getClickCount() == 2 && string != null) {
            this.insertInFormat(string);
        }
    }

    private void insertInFormat(String string) {
        block3: {
            int n = string.indexOf(32);
            if (n < 0 || n > string.length()) {
                return;
            }
            String string2 = string.substring(0, n);
            JTextField jTextField = (JTextField)this.combo.getEditor().getEditorComponent();
            try {
                jTextField.getDocument().insertString(jTextField.getCaretPosition(), string2, null);
            }
            catch (BadLocationException badLocationException) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                System.err.println("I18N: Text not inserted in property editor");
            }
        }
    }

    public static class I18nRegExpEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)((PropertyEditorSupport)((Object)this)).getValue(), I18nUtil.getI18nRegExpItems(), I18nUtil.getRegExpHelpItems(), I18nUtil.getBundle().getString("LBL_I18nRegExpFormat"));
        }
    }

    public static class RegExpEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)((PropertyEditorSupport)((Object)this)).getValue(), I18nUtil.getRegExpItems(), I18nUtil.getRegExpHelpItems(), I18nUtil.getBundle().getString("LBL_NonI18nRegExpFormat"));
        }
    }

    public static class ReplaceCodeEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)((PropertyEditorSupport)((Object)this)).getValue(), I18nUtil.getReplaceFormatItems(), I18nUtil.getReplaceHelpItems(), I18nUtil.getBundle().getString("LBL_ReplaceCodeFormat"));
        }
    }

    public static class InitCodeEditor
    extends StringEditor {
        public Component getCustomEditor() {
            return new HelpStringCustomEditor((String)((PropertyEditorSupport)((Object)this)).getValue(), I18nUtil.getInitFormatItems(), I18nUtil.getInitHelpItems(), I18nUtil.getBundle().getString("LBL_InitCodeFormat"));
        }
    }
}

