/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.SAXParser;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ejb.DescriptorHandler;
import org.apache.tools.ant.taskdefs.optional.ejb.EJBDeploymentTool;
import org.apache.tools.ant.taskdefs.optional.ejb.EjbJar;
import org.apache.tools.ant.taskdefs.optional.ejb.InnerClassFilenameFilter;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GenericDeploymentTool
implements EJBDeploymentTool {
    protected static final String META_DIR = "META-INF/";
    protected static final String EJB_DD = "ejb-jar.xml";
    private EjbJar.Config config;
    private File destDir;
    private Path classpath;
    private String genericJarSuffix = "-generic.jar";
    private Task task;
    private ClassLoader classpathLoader = null;
    private List addedfiles;
    private DescriptorHandler handler;

    public void setDestdir(File inDir) {
        this.destDir = inDir;
    }

    protected File getDestDir() {
        return this.destDir;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    protected Task getTask() {
        return this.task;
    }

    protected EjbJar.Config getConfig() {
        return this.config;
    }

    protected boolean usingBaseJarName() {
        return this.config.baseJarName != null;
    }

    public void setGenericJarSuffix(String inString) {
        this.genericJarSuffix = inString;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.task.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    protected Path getCombinedClasspath() {
        Path combinedPath = this.classpath;
        if (this.config.classpath != null) {
            if (combinedPath == null) {
                combinedPath = this.config.classpath;
            } else {
                combinedPath.append(this.config.classpath);
            }
        }
        return combinedPath;
    }

    protected void log(String message, int level) {
        this.getTask().log(message, level);
    }

    protected Location getLocation() {
        return this.getTask().getLocation();
    }

    public void configure(EjbJar.Config config) {
        this.config = config;
        this.classpathLoader = null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addFileToJar(JarOutputStream jStream, File inputFile, String logicalFilename) throws BuildException {
        FileInputStream iStream;
        block9: {
            iStream = null;
            if (this.addedfiles.contains(logicalFilename)) break block9;
            iStream = new FileInputStream(inputFile);
            ZipEntry zipEntry = new ZipEntry(logicalFilename.replace('\\', '/'));
            jStream.putNextEntry(zipEntry);
            byte[] byteBuffer = new byte[2048];
            int count = 0;
            do {
                jStream.write(byteBuffer, 0, count);
            } while ((count = iStream.read(byteBuffer, 0, byteBuffer.length)) != -1);
            this.addedfiles.add(logicalFilename);
        }
        Object var9_9 = null;
        if (iStream == null) return;
        try {
            iStream.close();
            return;
        }
        catch (IOException closeException) {}
        return;
        {
            catch (IOException ioe) {
                this.log("WARNING: IOException while adding entry " + logicalFilename + " to jarfile from " + inputFile.getPath() + " " + ioe.getClass().getName() + "-" + ioe.getMessage(), 1);
                Object var9_10 = null;
                if (iStream == null) return;
                try {
                    iStream.close();
                    return;
                }
                catch (IOException closeException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (iStream == null) throw throwable;
            try {
                iStream.close();
                throw throwable;
            }
            catch (IOException closeException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected DescriptorHandler getDescriptorHandler(File srcDir) {
        DescriptorHandler handler = new DescriptorHandler(this.getTask(), srcDir);
        this.registerKnownDTDs(handler);
        Iterator i = ((AbstractList)this.getConfig().dtdLocations).iterator();
        while (i.hasNext()) {
            EjbJar.DTDLocation dtdLocation = (EjbJar.DTDLocation)i.next();
            handler.registerDTD(dtdLocation.getPublicId(), dtdLocation.getLocation());
        }
        return handler;
    }

    protected void registerKnownDTDs(DescriptorHandler handler) {
    }

    public void processDescriptor(String descriptorFileName, SAXParser saxParser) {
        this.checkConfiguration(descriptorFileName, saxParser);
        try {
            File jarFile;
            this.handler = this.getDescriptorHandler(this.config.srcDir);
            Hashtable ejbFiles = this.parseEjbFiles(descriptorFileName, saxParser);
            this.addSupportClasses(ejbFiles);
            String baseName = this.getJarBaseName(descriptorFileName);
            String ddPrefix = this.getVendorDDPrefix(baseName, descriptorFileName);
            ejbFiles.put("META-INF/ejb-jar.xml", new File(this.config.descriptorDir, descriptorFileName));
            this.addVendorFiles(ejbFiles, ddPrefix);
            this.checkAndAddInherited(ejbFiles);
            if (this.config.flatDestDir && baseName.length() != 0) {
                int startName = baseName.lastIndexOf(File.separator);
                if (startName == -1) {
                    startName = 0;
                }
                int endName = baseName.length();
                baseName = baseName.substring(startName, endName);
            }
            if (this.needToRebuild(ejbFiles, jarFile = this.getVendorOutputJarFile(baseName))) {
                this.log("building " + jarFile.getName() + " with " + String.valueOf(ejbFiles.size()) + " files", 2);
                String publicId = this.getPublicId();
                this.writeJar(baseName, jarFile, ejbFiles, publicId);
            } else {
                this.log(jarFile.toString() + " is up to date.", 3);
            }
        }
        catch (SAXException se) {
            String msg = "SAXException while parsing '" + descriptorFileName.toString() + "'. This probably indicates badly-formed XML." + "  Details: " + se.getMessage();
            throw new BuildException(msg, (Throwable)se);
        }
        catch (IOException ioe) {
            String msg = "IOException while parsing'" + descriptorFileName.toString() + "'.  This probably indicates that the descriptor" + " doesn't exist. Details: " + ioe.getMessage();
            throw new BuildException(msg, (Throwable)ioe);
        }
    }

    protected void checkConfiguration(String descriptorFileName, SAXParser saxParser) throws BuildException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Hashtable parseEjbFiles(String descriptorFileName, SAXParser saxParser) throws IOException, SAXException {
        FileInputStream descriptorStream = null;
        Hashtable ejbFiles = null;
        try {
            descriptorStream = new FileInputStream(new File(this.config.descriptorDir, descriptorFileName));
            saxParser.parse(new InputSource(descriptorStream), (HandlerBase)this.handler);
            ejbFiles = this.handler.getFiles();
            Object var6_5 = null;
            if (descriptorStream == null) return ejbFiles;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (descriptorStream == null) throw throwable;
            try {
                descriptorStream.close();
                throw throwable;
            }
            catch (IOException closeException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            descriptorStream.close();
            return ejbFiles;
        }
        catch (IOException closeException) {}
        return ejbFiles;
    }

    protected void addSupportClasses(Hashtable ejbFiles) {
        Project project = this.task.getProject();
        Iterator i = this.config.supportFileSets.iterator();
        while (i.hasNext()) {
            FileSet supportFileSet = (FileSet)i.next();
            File supportBaseDir = supportFileSet.getDir(project);
            DirectoryScanner supportScanner = supportFileSet.getDirectoryScanner(project);
            supportScanner.scan();
            String[] supportFiles = supportScanner.getIncludedFiles();
            int j = 0;
            while (j < supportFiles.length) {
                ejbFiles.put(supportFiles[j], new File(supportBaseDir, supportFiles[j]));
                ++j;
            }
        }
    }

    protected String getJarBaseName(String descriptorFileName) {
        String baseName = "";
        if (this.config.namingScheme.getValue().equals("basejarname")) {
            String canonicalDescriptor = descriptorFileName.replace('\\', '/');
            int index = canonicalDescriptor.lastIndexOf(47);
            if (index != -1) {
                baseName = descriptorFileName.substring(0, index + 1);
            }
            baseName = baseName + this.config.baseJarName;
        } else if (this.config.namingScheme.getValue().equals("descriptor")) {
            int lastSeparatorIndex = descriptorFileName.lastIndexOf(File.separator);
            int endBaseName = -1;
            endBaseName = lastSeparatorIndex != -1 ? descriptorFileName.indexOf(this.config.baseNameTerminator, lastSeparatorIndex) : descriptorFileName.indexOf(this.config.baseNameTerminator);
            if (endBaseName != -1) {
                baseName = descriptorFileName.substring(0, endBaseName);
            }
            baseName = descriptorFileName.substring(0, endBaseName);
        } else if (this.config.namingScheme.getValue().equals("directory")) {
            int lastSeparatorIndex = descriptorFileName.lastIndexOf(File.separator);
            String dirName = descriptorFileName.substring(0, lastSeparatorIndex);
            int dirSeparatorIndex = dirName.lastIndexOf(File.separator);
            if (dirSeparatorIndex != -1) {
                dirName = dirName.substring(dirSeparatorIndex + 1);
            }
            baseName = dirName;
        } else if (this.config.namingScheme.getValue().equals("ejb-name")) {
            baseName = this.handler.getEjbName();
        }
        return baseName;
    }

    public String getVendorDDPrefix(String baseName, String descriptorFileName) {
        String ddPrefix = null;
        if (this.config.namingScheme.getValue().equals("descriptor")) {
            ddPrefix = baseName + this.config.baseNameTerminator;
        } else if (this.config.namingScheme.getValue().equals("basejarname") || this.config.namingScheme.getValue().equals("ejb-name") || this.config.namingScheme.getValue().equals("directory")) {
            String canonicalDescriptor = descriptorFileName.replace('\\', '/');
            int index = canonicalDescriptor.lastIndexOf(47);
            ddPrefix = index == -1 ? "" : descriptorFileName.substring(0, index + 1);
        }
        return ddPrefix;
    }

    protected void addVendorFiles(Hashtable ejbFiles, String ddPrefix) {
    }

    File getVendorOutputJarFile(String baseName) {
        return new File(this.destDir, baseName + this.genericJarSuffix);
    }

    protected boolean needToRebuild(Hashtable ejbFiles, File jarFile) {
        if (jarFile.exists()) {
            long lastBuild = jarFile.lastModified();
            if (this.config.manifest != null && this.config.manifest.exists() && this.config.manifest.lastModified() > lastBuild) {
                this.log("Build needed because manifest " + this.config.manifest + " is out of date", 3);
                return true;
            }
            Iterator fileIter = ejbFiles.values().iterator();
            while (fileIter.hasNext()) {
                File currentFile = (File)fileIter.next();
                if (lastBuild >= currentFile.lastModified()) continue;
                this.log("Build needed because " + currentFile.getPath() + " is out of date", 3);
                return true;
            }
            return false;
        }
        return true;
    }

    protected String getPublicId() {
        return this.handler.getPublicId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeJar(String baseName, File jarfile, Hashtable files, String publicId) throws BuildException {
        ZipOutputStream jarStream = null;
        try {
            try {
                Manifest manifest;
                block19: {
                    this.addedfiles = new ArrayList();
                    if (jarfile.exists()) {
                        jarfile.delete();
                    }
                    jarfile.getParentFile().mkdirs();
                    jarfile.createNewFile();
                    InputStream in = null;
                    manifest = null;
                    try {
                        try {
                            if (this.config.manifest != null) {
                                in = new FileInputStream(this.config.manifest);
                                if (in == null) {
                                    throw new BuildException("Could not find manifest file: " + this.config.manifest, this.getLocation());
                                }
                            } else {
                                String defaultManifest = "/org/apache/tools/ant/defaultManifest.mf";
                                in = this.getClass().getResourceAsStream(defaultManifest);
                                if (in == null) {
                                    throw new BuildException("Could not find default manifest: " + defaultManifest, this.getLocation());
                                }
                            }
                            manifest = new Manifest(in);
                        }
                        catch (IOException e) {
                            throw new BuildException("Unable to read manifest", (Throwable)e, this.getLocation());
                        }
                        Object var10_12 = null;
                        if (in == null) break block19;
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
                jarStream = new JarOutputStream((OutputStream)new FileOutputStream(jarfile), manifest);
                jarStream.setMethod(8);
                Iterator entryIterator = files.keySet().iterator();
                while (entryIterator.hasNext()) {
                    String entryName = (String)entryIterator.next();
                    File entryFile = (File)files.get(entryName);
                    this.log("adding file '" + entryName + "'", 3);
                    this.addFileToJar((JarOutputStream)jarStream, entryFile, entryName);
                    InnerClassFilenameFilter flt = new InnerClassFilenameFilter(entryFile.getName());
                    File entryDir = entryFile.getParentFile();
                    String[] innerfiles = entryDir.list(flt);
                    int i = 0;
                    int n = innerfiles.length;
                    while (i < n) {
                        int entryIndex = entryName.lastIndexOf(entryFile.getName()) - 1;
                        entryName = entryIndex < 0 ? innerfiles[i] : entryName.substring(0, entryIndex) + File.separatorChar + innerfiles[i];
                        entryFile = new File(this.config.srcDir, entryName);
                        this.log("adding innerclass file '" + entryName + "'", 3);
                        this.addFileToJar((JarOutputStream)jarStream, entryFile, entryName);
                        ++i;
                    }
                }
            }
            catch (IOException ioe) {
                String msg = "IOException while processing ejb-jar file '" + jarfile.toString() + "'. Details: " + ioe.getMessage();
                throw new BuildException(msg, (Throwable)ioe);
            }
            Object var18_22 = null;
            if (jarStream == null) return;
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            if (jarStream == null) throw throwable;
            try {
                jarStream.close();
                throw throwable;
            }
            catch (IOException closeException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException closeException) {}
        jarStream.close();
        return;
    }

    protected void checkAndAddInherited(Hashtable checkEntries) throws BuildException {
        Hashtable copiedHash = (Hashtable)checkEntries.clone();
        Iterator entryIterator = copiedHash.keySet().iterator();
        while (entryIterator.hasNext()) {
            String entryName = (String)entryIterator.next();
            File entryFile = (File)copiedHash.get(entryName);
            if (!entryName.endsWith(".class")) continue;
            String classname = entryName.substring(0, entryName.lastIndexOf(".class")).replace(File.separatorChar, '.');
            ClassLoader loader = this.getClassLoaderForBuild();
            try {
                Class<?> c = loader.loadClass(classname);
                if (c.isPrimitive()) continue;
                if (c.isInterface()) {
                    this.log("looking at interface " + c.getName(), 3);
                    Class<?>[] interfaces = c.getInterfaces();
                    int i = 0;
                    while (i < interfaces.length) {
                        this.log("     implements " + interfaces[i].getName(), 3);
                        this.addInterface(interfaces[i], checkEntries);
                        ++i;
                    }
                    continue;
                }
                this.log("looking at class " + c.getName(), 3);
                Class<?> s = c.getSuperclass();
                this.addSuperClass(c.getSuperclass(), checkEntries);
            }
            catch (ClassNotFoundException cnfe) {
                this.log("Could not load class " + classname + " for super class check", 1);
            }
            catch (NoClassDefFoundError ncdfe) {
                this.log("Could not fully load class " + classname + " for super class check", 1);
            }
        }
    }

    private void addInterface(Class theInterface, Hashtable checkEntries) {
        File interfaceFile;
        if (!theInterface.getName().startsWith("java") && (interfaceFile = new File(this.config.srcDir.getAbsolutePath() + File.separatorChar + theInterface.getName().replace('.', File.separatorChar) + ".class")).exists() && interfaceFile.isFile()) {
            checkEntries.put(theInterface.getName().replace('.', File.separatorChar) + ".class", interfaceFile);
            Class<?>[] superInterfaces = theInterface.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                this.addInterface(superInterfaces[i], checkEntries);
                ++i;
            }
        }
    }

    private void addSuperClass(Class superClass, Hashtable checkEntries) {
        File superClassFile;
        if (!superClass.getName().startsWith("java") && (superClassFile = new File(this.config.srcDir.getAbsolutePath() + File.separatorChar + superClass.getName().replace('.', File.separatorChar) + ".class")).exists() && superClassFile.isFile()) {
            checkEntries.put(superClass.getName().replace('.', File.separatorChar) + ".class", superClassFile);
            Class<?>[] superInterfaces = superClass.getInterfaces();
            int i = 0;
            while (i < superInterfaces.length) {
                this.addInterface(superInterfaces[i], checkEntries);
                ++i;
            }
            this.addSuperClass(superClass.getSuperclass(), checkEntries);
        }
    }

    protected ClassLoader getClassLoaderForBuild() {
        if (this.classpathLoader != null) {
            return this.classpathLoader;
        }
        Path combinedClasspath = this.getCombinedClasspath();
        this.classpathLoader = combinedClasspath == null ? this.getClass().getClassLoader() : new AntClassLoader(this.getTask().getProject(), combinedClasspath);
        return this.classpathLoader;
    }

    public void validateConfigured() throws BuildException {
        if (this.destDir == null || !this.destDir.isDirectory()) {
            String msg = "A valid destination directory must be specified using the \"destdir\" attribute.";
            throw new BuildException(msg, this.getLocation());
        }
    }
}

