/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.registry;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.netbeans.modules.rmi.RMIModule;
import org.netbeans.modules.rmi.registry.RegistryItem;
import org.netbeans.modules.rmi.registry.RegistryItemChildren;
import org.netbeans.modules.rmi.registry.RegistryItemNode;
import org.netbeans.modules.rmi.settings.RMIRegistryItems;
import org.netbeans.modules.rmi.settings.RMIRegistrySettings;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;

public class RMIRegistryPool {
    private static boolean DEBUG = false;
    protected static RMIRegistryPool pool = null;
    protected RegistryChildren children;

    protected RMIRegistryPool() {
    }

    public static RMIRegistryPool getDefault() {
        try {
            if (pool == null) {
                pool = new RMIRegistryPool();
            }
            return pool;
        }
        catch (NullPointerException nullPointerException) {
            if (DEBUG) {
                nullPointerException.printStackTrace();
            }
            throw nullPointerException;
        }
    }

    public synchronized void add(RegistryItem registryItem) {
        RMIRegistryItems.getInstance().addRegistryItem(registryItem);
        RMIRegistryPool.updateItem(registryItem);
        this.getChildren().setKeys();
    }

    public synchronized void remove(RegistryItem registryItem) {
        RMIRegistryItems.getInstance().removeRegistryItem(registryItem);
        this.getChildren().setKeys();
    }

    public RegistryChildren getChildren() {
        try {
            if (this.children == null) {
                this.children = new RegistryChildren();
            }
            return this.children;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            throw nullPointerException;
        }
    }

    public static void updateItem(final RegistryItem registryItem) {
        RMIModule.getRP();
        RequestProcessor.postRequest((Runnable)new Runnable(){

            public void run() {
                registryItem.updateServices();
            }
        }, (int)0, (int)2);
    }

    public class RegistryChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private transient RequestProcessor.Task task = null;
        private transient RefreshTask taskRunnable = null;
        private int timeout = 0;
        Collection keys = Collections.EMPTY_SET;
        static /* synthetic */ Class class$org$netbeans$modules$rmi$settings$RMIRegistryItems;
        static /* synthetic */ Class class$org$netbeans$modules$rmi$settings$RMIRegistrySettings;

        public RegistryChildren() {
            this.updateTimeout();
            SharedClassObject.findObject((Class)(class$org$netbeans$modules$rmi$settings$RMIRegistryItems == null ? (class$org$netbeans$modules$rmi$settings$RMIRegistryItems = RegistryChildren.class$("org.netbeans.modules.rmi.settings.RMIRegistryItems")) : class$org$netbeans$modules$rmi$settings$RMIRegistryItems), (boolean)true).addPropertyChangeListener((PropertyChangeListener)this);
            SharedClassObject.findObject((Class)(class$org$netbeans$modules$rmi$settings$RMIRegistrySettings == null ? (class$org$netbeans$modules$rmi$settings$RMIRegistrySettings = RegistryChildren.class$("org.netbeans.modules.rmi.settings.RMIRegistrySettings")) : class$org$netbeans$modules$rmi$settings$RMIRegistrySettings), (boolean)true).addPropertyChangeListener((PropertyChangeListener)this);
        }

        protected void scheduleRefreshTask(int n) {
            if (this.task == null) {
                this.taskRunnable = new RefreshTask();
                this.task = RMIModule.getRP().create((Runnable)this.taskRunnable);
                this.task.setPriority(1);
            }
            this.task.schedule(n);
            if (DEBUG) {
                System.err.println("RCH: planned to " + this.timeout + " ms.");
            }
        }

        protected void addNotify() {
            this.refreshIt();
        }

        protected void removeNotify() {
            this.setKeys2(Collections.EMPTY_SET);
            this.task = null;
            this.taskRunnable = null;
        }

        public void setKeys() {
            this.setKeys2(RMIRegistryItems.getInstance().getRegs());
        }

        protected void setKeys2(Collection collection) {
            this.keys = collection;
            super.setKeys(this.keys);
        }

        public void refreshIt() {
            this.scheduleRefreshTask(0);
        }

        protected void refreshKey2(Object object) {
            this.refreshKey(object);
        }

        public void refresh(Object object) {
            this.refreshKey2(object);
        }

        protected Node[] createNodes(Object object) {
            RegistryItem registryItem = (RegistryItem)object;
            Collection collection = registryItem.getServices();
            RegistryItemNode registryItemNode = collection != null ? new RegistryItemNode.ValidNode(registryItem, (Children)new RegistryItemChildren(registryItem)) : new RegistryItemNode.InvalidNode(registryItem);
            return new Node[]{registryItemNode};
        }

        protected Collection getKeys() {
            return this.keys;
        }

        void setCleanFlag(boolean bl) {
            if (this.taskRunnable != null) {
                this.taskRunnable.setCleanFlag(bl);
            }
        }

        protected void updateTimeout() {
            this.timeout = ((RMIRegistrySettings)SharedClassObject.findObject((Class)(class$org$netbeans$modules$rmi$settings$RMIRegistrySettings == null ? (class$org$netbeans$modules$rmi$settings$RMIRegistrySettings = RegistryChildren.class$("org.netbeans.modules.rmi.settings.RMIRegistrySettings")) : class$org$netbeans$modules$rmi$settings$RMIRegistrySettings), (boolean)true)).getRefreshTime();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof RMIRegistrySettings) {
                if ("internalRegistryPort".equals(propertyChangeEvent.getPropertyName())) {
                    this.refreshIt();
                }
                if ("refreshTime".equals(propertyChangeEvent.getPropertyName())) {
                    this.updateTimeout();
                    if (this.timeout > 0) {
                        this.scheduleRefreshTask(this.timeout);
                    }
                }
            }
            if (object instanceof RMIRegistryItems) {
                this.refreshIt();
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private class RefreshTask
        implements Runnable {
            private boolean cleanFlag = false;

            private RefreshTask() {
            }

            public synchronized void setCleanFlag(boolean bl) {
                this.cleanFlag = bl;
            }

            private synchronized boolean getCleanFlag() {
                return this.cleanFlag;
            }

            private void resetLoader() {
                try {
                    Class<?> clazz = Class.forName("sun.rmi.server.LoaderHandler");
                    Field field = clazz.getDeclaredField("loaderTable");
                    ((AccessibleObject)field).setAccessible(true);
                    Class<?> clazz2 = clazz;
                    synchronized (clazz2) {
                        HashMap hashMap = (HashMap)field.get(null);
                        if (hashMap != null) {
                            hashMap.clear();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void run() {
                boolean bl = this.getCleanFlag();
                this.setCleanFlag(false);
                if (bl) {
                    this.resetLoader();
                }
                if (DEBUG) {
                    System.err.println("RCH: Refresh Task invoked. ");
                }
                RegistryChildren.this.setKeys();
                Iterator iterator = RegistryChildren.this.keys.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (bl) {
                        ((RegistryItem)e).setServices(null);
                    }
                    ((RegistryItem)e).updateServices();
                }
                if (RegistryChildren.this.task != null && RegistryChildren.this.timeout > 0) {
                    RegistryChildren.this.task.schedule(RegistryChildren.this.timeout);
                    if (DEBUG) {
                        System.err.println("RCH: replanned to " + RegistryChildren.this.timeout + " ms.");
                    }
                }
                if (DEBUG) {
                    System.err.println("RCH: RefreshTask finished.");
                }
            }
        }
    }
}

