/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi.activation;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupDesc;
import org.netbeans.modules.rmi.RMIModule;
import org.netbeans.modules.rmi.activation.ActivationSystemItem;
import org.netbeans.modules.rmi.settings.RMIRegistryItems;
import org.netbeans.modules.rmi.util.RefreshCookie;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;

public class ActivationSystemNode
extends AbstractNode
implements Node.Cookie,
RefreshCookie,
PropertyChangeListener {
    private static final String ON_ICON_BASE = "/org/netbeans/modules/rmi/resources/activationSystem";
    private static final String OFF_ICON_BASE = "/org/netbeans/modules/rmi/resources/activationSystemOff";
    private static final String ERR_ICON_BASE = "/org/netbeans/modules/rmi/resources/activationSystemErr";
    private static final SystemAction[] saValid = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = ActivationSystemNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$rmi$util$RefreshAction == null ? (class$org$netbeans$modules$rmi$util$RefreshAction = ActivationSystemNode.class$("org.netbeans.modules.rmi.util.RefreshAction")) : class$org$netbeans$modules$rmi$util$RefreshAction)), SystemAction.get((Class)(class$org$netbeans$modules$rmi$activation$ActivationSystemNode$ShutdownAction == null ? (class$org$netbeans$modules$rmi$activation$ActivationSystemNode$ShutdownAction = ActivationSystemNode.class$("org.netbeans.modules.rmi.activation.ActivationSystemNode$ShutdownAction")) : class$org$netbeans$modules$rmi$activation$ActivationSystemNode$ShutdownAction)), null, SystemAction.get((Class)(class$org$netbeans$modules$rmi$activation$GenerateSetupAction == null ? (class$org$netbeans$modules$rmi$activation$GenerateSetupAction = ActivationSystemNode.class$("org.netbeans.modules.rmi.activation.GenerateSetupAction")) : class$org$netbeans$modules$rmi$activation$GenerateSetupAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ActivationSystemNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ActivationSystemNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ActivationSystemNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    private static final SystemAction[] saInvalid = new SystemAction[]{SystemAction.get((Class)(class$org$netbeans$modules$rmi$util$RefreshAction == null ? (class$org$netbeans$modules$rmi$util$RefreshAction = ActivationSystemNode.class$("org.netbeans.modules.rmi.util.RefreshAction")) : class$org$netbeans$modules$rmi$util$RefreshAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ActivationSystemNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ActivationSystemNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ActivationSystemNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    private ActivationSystemItem item;
    private PropertyChangeListener listener;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$util$RefreshAction;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivationSystemNode$ShutdownAction;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$GenerateSetupAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivationSystemNode;
    static /* synthetic */ Class class$java$lang$String;

    public ActivationSystemNode(ActivationSystemItem activationSystemItem, Children children) {
        super(children);
        this.item = activationSystemItem;
        this.setIconBase(OFF_ICON_BASE);
        this.systemActions = saInvalid;
        this.setName(NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$activation$ActivationSystemNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationSystemNode = ActivationSystemNode.class$("org.netbeans.modules.rmi.activation.ActivationSystemNode")) : class$org$netbeans$modules$rmi$activation$ActivationSystemNode), (String)"FMT_ValidItem", (Object)activationSystemItem.getHostName(), (Object)new Integer(activationSystemItem.getPort())));
        this.setShortDescription(ActivationSystemNode.getLocalizedString("HINT_ActivationSystemNodeNotRunning"));
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)this);
        this.listener = WeakListener.propertyChange((PropertyChangeListener)this, (Object)activationSystemItem);
        activationSystemItem.addPropertyChangeListener(this.listener);
    }

    public void destroy() throws IOException {
        super.destroy();
        this.item.removePropertyChangeListener(this.listener);
        RMIRegistryItems.getInstance().removeAS(this.item);
    }

    public boolean canDestroy() {
        return true;
    }

    public void refresh() {
        this.item.updateActivationItems();
    }

    private static String getLocalizedString(String string) {
        return NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$activation$ActivationSystemNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationSystemNode = ActivationSystemNode.class$("org.netbeans.modules.rmi.activation.ActivationSystemNode")) : class$org$netbeans$modules$rmi$activation$ActivationSystemNode)).getString(string);
    }

    public ActivationSystemItem getActivationSystem() {
        return this.item;
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new ActivationGroupType()};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activationItems".equals(propertyChangeEvent.getPropertyName())) {
            switch (this.item.getRMID()) {
                case 0: {
                    this.systemActions = saValid;
                    this.setIconBase(ON_ICON_BASE);
                    this.setShortDescription(ActivationSystemNode.getLocalizedString("HINT_ActivationSystemNodeRunning"));
                    break;
                }
                case 1: {
                    this.systemActions = saInvalid;
                    this.setIconBase(OFF_ICON_BASE);
                    this.setShortDescription(ActivationSystemNode.getLocalizedString("HINT_ActivationSystemNodeNotRunning"));
                    break;
                }
                case 2: {
                    this.systemActions = saInvalid;
                    this.setIconBase(ERR_ICON_BASE);
                    this.setShortDescription(ActivationSystemNode.getLocalizedString("HINT_ActivationSystemNodeUnknown"));
                }
            }
            this.fireIconChange();
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        try {
            PropertySupport.Reflection reflection = new PropertySupport.Reflection((Object)this.item, class$java$lang$String == null ? (class$java$lang$String = ActivationSystemNode.class$("java.lang.String")) : class$java$lang$String, "getHostName", null);
            reflection.setName("host");
            reflection.setDisplayName(ActivationSystemNode.getLocalizedString("PROP_Host"));
            reflection.setShortDescription(ActivationSystemNode.getLocalizedString("HINT_Host"));
            set.put((Node.Property)reflection);
            reflection = new PropertySupport.Reflection((Object)this.item, Integer.TYPE, "getPort", null);
            reflection.setName("port");
            reflection.setDisplayName(ActivationSystemNode.getLocalizedString("PROP_Port"));
            reflection.setShortDescription(ActivationSystemNode.getLocalizedString("HINT_Port"));
            set.put((Node.Property)reflection);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            TopManager.getDefault().notifyException((Throwable)noSuchMethodException);
        }
        return sheet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ShutdownAction
    extends CookieAction {
        static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivationSystemNode;

        ShutdownAction() {
        }

        protected Class[] cookieClasses() {
            return new Class[]{class$org$netbeans$modules$rmi$activation$ActivationSystemNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationSystemNode = ShutdownAction.class$("org.netbeans.modules.rmi.activation.ActivationSystemNode")) : class$org$netbeans$modules$rmi$activation$ActivationSystemNode};
        }

        protected int mode() {
            return 4;
        }

        protected void performAction(Node[] nodeArray) {
            int n = 0;
            while (n < nodeArray.length) {
                ActivationSystemNode activationSystemNode = (ActivationSystemNode)nodeArray[n];
                this.shutdown(activationSystemNode.getActivationSystem());
                ++n;
            }
        }

        private void shutdown(ActivationSystemItem activationSystemItem) {
            activationSystemItem.getRP();
            RequestProcessor.postRequest((Runnable)new Runnable(this, activationSystemItem){
                private final /* synthetic */ ActivationSystemItem val$item;
                private final /* synthetic */ ShutdownAction this$0;
                {
                    this.this$0 = shutdownAction;
                    this.val$item = activationSystemItem;
                }

                public void run() {
                    try {
                        TopManager.getDefault().setStatusText(ActivationSystemNode.access$000("MSG_ShutdownStart"));
                        this.val$item.shutdown();
                        TopManager.getDefault().setStatusText(ActivationSystemNode.access$000("MSG_ShutdownSuccessful"));
                    }
                    catch (ConnectException connectException) {
                        TopManager.getDefault().setStatusText(ActivationSystemNode.access$000("MSG_ShutdownFailed"));
                        this.val$item.updateActivationItems();
                        TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ActivationSystemNode.access$000("ERR_ConnectException"), 0));
                    }
                    catch (RemoteException remoteException) {
                        TopManager.getDefault().setStatusText(ActivationSystemNode.access$000("MSG_ShutdownFailed"));
                        ErrorManager errorManager = RMIModule.getErrorManager(this.getClass());
                        errorManager.annotate((Throwable)remoteException, ActivationSystemNode.access$000("MSG_ShutdownFailed"));
                        this.val$item.updateActivationItems();
                        errorManager.notify((Throwable)remoteException);
                    }
                }
            });
        }

        public String getName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$rmi$activation$ActivationSystemNode == null ? (class$org$netbeans$modules$rmi$activation$ActivationSystemNode = ShutdownAction.class$("org.netbeans.modules.rmi.activation.ActivationSystemNode")) : class$org$netbeans$modules$rmi$activation$ActivationSystemNode), (String)"LBL_ShutdownAction");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    class ActivationGroupType
    extends NewType
    implements ActionListener {
        EnhancedCustomPropertyEditor editor;
        Dialog dialog;
        static /* synthetic */ Class class$java$rmi$activation$ActivationGroupDesc;
        static /* synthetic */ Class class$org$netbeans$modules$rmi$activation$ActivationSystemNode$ActivationGroupType;

        ActivationGroupType() {
        }

        public void create() throws IOException {
            PropertyEditor propertyEditor = PropertyEditorManager.findEditor(class$java$rmi$activation$ActivationGroupDesc == null ? (class$java$rmi$activation$ActivationGroupDesc = ActivationGroupType.class$("java.rmi.activation.ActivationGroupDesc")) : class$java$rmi$activation$ActivationGroupDesc);
            Component component = null;
            if (propertyEditor != null && propertyEditor.supportsCustomEditor()) {
                component = propertyEditor.getCustomEditor();
            }
            if (!(component instanceof EnhancedCustomPropertyEditor)) {
                TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ActivationSystemNode.getLocalizedString("ERR_CustomEditor"), 0));
                return;
            }
            this.editor = (EnhancedCustomPropertyEditor)component;
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)component, ActivationSystemNode.getLocalizedString("LBL_NewGroup"), true, (ActionListener)this);
            dialogDescriptor.setHelpCtx(new HelpCtx(class$org$netbeans$modules$rmi$activation$ActivationSystemNode$ActivationGroupType == null ? (class$org$netbeans$modules$rmi$activation$ActivationSystemNode$ActivationGroupType = ActivationGroupType.class$("org.netbeans.modules.rmi.activation.ActivationSystemNode$ActivationGroupType")) : class$org$netbeans$modules$rmi$activation$ActivationSystemNode$ActivationGroupType));
            dialogDescriptor.setClosingOptions(new Object[0]);
            this.dialog = TopManager.getDefault().createDialog(dialogDescriptor);
            this.dialog.show();
        }

        public String getName() {
            return ActivationSystemNode.getLocalizedString("LBL_NewGroup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == NotifyDescriptor.OK_OPTION) {
                ActivationSystemNode.this.item.getRP();
                RequestProcessor.postRequest((Runnable)new Runnable(this){
                    private final /* synthetic */ ActivationGroupType this$1;
                    {
                        this.this$1 = activationGroupType;
                    }

                    public void run() {
                        try {
                            ActivationGroupDesc activationGroupDesc = (ActivationGroupDesc)this.this$1.editor.getPropertyValue();
                            TopManager.getDefault().setStatusText(ActivationSystemNode.access$000("MSG_NewGroupStart"));
                            ActivationSystemNode.access$200(ActivationGroupType.access$100(this.this$1)).addActivationGroupItem(activationGroupDesc);
                            TopManager.getDefault().setStatusText(ActivationSystemNode.access$000("MSG_NewGroupSuccessful"));
                            this.this$1.dialog.dispose();
                            this.this$1.dialog = null;
                        }
                        catch (IllegalStateException illegalStateException) {
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ActivationSystemNode.access$000("ERR_PropertyGroupDesc"), 0));
                        }
                        catch (ActivationException activationException) {
                            ActivationGroupType.access$300(this.this$1, activationException, ActivationSystemNode.access$000("ERR_NewGroup"));
                        }
                        catch (ConnectException connectException) {
                            TopManager.getDefault().setStatusText(ActivationSystemNode.access$000("MSG_NewGroupFailed"));
                            ActivationSystemNode.access$200(ActivationGroupType.access$100(this.this$1)).updateActivationItems();
                            TopManager.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ActivationSystemNode.access$000("ERR_ConnectException"), 0));
                        }
                        catch (RemoteException remoteException) {
                            ActivationGroupType.access$300(this.this$1, remoteException, ActivationSystemNode.access$000("ERR_NewGroup"));
                        }
                    }
                });
            } else {
                this.dialog.dispose();
                this.dialog = null;
            }
        }

        private void registrationFailed(Throwable throwable, String string) {
            TopManager.getDefault().setStatusText(ActivationSystemNode.getLocalizedString("MSG_NewGroupFailed"));
            ActivationSystemNode.this.refresh();
            ErrorManager errorManager = RMIModule.getErrorManager(this.getClass());
            errorManager.annotate(throwable, string);
            errorManager.notify(throwable);
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        static /* synthetic */ ActivationSystemNode access$100(ActivationGroupType activationGroupType) {
            return activationGroupType.ActivationSystemNode.this;
        }

        static /* synthetic */ void access$300(ActivationGroupType activationGroupType, Throwable throwable, String string) {
            activationGroupType.registrationFailed(throwable, string);
        }
    }
}

