/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.openide.util.NbBundle;

public class UnicastExportClass {
    public static final String TAG_PORT = "port";
    public static final String TAG_SERVICE = "service";
    public static final String TAG_VERBOSE = "verbose";
    public static final String TAG_WAIT = "wait";
    private static ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$UnicastExportClass == null ? (class$org$netbeans$modules$rmi$UnicastExportClass = UnicastExportClass.class$("org.netbeans.modules.rmi.UnicastExportClass")) : class$org$netbeans$modules$rmi$UnicastExportClass));
    private static boolean verbose = false;
    static /* synthetic */ Class class$org$netbeans$modules$rmi$UnicastExportClass;
    static /* synthetic */ Class class$java$rmi$server$UnicastRemoteObject;
    static /* synthetic */ Class class$java$rmi$Remote;

    public static void main(String[] stringArray) throws Throwable {
        Class<?> clazz;
        Remote remote;
        System.setSecurityManager(new RMISecurityManager());
        ParamParse paramParse = new ParamParse(stringArray, new String[]{TAG_PORT, TAG_SERVICE, TAG_WAIT});
        String[] stringArray2 = paramParse.getRest();
        String string = stringArray2[0];
        Map map = paramParse.getParams();
        int n = 0;
        long l = 0L;
        try {
            String string2 = (String)map.get(TAG_PORT);
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(MessageFormat.format(bundle.getString("FMT_WrongParameter"), TAG_PORT, map.get(TAG_PORT)));
            n = 0;
        }
        String string3 = (String)map.get(TAG_SERVICE);
        if (string3 == null) {
            string3 = string;
        }
        try {
            String string4 = (String)map.get(TAG_WAIT);
            if (string4 != null) {
                l = Long.parseLong(string4);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(MessageFormat.format(bundle.getString("FMT_WrongParameter"), TAG_WAIT, map.get(TAG_WAIT)));
        }
        if (map.containsKey(TAG_VERBOSE)) {
            verbose = true;
        }
        if ((remote = UnicastExportClass.export(clazz = Class.forName(string), n)) != null) {
            System.out.println(bundle.getString("MSG_SuccessfullyExported"));
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                UnicastExportClass.register(1099, string3, remote);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            System.out.println(bundle.getString("MSG_SuccessfullyRegistered"));
            remote = null;
        } else {
            System.out.println(bundle.getString("MSG_ExportFailed"));
            System.exit(1);
        }
    }

    public static Remote export(Class clazz, int n) {
        boolean bl = false;
        try {
            if ((class$java$rmi$server$UnicastRemoteObject == null ? (class$java$rmi$server$UnicastRemoteObject = UnicastExportClass.class$("java.rmi.server.UnicastRemoteObject")) : class$java$rmi$server$UnicastRemoteObject).isAssignableFrom(clazz)) {
                Constructor constructor = clazz.getConstructor(Integer.TYPE);
                UnicastRemoteObject unicastRemoteObject = (UnicastRemoteObject)constructor.newInstance(new Integer(n));
                return unicastRemoteObject;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if ((class$java$rmi$server$UnicastRemoteObject == null ? (class$java$rmi$server$UnicastRemoteObject = UnicastExportClass.class$("java.rmi.server.UnicastRemoteObject")) : class$java$rmi$server$UnicastRemoteObject).isAssignableFrom(clazz)) {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                UnicastRemoteObject unicastRemoteObject = (UnicastRemoteObject)constructor.newInstance(new Object[0]);
                return unicastRemoteObject;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if ((class$java$rmi$Remote == null ? (class$java$rmi$Remote = UnicastExportClass.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(clazz)) {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                Remote remote = (Remote)constructor.newInstance(new Object[0]);
                Remote remote2 = UnicastRemoteObject.exportObject(remote, n);
                return remote;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.err.println(bundle.getString("MSG_Unicast_Export_Hint"));
        return null;
    }

    public static void register(int n, String string, Remote remote) throws RemoteException, MalformedURLException {
        Naming.rebind(string, remote);
    }

    public static void grUsage() {
        String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$UnicastExportClass == null ? (class$org$netbeans$modules$rmi$UnicastExportClass = UnicastExportClass.class$("org.netbeans.modules.rmi.UnicastExportClass")) : class$org$netbeans$modules$rmi$UnicastExportClass)).getString("MSG_Unicast_Export_Hint");
        System.err.println(string);
    }

    public static boolean isMain(Method method) {
        int n = method.getModifiers();
        return method.getReturnType().equals(Void.TYPE) && Modifier.isStatic(n) && Modifier.isPublic(n);
    }

    public static void usage() {
        String string = NbBundle.getBundle((Class)(class$org$netbeans$modules$rmi$UnicastExportClass == null ? (class$org$netbeans$modules$rmi$UnicastExportClass = UnicastExportClass.class$("org.netbeans.modules.rmi.UnicastExportClass")) : class$org$netbeans$modules$rmi$UnicastExportClass)).getString("MSG_UnicastExportUsage");
        System.err.println(string);
    }

    public static String arrayString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        if (objectArray.length > 0) {
            stringBuffer.append(objectArray[0].toString());
        }
        int n = 1;
        while (n < objectArray.length) {
            stringBuffer.append(";");
            stringBuffer.append(objectArray[n].toString());
            ++n;
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ParamParse {
        Set one;
        HashMap params;
        String[] args;
        int last;

        public ParamParse(String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
            this.args = stringArray;
            this.one = this.createSet(stringArray2);
            this.params = new HashMap();
            this.process();
        }

        protected Set createSet(String[] stringArray) {
            HashSet<String> hashSet = new HashSet<String>();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    hashSet.add(stringArray[n]);
                    ++n;
                }
            }
            return hashSet;
        }

        protected void process() throws IllegalArgumentException {
            try {
                int n = 0;
                while (n < this.args.length) {
                    String string;
                    String string2 = this.args[n];
                    String string3 = ParamParse.getSwitchName(string2);
                    if (string3 == null) {
                        this.last = n;
                        break;
                    }
                    if (this.one.contains(string3)) {
                        if (ParamParse.getSwitchName(string = this.args[++n]) != null) {
                            throw new IllegalArgumentException();
                        }
                    } else {
                        string = null;
                    }
                    this.params.put(string3, string);
                    ++n;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException();
            }
        }

        public Map getParams() {
            return this.params;
        }

        public String[] getRest() {
            String[] stringArray = new String[this.args.length - this.last];
            System.arraycopy(this.args, this.last, stringArray, 0, stringArray.length);
            return stringArray;
        }

        public static String getSwitchName(String string) {
            if (string.charAt(0) == '-') {
                return string.substring(1, string.length());
            }
            return null;
        }
    }
}

