/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.rmi;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;

public class RMIStubSupport {
    static final String EXT_JAVA = "java";
    static final String EXT_CLASS = "class";

    public static FileObject[] getStubs(DataObject dataObject, FileSystem fileSystem, String[] stringArray) {
        FileObject fileObject = fileSystem.findResource(dataObject.getPrimaryFile().getParent().getPackageNameExt('/', '.'));
        if (fileObject != null) {
            return RMIStubSupport.getStubs(dataObject, fileObject, stringArray);
        }
        return new FileObject[0];
    }

    public static FileObject[] getStubs(DataObject dataObject, String[] stringArray) {
        return RMIStubSupport.getStubs(dataObject, dataObject.getPrimaryFile(), stringArray);
    }

    public static FileObject[] getStubs(DataObject dataObject, FileObject fileObject, String[] stringArray) {
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        String string = dataObject.getName();
        if (fileObject.isFolder()) {
            fileObject.refresh();
            Enumeration enumeration = fileObject.getChildren(false);
            block0: while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (!fileObject2.isData() || !EXT_JAVA.equals(fileObject2.getExt()) && !EXT_CLASS.equals(fileObject2.getExt())) continue;
                int n = 0;
                while (n < stringArray.length) {
                    if (RMIStubSupport.isStub(string, fileObject2.getName(), stringArray[n])) {
                        linkedList.add(fileObject2);
                        continue block0;
                    }
                    ++n;
                }
            }
            return linkedList.toArray(new FileObject[linkedList.size()]);
        }
        return new FileObject[0];
    }

    static String getSourceName(String string, String string2) {
        String string3 = null;
        int n = 0;
        int n2 = string.length() - 1;
        int n3 = string2.length() - 1;
        int n4 = Math.min(n2, n3);
        while (true) {
            if (n >= n4) {
                return null;
            }
            if (string2.charAt(n) == '{') break;
            if (string2.charAt(n) != string.charAt(n)) {
                return null;
            }
            ++n;
        }
        while (true) {
            if (n2 <= n || n3 <= n) {
                return null;
            }
            if (string2.charAt(n3) == '}') break;
            if (string2.charAt(n3) != string.charAt(n2)) {
                return null;
            }
            --n2;
            --n3;
        }
        string3 = string.substring(n, n2 + 1);
        return string3;
    }

    public static boolean isStub(String string, String string2, String string3) {
        String string4 = RMIStubSupport.getSourceName(string2, string3);
        if (string4 != null && string4.startsWith(string)) {
            if (string4.length() == string.length()) {
                return true;
            }
            if (string4.charAt(string.length()) == '$') {
                return true;
            }
        }
        return false;
    }

    private static boolean Test_IsStub() {
        boolean bl = true;
        bl &= RMIStubSupport.isStub("Test", "Test_Stub", "{0}_Stub");
        bl &= RMIStubSupport.isStub("Test", "Test_Stub", "{}_Stub");
        bl &= !RMIStubSupport.isStub("Test", "Test_Stub", "_Stub");
        bl &= RMIStubSupport.isStub("Test", "Test$A_Stub", "{0}_Stub");
        bl &= !RMIStubSupport.isStub("Test", "TestA_Stub", "{0}_Stub");
        bl &= !RMIStubSupport.isStub("Test", "Test_Stub_Stub", "{0}_Stub");
        bl &= !RMIStubSupport.isStub("Test", "ATest_Stub", "{0}_Stub");
        bl &= !RMIStubSupport.isStub("Test", "Test_Stuby", "{0}_Stub");
        bl &= RMIStubSupport.isStub("Test", "_Test_Stub", "_{0}_Stub");
        return bl &= !RMIStubSupport.isStub("Test", "__Test_Stub", "_{0}_Stub");
    }

    private static boolean Test_getStubs() {
        try {
            FileObject fileObject = TopManager.getDefault().getRepository().findResource("/RMIStubSupport/data/");
            FileObject fileObject2 = fileObject.getFileObject("TestImpl", EXT_JAVA);
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            FileObject[] fileObjectArray = RMIStubSupport.getStubs(dataObject, fileObject, new String[]{"{0}_Stub", "_{0}_Stub"});
            Object[] objectArray = new String[fileObjectArray.length];
            int n = 0;
            while (n < fileObjectArray.length) {
                objectArray[n] = fileObjectArray[n].getNameExt();
                System.err.println(objectArray[n]);
                ++n;
            }
            Object[] objectArray2 = new String[]{"TestImpl_Stub.class", "TestImpl$A_Stub.class", "_TestImpl_Stub.class", "_TestImpl_Stub.java"};
            Arrays.sort(objectArray);
            Arrays.sort(objectArray2);
            return Arrays.equals(objectArray, objectArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean Test_getStubs2() {
        try {
            FileObject fileObject = TopManager.getDefault().getRepository().findResource("/RMIStubSupport/data/");
            FileObject fileObject2 = fileObject.getFileObject("TestImpl", EXT_JAVA);
            DataObject dataObject = DataObject.find((FileObject)fileObject2);
            FileSystem fileSystem = null;
            try {
                fileSystem = dataObject.getPrimaryFile().getFileSystem();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            FileObject[] fileObjectArray = RMIStubSupport.getStubs(dataObject, fileSystem, new String[]{"{0}_Stub", "_{0}_Stub"});
            Object[] objectArray = new String[fileObjectArray.length];
            int n = 0;
            while (n < fileObjectArray.length) {
                objectArray[n] = fileObjectArray[n].getNameExt();
                System.err.println(objectArray[n]);
                ++n;
            }
            Object[] objectArray2 = new String[]{"TestImpl_Stub.class", "TestImpl$A_Stub.class", "_TestImpl_Stub.class", "_TestImpl_Stub.java"};
            Arrays.sort(objectArray);
            Arrays.sort(objectArray2);
            return Arrays.equals(objectArray, objectArray2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        System.err.println("Test_IsStub = " + RMIStubSupport.Test_IsStub());
        System.err.println("Test_getStubs = " + RMIStubSupport.Test_getStubs());
        System.err.println("Test_getStubs2 = " + RMIStubSupport.Test_getStubs2());
        System.err.println("time = " + (System.currentTimeMillis() - l));
    }
}

