/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ManifestException;

public class Manifest {
    public static final String ATTRIBUTE_MANIFEST_VERSION = "Manifest-Version";
    public static final String ATTRIBUTE_SIGNATURE_VERSION = "Signature-Version";
    public static final String ATTRIBUTE_NAME = "Name";
    public static final String ATTRIBUTE_FROM = "From";
    public static final String DEFAULT_MANIFEST_VERSION = "1.0";
    public static final int MAX_LINE_LENGTH = 70;
    private String manifestVersion = "1.0";
    private Section mainSection = new Section();
    private Hashtable sections = new Hashtable();

    public Manifest() {
    }

    public Manifest(InputStream inputStream) throws ManifestException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = this.mainSection.read(bufferedReader);
        String string2 = this.mainSection.getAttributeValue(ATTRIBUTE_MANIFEST_VERSION);
        if (string2 != null) {
            this.manifestVersion = string2;
            this.mainSection.removeAttribute(ATTRIBUTE_MANIFEST_VERSION);
        }
        String string3 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            Attribute attribute;
            if (string3.length() == 0) continue;
            Section section = new Section();
            if (string == null) {
                attribute = new Attribute(string3);
                if (!attribute.getName().equalsIgnoreCase(ATTRIBUTE_NAME)) {
                    throw new ManifestException("Manifest sections should start with a \"Name\" attribute and not \"" + attribute.getName() + "\"");
                }
                string = attribute.getValue();
            } else {
                attribute = new Attribute(string3);
                section.addAttributeAndCheck(attribute);
            }
            section.setName(string);
            string = section.read(bufferedReader);
            this.addConfiguredSection(section);
        }
    }

    public void addConfiguredSection(Section section) throws ManifestException {
        if (section.getName() == null) {
            throw new BuildException("Sections must have a name");
        }
        this.sections.put(section.getName().toLowerCase(), section);
    }

    public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
        this.mainSection.addConfiguredAttribute(attribute);
    }

    public void merge(Manifest manifest) throws ManifestException {
        this.manifestVersion = manifest.manifestVersion;
        this.mainSection.merge(manifest.mainSection);
        Enumeration enumeration = manifest.sections.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Section section = (Section)this.sections.get(string);
            Section section2 = (Section)manifest.sections.get(string);
            if (section == null) {
                this.sections.put(string.toLowerCase(), section2);
                continue;
            }
            section.merge(section2);
        }
    }

    public void write(PrintWriter printWriter) throws IOException {
        printWriter.println("Manifest-Version: " + this.manifestVersion);
        String string = this.mainSection.getAttributeValue(ATTRIBUTE_SIGNATURE_VERSION);
        if (string != null) {
            printWriter.println("Signature-Version: " + string);
            this.mainSection.removeAttribute(ATTRIBUTE_SIGNATURE_VERSION);
        }
        this.mainSection.write(printWriter);
        if (string != null) {
            try {
                this.mainSection.addConfiguredAttribute(new Attribute(ATTRIBUTE_SIGNATURE_VERSION, string));
            }
            catch (ManifestException manifestException) {
                // empty catch block
            }
        }
        Enumeration enumeration = this.sections.elements();
        while (enumeration.hasMoreElements()) {
            Section section = (Section)enumeration.nextElement();
            section.write(printWriter);
        }
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.write(new PrintWriter(stringWriter));
        }
        catch (IOException iOException) {
            return null;
        }
        return stringWriter.toString();
    }

    public Enumeration getWarnings() {
        Vector vector = new Vector();
        Enumeration enumeration = this.mainSection.getWarnings();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Enumeration enumeration2 = this.sections.elements();
        while (enumeration2.hasMoreElements()) {
            Section section = (Section)enumeration2.nextElement();
            Enumeration enumeration3 = section.getWarnings();
            while (enumeration3.hasMoreElements()) {
                vector.addElement(enumeration3.nextElement());
            }
        }
        return vector.elements();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Manifest)) {
            return false;
        }
        Manifest manifest = (Manifest)object;
        if (!this.manifestVersion.equals(manifest.manifestVersion)) {
            return false;
        }
        if (this.sections.size() != manifest.sections.size()) {
            return false;
        }
        if (!this.mainSection.equals(manifest.mainSection)) {
            return false;
        }
        Enumeration enumeration = this.sections.elements();
        while (enumeration.hasMoreElements()) {
            Section section;
            Section section2 = (Section)enumeration.nextElement();
            if (section2.equals(section = (Section)manifest.sections.get(section2.getName().toLowerCase()))) continue;
            return false;
        }
        return true;
    }

    public static class Section {
        private Vector warnings = new Vector();
        private String name = null;
        private Hashtable attributes = new Hashtable();

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public String read(BufferedReader bufferedReader) throws ManifestException, IOException {
            String string;
            Attribute attribute = null;
            while (true) {
                String string2;
                if ((string2 = bufferedReader.readLine()) == null || string2.length() == 0) {
                    return null;
                }
                if (string2.charAt(0) == ' ') {
                    if (attribute == null) {
                        throw new ManifestException("Can't start an attribute with a continuation line " + string2);
                    }
                    attribute.addContinuation(string2);
                    continue;
                }
                attribute = new Attribute(string2);
                string = this.addAttributeAndCheck(attribute);
                if (string != null) break;
            }
            return string;
        }

        public void merge(Section section) throws ManifestException {
            Object object;
            if (this.name == null && section.getName() != null || this.name != null && !this.name.equalsIgnoreCase(section.getName())) {
                throw new ManifestException("Unable to merge sections with different names");
            }
            Enumeration enumeration = section.attributes.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                this.attributes.put(object, section.attributes.get(object));
            }
            object = section.warnings.elements();
            while (object.hasMoreElements()) {
                this.warnings.addElement(object.nextElement());
            }
        }

        public void write(PrintWriter printWriter) throws IOException {
            Object object;
            if (this.name != null) {
                object = new Attribute(Manifest.ATTRIBUTE_NAME, this.name);
                ((Attribute)object).write(printWriter);
            }
            object = this.attributes.elements();
            while (object.hasMoreElements()) {
                Attribute attribute = (Attribute)object.nextElement();
                attribute.write(printWriter);
            }
            printWriter.println();
        }

        public String getAttributeValue(String string) {
            Attribute attribute = (Attribute)this.attributes.get(string.toLowerCase());
            if (attribute == null) {
                return null;
            }
            return attribute.getValue();
        }

        public void removeAttribute(String string) {
            this.attributes.remove(string.toLowerCase());
        }

        public void addConfiguredAttribute(Attribute attribute) throws ManifestException {
            String string = this.addAttributeAndCheck(attribute);
            if (string != null) {
                throw new BuildException("Use the \"name\" attribute of the <section> element rather than using the \"Name\" attribute");
            }
        }

        public String addAttributeAndCheck(Attribute attribute) throws ManifestException {
            if (attribute.getName() == null || attribute.getValue() == null) {
                throw new BuildException("Attributes must have name and value");
            }
            if (attribute.getName().equalsIgnoreCase(Manifest.ATTRIBUTE_NAME)) {
                this.warnings.addElement("\"Name\" attributes should not occur in the main section and must be the first element in all other sections: \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
                return attribute.getValue();
            }
            if (attribute.getName().toLowerCase().startsWith(Manifest.ATTRIBUTE_FROM.toLowerCase())) {
                this.warnings.addElement("Manifest attributes should not start with \"From\" in \"" + attribute.getName() + ": " + attribute.getValue() + "\"");
            } else {
                if (this.attributes.containsKey(attribute.getName().toLowerCase())) {
                    throw new ManifestException("The attribute \"" + attribute.getName() + "\" may not " + "occur more than once in the same section");
                }
                this.attributes.put(attribute.getName().toLowerCase(), attribute);
            }
            return null;
        }

        public Enumeration getWarnings() {
            return this.warnings.elements();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Section)) {
                return false;
            }
            Section section = (Section)object;
            if (this.attributes.size() != section.attributes.size()) {
                return false;
            }
            Enumeration enumeration = this.attributes.elements();
            while (enumeration.hasMoreElements()) {
                Attribute attribute;
                Attribute attribute2 = (Attribute)enumeration.nextElement();
                if (attribute2.equals(attribute = (Attribute)section.attributes.get(attribute2.getName().toLowerCase()))) continue;
                return false;
            }
            return true;
        }
    }

    public static class Attribute {
        private String name = null;
        private String value = null;

        public Attribute() {
        }

        public Attribute(String string) throws ManifestException {
            this.parse(string);
        }

        public Attribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Attribute)) {
                return false;
            }
            Attribute attribute = (Attribute)object;
            return this.name != null && attribute.name != null && this.name.toLowerCase().equals(attribute.name.toLowerCase()) && this.value != null && this.value.equals(attribute.value);
        }

        public void parse(String string) throws ManifestException {
            int n = string.indexOf(": ");
            if (n == -1) {
                throw new ManifestException("Manifest line \"" + string + "\" is not valid");
            }
            this.name = string.substring(0, n);
            this.value = string.substring(n + 2);
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }

        public void addContinuation(String string) {
            this.value = this.value + string.substring(1);
        }

        public void write(PrintWriter printWriter) throws IOException {
            String string = this.name + ": " + this.value;
            while (string.getBytes().length > 70) {
                int n = 70;
                String string2 = string.substring(0, n);
                while (string2.getBytes().length > 70 && n > 0) {
                    string2 = string.substring(0, --n);
                }
                if (n == 0) {
                    throw new IOException("Unable to write manifest line " + this.name + ": " + this.value);
                }
                printWriter.println(string2);
                string = " " + string.substring(n);
            }
            printWriter.println(string);
        }
    }
}

