/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.updater.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterFrame;

public class ModuleUpdater
extends Thread {
    ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/updater/Bundle");
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String UPDATE_DIR = "update";
    private static final String DOWNLOAD_DIR = "update" + FILE_SEPARATOR + "download";
    private static final String BACKUP_DIR = "update" + FILE_SEPARATOR + "backup";
    private static final String NB_LIB_DIR = "lib";
    private static final String EXT_DIR = "ext";
    private static final String JAVA_LIB_EXT_DIR = "lib" + FILE_SEPARATOR + "ext";
    public static final String UPDATE_NETBEANS_DIR = "netbeans";
    public static final String UPDATE_JAVA_EXT_DIR = "java_ext";
    public static final String UPDATE_MAIN_DIR = "main";
    private static final String JVM_PARAMS_FILE = "main.properties";
    private static final String NBM_EXTENSION = "nbm";
    public static final String LOG_FILE_NAME = "update.log";
    public static final String LATER_FILE_NAME = "install_later.xml";
    private static File downloadDirectory = null;
    private static File backupDirectory = null;
    private static File netbeansDirectory = null;
    private static File nbLibDirectory = null;
    private static File javaLibExtDirectory = null;
    private static File updateDirectory = null;
    private static File mainDirectory = null;
    private File[] nbmFiles = null;
    private static Boolean singleMode = null;
    private volatile boolean stop = false;
    private volatile boolean suspend = false;
    private long totalLength;
    private static int instCount = 0;
    private static boolean fromInstall = false;

    public void run() {
        instCount = 0;
        ModuleUpdater.getDownloadDirectory();
        this.checkStop();
        if (downloadDirectory == null) {
            this.endRun();
        }
        this.checkStop();
        this.nbmFiles = ModuleUpdater.getNBMFiles();
        if (this.nbmFiles == null || this.nbmFiles.length == 0) {
            this.endRun();
        }
        this.checkStop();
        this.totalLength();
        this.checkStop();
        this.unpack();
        this.deleteInstall_Later();
        UpdaterFrame.unpackingFinished();
    }

    private void deleteInstall_Later() {
        File file = null;
        if (ModuleUpdater.isMultiuser() && (file = new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME)).exists()) {
            file.delete();
        }
        if ((file = new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + DOWNLOAD_DIR + FILE_SEPARATOR + LATER_FILE_NAME)).exists()) {
            file.delete();
        }
    }

    void endRun() {
        this.stop = true;
    }

    private void checkStop() {
        if (this.suspend) {
            while (this.suspend) {
            }
        }
        if (this.stop) {
            System.exit(0);
        }
    }

    static File[] getNBMFiles() {
        instCount = 0;
        File[] fileArray = null;
        if (ModuleUpdater.isMultiuser() && (fileArray = ModuleUpdater.getInstallDownloadDirectory().listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(ModuleUpdater.NBM_EXTENSION);
            }
        })) != null) {
            instCount = fileArray.length;
        }
        int n = 0;
        File[] fileArray2 = downloadDirectory.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(ModuleUpdater.NBM_EXTENSION);
            }
        });
        if (fileArray2 != null) {
            n = fileArray2.length;
        }
        File[] fileArray3 = new File[instCount + n];
        if (instCount > 0) {
            int n2 = 0;
            while (n2 < instCount) {
                fileArray3[n2] = fileArray[n2];
                ++n2;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            fileArray3[ModuleUpdater.instCount + n3] = fileArray2[n3];
            ++n3;
        }
        return fileArray3;
    }

    /*
     * Loose catch block
     */
    private void totalLength() {
        this.totalLength = 0L;
        UpdaterFrame.setLabel(this.bundle.getString("CTL_PreparingUnpack"));
        UpdaterFrame.setProgressRange(0L, this.nbmFiles.length);
        int n = 0;
        while (n < this.nbmFiles.length) {
            block13: {
                ZipFile zipFile = null;
                UpdaterFrame.setProgressValue(n + 1);
                zipFile = new JarFile(this.nbmFiles[n]);
                Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    this.checkStop();
                    if (!jarEntry.getName().startsWith(UPDATE_NETBEANS_DIR) && !jarEntry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !jarEntry.getName().startsWith(UPDATE_MAIN_DIR) || jarEntry.isDirectory()) continue;
                    this.totalLength += jarEntry.getSize();
                }
                Object var6_6 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                    break block13;
                }
                catch (IOException iOException2) {}
                break block13;
                {
                    catch (IOException iOException) {
                        var6_6 = null;
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                            break block13;
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    var6_6 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            ++n;
        }
    }

    /*
     * Loose catch block
     */
    void unpack() {
        long l = 0L;
        UpdaterFrame.setLabel("");
        UpdaterFrame.setProgressRange(0L, this.totalLength);
        LogWriter logWriter = new LogWriter();
        logWriter.println("Updater: ");
        logWriter.println("NBM files installed: ");
        fromInstall = true;
        UpdateTracking updateTracking = UpdateTracking.getTracking(false);
        int n = 0;
        while (n < this.nbmFiles.length) {
            block27: {
                JarFile jarFile;
                block25: {
                    File[] fileArray;
                    Object object;
                    Object object2;
                    Object object3;
                    if (n > instCount - 1 && fromInstall) {
                        if (n > 0) {
                            updateDirectory = null;
                            downloadDirectory = null;
                            backupDirectory = null;
                            netbeansDirectory = null;
                            mainDirectory = null;
                            nbLibDirectory = null;
                            updateTracking.write();
                        }
                        fromInstall = false;
                        updateTracking = UpdateTracking.getTracking(true);
                    }
                    ModuleUpdate moduleUpdate = new ModuleUpdate(this.nbmFiles[n]);
                    UpdateTracking.Version version = updateTracking.addNewModuleVersion(moduleUpdate.getCodenamebase(), moduleUpdate.getSpecification_version());
                    moduleUpdate = null;
                    System.gc();
                    boolean bl = false;
                    UpdaterFrame.setLabel(this.bundle.getString("CTL_UnpackingFile") + "  " + this.nbmFiles[n].getName());
                    UpdaterFrame.setProgressValue(l);
                    logWriter.println("> " + this.nbmFiles[n].getName());
                    jarFile = null;
                    jarFile = new JarFile(this.nbmFiles[n]);
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        object3 = enumeration.nextElement();
                        this.checkStop();
                        if (((ZipEntry)object3).getName().startsWith(UPDATE_NETBEANS_DIR)) {
                            if (((ZipEntry)object3).isDirectory()) {
                                object2 = new File(ModuleUpdater.getNetbeansDirectory(), ((ZipEntry)object3).getName().substring(UPDATE_NETBEANS_DIR.length()));
                                if (!((File)object2).isDirectory()) {
                                    ((File)object2).mkdirs();
                                }
                                if (((File)(object = new File(ModuleUpdater.getBackupDirectory(), ((ZipEntry)object3).getName()))).isDirectory()) continue;
                                ((File)object).mkdirs();
                                continue;
                            }
                            object2 = ((ZipEntry)object3).getName().substring(9);
                            version.addFileWithCrc((String)object2, Long.toString(((ZipEntry)object3).getCrc()));
                            object = new File(ModuleUpdater.getNetbeansDirectory(), ((ZipEntry)object3).getName().substring(UPDATE_NETBEANS_DIR.length()));
                            if (((File)object).exists()) {
                                fileArray = new File(ModuleUpdater.getBackupDirectory(), ((ZipEntry)object3).getName());
                                fileArray.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream((File)object), new FileOutputStream((File)fileArray));
                            } else {
                                ((File)object).getParentFile().mkdirs();
                            }
                            this.copyStreams(jarFile.getInputStream((ZipEntry)object3), new FileOutputStream((File)object));
                            UpdaterFrame.setProgressValue(l += ((ZipEntry)object3).getSize());
                            continue;
                        }
                        if (((ZipEntry)object3).getName().startsWith(UPDATE_JAVA_EXT_DIR) && !((ZipEntry)object3).isDirectory()) {
                            object2 = new File(ModuleUpdater.getJavaLibExtDirectory(), ((ZipEntry)object3).getName().substring(UPDATE_JAVA_EXT_DIR.length()));
                            if (((File)object2).exists()) {
                                object = new File(ModuleUpdater.getBackupDirectory(), UPDATE_JAVA_EXT_DIR + FILE_SEPARATOR + ((ZipEntry)object3).getName().substring(UPDATE_NETBEANS_DIR.length()));
                                ((File)object).getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream((File)object2), new FileOutputStream((File)object));
                            } else {
                                ((File)object2).getParentFile().mkdirs();
                            }
                            this.copyStreams(jarFile.getInputStream((ZipEntry)object3), new FileOutputStream((File)object2));
                            UpdaterFrame.setProgressValue(l += ((ZipEntry)object3).getSize());
                            continue;
                        }
                        if (!((ZipEntry)object3).getName().startsWith(UPDATE_MAIN_DIR) || ((ZipEntry)object3).isDirectory()) continue;
                        object2 = new File(ModuleUpdater.getMainDirectory(), ((ZipEntry)object3).getName().substring(UPDATE_MAIN_DIR.length() + 1));
                        ((File)object2).getParentFile().mkdirs();
                        bl = true;
                        this.copyStreams(jarFile.getInputStream((ZipEntry)object3), new FileOutputStream((File)object2));
                        UpdaterFrame.setProgressValue(l += ((ZipEntry)object3).getSize());
                    }
                    if (!bl || !((MainConfig)(object3 = new MainConfig(ModuleUpdater.getMainDirString() + FILE_SEPARATOR + JVM_PARAMS_FILE))).isValid()) break block25;
                    object2 = System.getProperty("java.home") + FILE_SEPARATOR + "bin" + FILE_SEPARATOR;
                    object = (String)object2 + "java -cp " + ModuleUpdater.getMainDirString() + ((MainConfig)object3).getCommand();
                    this.startCommand((String)object);
                    fileArray = ModuleUpdater.getMainDirectory().listFiles();
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        fileArray[n2].delete();
                        ++n2;
                    }
                }
                Object var17_16 = null;
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.nbmFiles[n].delete();
                {
                    break block27;
                    catch (IOException iOException) {
                        if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                            iOException.printStackTrace();
                        }
                        var17_16 = null;
                        try {
                            if (jarFile != null) {
                                jarFile.close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        this.nbmFiles[n].delete();
                    }
                }
                catch (Throwable throwable) {
                    var17_16 = null;
                    try {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.nbmFiles[n].delete();
                    throw throwable;
                }
            }
            ++n;
        }
        updateTracking.write();
        logWriter.println("Finished.");
        logWriter.close();
    }

    public static File getUpdateDirectory() {
        if (updateDirectory == null && !(updateDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + UPDATE_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + UPDATE_DIR)).isDirectory()) {
            updateDirectory.mkdirs();
        }
        return updateDirectory;
    }

    private static File getInstallDownloadDirectory() {
        File file = new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + DOWNLOAD_DIR);
        if (!file.isDirectory()) {
            file.mkdirs();
        }
        return file;
    }

    public static File getDownloadDirectory() {
        if (downloadDirectory == null && !(downloadDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + DOWNLOAD_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + DOWNLOAD_DIR)).isDirectory()) {
            downloadDirectory.mkdirs();
        }
        return downloadDirectory;
    }

    private void startCommand(String string) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process;
            final Process process2 = process = runtime.exec(string);
            new Thread(){

                public void run() {
                    try {
                        String string;
                        InputStreamReader inputStreamReader = new InputStreamReader(process2.getErrorStream());
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        do {
                            if ((string = bufferedReader.readLine()) == null) continue;
                            System.out.println(string);
                        } while (string != null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.start();
            int n = process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static File getBackupDirectory() {
        if (backupDirectory == null && !(backupDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + BACKUP_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + BACKUP_DIR)).isDirectory()) {
            backupDirectory.mkdirs();
        }
        return backupDirectory;
    }

    public static File getNetbeansDirectory() {
        if (netbeansDirectory == null) {
            netbeansDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user")) : new File(System.getProperty("netbeans.home"));
        }
        return netbeansDirectory;
    }

    private static File getMainDirectory() {
        if (mainDirectory == null) {
            mainDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + UPDATE_DIR + FILE_SEPARATOR + UPDATE_MAIN_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + UPDATE_DIR + FILE_SEPARATOR + UPDATE_MAIN_DIR);
        }
        return mainDirectory;
    }

    private static String getMainDirString() {
        return ModuleUpdater.getMainDirectory().getPath();
    }

    public static File getNbLibDirectory() {
        File file;
        if (nbLibDirectory == null) {
            nbLibDirectory = ModuleUpdater.isMultiuser() ? new File(System.getProperty("netbeans.user") + FILE_SEPARATOR + NB_LIB_DIR) : new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + NB_LIB_DIR);
        }
        if (!(file = new File(nbLibDirectory, EXT_DIR)).isDirectory()) {
            file.mkdirs();
        }
        return nbLibDirectory;
    }

    public static File getJavaLibExtDirectory() {
        if (javaLibExtDirectory == null) {
            javaLibExtDirectory = new File(System.getProperty("java.home") + FILE_SEPARATOR + JAVA_LIB_EXT_DIR);
        }
        if (ModuleUpdater.canWrite(javaLibExtDirectory, true)) {
            return javaLibExtDirectory;
        }
        return ModuleUpdater.getNbLibDirectory();
    }

    private static boolean isMultiuser() {
        if (fromInstall) {
            return false;
        }
        return !ModuleUpdater.singleMode();
    }

    private static boolean singleMode() {
        if (singleMode == null) {
            File file;
            File file2;
            singleMode = System.getProperty("netbeans.user") == null ? new Boolean(true) : ((file2 = new File(System.getProperty("netbeans.user"))).equals(file = new File(System.getProperty("netbeans.home"))) ? new Boolean(true) : new Boolean(false));
        }
        return singleMode;
    }

    private void copyStreams(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = 0;
        try {
            int n2;
            while ((n2 = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(n2);
                if (++n <= 8500) continue;
                n = 0;
                this.checkStop();
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            bufferedInputStream.close();
            bufferedOutputStream.close();
            throw throwable;
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    private static boolean canWrite(File file, boolean bl) {
        if (!file.exists() && bl) {
            file.mkdirs();
        }
        if (!file.isDirectory() || !file.canWrite()) {
            return false;
        }
        File file2 = null;
        try {
            file2 = File.createTempFile("test", "access", file);
        }
        catch (IOException iOException) {
            return false;
        }
        if (file2 == null) {
            return false;
        }
        boolean bl2 = file2.canWrite();
        if (bl2) {
            file2.delete();
        }
        return bl2;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getBranding() {
        String string;
        BufferedReader bufferedReader;
        block8: {
            bufferedReader = null;
            string = null;
            File file = new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + NB_LIB_DIR + FILE_SEPARATOR + "branding");
            bufferedReader = new BufferedReader(new FileReader(file));
            if (!bufferedReader.ready()) break block8;
            string = bufferedReader.readLine();
        }
        Object var4_4 = null;
        if (bufferedReader == null) return string;
        try {
            bufferedReader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        {
            catch (IOException iOException) {
                Object var4_5 = null;
                if (bufferedReader == null) return string;
                try {
                    bufferedReader.close();
                    return string;
                }
                catch (IOException iOException2) {}
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static class LogWriter {
        private FileWriter log = null;

        public LogWriter() {
            try {
                this.log = this.getLogWriter();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private FileWriter getLogWriter() throws IOException {
            File file = new File(ModuleUpdater.getUpdateDirectory() + FILE_SEPARATOR + ModuleUpdater.LOG_FILE_NAME);
            if (file.exists() && !file.canWrite() || file.isDirectory()) {
                throw new IOException("Cannot write to update.log");
            }
            return new FileWriter(file.getAbsolutePath(), true);
        }

        void println(String string) {
            if (this.log != null) {
                try {
                    this.log.write(string);
                    this.log.write(10);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        void close() {
            if (this.log != null) {
                try {
                    this.log.flush();
                    this.log.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    class MainConfig {
        private final String PAR_MAIN = "mainClass";
        private final String PAR_RELCP = "relativeClassPath";
        private final String PAR_JVMPAR = "jvm.parameters";
        private final String PAR_MAINARGS = "mainClass.arguments";
        private final String VAR_IDE_HOME = "%IDE_HOME%";
        private final String VAR_IDE_USER = "%IDE_USER%";
        private final String VAR_FILE_SEPARATOR = "%FS%";
        private final String VAR_JAVA_HOME = "%JAVA_HOME%";
        private final String VAR_ICON_ROOT = "%ICON_ROOT%";
        private final String ICON_ROOT = "Forte for Java";
        private String parameters = "";
        private boolean valid = false;

        public MainConfig(String string) {
            this.valid = this.readParms(string);
        }

        public String getCommand() {
            return this.parameters;
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * Unable to fully structure code
         */
        private boolean readParms(String var1_1) {
            block15: {
                var2_2 = new Properties();
                var3_3 = null;
                try {
                    var3_3 = new FileInputStream(var1_1);
                    var2_2.load(var3_3);
                    var7_4 = null;
                    ** if (var3_3 == null) goto lbl-1000
                }
                catch (Throwable var6_14) {
                    var7_6 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException var8_9) {
                            // empty catch block
                        }
                    }
                    throw var6_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var3_3.close();
                    }
                    catch (IOException var8_7) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (IOException var4_10) {
                        var5_12 = false;
                        var7_5 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var8_8) {
                                // empty catch block
                            }
                        }
                        return var5_12;
                    }
                }
            }
            if ((var5_13 = var2_2.getProperty("relativeClassPath", null)) != null) {
                this.parameters = ";" + var5_13;
            }
            if ((var6_15 = var2_2.getProperty("jvm.parameters", null)) != null) {
                this.parameters = this.parameters + " " + var6_15;
            }
            if ((var4_11 = var2_2.getProperty("mainClass", null)) == null) {
                return false;
            }
            this.parameters = this.parameters + " " + var4_11;
            var7_4 = var2_2.getProperty("mainClass.arguments", null);
            if (var7_4 != null) {
                this.parameters = this.parameters + " " + var7_4;
            }
            this.parameters = this.replaceAll(this.parameters, "%IDE_HOME%", new File(System.getProperty("netbeans.home")).getPath());
            this.parameters = this.replaceAll(this.parameters, "%IDE_USER%", ModuleUpdater.getNetbeansDirectory().getPath());
            this.parameters = this.replaceAll(this.parameters, "%FS%", ModuleUpdater.access$000());
            this.parameters = this.replaceAll(this.parameters, "%JAVA_HOME%", System.getProperty("java.home"));
            this.parameters = this.replaceAll(this.parameters, "%ICON_ROOT%", this.getIconRoot());
            return true;
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String getIconRoot() {
            String string;
            FileInputStream fileInputStream;
            block8: {
                Properties properties = new Properties();
                fileInputStream = null;
                File file = new File(System.getProperty("netbeans.home") + FILE_SEPARATOR + "system" + FILE_SEPARATOR + "product.properties");
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                string = properties.getProperty("start.menu.icon.root");
                if (string != null) break block8;
                string = this.getDefaultIconRoot();
            }
            Object var6_6 = null;
            if (fileInputStream == null) return '\"' + string + '\"';
            try {
                fileInputStream.close();
                return '\"' + string + '\"';
            }
            catch (IOException iOException) {}
            return '\"' + string + '\"';
            {
                catch (IOException iOException) {
                    string = this.getDefaultIconRoot();
                    Object var6_7 = null;
                    if (fileInputStream == null) return '\"' + string + '\"';
                    try {
                        fileInputStream.close();
                        return '\"' + string + '\"';
                    }
                    catch (IOException iOException2) {}
                    return '\"' + string + '\"';
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        private String getDefaultIconRoot() {
            String string = ModuleUpdater.getBranding();
            String string2 = "";
            if (string != null) {
                if (string.indexOf("_ce") > 0) {
                    string2 = " CE";
                } else if (string.indexOf("_ie") > 0) {
                    string2 = " IE";
                } else if (string.indexOf("_ee") > 0) {
                    string2 = " EE";
                }
            }
            return "Forte for Java" + string2;
        }

        private String replaceAll(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.toString().indexOf(string2);
            int n2 = string2.length();
            while (n > -1) {
                stringBuffer.replace(n, n + n2, string3);
                n = stringBuffer.toString().indexOf(string2, n + 1);
            }
            return stringBuffer.toString();
        }
    }
}

