/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.xml;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.InputSource;

public class AntProjectSupport
implements AntProjectCookie,
DocumentListener,
FileChangeListener,
EventListener,
Runnable,
ChangeListener {
    private File file;
    private FileObject fo;
    private transient org.w3c.dom.Document projDoc = null;
    private transient Throwable exception = null;
    private transient boolean parsed = false;
    private transient WeakReference styledDocRef = null;
    private transient Object parseLock;
    private transient boolean upToDate = false;
    private transient Set listeners;
    private transient EditorCookie editor = null;
    private static final long REPARSE_DELAY = 3000L;
    private static final Object expectingDocUpdates = new Object();
    private static final long serialVersionUID = 7366509989041657663L;
    private static boolean runFiringProcessor = false;
    private static final Map tofire = new HashMap();
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public AntProjectSupport(FileObject fileObject) {
        this(fileObject, FileUtil.toFile((FileObject)fileObject));
    }

    public AntProjectSupport(File file) {
        this(null, file);
    }

    private AntProjectSupport(FileObject fileObject, File file) {
        this.fo = fileObject;
        this.file = file;
        this.init();
    }

    private void init() {
        this.parseLock = new Object();
        this.listeners = new HashSet();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }

    private synchronized EditorCookie getEditor() {
        FileObject fileObject = this.getFileObject();
        if (fileObject == null) {
            return null;
        }
        if (this.editor == null) {
            try {
                this.editor = (EditorCookie)DataObject.find((FileObject)fileObject).getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = AntProjectSupport.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (this.editor != null && this.editor instanceof CloneableEditorSupport) {
                    ((CloneableEditorSupport)this.editor).addChangeListener(WeakListener.change((ChangeListener)this, (Object)this.editor));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                AntModule.err.notify(1, (Throwable)dataObjectNotFoundException);
            }
        }
        return this.editor;
    }

    public File getFile() {
        return this.file;
    }

    public FileObject getFileObject() {
        if (this.fo != null && !this.fo.isValid()) {
            AntModule.err.log("AntProjectSupport fo=" + this.fo + " was not valid, clearing");
            this.fo = null;
        }
        return this.fo;
    }

    public void setFile(File file) {
        this.file = file;
        this.fo = null;
        this.invalidate();
    }

    public void setFileObject(FileObject fileObject) {
        this.fo = fileObject;
        this.file = FileUtil.toFile((FileObject)fileObject);
        this.invalidate();
    }

    public org.w3c.dom.Document getDocument() {
        if (this.parsed) {
            return this.projDoc;
        }
        Object object = this.parseLock;
        synchronized (object) {
            if (this.parsed) {
                org.w3c.dom.Document document = this.projDoc;
                return document;
            }
            this.parseDocument();
            org.w3c.dom.Document document = this.projDoc;
            return document;
        }
    }

    public Throwable getParseException() {
        if (this.parsed) {
            return this.exception;
        }
        Object object = this.parseLock;
        synchronized (object) {
            if (this.parsed) {
                Throwable throwable = this.exception;
                return throwable;
            }
            this.parseDocument();
            Throwable throwable = this.exception;
            return throwable;
        }
    }

    private void parseDocument() {
        FileObject fileObject = this.getFileObject();
        AntModule.err.log("AntProjectSupport.parseDocument: fo=" + fileObject);
        try {
            Reader reader;
            Object object;
            DOMParser dOMParser = new DOMParser();
            dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            EditorCookie editorCookie = this.getEditor();
            if (editorCookie != null) {
                object = editorCookie.openDocument();
                reader = new DocumentReader((StyledDocument)object, fileObject);
                if (this.styledDocRef != null && this.styledDocRef.get() != object || this.styledDocRef == null) {
                    object.addDocumentListener(this);
                    this.styledDocRef = new WeakReference<Object>(object);
                }
            } else if (fileObject != null) {
                reader = new InputStreamReader(fileObject.getInputStream());
                fileObject.addFileChangeListener((FileChangeListener)this);
            } else if (this.file != null) {
                reader = new FileReader(this.file);
            } else {
                this.exception = new NullPointerException();
                return;
            }
            try {
                object = new InputSource(reader);
                if (this.file != null) {
                    try {
                        ((InputSource)object).setSystemId(this.file.toURL().toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        AntModule.err.notify(16, (Throwable)malformedURLException);
                    }
                }
                dOMParser.parse((InputSource)object);
                org.w3c.dom.Document document = dOMParser.getDocument();
                if (editorCookie != null) {
                    EventTarget eventTarget = (EventTarget)((Object)document);
                    eventTarget.addEventListener("DOMSubtreeModified", this, false);
                    eventTarget.addEventListener("DOMAttrModified", this, false);
                }
                this.projDoc = document;
                this.exception = null;
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                reader.close();
                throw throwable;
            }
            reader.close();
            {
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.exception = throwable;
        }
        this.parsed = true;
    }

    public Element getProjectElement() {
        org.w3c.dom.Document document = this.getDocument();
        if (document != null) {
            return document.getDocumentElement();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AntProjectSupport)) {
            return false;
        }
        AntProjectSupport antProjectSupport = (AntProjectSupport)object;
        if (this.fo != null && antProjectSupport.fo != null) {
            return this.fo.equals(antProjectSupport.fo);
        }
        if (this.file != null && antProjectSupport.file != null) {
            return this.file.equals(antProjectSupport.file);
        }
        return false;
    }

    public int hashCode() {
        return 0x6CB1 ^ (this.fo == null ? this.file.hashCode() : this.fo.hashCode());
    }

    public String toString() {
        FileObject fileObject = this.getFileObject();
        if (fileObject != null) {
            try {
                return DataObject.find((FileObject)fileObject).getNodeDelegate().getDisplayName();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return fileObject.toString();
            }
        }
        return this.file.getAbsolutePath();
    }

    private synchronized void regenerate() {
        block10: {
            FileObject fileObject = this.getFileObject();
            AntModule.err.log("AntProjectSupport.regenerate: fo=" + fileObject);
            if (this.projDoc == null) {
                throw new IllegalStateException();
            }
            try {
                EditorCookie editorCookie = this.getEditor();
                if (editorCookie == null) break block10;
                StyledDocument styledDocument = editorCookie.openDocument();
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                int[] nArray = new int[jEditorPaneArray == null ? 0 : jEditorPaneArray.length];
                int n = 0;
                while (n < nArray.length) {
                    nArray[n] = jEditorPaneArray[n].getCaretPosition();
                    ++n;
                }
                OutputFormat outputFormat = new OutputFormat(this.projDoc);
                outputFormat.setPreserveSpace(true);
                DocumentWriter documentWriter = new DocumentWriter(styledDocument, fileObject);
                try {
                    XMLSerializer xMLSerializer = new XMLSerializer((Writer)documentWriter, outputFormat);
                    xMLSerializer.serialize(this.projDoc);
                    ((Writer)documentWriter).write(10);
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    ((Writer)documentWriter).close();
                    throw throwable;
                }
                ((Writer)documentWriter).close();
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] < styledDocument.getLength()) {
                        try {
                            jEditorPaneArray[n2].setCaretPosition(nArray[n2]);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            AntModule.err.notify(1, (Throwable)illegalArgumentException);
                        }
                    }
                    ++n2;
                }
                this.exception = null;
                this.parsed = true;
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
        }
        this.fireChangeEvent();
    }

    public void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    protected void fireChangeEvent() {
        Iterator iterator;
        AntModule.err.log("AntProjectSupport.fireChangeEvent: fo=" + this.fo);
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        ChangeEvent changeEvent = new ChangeEvent(this);
        RequestProcessor.postRequest((Runnable)new ChangeFirer(iterator, changeEvent));
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getProperty(expectingDocUpdates) == null) {
            this.invalidate();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument().getProperty(expectingDocUpdates) == null) {
            this.invalidate();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.invalidate();
    }

    public void fileDeleted(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public void handleEvent(Event event) {
        AntModule.err.log("AntProjectSupport.handleEvent: fo=" + this.fo);
        AntModule.err.log("\tev=" + event);
        AntModule.err.log("\tev.type=" + event.getType());
        AntModule.err.log("\tev.target=" + event.getTarget());
        if (this.exception != null || event.getCurrentTarget() != this.projDoc) {
            AntModule.err.log(16, "AntProjectSupport.handleEvent on stale DOM tree");
            return;
        }
        this.upToDate = false;
        RequestProcessor.postRequest((Runnable)this);
    }

    public void run() {
        if (!this.upToDate) {
            this.upToDate = true;
            this.regenerate();
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        this.invalidate();
    }

    protected final void invalidate() {
        AntModule.err.log("AntProjectSupport.invalidate: fo=" + this.fo);
        this.parsed = false;
        Map map = tofire;
        synchronized (map) {
            if (!runFiringProcessor) {
                AntProjectSupport.startFiringProcessor();
            }
            if (tofire.put(this, new Date(System.currentTimeMillis() + 3000L)) == null) {
                tofire.notify();
            }
        }
    }

    public static void startFiringProcessor() {
        Map map = tofire;
        synchronized (map) {
            if (runFiringProcessor) {
                return;
            }
            runFiringProcessor = true;
            new FiringProcessor().start();
        }
    }

    public static void stopFiringProcessor() {
        Map map = tofire;
        synchronized (map) {
            if (!runFiringProcessor) {
                return;
            }
            runFiringProcessor = false;
            tofire.notify();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Object access$200() {
        return expectingDocUpdates;
    }

    private static final class FiringProcessor
    extends Thread {
        public FiringProcessor() {
            super("AntProjectSupport.FiringProcessor");
        }

        public void run() {
            Map map = tofire;
            synchronized (map) {
                Iterator<Object> iterator;
                HashSet hashSet = new HashSet();
                while (runFiringProcessor) {
                    iterator = tofire.entrySet().iterator();
                    long l = Long.MAX_VALUE;
                    long l2 = System.currentTimeMillis();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        Date date = (Date)entry.getValue();
                        long l3 = date.getTime();
                        if (l3 <= l2) {
                            hashSet.add(entry.getKey());
                            iterator.remove();
                            continue;
                        }
                        if (l3 >= l) continue;
                        l = l3;
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        ((AntProjectSupport)iterator.next()).fireChangeEvent();
                    }
                    hashSet.clear();
                    try {
                        tofire.wait(l - l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                iterator = tofire.keySet().iterator();
                while (iterator.hasNext()) {
                    ((AntProjectSupport)iterator.next()).fireChangeEvent();
                }
            }
        }
    }

    private static class DocumentWriter
    extends PipedWriter
    implements Runnable {
        private StyledDocument doc;
        private PipedReader rd;
        private Thread t;

        public DocumentWriter(StyledDocument styledDocument, FileObject fileObject) throws IOException {
            this.doc = styledDocument;
            this.rd = new PipedReader();
            this.connect(this.rd);
            this.t = new Thread((Runnable)this, "ant DocumentWriter: " + fileObject);
            this.t.start();
        }

        public void run() {
            try {
                NbDocument.runAtomicAsUser((StyledDocument)this.doc, (Runnable)new Runnable(this){
                    private final /* synthetic */ DocumentWriter this$0;
                    {
                        this.this$0 = documentWriter;
                    }

                    public void run() {
                        block5: {
                            DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), Boolean.TRUE);
                            try {
                                try {
                                    DocumentWriter.access$300(this.this$0).remove(0, DocumentWriter.access$300(this.this$0).getLength());
                                    new DefaultEditorKit().read(DocumentWriter.access$400(this.this$0), (Document)DocumentWriter.access$300(this.this$0), 0);
                                }
                                catch (IOException iOException) {
                                    AntModule.err.notify(1, (Throwable)iOException);
                                    Object var4_2 = null;
                                    DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), null);
                                    break block5;
                                }
                                catch (BadLocationException badLocationException) {
                                    AntModule.err.notify(1, (Throwable)badLocationException);
                                    Object var4_3 = null;
                                    DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), null);
                                }
                                Object var4_1 = null;
                                DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), null);
                            }
                            catch (Throwable throwable) {
                                Object var4_4 = null;
                                DocumentWriter.access$300(this.this$0).putProperty(AntProjectSupport.access$200(), null);
                                throw throwable;
                            }
                        }
                    }
                });
            }
            catch (BadLocationException badLocationException) {
                AntModule.err.notify(1, (Throwable)badLocationException);
            }
        }

        public void close() throws IOException {
            super.close();
            try {
                this.t.join();
            }
            catch (InterruptedException interruptedException) {
                IOException iOException = new IOException();
                AntModule.err.annotate((Throwable)iOException, (Throwable)interruptedException);
                throw iOException;
            }
        }

        static /* synthetic */ StyledDocument access$300(DocumentWriter documentWriter) {
            return documentWriter.doc;
        }

        static /* synthetic */ PipedReader access$400(DocumentWriter documentWriter) {
            return documentWriter.rd;
        }
    }

    private static class DocumentReader
    extends PipedReader
    implements Runnable {
        private StyledDocument doc;
        private PipedWriter wr;

        public DocumentReader(StyledDocument styledDocument, FileObject fileObject) throws IOException {
            this.doc = styledDocument;
            this.wr = new PipedWriter();
            this.connect(this.wr);
            new Thread((Runnable)this, "ant DocumentReader: " + fileObject).start();
        }

        public void run() {
            try {
                this.doc.render(new Runnable(this){
                    private final /* synthetic */ DocumentReader this$0;
                    {
                        this.this$0 = documentReader;
                    }

                    public void run() {
                        try {
                            new DefaultEditorKit().write(DocumentReader.access$000(this.this$0), (Document)DocumentReader.access$100(this.this$0), 0, DocumentReader.access$100(this.this$0).getLength());
                        }
                        catch (IOException iOException) {
                            AntModule.err.notify(1, (Throwable)iOException);
                        }
                        catch (BadLocationException badLocationException) {
                            AntModule.err.notify(1, (Throwable)badLocationException);
                        }
                    }
                });
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                try {
                    this.wr.close();
                }
                catch (IOException iOException) {
                    AntModule.err.notify(1, (Throwable)iOException);
                }
                throw throwable;
            }
            try {
                this.wr.close();
            }
            catch (IOException iOException) {
                AntModule.err.notify(1, (Throwable)iOException);
            }
        }

        static /* synthetic */ PipedWriter access$000(DocumentReader documentReader) {
            return documentReader.wr;
        }

        static /* synthetic */ StyledDocument access$100(DocumentReader documentReader) {
            return documentReader.doc;
        }
    }

    private static final class ChangeFirer
    implements Runnable {
        private final Iterator it;
        private final ChangeEvent ev;

        public ChangeFirer(Iterator iterator, ChangeEvent changeEvent) {
            this.it = iterator;
            this.ev = changeEvent;
        }

        public void run() {
            AntModule.err.log("AntProjectSupport.ChangeFirer.run");
            while (this.it.hasNext()) {
                ChangeListener changeListener = (ChangeListener)this.it.next();
                try {
                    changeListener.stateChanged(this.ev);
                }
                catch (RuntimeException runtimeException) {
                    AntModule.err.notify((Throwable)runtimeException);
                }
            }
        }
    }
}

