/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.run;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.DefinitionRegistry;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.run.NetBeansLogger;
import org.apache.tools.ant.module.run.OutputWriterOutputStream;
import org.openide.TopManager;
import org.openide.actions.ExecuteAction;
import org.openide.awt.Actions;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.Workspace;
import org.w3c.dom.Element;

public class TargetExecutor
implements Runnable {
    private AntProjectCookie pcookie;
    private InputOutput io;
    private boolean ok = false;
    private int verbosity = AntSettings.getDefault().getVerbosity();
    private Properties properties = (Properties)((Hashtable)AntSettings.getDefault().getProperties()).clone();
    private List targetNames;
    private boolean switchWorkspace = false;
    static /* synthetic */ Class class$org$apache$tools$ant$module$run$TargetExecutor;

    public TargetExecutor(AntProjectCookie antProjectCookie, String[] stringArray) {
        this.pcookie = antProjectCookie;
        this.targetNames = stringArray == null ? null : Arrays.asList(stringArray);
    }

    public void setVerbosity(int n) {
        this.verbosity = n;
    }

    public synchronized void setProperties(Properties properties) {
        this.properties = (Properties)((Hashtable)properties).clone();
    }

    public synchronized void addProperties(Properties properties) {
        if (((Hashtable)properties).isEmpty()) {
            return;
        }
        Properties properties2 = this.properties;
        this.properties = new Properties();
        ((Hashtable)this.properties).putAll(properties2);
        ((Hashtable)this.properties).putAll(properties);
    }

    public void setSwitchWorkspace(boolean bl) {
        this.switchWorkspace = bl;
    }

    public ExecutorTask execute() throws IOException {
        Object object;
        Element element;
        String string;
        if (AntSettings.getDefault().getReuseOutput()) {
            string = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"TITLE_output_reused");
        } else {
            element = this.pcookie.getProjectElement();
            object = element != null ? Actions.cutAmpersand((String)element.getAttribute("name")) : NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"LBL_unparseable_proj_name");
            String string2 = this.pcookie.getFileObject() != null ? DataObject.find((FileObject)this.pcookie.getFileObject()).getNodeDelegate().getDisplayName() : this.pcookie.getFile().getName();
            if (((String)object).equals("")) {
                object = string2;
            }
            if (this.targetNames != null) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = this.targetNames.iterator();
                if (iterator.hasNext()) {
                    stringBuffer.append((String)iterator.next());
                }
                while (iterator.hasNext()) {
                    stringBuffer.append(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor") : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"SEP_output_target"));
                    stringBuffer.append((String)iterator.next());
                }
                string = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"TITLE_output_target", (Object)object, (Object)string2, (Object)stringBuffer);
            } else {
                string = NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"TITLE_output_notarget", (Object)object, (Object)string2);
            }
        }
        object = this;
        synchronized (object) {
            if (this.switchWorkspace) {
                Mutex.EVENT.readAccess(new Mutex.Action(){

                    public Object run() {
                        Workspace workspace = TopManager.getDefault().getWindowManager().findWorkspace(ExecuteAction.getWorkspace());
                        if (workspace != null) {
                            workspace.activate();
                        }
                        return null;
                    }
                });
            }
            this.io = TopManager.getDefault().getIO(string, false);
            this.io.getOut().reset();
            this.io.select();
            element = TopManager.getDefault().getExecutionEngine().execute(string, (Runnable)this, InputOutput.NULL);
        }
        return new WrapperExecutorTask((ExecutorTask)element);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        Object object;
        Project project;
        block18: {
            NetBeansLogger netBeansLogger;
            Object object2;
            Object object3;
            PrintStream printStream;
            this.io.setFocusTaken(true);
            this.io.setErrVisible(false);
            this.io.setErrSeparated(false);
            if (AntSettings.getDefault().getSaveAll()) {
                TopManager.getDefault().saveAll();
            }
            project = null;
            PrintStream printStream2 = printStream = new PrintStream(new OutputWriterOutputStream(this.io.getErr()));
            try {
                object3 = this.pcookie.getFile();
                if (object3 == null) {
                    Class clazz;
                    if (class$org$apache$tools$ant$module$run$TargetExecutor == null) {
                        clazz = class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor");
                        throw new BuildException(NbBundle.getMessage((Class)clazz, (String)"EXC_non_local_proj_file"));
                    }
                    clazz = class$org$apache$tools$ant$module$run$TargetExecutor;
                    throw new BuildException(NbBundle.getMessage((Class)clazz, (String)"EXC_non_local_proj_file"));
                }
                project = new Project();
                project.init();
                object2 = DefinitionRegistry.getDefs("task").entrySet().iterator();
                while (true) {
                    if (!object2.hasNext()) break;
                    object = object2.next();
                    project.addTaskDefinition((String)object.getKey(), (Class)object.getValue());
                }
                object2 = DefinitionRegistry.getDefs("type").entrySet().iterator();
                while (true) {
                    if (!object2.hasNext()) break;
                    object = object2.next();
                    project.addDataTypeDefinition((String)object.getKey(), (Class)object.getValue());
                }
                project.setUserProperty("ant.file", ((File)object3).getAbsolutePath());
                project.setUserProperty("ant.version", Main.getAntVersion());
                object = ((Hashtable)this.properties).entrySet().iterator();
                while (true) {
                    if (!object.hasNext()) {
                        netBeansLogger = new NetBeansLogger();
                        netBeansLogger.setMessageOutputLevel(this.verbosity);
                        netBeansLogger.setOutputPrintStream(printStream2);
                        netBeansLogger.setErrorPrintStream(printStream);
                        project.addBuildListener(netBeansLogger);
                        ProjectHelper.configureProject(project, (File)object3);
                        break;
                    }
                    Map.Entry entry = (Map.Entry)object.next();
                    project.setUserProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (BuildException buildException) {
                if (this.verbosity >= 3) {
                    buildException.printStackTrace(printStream);
                    return;
                }
                printStream.println(buildException);
                return;
            }
            netBeansLogger.buildStarted(new BuildEvent(project));
            object3 = System.out;
            object2 = System.err;
            System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
            System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
            try {
                try {
                    if (this.targetNames != null) {
                        object = new Vector(this.targetNames);
                    } else {
                        object = new Vector<String>(1);
                        ((Vector)object).add(project.getDefaultTarget());
                    }
                    project.executeTargets((Vector)object);
                    netBeansLogger.buildFinished(new BuildEvent(project));
                    this.ok = true;
                }
                catch (ThreadDeath threadDeath) {
                    TopManager.getDefault().setStatusText(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$run$TargetExecutor == null ? (class$org$apache$tools$ant$module$run$TargetExecutor = TargetExecutor.class$("org.apache.tools.ant.module.run.TargetExecutor")) : class$org$apache$tools$ant$module$run$TargetExecutor), (String)"MSG_target_failed_status"));
                    Object var11_13 = null;
                    System.setOut((PrintStream)object3);
                    System.setErr((PrintStream)object2);
                    return;
                }
                catch (Throwable throwable) {
                    BuildEvent buildEvent = new BuildEvent(project);
                    buildEvent.setException(throwable);
                    netBeansLogger.buildFinished(buildEvent);
                    Object var11_14 = null;
                    System.setOut((PrintStream)object3);
                    System.setErr((PrintStream)object2);
                    break block18;
                }
                Object var11_12 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                System.setOut((PrintStream)object3);
                System.setErr((PrintStream)object2);
                throw throwable;
            }
            System.setOut((PrintStream)object3);
            System.setErr((PrintStream)object2);
        }
        object = project;
        RequestProcessor.postRequest((Runnable)new Runnable((Project)object){
            private final /* synthetic */ Project val$p2;
            {
                this.val$p2 = project;
            }

            public void run() {
                IntrospectedInfo introspectedInfo = AntSettings.getDefault().getCustomDefs();
                introspectedInfo.scanProject(this.val$p2);
            }
        }, (int)1000);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class WrapperRunnable
    implements Runnable {
        private ExecutorTask task;

        public WrapperRunnable(ExecutorTask executorTask) {
            this.task = executorTask;
        }

        public void run() {
            this.task.waitFinished();
        }
    }

    private class WrapperExecutorTask
    extends ExecutorTask {
        private ExecutorTask task;

        public WrapperExecutorTask(ExecutorTask executorTask) {
            super((Runnable)new WrapperRunnable(executorTask));
            this.task = executorTask;
        }

        public void stop() {
            this.task.stop();
        }

        public int result() {
            return this.task.result() + (TargetExecutor.this.ok ? 0 : 1);
        }

        public InputOutput getInputOutput() {
            return TargetExecutor.this.io;
        }
    }
}

