/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.awt.datatransfer.Transferable;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.ElementCookie;
import org.apache.tools.ant.module.nodes.AntProjectNode;
import org.apache.tools.ant.module.nodes.AntProperty;
import org.apache.tools.ant.module.nodes.ElementChildren;
import org.apache.tools.ant.module.xml.ElementSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class ElementNode
extends AbstractNode
implements EventListener,
Runnable,
NodeListener {
    protected Element el;
    private String error;
    private ElementCookie elCookie;
    private boolean attachedCookieListener = false;
    private static final int INDENT_STEP = 4;
    static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$ElementNode;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$ElementCookie;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$IntrospectionCookie;
    static /* synthetic */ Class class$org$openide$cookies$CompilerCookie;
    static /* synthetic */ Class class$org$openide$cookies$ExecCookie;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;
    static /* synthetic */ Class class$org$openide$actions$OpenLocalExplorerAction;
    static /* synthetic */ Class class$org$openide$actions$CutAction;
    static /* synthetic */ Class class$org$openide$actions$CopyAction;
    static /* synthetic */ Class class$org$openide$actions$PasteAction;
    static /* synthetic */ Class class$org$openide$actions$MoveUpAction;
    static /* synthetic */ Class class$org$openide$actions$MoveDownAction;
    static /* synthetic */ Class class$org$openide$actions$ReorderAction;
    static /* synthetic */ Class class$org$openide$actions$DeleteAction;
    static /* synthetic */ Class class$org$openide$actions$RenameAction;
    static /* synthetic */ Class class$org$openide$actions$NewAction;
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$org$openide$actions$PropertiesAction;

    public ElementNode(Element element, String string) {
        this(element);
        if (string == null) {
            throw new NullPointerException();
        }
        this.error = string;
        this.initDisplay();
    }

    protected ElementNode(Element element) {
        this(element, (Children)new ElementChildren(element));
    }

    protected ElementNode(Element element, Children children) {
        super(children);
        this.el = element;
        this.initDisplay();
        if (element instanceof EventTarget) {
            ((EventTarget)((Object)element)).addEventListener("DOMSubtreeModified", this, false);
            ((EventTarget)((Object)element)).addEventListener("DOMAttrModified", this, false);
        } else {
            AntModule.err.log(16, "Element was not an EventTarget: " + element);
        }
        this.getCookieSet().add((Node.Cookie)new ElementNodeIndex((Node)this));
    }

    protected ElementCookie createElementCookie() {
        return new ElementSupport(this.el);
    }

    protected void initDisplay() {
        this.setNameSuper(ElementNode.semiUniqueName(this.el));
        this.setDisplayName(ElementNode.displayName(this.el));
        if (this.error != null) {
            AntModule.err.log("ElementNode.initDisplay: error=" + this.error);
            this.setShortDescription(this.error);
        } else {
            this.setShortDescription(ElementNode.fullText(this.el));
        }
        this.setIconBase("/org/apache/tools/ant/module/resources/ElementIcon");
    }

    protected void setNameSuper(String string) {
        super.setName(string);
    }

    protected static String semiUniqueName(Element element) {
        Attr attr = element.getAttributeNode("id");
        if (attr != null) {
            return attr.getValue();
        }
        attr = element.getAttributeNode("name");
        if (attr != null) {
            return attr.getValue();
        }
        return element.getNodeName();
    }

    protected static String displayName(Element element) {
        Attr attr = element.getAttributeNode("name");
        if (attr != null) {
            return NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$ElementNode == null ? (class$org$apache$tools$ant$module$nodes$ElementNode = ElementNode.class$("org.apache.tools.ant.module.nodes.ElementNode")) : class$org$apache$tools$ant$module$nodes$ElementNode), (String)"LBL_node_with_name", (Object)element.getNodeName(), (Object)attr.getValue());
        }
        return element.getNodeName();
    }

    protected static String fullText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(element.getNodeName());
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = (Attr)namedNodeMap.item(n2);
            stringBuffer.append(' ');
            stringBuffer.append(attr.getName());
            stringBuffer.append('=');
            stringBuffer.append('\"');
            stringBuffer.append(attr.getValue());
            stringBuffer.append('\"');
            ++n2;
        }
        if (element.getChildNodes().getLength() > n) {
            stringBuffer.append(">...</");
            stringBuffer.append(element.getNodeName());
            stringBuffer.append('>');
        } else {
            stringBuffer.append("/>");
        }
        return stringBuffer.toString();
    }

    public Node.Cookie getCookie(Class clazz) {
        Node.Cookie cookie = super.getCookie(clazz);
        if (cookie != null) {
            return cookie;
        }
        if ((class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNode.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie).isAssignableFrom(clazz) || (class$org$apache$tools$ant$module$api$IntrospectionCookie == null ? (class$org$apache$tools$ant$module$api$IntrospectionCookie = ElementNode.class$("org.apache.tools.ant.module.api.IntrospectionCookie")) : class$org$apache$tools$ant$module$api$IntrospectionCookie).isAssignableFrom(clazz)) {
            if (this.elCookie == null) {
                ElementCookie elementCookie;
                this.elCookie = elementCookie = this.createElementCookie();
                RequestProcessor.postRequest((Runnable)new Runnable(){

                    public void run() {
                        ElementNode.super.getCookieSet().add((Node.Cookie)elementCookie);
                    }
                });
            }
            if (clazz.isInstance(this.elCookie)) {
                return this.elCookie;
            }
            return null;
        }
        if ((class$org$openide$cookies$CompilerCookie == null ? (class$org$openide$cookies$CompilerCookie = ElementNode.class$("org.openide.cookies.CompilerCookie")) : class$org$openide$cookies$CompilerCookie).isAssignableFrom(clazz) || (class$org$openide$cookies$ExecCookie == null ? (class$org$openide$cookies$ExecCookie = ElementNode.class$("org.openide.cookies.ExecCookie")) : class$org$openide$cookies$ExecCookie).isAssignableFrom(clazz)) {
            return null;
        }
        Node node = this.getParentNode();
        if (node != null) {
            if (!this.attachedCookieListener) {
                this.attachedCookieListener = true;
                node.addNodeListener(WeakListener.node((NodeListener)this, (Object)node));
            }
            return node.getCookie(clazz);
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.apache.tools.ant.module.node-manip");
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        if (set == null) {
            set = Sheet.createPropertiesSet();
            sheet.put(set);
        }
        this.addProperties(set);
        return sheet;
    }

    protected void addProperties(Sheet.Set set) {
        NamedNodeMap namedNodeMap = this.el.getAttributes();
        AntProjectCookie antProjectCookie = (AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie);
        int n = namedNodeMap.getLength();
        int n2 = 0;
        while (n2 < n) {
            set.put((Node.Property)new AntProperty(this.el, namedNodeMap.item(n2).getNodeName(), antProjectCookie));
            ++n2;
        }
        set.put((Node.Property)new AntProperty(this.el, "id", antProjectCookie));
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$OpenLocalExplorerAction == null ? (class$org$openide$actions$OpenLocalExplorerAction = ElementNode.class$("org.openide.actions.OpenLocalExplorerAction")) : class$org$openide$actions$OpenLocalExplorerAction)), null, SystemAction.get((Class)(class$org$openide$actions$CutAction == null ? (class$org$openide$actions$CutAction = ElementNode.class$("org.openide.actions.CutAction")) : class$org$openide$actions$CutAction)), SystemAction.get((Class)(class$org$openide$actions$CopyAction == null ? (class$org$openide$actions$CopyAction = ElementNode.class$("org.openide.actions.CopyAction")) : class$org$openide$actions$CopyAction)), SystemAction.get((Class)(class$org$openide$actions$PasteAction == null ? (class$org$openide$actions$PasteAction = ElementNode.class$("org.openide.actions.PasteAction")) : class$org$openide$actions$PasteAction)), null, SystemAction.get((Class)(class$org$openide$actions$MoveUpAction == null ? (class$org$openide$actions$MoveUpAction = ElementNode.class$("org.openide.actions.MoveUpAction")) : class$org$openide$actions$MoveUpAction)), SystemAction.get((Class)(class$org$openide$actions$MoveDownAction == null ? (class$org$openide$actions$MoveDownAction = ElementNode.class$("org.openide.actions.MoveDownAction")) : class$org$openide$actions$MoveDownAction)), SystemAction.get((Class)(class$org$openide$actions$ReorderAction == null ? (class$org$openide$actions$ReorderAction = ElementNode.class$("org.openide.actions.ReorderAction")) : class$org$openide$actions$ReorderAction)), null, SystemAction.get((Class)(class$org$openide$actions$DeleteAction == null ? (class$org$openide$actions$DeleteAction = ElementNode.class$("org.openide.actions.DeleteAction")) : class$org$openide$actions$DeleteAction)), SystemAction.get((Class)(class$org$openide$actions$RenameAction == null ? (class$org$openide$actions$RenameAction = ElementNode.class$("org.openide.actions.RenameAction")) : class$org$openide$actions$RenameAction)), null, SystemAction.get((Class)(class$org$openide$actions$NewAction == null ? (class$org$openide$actions$NewAction = ElementNode.class$("org.openide.actions.NewAction")) : class$org$openide$actions$NewAction)), null, SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = ElementNode.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction)), SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ElementNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction))};
    }

    public SystemAction getDefaultAction() {
        return SystemAction.get((Class)(class$org$openide$actions$PropertiesAction == null ? (class$org$openide$actions$PropertiesAction = ElementNode.class$("org.openide.actions.PropertiesAction")) : class$org$openide$actions$PropertiesAction));
    }

    public boolean canDestroy() {
        if (AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie))) {
            return false;
        }
        org.w3c.dom.Node node = this.el.getParentNode();
        if (node == null) {
            return false;
        }
        short s = node.getNodeType();
        boolean bl = s == 1;
        return bl;
    }

    public void destroy() throws IOException {
        ElementCookie elementCookie;
        org.w3c.dom.Node node = this.el.getParentNode();
        if (node == null) {
            throw new IOException("Node had no DOM parent");
        }
        try {
            node.removeChild(this.el);
            AntModule.err.log("ElementNode.destroy: el=" + this.el + " done");
        }
        catch (DOMException dOMException) {
            IOException iOException = new IOException();
            AntModule.err.annotate((Throwable)iOException, (Throwable)dOMException);
            throw iOException;
        }
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) == this.el) {
                throw new IOException("Node.removeChild did not work!");
            }
            ++n;
        }
        AntProjectCookie antProjectCookie = (AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie);
        if (antProjectCookie != null && antProjectCookie.getDocument() != this.el.getOwnerDocument()) {
            throw new IOException("DOM mismatch");
        }
        Node node2 = this.getParentNode();
        if (node2 != null && (elementCookie = (ElementCookie)node2.getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNode.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie)) != null && elementCookie.getElement() != node) {
            throw new IOException("I am not my father's son!");
        }
    }

    public boolean canRename() {
        if (AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie))) {
            return false;
        }
        return this.el.getAttributeNode("id") != null || this.el.getAttributeNode("name") != null;
    }

    public void setName(String string) throws IllegalArgumentException {
        block5: {
            if (((FeatureDescriptor)((Object)this)).getName().equals(string)) {
                return;
            }
            try {
                Attr attr = this.el.getAttributeNode("id");
                if (attr != null) {
                    attr.setNodeValue(string);
                    break block5;
                }
                attr = this.el.getAttributeNode("name");
                if (attr != null) {
                    attr.setNodeValue(string);
                    break block5;
                }
                throw new IllegalArgumentException();
            }
            catch (DOMException dOMException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                AntModule.err.annotate((Throwable)illegalArgumentException, (Throwable)dOMException);
                throw illegalArgumentException;
            }
        }
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return !AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
    }

    static void appendWithIndent(Element element, org.w3c.dom.Node node) throws DOMException {
        org.w3c.dom.Node node2 = element;
        int n = -1;
        while (!(node2 instanceof Document)) {
            node2 = node2.getParentNode();
            ++n;
        }
        String string = element.hasChildNodes() ? ElementNode.spaces(4) : "\n" + ElementNode.spaces((n + 1) * 4);
        element.appendChild(((Document)node2).createTextNode(string));
        element.appendChild(node);
        element.appendChild(((Document)node2).createTextNode("\n" + ElementNode.spaces(n * 4)));
    }

    private static String spaces(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 32;
            ++n2;
        }
        return new String(cArray);
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        if (!AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ElementNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie))) {
            ElementCookie elementCookie = (ElementCookie)NodeTransfer.cookie((Transferable)transferable, (int)1, (Class)(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNode.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie));
            if (elementCookie != null && this.canPasteElement(elementCookie.getElement())) {
                list.add(new ElementPaste(this.el, elementCookie.getElement(), false));
            }
            if ((elementCookie = (ElementCookie)NodeTransfer.cookie((Transferable)transferable, (int)6, (Class)(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNode.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie))) != null && this.canPasteElement(elementCookie.getElement())) {
                list.add(new ElementPaste(this.el, elementCookie.getElement(), true));
            }
        }
    }

    protected boolean canPasteElement(Element element) {
        return true;
    }

    public NewType[] getNewTypes() {
        return new NewType[0];
    }

    public void handleEvent(Event event) {
        if (this.isRelevant(event)) {
            RequestProcessor.postRequest((Runnable)this);
        }
    }

    public void run() {
        this.initDisplay();
        this.firePropertyChange(null, null, null);
    }

    protected boolean isRelevant(Event event) {
        return event.getTarget() == this.el;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("cookie".equals(propertyChangeEvent.getPropertyName())) {
            this.fireCookieChange();
        }
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ElementNodeIndex
    extends Index.Support {
        protected Node indexNode;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$ElementCookie;

        public ElementNodeIndex(Node node) {
            this.indexNode = node;
        }

        public Node[] getNodes() {
            return this.indexNode.getChildren().getNodes();
        }

        public int getNodesCount() {
            return this.indexNode.getChildren().getNodesCount();
        }

        public int indexOf(Node node) {
            ElementCookie elementCookie = (ElementCookie)node.getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie);
            if (elementCookie == null) {
                return -1;
            }
            Element element = elementCookie.getElement();
            if (element == null) {
                return -1;
            }
            Node[] nodeArray = this.getNodes();
            int n = 0;
            while (n < nodeArray.length) {
                ElementCookie elementCookie2 = (ElementCookie)nodeArray[n].getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie") : class$org$apache$tools$ant$module$api$ElementCookie);
                if (elementCookie2 != null && elementCookie2.getElement() == element) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        protected org.w3c.dom.Node getParentNode() {
            return ((ElementCookie)this.indexNode.getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? (class$org$apache$tools$ant$module$api$ElementCookie = ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie")) : class$org$apache$tools$ant$module$api$ElementCookie)).getElement();
        }

        public void reorder(int[] nArray) {
            Node[] nodeArray = this.getNodes();
            org.w3c.dom.Node node = this.getParentNode();
            if (node == null) {
                return;
            }
            LinkedList<Element> linkedList = new LinkedList<Element>();
            int n = 0;
            while (n < nArray.length) {
                linkedList.add(((ElementCookie)nodeArray[n].getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie") : class$org$apache$tools$ant$module$api$ElementCookie)).getElement());
                ++n;
            }
            Element[] elementArray = new Element[nArray.length];
            int n2 = 0;
            while (n2 < nArray.length) {
                elementArray[n2] = ((ElementCookie)nodeArray[nArray[n2]].getCookie(class$org$apache$tools$ant$module$api$ElementCookie == null ? ElementNodeIndex.class$("org.apache.tools.ant.module.api.ElementCookie") : class$org$apache$tools$ant$module$api$ElementCookie)).getElement();
                ++n2;
            }
            int n3 = 0;
            while (n3 < elementArray.length) {
                Object e = linkedList.get(n3);
                if (e != elementArray[n3]) {
                    this.exchangeElements(node, (Element)e, elementArray[n3]);
                    int n4 = linkedList.indexOf(elementArray[n3]);
                    linkedList.remove(e);
                    linkedList.remove(elementArray[n3]);
                    linkedList.add(n3, elementArray[n3]);
                    linkedList.add(n4, (Element)e);
                }
                ++n3;
            }
        }

        protected void exchangeElements(org.w3c.dom.Node node, org.w3c.dom.Node node2, org.w3c.dom.Node node3) {
            org.w3c.dom.Node node4 = node3.getNextSibling();
            node.replaceChild(node3, node2);
            if (node4 != null) {
                node.insertBefore(node2, node4);
            } else {
                node.appendChild(node2);
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class ElementPaste
    extends PasteType {
        private boolean cut;
        private Element el;
        private Element el2;

        public ElementPaste(Element element, Element element2, boolean bl) {
            this.el = element;
            this.el2 = element2;
            this.cut = bl;
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public String getDisplayName() {
            return ElementNode.fullText(this.el2);
        }

        public Transferable paste() throws IOException {
            try {
                boolean bl;
                boolean bl2 = bl = this.el.getOwnerDocument() != this.el2.getOwnerDocument();
                org.w3c.dom.Node node = bl ? this.el.getOwnerDocument().importNode(this.el2, true) : (this.cut ? this.el2 : this.el2.cloneNode(true));
                AntModule.err.log("ElementPaste: el=" + this.el + " el2=" + this.el2 + " toadd=" + node);
                if (this.cut && bl) {
                    this.el2.getParentNode().removeChild(this.el2);
                }
                ElementNode.appendWithIndent(this.el, node);
            }
            catch (DOMException dOMException) {
                IOException iOException = new IOException();
                AntModule.err.annotate((Throwable)iOException, (Throwable)dOMException);
                throw iOException;
            }
            return this.cut ? ExTransferable.EMPTY : null;
        }
    }
}

