/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.nodes;

import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.ElementCookie;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.api.IntrospectionCookie;
import org.apache.tools.ant.module.nodes.AntProjectNode;
import org.apache.tools.ant.module.nodes.AntProperty;
import org.apache.tools.ant.module.nodes.ElementChildren;
import org.apache.tools.ant.module.nodes.ElementNode;
import org.apache.tools.ant.module.xml.ElementSupport;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.openide.TopManager;
import org.openide.execution.NbClassPath;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.NewType;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DataTypeNode
extends ElementNode {
    private Map attrs;
    private Map subels;
    private Boolean supportsTextFlag;
    private String clazz;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$IntrospectionCookie;
    static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$tools$ant$types$EnumeratedAttribute;
    static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$DataTypeNode;

    public DataTypeNode(Element element, String string) {
        this(element, DataTypeNode.computeChildren(element, string));
        this.clazz = string;
    }

    protected DataTypeNode(Element element, Children children) {
        super(element, children);
    }

    private static Children computeChildren(Element element, String string) {
        if (DataTypeNode.isEmpty(string)) {
            return Children.LEAF;
        }
        return new ElementChildren(element);
    }

    protected static boolean isEmpty(String string) {
        return DataTypeNode.isEmpty(string, IntrospectedInfo.getDefaults()) || DataTypeNode.isEmpty(string, AntSettings.getDefault().getCustomDefs());
    }

    private static boolean isEmpty(String string, IntrospectedInfo introspectedInfo) {
        if (introspectedInfo.isKnown(string)) {
            return introspectedInfo.getElements(string).isEmpty();
        }
        return false;
    }

    protected DataTypeNode(Element element) {
        super(element);
    }

    protected ElementCookie createElementCookie() {
        if (this.clazz != null) {
            return new ElementSupport.Introspection(this.el, this.clazz);
        }
        return new ElementSupport(this.el);
    }

    protected void initDisplay() {
        super.initDisplay();
        this.setIconBase("/org/apache/tools/ant/module/resources/DataTypeIcon");
    }

    public HelpCtx getHelpCtx() {
        if (this.clazz != null) {
            Map map = IntrospectedInfo.getDefaults().getDefs("type");
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!this.clazz.equals((String)entry.getValue())) continue;
                return new HelpCtx("org.apache.tools.ant.module.types." + (String)entry.getKey());
            }
        }
        return new HelpCtx("org.apache.tools.ant.module.node-manip");
    }

    protected Map getAttrs() {
        DataTypeNode dataTypeNode = this;
        synchronized (dataTypeNode) {
            if (this.attrs != null) {
                Map map = this.attrs;
                return map;
            }
            this.updateStuff();
            Map map = this.attrs;
            return map;
        }
    }

    protected Map getSubels() {
        DataTypeNode dataTypeNode = this;
        synchronized (dataTypeNode) {
            if (this.subels != null) {
                Map map = this.subels;
                return map;
            }
            this.updateStuff();
            Map map = this.subels;
            return map;
        }
    }

    protected boolean supportsText() {
        DataTypeNode dataTypeNode = this;
        synchronized (dataTypeNode) {
            if (this.supportsTextFlag != null) {
                boolean bl = this.supportsTextFlag;
                return bl;
            }
            this.updateStuff();
            boolean bl = this.supportsTextFlag;
            return bl;
        }
    }

    private void updateStuff() {
        this.attrs = new HashMap();
        this.subels = new HashMap();
        this.supportsTextFlag = Boolean.FALSE;
        String string = this.el.getNodeName();
        IntrospectionCookie introspectionCookie = (IntrospectionCookie)this.getCookie(class$org$apache$tools$ant$module$api$IntrospectionCookie == null ? (class$org$apache$tools$ant$module$api$IntrospectionCookie = DataTypeNode.class$("org.apache.tools.ant.module.api.IntrospectionCookie")) : class$org$apache$tools$ant$module$api$IntrospectionCookie);
        if (introspectionCookie == null) {
            return;
        }
        String string2 = introspectionCookie.getClassName();
        IntrospectedInfo introspectedInfo = IntrospectedInfo.getDefaults();
        if (introspectedInfo.isKnown(string2)) {
            this.attrs = introspectedInfo.getAttributes(string2);
            this.subels = introspectedInfo.getElements(string2);
            this.supportsTextFlag = new Boolean(introspectedInfo.supportsText(string2));
        } else {
            introspectedInfo = AntSettings.getDefault().getCustomDefs();
            if (introspectedInfo.isKnown(string2)) {
                this.attrs = introspectedInfo.getAttributes(string2);
                this.subels = introspectedInfo.getElements(string2);
                this.supportsTextFlag = new Boolean(introspectedInfo.supportsText(string2));
            }
        }
    }

    protected void addProperties(Sheet.Set set) {
        Object object;
        Iterator iterator = this.getAttrs().entrySet().iterator();
        AntProjectCookie antProjectCookie = (AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = DataTypeNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie);
        while (iterator.hasNext()) {
            Class clazz;
            object = iterator.next();
            String string = (String)object.getKey();
            if (this.el.getAttribute(string).indexOf("${") != -1) {
                set.put((Node.Property)new AntProperty(this.el, string, antProjectCookie));
                continue;
            }
            String string2 = (String)object.getValue();
            if (string2.equals("org.apache.tools.ant.types.Reference")) {
                set.put((Node.Property)new ReferenceProperty(string));
                continue;
            }
            if (string2.equals("org.apache.tools.ant.types.Path")) {
                set.put((Node.Property)new PathProperty(string));
                continue;
            }
            if (string2.equals("java.io.File")) {
                set.put((Node.Property)new FileProperty(string));
                continue;
            }
            if (string2.equals("java.lang.String") && string.equals("path") && (this.clazz.equals("org.apache.tools.ant.types.Path") || this.clazz.equals("org.apache.tools.ant.types.Path$PathElement"))) {
                set.put((Node.Property)new PathProperty(string));
                continue;
            }
            if (string2.equals("boolean")) {
                clazz = Boolean.TYPE;
            } else if (string2.equals("char")) {
                clazz = Character.TYPE;
            } else if (string2.equals("byte")) {
                clazz = Byte.TYPE;
            } else if (string2.equals("short")) {
                clazz = Short.TYPE;
            } else if (string2.equals("int")) {
                clazz = Integer.TYPE;
            } else if (string2.equals("long")) {
                clazz = Long.TYPE;
            } else if (string2.equals("float")) {
                clazz = Float.TYPE;
            } else if (string2.equals("double")) {
                clazz = Double.TYPE;
            } else {
                try {
                    clazz = TopManager.getDefault().currentClassLoader().loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = class$java$lang$String == null ? DataTypeNode.class$("java.lang.String") : class$java$lang$String;
                }
            }
            if ((class$org$apache$tools$ant$types$EnumeratedAttribute == null ? DataTypeNode.class$("org.apache.tools.ant.types.EnumeratedAttribute") : class$org$apache$tools$ant$types$EnumeratedAttribute).isAssignableFrom(clazz)) {
                set.put((Node.Property)new EnumeratedProperty(string, clazz, antProjectCookie));
                continue;
            }
            set.put((Node.Property)new DataProperty(string, clazz));
        }
        object = new AntProperty(this.el, "id", antProjectCookie);
        ((FeatureDescriptor)object).setDisplayName(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = DataTypeNode.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"PROP_data_id"));
        ((FeatureDescriptor)object).setShortDescription(NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = DataTypeNode.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"HINT_data_id"));
        set.put((Node.Property)object);
        if (this.supportsText()) {
            set.put((Node.Property)new TextProperty());
        }
    }

    protected boolean canPasteElement(Element element) {
        return this.getSubels().containsKey(element.getNodeName());
    }

    public NewType[] getNewTypes() {
        if (!AntProjectNode.isScriptReadOnly((AntProjectCookie)this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = DataTypeNode.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie))) {
            ArrayList arrayList = new ArrayList(this.getSubels().keySet());
            Collections.sort(arrayList);
            NewType[] newTypeArray = new NewType[arrayList.size()];
            int n = 0;
            while (n < newTypeArray.length) {
                newTypeArray[n] = new SubElementNewType((String)arrayList.get(n));
                ++n;
            }
            return newTypeArray;
        }
        return new NewType[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SubElementNewType
    extends NewType {
        private String name;

        public SubElementNewType(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.apache.tools.ant.module.node-manip");
        }

        public void create() throws IOException {
            try {
                Element element = DataTypeNode.this.el.getOwnerDocument().createElement(this.name);
                ElementNode.appendWithIndent(DataTypeNode.this.el, element);
            }
            catch (DOMException dOMException) {
                IOException iOException = new IOException();
                AntModule.err.annotate((Throwable)iOException, (Throwable)dOMException);
                throw iOException;
            }
        }
    }

    private class TextProperty
    extends PropertySupport.ReadWrite {
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$DataTypeNode;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public TextProperty() {
            super("text", class$java$lang$String == null ? (class$java$lang$String = TextProperty.class$("java.lang.String")) : class$java$lang$String, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = TextProperty.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"PROP_data_text"), NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = TextProperty.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"HINT_data_text"));
        }

        public Object getValue() {
            NodeList nodeList = DataTypeNode.this.el.getChildNodes();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < nodeList.getLength()) {
                if (nodeList.item(n) instanceof Text) {
                    stringBuffer.append(((Text)nodeList.item(n)).getData());
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException();
            }
            NodeList nodeList = DataTypeNode.this.el.getChildNodes();
            try {
                int n = 0;
                while (n < nodeList.getLength()) {
                    if (nodeList.item(n) instanceof Text) {
                        DataTypeNode.this.el.removeChild(nodeList.item(n));
                    }
                    ++n;
                }
                DataTypeNode.this.el.appendChild(DataTypeNode.this.el.getOwnerDocument().createCDATASection((String)object));
            }
            catch (DOMException dOMException) {
                throw new InvocationTargetException(dOMException);
            }
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = TextProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class PathProperty
    extends PropertySupport.ReadWrite {
        static /* synthetic */ Class class$org$openide$execution$NbClassPath;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public PathProperty(String string) {
            super(string, class$org$openide$execution$NbClassPath == null ? (class$org$openide$execution$NbClassPath = PathProperty.class$("org.openide.execution.NbClassPath")) : class$org$openide$execution$NbClassPath, string, string);
        }

        public Object getValue() {
            String string = DataTypeNode.this.el.getAttribute(((FeatureDescriptor)((Object)this)).getName());
            string = this.subst(string, File.separatorChar, '/');
            string = this.subst(string, File.separatorChar, '\\');
            string = this.substColonCarefully(string);
            string = this.subst(string, File.pathSeparatorChar, ';');
            return new NbClassPath(string);
        }

        private String substColonCarefully(String string) {
            if (File.pathSeparatorChar == ':') {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == ':' && (n <= 0 || !Character.isLetter(stringBuffer.charAt(n - 1)) || n != 1 && stringBuffer.charAt(n - 2) != ':' && stringBuffer.charAt(n - 2) != ';')) {
                    stringBuffer.setCharAt(n, File.pathSeparatorChar);
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        private String subst(String string, char c, char c2) {
            if (c == c2) {
                return string;
            }
            return string.replace(c2, c);
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            try {
                if (object == null) {
                    DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                } else {
                    if (!(object instanceof NbClassPath)) {
                        throw new IllegalArgumentException();
                    }
                    String string = ((NbClassPath)object).getClassPath();
                    if (string.length() < 1) {
                        DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                    } else {
                        if (string.startsWith("\"") && (string = string.substring(1)).endsWith("\"")) {
                            string = string.substring(0, string.length() - 1);
                        }
                        DataTypeNode.this.el.setAttribute(((FeatureDescriptor)((Object)this)).getName(), string);
                    }
                }
            }
            catch (DOMException dOMException) {
                throw new InvocationTargetException(dOMException);
            }
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() throws IllegalArgumentException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = PathProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class FileProperty
    extends PropertySupport.ReadWrite {
        static /* synthetic */ Class class$java$io$File;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public FileProperty(String string) {
            super(string, class$java$io$File == null ? (class$java$io$File = FileProperty.class$("java.io.File")) : class$java$io$File, string, string);
        }

        public PropertyEditor getPropertyEditor() {
            AntProjectCookie antProjectCookie = (AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = FileProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie);
            if (antProjectCookie != null) {
                Element element = antProjectCookie.getProjectElement();
                File file = antProjectCookie.getFile();
                if (element != null && file != null) {
                    String string = element.getAttribute("basedir");
                    File file2 = file.getParentFile();
                    if (string != null && !string.equals(".")) {
                        File file3 = new File(string);
                        file2 = file3.isAbsolute() ? file3 : new File(file2, string);
                    }
                    AntModule.err.log("FileProperty: setting baseDir=" + file2);
                    ((FeatureDescriptor)((Object)this)).setValue("baseDir", file2);
                }
            }
            return super.getPropertyEditor();
        }

        public Object getValue() {
            String string = DataTypeNode.this.el.getAttribute(((FeatureDescriptor)((Object)this)).getName());
            if (string.equals("")) {
                return null;
            }
            if (string.equals(".")) {
                string = "";
            }
            return new File(string);
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            try {
                if (object == null) {
                    DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                } else {
                    if (!(object instanceof File)) {
                        throw new IllegalArgumentException();
                    }
                    String string = ((File)object).getPath();
                    if (string.equals("")) {
                        string = ".";
                    }
                    AntModule.err.log("FileProperty: set path=" + string);
                    DataTypeNode.this.el.setAttribute(((FeatureDescriptor)((Object)this)).getName(), string);
                }
            }
            catch (DOMException dOMException) {
                throw new InvocationTargetException(dOMException);
            }
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() throws IllegalArgumentException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = FileProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class ReferenceEditor
    extends PropertyEditorSupport {
        private ReferenceEditor() {
        }

        public String getAsText() {
            return ((Reference)this.getValue()).getRefId();
        }

        public void setAsText(String string) {
            this.setValue(new Reference(string));
        }

        public String[] getTags() {
            TreeSet<String> treeSet = new TreeSet<String>();
            NodeList nodeList = DataTypeNode.this.el.getOwnerDocument().getElementsByTagName("*");
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string;
                Attr attr = ((Element)nodeList.item(n2)).getAttributeNode("id");
                if (attr != null && (string = attr.getValue()) != null && !string.equals("")) {
                    treeSet.add(string);
                }
                ++n2;
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }
    }

    private class ReferenceProperty
    extends PropertySupport.ReadWrite {
        static /* synthetic */ Class class$org$apache$tools$ant$types$Reference;
        static /* synthetic */ Class class$org$apache$tools$ant$module$nodes$DataTypeNode;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public ReferenceProperty(String string) {
            super(string, class$org$apache$tools$ant$types$Reference == null ? (class$org$apache$tools$ant$types$Reference = ReferenceProperty.class$("org.apache.tools.ant.types.Reference")) : class$org$apache$tools$ant$types$Reference, string, NbBundle.getMessage((Class)(class$org$apache$tools$ant$module$nodes$DataTypeNode == null ? (class$org$apache$tools$ant$module$nodes$DataTypeNode = ReferenceProperty.class$("org.apache.tools.ant.module.nodes.DataTypeNode")) : class$org$apache$tools$ant$module$nodes$DataTypeNode), (String)"HINT_data_refid"));
        }

        public Object getValue() {
            return new Reference(DataTypeNode.this.el.getAttribute(((FeatureDescriptor)((Object)this)).getName()));
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            try {
                if (object == null) {
                    DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                } else {
                    if (!(object instanceof Reference)) {
                        throw new IllegalArgumentException();
                    }
                    DataTypeNode.this.el.setAttribute(((FeatureDescriptor)((Object)this)).getName(), ((Reference)object).getRefId());
                }
            }
            catch (DOMException dOMException) {
                throw new InvocationTargetException(dOMException);
            }
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() throws IllegalArgumentException, InvocationTargetException {
            this.setValue(null);
        }

        public PropertyEditor getPropertyEditor() {
            return new ReferenceEditor();
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = ReferenceProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    private class EnumeratedEditor
    extends PropertyEditorSupport {
        String[] tags;

        public EnumeratedEditor(Class clazz) {
            try {
                EnumeratedAttribute enumeratedAttribute = (EnumeratedAttribute)clazz.newInstance();
                this.tags = enumeratedAttribute.getValues();
            }
            catch (Exception exception) {
                AntModule.err.notify(1, (Throwable)exception);
                this.tags = new String[0];
            }
        }

        public String getAsText() {
            return (String)this.getValue();
        }

        public void setAsText(String string) {
            this.setValue(string);
        }

        public String[] getTags() {
            return this.tags;
        }
    }

    private class EnumeratedProperty
    extends AntProperty {
        private Class clazz;

        public EnumeratedProperty(String string, Class clazz, AntProjectCookie antProjectCookie) {
            super(DataTypeNode.this.el, string, antProjectCookie);
            this.clazz = clazz;
        }

        public PropertyEditor getPropertyEditor() {
            return new EnumeratedEditor(this.clazz);
        }
    }

    private class DataProperty
    extends PropertySupport.ReadWrite {
        private Constructor cons;
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$org$apache$tools$ant$module$api$AntProjectCookie;

        public DataProperty(String string, Class clazz) {
            super(string, clazz, string, string);
            if (!clazz.isPrimitive()) {
                try {
                    this.cons = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = DataProperty.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    this.cons = null;
                }
            }
        }

        public Object getValue() {
            Class clazz = this.getValueType();
            String string = DataTypeNode.this.el.getAttribute(((FeatureDescriptor)((Object)this)).getName());
            try {
                if (clazz == Boolean.TYPE) {
                    return new Boolean(Project.toBoolean(string));
                }
                if (clazz == Character.TYPE) {
                    return new Character(string.length() > 0 ? string.charAt(0) : (char)'\u0000');
                }
                if (clazz == Byte.TYPE) {
                    return new Byte(string);
                }
                if (clazz == Short.TYPE) {
                    return new Short(string);
                }
                if (clazz == Integer.TYPE) {
                    return new Integer(string);
                }
                if (clazz == Long.TYPE) {
                    return new Long(string);
                }
                if (clazz == Float.TYPE) {
                    return new Float(string);
                }
                if (clazz == Double.TYPE) {
                    return new Double(string);
                }
                if (this.cons == null) {
                    return null;
                }
                try {
                    return this.cons.newInstance(string);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (invocationTargetException.getTargetException() instanceof NumberFormatException) {
                        throw (NumberFormatException)invocationTargetException.getTargetException();
                    }
                    AntModule.err.notify(1, (Throwable)invocationTargetException);
                    return null;
                }
                catch (Exception exception) {
                    AntModule.err.notify(1, (Throwable)exception);
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!string.equals("")) {
                    AntModule.err.notify(1, (Throwable)numberFormatException);
                }
                return null;
            }
        }

        public void setValue(Object object) throws InvocationTargetException {
            try {
                String string;
                String string2 = string = object == null ? null : object.toString();
                if (string == null || string.equals("")) {
                    DataTypeNode.this.el.removeAttribute(((FeatureDescriptor)((Object)this)).getName());
                } else {
                    DataTypeNode.this.el.setAttribute(((FeatureDescriptor)((Object)this)).getName(), string);
                }
            }
            catch (DOMException dOMException) {
                throw new InvocationTargetException(dOMException);
            }
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void restoreDefaultValue() throws InvocationTargetException {
            this.setValue(null);
        }

        public boolean canWrite() {
            return !AntProjectNode.isScriptReadOnly((AntProjectCookie)DataTypeNode.this.getCookie(class$org$apache$tools$ant$module$api$AntProjectCookie == null ? (class$org$apache$tools$ant$module$api$AntProjectCookie = DataProperty.class$("org.apache.tools.ant.module.api.AntProjectCookie")) : class$org$apache$tools$ant$module$api$AntProjectCookie));
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

