/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.Utf8CPInfo;
import org.apache.tools.ant.taskdefs.optional.sitraka.bytecode.attributes.AttributeInfo;

public class LocalVariableTable
extends AttributeInfo {
    protected int count;
    protected int[] varTable;

    public LocalVariableTable(int attr_index, ConstantPool pool) {
        super(attr_index, pool);
    }

    protected void read(DataInputStream dis) throws IOException {
        int len = dis.readInt();
        this.count = dis.readShort();
        this.varTable = new int[this.count * 5];
        int i = 0;
        while (i < this.varTable.length) {
            this.varTable[i] = dis.readShort();
            ++i;
        }
    }

    public int getStartPC(int index) {
        return this.varTable[5 * index];
    }

    public int getEndPC(int index) {
        return this.varTable[5 * index] + this.varTable[5 * index + 1];
    }

    public String getVariableName(int index) {
        int i = this.varTable[5 * index + 2];
        return ((Utf8CPInfo)this.constantPool.getEntry(i)).getValue();
    }

    public String getType(int index) {
        int i = this.varTable[5 * index + 3];
        return ((Utf8CPInfo)this.constantPool.getEntry(i)).getValue();
    }

    public int getSlot(int index) {
        return this.varTable[5 * index + 4];
    }

    public int length() {
        return this.count;
    }
}

