/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public class JUnitTask
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private Vector tests = new Vector();
    private Vector batchTests = new Vector();
    private Vector formatters = new Vector();
    private File dir = null;
    private Integer timeout = null;
    private boolean summary = false;
    private String summaryValue = "";
    private JUnitTestRunner runner = null;

    public void setHaltonerror(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setHaltonerror(value);
        }
    }

    public void setErrorProperty(String propertyName) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setErrorProperty(propertyName);
        }
    }

    public void setHaltonfailure(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setHaltonfailure(value);
        }
    }

    public void setFailureProperty(String propertyName) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setFailureProperty(propertyName);
        }
    }

    public void setFork(boolean value) {
        Enumeration enumeration = this.allTests();
        while (enumeration.hasMoreElements()) {
            BaseTest test = (BaseTest)enumeration.nextElement();
            test.setFork(value);
        }
    }

    public void setPrintsummary(SummaryAttribute value) {
        this.summaryValue = value.getValue();
        this.summary = value.asBoolean();
    }

    public void setTimeout(Integer value) {
        this.timeout = value;
    }

    public void setMaxmemory(String max) {
        if (Project.getJavaVersion().startsWith("1.1")) {
            this.createJvmarg().setValue("-mx" + max);
        } else {
            this.createJvmarg().setValue("-Xmx" + max);
        }
    }

    public void setJvm(String value) {
        this.commandline.setVm(value);
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void addSysproperty(Environment.Variable sysp) {
        this.commandline.addSysproperty(sysp);
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(((ProjectComponent)this).project).createPath();
    }

    public void addTest(JUnitTest test) {
        this.tests.addElement(test);
    }

    public BatchTest createBatchTest() {
        BatchTest test = new BatchTest(((ProjectComponent)this).project);
        this.batchTests.addElement(test);
        return test;
    }

    public void addFormatter(FormatterElement fe) {
        this.formatters.addElement(fe);
    }

    public JUnitTask() throws Exception {
        this.commandline.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
    }

    public void init() {
        this.addClasspathEntry("/junit/framework/TestCase.class");
        this.addClasspathEntry("/org/apache/tools/ant/Task.class");
        this.addClasspathEntry("/org/apache/tools/ant/taskdefs/optional/junit/JUnitTestRunner.class");
    }

    public void execute() throws BuildException {
        Enumeration list = this.getIndividualTests();
        while (list.hasMoreElements()) {
            JUnitTest test = (JUnitTest)list.nextElement();
            if (!test.shouldRun(((ProjectComponent)this).project)) continue;
            this.execute(test);
        }
    }

    protected void execute(JUnitTest test) throws BuildException {
        boolean failureOccurredHere;
        if (test.getTodir() == null) {
            test.setTodir(((ProjectComponent)this).project.resolveFile("."));
        }
        if (test.getOutfile() == null) {
            test.setOutfile("TEST-" + test.getName());
        }
        int exitValue = 2;
        boolean wasKilled = false;
        if (!test.getFork()) {
            exitValue = this.executeInVM(test);
        } else {
            ExecuteWatchdog watchdog = this.createWatchdog();
            exitValue = this.executeAsForked(test, watchdog);
            if (watchdog != null) {
                wasKilled = watchdog.killedProcess();
            }
        }
        boolean errorOccurredHere = exitValue == 2;
        boolean bl = failureOccurredHere = exitValue != 0;
        if (errorOccurredHere || failureOccurredHere) {
            if (errorOccurredHere && test.getHaltonerror() || failureOccurredHere && test.getHaltonfailure()) {
                throw new BuildException("Test " + test.getName() + " failed" + (wasKilled ? " (timeout)" : ""), this.location);
            }
            this.log("TEST " + test.getName() + " FAILED" + (wasKilled ? " (timeout)" : ""), 0);
            if (errorOccurredHere && test.getErrorProperty() != null) {
                ((ProjectComponent)this).project.setProperty(test.getErrorProperty(), "true");
            }
            if (failureOccurredHere && test.getFailureProperty() != null) {
                ((ProjectComponent)this).project.setProperty(test.getFailureProperty(), "true");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeAsForked(JUnitTest test, ExecuteWatchdog watchdog) throws BuildException {
        CommandlineJava cmd = (CommandlineJava)this.commandline.clone();
        cmd.setClassname("org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner");
        cmd.createArgument().setValue(test.getName());
        cmd.createArgument().setValue("haltOnError=" + test.getHaltonerror());
        cmd.createArgument().setValue("haltOnFailure=" + test.getHaltonfailure());
        if (this.summary) {
            this.log("Running " + test.getName(), 2);
            cmd.createArgument().setValue("formatter=org.apache.tools.ant.taskdefs.optional.junit.SummaryJUnitResultFormatter");
        }
        StringBuffer formatterArg = new StringBuffer(128);
        FormatterElement[] feArray = this.mergeFormatters(test);
        int i = 0;
        while (i < feArray.length) {
            FormatterElement fe = feArray[i];
            formatterArg.append("formatter=");
            formatterArg.append(fe.getClassname());
            File outFile = this.getOutput(fe, test);
            if (outFile != null) {
                formatterArg.append(",");
                formatterArg.append(outFile);
            }
            cmd.createArgument().setValue(formatterArg.toString());
            formatterArg.setLength(0);
            ++i;
        }
        File propsFile = new File("junit" + new Random(System.currentTimeMillis()).nextLong() + ".properties");
        cmd.createArgument().setValue("propsfile=" + propsFile.getAbsolutePath());
        Hashtable p = ((ProjectComponent)this).project.getProperties();
        Properties props = new Properties();
        Enumeration enumeration = p.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            ((Hashtable)props).put(key, p.get(key));
        }
        try {
            FileOutputStream outstream = new FileOutputStream(propsFile);
            props.save(outstream, "Ant JUnitTask generated properties file");
            outstream.close();
        }
        catch (IOException e) {
            throw new BuildException("Error creating temporary properties file.", (Throwable)e, this.location);
        }
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), watchdog);
        execute.setCommandline(cmd.getCommandline());
        execute.setAntRun(((ProjectComponent)this).project);
        if (this.dir != null) {
            execute.setWorkingDirectory(this.dir);
        }
        this.log("Executing: " + cmd.toString(), 3);
        try {
            int retVal;
            try {
                retVal = execute.execute();
            }
            catch (IOException e) {
                throw new BuildException("Process fork failed.", (Throwable)e, this.location);
            }
            Object var15_14 = null;
            if (propsFile.delete()) return retVal;
            throw new BuildException("Could not delete temporary properties file.");
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            if (!propsFile.delete()) {
                throw new BuildException("Could not delete temporary properties file.");
            }
            throw throwable;
        }
    }

    protected void handleOutput(String line) {
        if (this.runner != null) {
            this.runner.handleOutput(line);
        } else {
            super.handleOutput(line);
        }
    }

    protected void handleErrorOutput(String line) {
        if (this.runner != null) {
            this.runner.handleErrorOutput(line);
        } else {
            super.handleErrorOutput(line);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int executeInVM(JUnitTest test) throws BuildException {
        int n;
        CommandlineJava.SysProperties sysProperties;
        test.setProperties(((ProjectComponent)this).project.getProperties());
        if (this.dir != null) {
            this.log("dir attribute ignored if running in the same VM", 1);
        }
        if ((sysProperties = this.commandline.getSystemProperties()) != null) {
            sysProperties.setSystem();
        }
        try {
            this.log("Using System properties " + System.getProperties(), 3);
            AntClassLoader cl = null;
            Path classpath = this.commandline.getClasspath();
            if (classpath != null) {
                this.log("Using CLASSPATH " + classpath, 3);
                cl = new AntClassLoader(null, ((ProjectComponent)this).project, classpath, false);
                cl.addSystemPackageRoot("junit");
                cl.addSystemPackageRoot("org.apache.tools.ant");
            }
            this.runner = new JUnitTestRunner(test, test.getHaltonerror(), test.getHaltonfailure(), (ClassLoader)cl);
            if (this.summary) {
                this.log("Running " + test.getName(), 2);
                SummaryJUnitResultFormatter f = new SummaryJUnitResultFormatter();
                f.setWithOutAndErr("withoutanderr".equalsIgnoreCase(this.summaryValue));
                f.setOutput(this.getDefaultOutput());
                this.runner.addFormatter(f);
            }
            FormatterElement[] feArray = this.mergeFormatters(test);
            int i = 0;
            while (i < feArray.length) {
                FormatterElement fe = feArray[i];
                File outFile = this.getOutput(fe, test);
                if (outFile != null) {
                    fe.setOutfile(outFile);
                } else {
                    fe.setOutput(this.getDefaultOutput());
                }
                this.runner.addFormatter(fe.createFormatter());
                ++i;
            }
            this.runner.run();
            n = this.runner.getRetCode();
            Object var10_10 = null;
            if (sysProperties == null) return n;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (sysProperties == null) throw throwable;
            sysProperties.restoreSystem();
            throw throwable;
        }
        sysProperties.restoreSystem();
        return n;
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout.intValue());
    }

    protected OutputStream getDefaultOutput() {
        return new LogOutputStream((Task)this, 2);
    }

    protected Enumeration getIndividualTests() {
        Enumeration[] enums = new Enumeration[this.batchTests.size() + 1];
        int i = 0;
        while (i < this.batchTests.size()) {
            BatchTest batchtest = (BatchTest)this.batchTests.elementAt(i);
            enums[i] = batchtest.elements();
            ++i;
        }
        enums[enums.length - 1] = this.tests.elements();
        return Enumerations.fromCompound(enums);
    }

    protected Enumeration allTests() {
        Enumeration[] enums = new Enumeration[]{this.tests.elements(), this.batchTests.elements()};
        return Enumerations.fromCompound(enums);
    }

    private FormatterElement[] mergeFormatters(JUnitTest test) {
        Vector feVector = (Vector)this.formatters.clone();
        test.addFormattersTo(feVector);
        Object[] feArray = new FormatterElement[feVector.size()];
        feVector.copyInto(feArray);
        return feArray;
    }

    protected File getOutput(FormatterElement fe, JUnitTest test) {
        if (fe.getUseFile()) {
            String filename = test.getOutfile() + fe.getExtension();
            File destFile = new File(test.getTodir(), filename);
            String absFilename = destFile.getAbsolutePath();
            return ((ProjectComponent)this).project.resolveFile(absFilename);
        }
        return null;
    }

    protected void addClasspathEntry(String resource) {
        URL url = ((Object)((Object)this)).getClass().getResource(resource);
        if (url != null) {
            String u = url.toString();
            if (u.startsWith("jar:file:")) {
                int pling = u.indexOf("!");
                String jarName = u.substring(9, pling);
                this.log("Implicitly adding " + jarName + " to classpath", 4);
                this.createClasspath().setLocation(new File(new File(jarName).getAbsolutePath()));
            } else if (u.startsWith("file:")) {
                int tail = u.indexOf(resource);
                String dirName = u.substring(5, tail);
                this.log("Implicitly adding " + dirName + " to classpath", 4);
                this.createClasspath().setLocation(new File(new File(dirName).getAbsolutePath()));
            } else {
                this.log("Don't know how to handle resource URL " + u, 4);
            }
        } else {
            this.log("Couldn't find " + resource, 4);
        }
    }

    public static class SummaryAttribute
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"true", "yes", "false", "no", "on", "off", "withOutAndErr"};
        }

        public boolean asBoolean() {
            return "true".equals(this.value) || "on".equals(this.value) || "yes".equals(this.value) || "withOutAndErr".equals(this.value);
        }
    }
}

